/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.groups.Group;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.FormComponentBeanConfig;
import com.install4j.runtime.installer.config.GroupProvider;
import com.install4j.runtime.installer.config.LinkActionBeanConfig;
import com.install4j.runtime.installer.config.LinkGroupBeanConfig;
import com.install4j.runtime.installer.config.LinkScreenBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class GroupBeanConfig
extends AbstractBeanConfig
implements GroupProvider {
    private Group instance;
    private List beanConfigs;
    private boolean screenGroup;

    public GroupBeanConfig(boolean bl) {
        this.screenGroup = bl;
    }

    public Group getOrInstantiateGroup(boolean bl) {
        if (this.instance == null) {
            this.instance = (Group)this.instantiateBean(bl);
        }
        return this.instance;
    }

    public Object getOrInstantiateBean() {
        return this.getOrInstantiateGroup(false);
    }

    public List getBeanConfigs() {
        return this.beanConfigs;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isInstantiated() {
        return this.instance != null;
    }

    protected void setBean(Bean bean) {
        this.instance = (Group)bean;
    }

    protected void read(Element element) {
        super.read(element);
        this.readBeanConfigs(element);
    }

    private void readBeanConfigs(Element element) {
        LinkedList<ActionBeanConfig> linkedList = new LinkedList<ActionBeanConfig>();
        Element element2 = GroupBeanConfig.findChild(element, "beans");
        if (element2 != null) {
            Iterator iterator = GroupBeanConfig.childElements(element2);
            while (iterator.hasNext()) {
                AbstractBeanConfig abstractBeanConfig;
                Element element3 = (Element)iterator.next();
                String string = element3.getTagName();
                if (string.equalsIgnoreCase("action")) {
                    abstractBeanConfig = new ActionBeanConfig();
                } else if (string.equalsIgnoreCase("screen")) {
                    abstractBeanConfig = new ScreenBeanConfig();
                } else if (string.equalsIgnoreCase("link")) {
                    abstractBeanConfig = GroupBeanConfig.readAttribute(element3, "group", false) ? new LinkGroupBeanConfig(this.screenGroup) : (this.screenGroup ? new LinkScreenBeanConfig() : new LinkActionBeanConfig());
                } else if (string.equalsIgnoreCase("formComponent")) {
                    abstractBeanConfig = new FormComponentBeanConfig();
                } else {
                    if (!string.equalsIgnoreCase("group")) continue;
                    abstractBeanConfig = new GroupBeanConfig(this.screenGroup);
                }
                ((AbstractBeanConfig)abstractBeanConfig).read(element3);
                linkedList.add((ActionBeanConfig)abstractBeanConfig);
            }
        }
        this.beanConfigs = Collections.unmodifiableList(linkedList);
    }

    public void addAllTo(Map map) {
        super.addAllTo(map);
        Iterator iterator = this.beanConfigs.iterator();
        while (iterator.hasNext()) {
            ((AbstractBeanConfig)iterator.next()).addAllTo(map);
        }
    }
}

