/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config.update;

import com.install4j.api.update.UpdateDescriptorEntry;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.util.VersionCheck;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Locale;
import org.w3c.dom.Element;

public class UpdateDescriptorEntryImpl
extends AbstractConfig
implements UpdateDescriptorEntry {
    public static final String ELEMENT_ENTRY = "entry";
    public static final String ELEMENT_COMMENT = "comment";
    public static final String ATTRIBUTE_TARGET_MEDIA_FILE_ID = "targetMediaFileId";
    public static final String ATTRIBUTE_UPDATABLE_VERSION_MIN = "updatableVersionMin";
    public static final String ATTRIBUTE_UPDATABLE_VERSION_MAX = "updatableVersionMax";
    public static final String ATTRIBUTE_FILE_NAME = "fileName";
    public static final String ATTRIBUTE_NEW_VERSION = "newVersion";
    public static final String ATTRIBUTE_NEW_MEDIA_FILE_ID = "newMediaFileId";
    public static final String ATTRIBUTE_FILE_SIZE = "fileSize";
    public static final String ATTRIBUTE_BUNDLED_JRE = "bundledJre";
    public static final String ATTRIBUTE_ARCHIVE = "archive";
    public static final String ATTRIBUTE_LANGUAGE = "language";
    private static final DecimalFormat DEFAULT_TRUNCATED_FORMAT = new DecimalFormat("#0.0");
    private String targetMediaFileId = "";
    private String updatableVersionMin = "";
    private String updatableVersionMax = "";
    private String fileName = "";
    private String newVersion = "";
    private String newMediaFileId = "";
    private long fileSize = -1L;
    private String bundledJre = "";
    private String comment = "";
    private boolean archive = false;
    private Element element;
    private URL url;

    public UpdateDescriptorEntryImpl() {
    }

    public UpdateDescriptorEntryImpl(String string, String string2, String string3, long l, String string4, boolean bl, String string5, String string6) {
        this.targetMediaFileId = string;
        this.fileName = string2;
        this.newVersion = string3;
        this.fileSize = l;
        this.bundledJre = string4;
        this.newMediaFileId = string;
        this.archive = bl;
        this.updatableVersionMin = string5;
        this.updatableVersionMax = string6;
    }

    protected void read(Element element) {
        this.element = element;
        this.targetMediaFileId = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_TARGET_MEDIA_FILE_ID, this.targetMediaFileId);
        this.updatableVersionMin = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_UPDATABLE_VERSION_MIN, this.updatableVersionMin);
        this.updatableVersionMax = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_UPDATABLE_VERSION_MAX, this.updatableVersionMax);
        this.fileName = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_FILE_NAME, this.fileName);
        this.newVersion = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_NEW_VERSION, this.newVersion);
        this.newMediaFileId = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_NEW_MEDIA_FILE_ID, this.newMediaFileId);
        this.fileSize = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_FILE_SIZE, this.fileSize);
        this.bundledJre = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_BUNDLED_JRE, this.bundledJre);
        this.archive = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_ARCHIVE, this.archive);
        ContextInt contextInt = ContextImpl.getSingleContextInt();
        String string = contextInt != null ? contextInt.getLanguageId() : Locale.getDefault().getLanguage();
        Element element2 = null;
        Element element3 = null;
        Iterator iterator = XmlHelper.childElements(element);
        while (iterator.hasNext()) {
            String string2;
            Element element4 = (Element)iterator.next();
            if (!element4.getNodeName().equals(ELEMENT_COMMENT)) continue;
            if (element2 == null) {
                element2 = element4;
            }
            if (!string.startsWith(string2 = UpdateDescriptorEntryImpl.readAttribute(element4, ATTRIBUTE_LANGUAGE, ""))) continue;
            element3 = element4;
        }
        if (element3 == null) {
            element3 = element2;
        }
        this.comment = XmlHelper.getTextValue(element3).trim();
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public String getAdditionalAttribute(String string, String string2) {
        return UpdateDescriptorEntryImpl.readAttribute(this.element, string, string2);
    }

    public String getTargetMediaFileId() {
        return this.targetMediaFileId;
    }

    public void setTargetMediaFileId(String string) {
        this.targetMediaFileId = string;
    }

    public String getUpdatableVersionMin() {
        return this.updatableVersionMin;
    }

    public void setUpdatableVersionMin(String string) {
        this.updatableVersionMin = string;
    }

    public String getUpdatableVersionMax() {
        return this.updatableVersionMax;
    }

    public void setUpdatableVersionMax(String string) {
        this.updatableVersionMax = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(String string) {
        this.newVersion = string;
    }

    public String getNewMediaFileId() {
        return this.newMediaFileId;
    }

    public void setNewMediaFileId(String string) {
        this.newMediaFileId = string;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFileSizeVerbose() {
        if (this.fileSize / 1024L / 1024L > 0L) {
            return new DecimalFormat("#0.0").format(1.0 * (double)this.fileSize / 1024.0 / 1024.0) + " MB";
        }
        return String.valueOf(this.fileSize / 1024L) + " KB";
    }

    public void setFileSize(long l) {
        this.fileSize = l;
    }

    public String getBundledJre() {
        return this.bundledJre;
    }

    public void setBundledJre(String string) {
        this.bundledJre = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String toString() {
        return "UpdateDescriptorEntry [target: " + this.targetMediaFileId + ", file: " + this.getFileName() + "]";
    }

    public boolean checkVersionCompatible(String string) {
        String string2 = this.updatableVersionMin.trim();
        if (string2.length() > 0 && !VersionCheck.checkCompatible(string2, string)) {
            return false;
        }
        String string3 = this.updatableVersionMax.trim();
        if (string3.length() > 0 && !VersionCheck.checkCompatible(string, string3)) {
            return false;
        }
        return !string.equals(this.newVersion) && VersionCheck.checkCompatible(string, this.newVersion);
    }
}

