/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config.update;

import com.install4j.api.update.UpdateDescriptor;
import com.install4j.api.update.UpdateDescriptorEntry;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.update.UpdateDescriptorEntryImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateDescriptorImpl
extends AbstractConfig
implements UpdateDescriptor {
    public static final String ELEMENT_UPDATE_DESCRIPTOR = "updateDescriptor";
    public static final String ATTRIBUTE_BASE_URL = "baseUrl";
    private UpdateDescriptorEntry[] entries;
    private String baseUrl = "";

    public UpdateDescriptorImpl(List list, String string) {
        this.baseUrl = string;
        this.entries = list.toArray(new UpdateDescriptorEntry[list.size()]);
    }

    public UpdateDescriptorImpl() {
    }

    public UpdateDescriptorEntry[] getEntries() {
        return this.entries;
    }

    public UpdateDescriptorEntry getPossibleUpdateEntry() {
        if (this.entries == null) {
            return null;
        }
        try {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            if (installerConfig == null) {
                installerConfig = InstallerConfig.getGeneralConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
            }
            String string = installerConfig.getMediaSetId();
            String string2 = installerConfig.getApplicationVersion();
            for (int i = 0; i < this.entries.length; ++i) {
                UpdateDescriptorEntry updateDescriptorEntry = this.entries[i];
                if (!updateDescriptorEntry.getTargetMediaFileId().equals(string) || !updateDescriptorEntry.checkVersionCompatible(string2)) continue;
                return updateDescriptorEntry;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void read(File file, URL uRL) throws IOException {
        URL uRL2;
        Document document = XmlHelper.parseFile(file);
        this.read(document.getDocumentElement());
        if (this.baseUrl.trim().length() > 0) {
            uRL2 = new URL(this.baseUrl);
        } else {
            String string = uRL.getPath();
            int n = string.lastIndexOf(47);
            if (n > -1) {
                string = string.substring(0, n + 1);
            }
            uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
        }
        for (int i = 0; i < this.entries.length; ++i) {
            UpdateDescriptorEntryImpl updateDescriptorEntryImpl = (UpdateDescriptorEntryImpl)this.entries[i];
            updateDescriptorEntryImpl.setURL(new URL(uRL2, updateDescriptorEntryImpl.getFileName()));
        }
    }

    protected void read(Element element) {
        this.baseUrl = UpdateDescriptorImpl.readAttribute(element, ATTRIBUTE_BASE_URL, this.baseUrl);
        ArrayList<UpdateDescriptorEntryImpl> arrayList = new ArrayList<UpdateDescriptorEntryImpl>();
        Iterator iterator = UpdateDescriptorImpl.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            UpdateDescriptorEntryImpl updateDescriptorEntryImpl = new UpdateDescriptorEntryImpl();
            updateDescriptorEntryImpl.read(element2);
            arrayList.add(updateDescriptorEntryImpl);
        }
        this.entries = arrayList.toArray(new UpdateDescriptorEntry[arrayList.size()]);
    }
}

