/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.AbstractFileSelector;
import com.install4j.runtime.installer.frontend.components.FileValidator;
import com.install4j.runtime.util.AbstractTextAndButtonPanel;
import com.install4j.runtime.util.FileDrop;
import com.install4j.runtime.util.MultiFileFilter;
import com.install4j.runtime.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class FileSelector
extends AbstractTextAndButtonPanel
implements AbstractFileSelector {
    private static File lastDirectory = null;
    private JTextField txtFile;
    private JButton btnBrowse;
    private JFileChooser fileChooser;
    private String fileFilterName;
    private String[] filteredExtensions;
    private boolean designTime;
    private FileValidator validator;
    private boolean alreadyValidated;
    private String initialBrowserDirectory;

    public FileSelector(String string, String[] stringArray, boolean bl) {
        this.fileFilterName = string;
        this.filteredExtensions = stringArray;
        this.designTime = bl;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    public void setEnabled(boolean bl) {
        this.txtFile.setEnabled(bl);
        this.btnBrowse.setEnabled(bl);
    }

    public void initFile(String string) {
        this.txtFile.setText(string);
    }

    public void setSelectedFile(File file) {
        this.initFile(file.getPath());
    }

    public File getSelectedFile() {
        return new File(StringUtil.replaceHomeDir(this.txtFile.getText().trim()));
    }

    public void focusTextField() {
        this.txtFile.requestFocus();
        this.txtFile.setSelectionStart(0);
        this.txtFile.setSelectionEnd(this.txtFile.getDocument().getLength());
    }

    public JTextField getTextField() {
        return this.txtFile;
    }

    public JButton getButton() {
        return this.btnBrowse;
    }

    public void setManualEntryAllowed(boolean bl) {
        this.txtFile.setEditable(bl);
    }

    public void setValidator(FileValidator fileValidator) {
        this.validator = fileValidator;
    }

    public boolean checkSelectedFile() {
        return this.alreadyValidated || this.checkFile(this.getSelectedFile());
    }

    public void setInitialBrowserDirectory(String string) {
        this.initialBrowserDirectory = string;
    }

    private boolean checkFile(File file) {
        return this.validator == null || this.validator.isValidFile(file);
    }

    private void setupControls() {
        this.txtFile = new JTextField();
        FileDrop.addTo(this.txtFile, null);
        this.btnBrowse = new JButton(Messages.getMessages().getString("ButtonBrowse"));
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtFile, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        this.add((Component)this.btnBrowse, gridBagConstraints);
    }

    private void setupEventHandlers() {
        if (this.designTime) {
            return;
        }
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileSelector.this.doBrowse();
            }
        });
        this.txtFile.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                FileSelector.this.alreadyValidated = false;
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                FileSelector.this.alreadyValidated = false;
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                FileSelector.this.alreadyValidated = false;
            }
        });
    }

    private void doBrowse() {
        File file;
        Object object;
        String string;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogType(2);
            if (this.filteredExtensions != null && this.fileFilterName.trim().length() > 0) {
                for (int i = 0; i < this.filteredExtensions.length; ++i) {
                    string = this.filteredExtensions[i].trim();
                    if (string.startsWith(".")) {
                        this.filteredExtensions[i] = string.substring(1);
                        continue;
                    }
                    if (!string.startsWith("*.")) continue;
                    this.filteredExtensions[i] = string.substring(2);
                }
                object = new MultiFileFilter(this.filteredExtensions, this.fileFilterName);
                this.fileChooser.addChoosableFileFilter((FileFilter)object);
                this.fileChooser.setFileFilter((FileFilter)object);
            }
        }
        if ((string = this.txtFile.getText().trim()).length() > 0) {
            object = new File(string);
        } else if (this.initialBrowserDirectory.length() > 0) {
            object = new File(this.initialBrowserDirectory);
        } else {
            if (lastDirectory == null) {
                lastDirectory = new File((String)ContextImpl.getSingleContextInt().getVariable("sys.installerDir"));
            }
            object = lastDirectory;
        }
        try {
            object = ((File)object).getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (!(((File)object).exists() && ((File)object).isDirectory() || (file = this.fileChooser.getFileSystemView().getParentDirectory((File)object)) == null || ((File)object).equals(file))) {
            object = file;
        }
        if (((File)object).exists() && ((File)object).isDirectory()) {
            this.fileChooser.setCurrentDirectory((File)object);
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            file = this.fileChooser.getSelectedFile();
            lastDirectory = file.getParentFile();
            if (this.checkFile(file)) {
                this.txtFile.setText(file.getPath());
                this.alreadyValidated = true;
            } else {
                this.alreadyValidated = false;
            }
        }
    }
}

