/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SystemInfoImpl {
    private static long physicalMemoryCache = -1L;

    public static long getFreeDiskSpace(File file) {
        block7: {
            for (file = file.getAbsoluteFile(); file != null && !file.exists(); file = file.getParentFile()) {
            }
            if (file != null) {
                try {
                    if (Util.isWindows()) {
                        return Misc.getFreeDiskSpace(file);
                    }
                    if (!Util.isMacOS() && !Util.isLinux()) break block7;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (!Execution.executeAndWait(new String[]{"df", "-k", file.getAbsolutePath()}, stringBuffer)) break block7;
                    String string = stringBuffer.toString().trim();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                    stringTokenizer.nextToken();
                    String string2 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " \t\f");
                    try {
                        stringTokenizer2.nextToken();
                        stringTokenizer2.nextToken();
                        stringTokenizer2.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        string2 = stringTokenizer.nextToken();
                        stringTokenizer2 = new StringTokenizer(string2, " \t\f");
                        stringTokenizer2.nextToken();
                        stringTokenizer2.nextToken();
                    }
                    return Long.parseLong(stringTokenizer2.nextToken()) * 1024L;
                }
                catch (Exception exception) {
                    System.err.println("Could not determine disk space: " + exception.getMessage());
                }
            }
        }
        return -1L;
    }

    public static long getPhysicalMemory() {
        if (physicalMemoryCache == -1L) {
            physicalMemoryCache = SystemInfoImpl.initPhysicalMemory();
        }
        return physicalMemoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long initPhysicalMemory() {
        try {
            if (Util.isWindows()) {
                return Misc.getPhysicalMemory();
            }
            if (Util.isMacOS()) {
                long l = SystemInfoImpl.getSysctlResult("hw.memsize");
                if (l != 0L) return l;
                return SystemInfoImpl.getSysctlResult("hw.physmem");
            }
            if (!Util.isLinux()) return 0L;
            BufferedReader bufferedReader = new BufferedReader(new FileReader("/proc/meminfo"));
            try {
                String string = bufferedReader.readLine();
                String string2 = "MemTotal: ";
                while (string != null) {
                    if ((string = string.trim()).startsWith(string2) && string.length() > string2.length() + 2) {
                        string = string.substring(string2.length(), string.length() - 2).trim();
                        long l = Long.parseLong(string) * 1024L;
                        return l;
                    }
                    string = bufferedReader.readLine();
                }
                return 0L;
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0L;
    }

    private static long getSysctlResult(String string) throws IOException {
        long l = 0L;
        try {
            String string2;
            String string3;
            StringBuffer stringBuffer = new StringBuffer();
            if (Execution.executeAndWait(new String[]{"sysctl", string}, stringBuffer) && (string3 = stringBuffer.toString().trim()).startsWith(string2 = string + ": ")) {
                l = Long.parseLong(string3.substring(string2.length()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }
}

