#include <stdio.h>
#include <string.h>
#include "vars.h"

/******************************************
 ************* PRUNE DOWN URLS ************
 ******************************************/
int prune_urls(int section)
{
 struct p_url *url;
 int i,l,z;
 char tmp[ML_2LD],etmp[ML_ETMP],*k,*k1,c;
 
  url=malloc(sizeof(struct p_url));
  if (url==NULL)
    {
     sprintf(etmp,"MAKE-CACHE: ERROR: Can't allocate memory\n");
     err_mes(etmp);
     exit(-1);
    }

 #ifdef DEBUG_PRUNE_URLS
 fprintf(stderr,"\n***** PRUNE DOWN \"%s\" SECTION *****\n",redir[section]->name);
 #endif

 qsort(redir[section]->ban_urls,redir[section]->ban_urls_count,sizeof(char*),cmp_urls);

  #ifdef DEBUG_PRUNE_URLS
  fprintf(stderr,"\n=== SORTED \"%s\" SECTION (%i elements)===\n",redir[section]->name,redir[section]->ban_urls_count);
  for (i=0;i<redir[section]->ban_urls_count;i++)
  {
   if (!redir[section]->ban_urls[i]) {fprintf(stderr,"NULL\n"); continue;}
       
   for (l=0;l<strlen(redir[section]->ban_urls[i]);l++)
    if ((redir[section]->ban_urls[i])[l]==1)  fprintf(stderr,"!");
    else fprintf(stderr,"%c",(redir[section]->ban_urls[i])[l]);

    fprintf(stderr,"\n");
  }
  #endif

 /************************************
  **** CHECK DOMEN TO BAD SYMBOLS ****
  
   ******** ALLOWED SYMBOLS **************
   * -.         [45-46]                  *
   * 0123456789 [48-57]                  *
   * ABCDEFGHIJKLMNOPQRSTUVWXYZ [65-90]  *
   *  _ [95]                             *
   * abcdefghijklmnopqrstuvwxyz [97-122] *
   ***************************************/

   // Set NULL in BAD domens
   for (i=0; i<redir[section]->ban_urls_count; i++)
   {
//    printf("s:%s\n",redir[section]->ban_urls[i]);
    
      k=strchr(redir[section]->ban_urls[i],1);
      if (!k)
      { //2lewel domen only
       l=strlen(redir[section]->ban_urls[i]);
       for(z=0;z<l;z++)
       { 
        c=redir[section]->ban_urls[i][z];
        if ((c>44 && c<47) || (c>47 && c<58) || (c>64 && c<91) || c==95 || (c>96 && c<123)) continue;
	else
	   {
	    sprintf(etmp, "MAKE-CACHE: WARNING: Bad symbol(%c) in domen name \"%s\" in %s section, skip",c,redir[section]->ban_urls[i],redir[section]->name);
	    err_mes(etmp);
	    redir[section]->ban_urls[i]=NULL;
	    break;
	   }
       }
      }//if !k
    else
      {// Combined url
       l=k-(char*)redir[section]->ban_urls[i];
       for(z=0;z<l;z++)
       { 
        c=redir[section]->ban_urls[i][z];
        if ((c>44 && c<47) || (c>47 && c<58) || (c>64 && c<91) || c==95 || (c>96 && c<123)) continue;
	else
	   {
	    cache2url(url,redir[section]->ban_urls[i]);
	    sprintf(etmp,"MAKE-CACHE: WARNING: Bad symbol(%c) in domen name \"%s%s\" %s%s in %s section, skip",c,url->subdomen,url->twoleveldomen,url->port,url->dirs,redir[section]->name);
	    err_mes(etmp);
	    redir[section]->ban_urls[i]=NULL;
	    break;
           }
       }
      } //else
     } //for
   // SPLIT NULL ELEMENTS
   for (i=0,l=0;i<redir[section]->ban_urls_count;i++)
    if (redir[section]->ban_urls[i])
	 redir[section]->ban_urls[l++]=redir[section]->ban_urls[i];
   redir[section]->ban_urls_count=l;
//   redir[section]->ban_urls=(unsigned char **)realloc(redir[section]->ban_urls,(1+redir[section]->ban_urls_count)*sizeof(unsigned char *));


  #ifdef DEBUG_PRUNE_URLS
  fprintf(stderr,"\n=== AFTER DELETE DUBLS (%i elements)===\n",redir[section]->ban_urls_count);
  for (i=0;i<redir[section]->ban_urls_count;i++)
  {
   if (!redir[section]->ban_urls[i]) {fprintf(stderr,"NULL\n"); continue;}
   for (l=0;l<strlen(redir[section]->ban_urls[i]);l++)
    if ((redir[section]->ban_urls[i])[l]==1)  fprintf(stderr,"!");
    else fprintf(stderr,"%c",(redir[section]->ban_urls[i])[l]);
    fprintf(stderr,"\n");
  }
  #endif



 /******************************
  **** DELETE DUBL ELEMENTS ****/

   // Set NULL in dubl
   for (i=0; i<redir[section]->ban_urls_count-1; i++)
   {
     if (!strcmp(redir[section]->ban_urls[i],redir[section]->ban_urls[i+1]))
     {
      if (!strchr(redir[section]->ban_urls[i],1))
          sprintf(etmp, "MAKE-CACHE: delete dublicate rule: %s in %s section",redir[section]->ban_urls[i],redir[section]->name);
      else
         {
	  cache2url(url,redir[section]->ban_urls[i]);
	  sprintf(etmp,"MAKE-CACHE: delete dublicate rule: %s%s%s%s in %s section",url->subdomen,url->twoleveldomen,url->port,url->dirs,redir[section]->name);
	 } 
      err_mes(etmp);
      redir[section]->ban_urls[i]=NULL;
     } //if strcmp
   } //for

   // SPLIT NULL ELEMENTS
   for (i=0,l=0;i<redir[section]->ban_urls_count;i++)
    if (redir[section]->ban_urls[i])
	 redir[section]->ban_urls[l++]=redir[section]->ban_urls[i];
   redir[section]->ban_urls_count=l;
//   redir[section]->ban_urls=(unsigned char **)realloc(redir[section]->ban_urls,(1+redir[section]->ban_urls_count)*sizeof(unsigned char *));


  #ifdef DEBUG_PRUNE_URLS
  fprintf(stderr,"\n=== AFTER DELETE DUBLS (%i elements)===\n",redir[section]->ban_urls_count);
  for (i=0;i<redir[section]->ban_urls_count;i++)
  {
   if (!redir[section]->ban_urls[i]) {fprintf(stderr,"NULL\n"); continue;}
   for (l=0;l<strlen(redir[section]->ban_urls[i]);l++)
    if ((redir[section]->ban_urls[i])[l]==1)  fprintf(stderr,"!");
    else fprintf(stderr,"%c",(redir[section]->ban_urls[i])[l]);
    fprintf(stderr,"\n");
  }
  #endif

/*************** Del sub dubl *****************
 ***** if (exist test.ru) del www.test.ru *****/
   tmp[0]=0;
   for (i=0;i<redir[section]->ban_urls_count;i++)
   {
    if (!strchr(redir[section]->ban_urls[i],1))
     { //2 level domen now in ban_urls[i]
       memcpy(tmp,redir[section]->ban_urls[i],strlen(redir[section]->ban_urls[i]));
       tmp[strlen(redir[section]->ban_urls[i])]=0;
     }
    else 
     {
      cache2url(url,redir[section]->ban_urls[i]);
      if (!strcmp(url->twoleveldomen,tmp))
      {
       sprintf(etmp,"MAKE-CACHE: delete rule: %s%s%s%s because exist rule: %s",url->subdomen,url->twoleveldomen,url->port,url->dirs,tmp);
       err_mes(etmp);
       redir[section]->ban_urls[i]=NULL;
      }
     }
   }

   // SPLIT NULL ELEMENTS
   for (i=0,l=0;i<redir[section]->ban_urls_count;i++)
    if (redir[section]->ban_urls[i])
	 redir[section]->ban_urls[l++]=redir[section]->ban_urls[i];
   redir[section]->ban_urls_count=l;
//   redir[section]->ban_urls=(unsigned char **)realloc(redir[section]->ban_urls,(1+redir[section]->ban_urls_count)*sizeof(unsigned char *));


  #ifdef DEBUG_PRUNE_URLS
  fprintf(stderr,"\n=== AFTER DELETE SUB DUBLS (%i elements)===\n",redir[section]->ban_urls_count);
  for (i=0;i<redir[section]->ban_urls_count;i++)
  {
   if (!redir[section]->ban_urls[i]) {fprintf(stderr,"NULL\n"); continue;}
   for (l=0;l<strlen(redir[section]->ban_urls[i]);l++)
    if ((redir[section]->ban_urls[i])[l]==1)  fprintf(stderr,"!");
    else fprintf(stderr,"%c",(redir[section]->ban_urls[i])[l]);
    fprintf(stderr,"\n");
  }
  #endif

/**********************************************
 *** PACK ELEMENTS WITH EQUAL 2 LEVEL DOMEN ***/
    l=0;
    tmp[0]=0;

   for (i=0;i<redir[section]->ban_urls_count;i++)
   {
     if (strchr(redir[section]->ban_urls[i],1)) cache2url(url,redir[section]->ban_urls[i]);
     else continue;

      if (!strcmp(url->twoleveldomen,tmp))
       {
//         printf("SUM: %s + %s\n",redir[section]->ban_urls[l],redir[section]->ban_urls[i]);
         /************************************************************
	     domen.ru|www|||\0   +  domen.ru|||/ban|\0
	     |               |	            |       |
	     ------(z)--------              k       k1
	 ************************************************************/
	 z=strlen(redir[section]->ban_urls[l]);
	 k=strchr(redir[section]->ban_urls[i],1);
	 k1=strchr(redir[section]->ban_urls[i],0);
	 
	 
         redir[section]->ban_urls[l]=(char *)realloc(redir[section]->ban_urls[l],(z+k1-k+1)*sizeof(char));	 

	 memcpy(&redir[section]->ban_urls[l][z],k+1,k1-k);
	 
	 free(redir[section]->ban_urls[i]);
         redir[section]->ban_urls[i]=NULL;

       }
      else
       {
	memcpy(tmp,url->twoleveldomen,strlen(url->twoleveldomen));
	tmp[strlen(url->twoleveldomen)]=0;
	l=i;
       }
   }



   // SPLIT NULL ELEMENTS
   for (i=0,l=0;i<redir[section]->ban_urls_count;i++)
    if (redir[section]->ban_urls[i])
	 redir[section]->ban_urls[l++]=redir[section]->ban_urls[i];
   redir[section]->ban_urls_count=l;
//   redir[section]->ban_urls=(unsigned char **)realloc(redir[section]->ban_urls,(1+redir[section]->ban_urls_count)*sizeof(unsigned char *));

  #ifdef DEBUG_PRUNE_URLS
  fprintf(stderr,"\n=== AFTER PACK (%i elements)===\n",redir[section]->ban_urls_count);
  for (i=0;i<redir[section]->ban_urls_count;i++)
  {
   if (!redir[section]->ban_urls[i]) {fprintf(stderr,"NULL\n"); continue;}
   for (l=0;l<strlen(redir[section]->ban_urls[i]);l++)
    if ((redir[section]->ban_urls[i])[l]==1)  fprintf(stderr,"!");
    else fprintf(stderr,"%c",(redir[section]->ban_urls[i])[l]);
    fprintf(stderr,"\n");
  }
  #endif

 return (0);
}
