/* i386-linux.elf-so_fold.h
   created from i386-linux.elf-so_fold.bin, 14087 (0x3707) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_I386_LINUX_ELF_SO_FOLD_SIZE    14087
#define STUB_I386_LINUX_ELF_SO_FOLD_ADLER32 0x23c68524
#define STUB_I386_LINUX_ELF_SO_FOLD_CRC32   0x56db865a

unsigned char stub_i386_linux_elf_so_fold[14087] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  68, 32,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  24,  0, 21,  0, 85,137,229, 83,255,117,  8,232,252,255,255,255,
/* 0x0040 */ 131,196,  4,187,127,  0,  0,  0,106,  1, 88,205,128,235,254, 85,
/* 0x0050 */ 137,229, 87, 86, 83,139,125,  8,139,119,  4,139, 93, 12,139, 69,
/* 0x0060 */  16, 57,  7,115, 10,106,  8,232,200,255,255,255,131,196,  4,139,
/* 0x0070 */  85, 16, 74,131,250,255,116, 12,138,  6,136,  3, 70, 67, 74,131,
/* 0x0080 */ 250,255,117,244,139, 69, 16,  1, 71,  4, 41,  7,141,101,244, 91,
/* 0x0090 */  94, 95,201,195, 85,137,229, 86, 83,131,236, 20,139,117,  8,139,
/* 0x00a0 */  93, 12,131, 59,  0, 15,132,220,  0,  0,  0,106, 12,141, 69,232,
/* 0x00b0 */  80, 86,232,152,255,255,255,131,196, 12,131,125,232,  0,117, 43,
/* 0x00c0 */ 129,125,236, 85, 80, 88, 33,116, 10,106,  2,232,100,255,255,255,
/* 0x00d0 */ 131,196,  4,131, 62,  0, 15,132,171,  0,  0,  0,106,  3,232, 81,
/* 0x00e0 */ 255,255,255,131,196,  4,233,156,  0,  0,  0,131,125,236,  0,117,
/* 0x00f0 */  10,106,  4,232, 60,255,255,255,131,196,  4,139, 69,236, 59, 69,
/* 0x0100 */ 232,119,  7,139, 69,232, 59,  3,118, 10,106,  5,232, 35,255,255,
/* 0x0110 */ 255,131,196,  4,139, 69,236, 59, 69,232,115, 68,139, 69,232,137,
/* 0x0120 */  69,228,141, 69,228, 80,255,115,  4,139, 70,  4,131,232, 12, 80,
/* 0x0130 */ 232,252,255,255,255,131,196, 12,133,192,117,  8,139, 69,232, 59,
/* 0x0140 */  69,228,116, 10,106,  7,232,233,254,255,255,131,196,  4,139, 70,
/* 0x0150 */   4,  3, 69,236,137, 70,  4,139,  6, 43, 69,236,137,  6,235, 15,
/* 0x0160 */ 255,117,236,255,115,  4, 86,232,227,254,255,255,131,196, 12,139,
/* 0x0170 */  67,  4,  3, 69,232,137, 67,  4,139,  3, 43, 69,232,137,  3,133,
/* 0x0180 */ 192, 15,133, 36,255,255,255,141,101,248, 91, 94,201,195, 85,137,
/* 0x0190 */ 229, 86, 83,131,236, 16,139, 85,  8,185,  0,  0,  0,  0,131, 58,
/* 0x01a0 */   1,117,118,246, 66, 24,  1,116,112,139, 66, 20, 43, 66, 16,139,
/* 0x01b0 */  85, 12,  1,194,137,208,247,216, 35, 69, 16,199, 69,244,205,128,
/* 0x01c0 */  97,195,131,248,  3,118, 11,137,209,184,205,128, 97,195,137,  2,
/* 0x01d0 */ 235, 71,232,  4,  0,  0,  0,117,112,120,  0, 90,185,  0,  0,  0,
/* 0x01e0 */   0,190,100,  1,  0,  0,137,240,137,211,205,128,137,198,141, 77,
/* 0x01f0 */ 244,186,  4,  0,  0,  0,137,195,106,  4, 88,205,128,106,  0, 86,
/* 0x0200 */ 106,  1,106,  5,106,  4,106,  0,232,252,255,255,255,137,193,131,
/* 0x0210 */ 196, 24,137,243,106,  6, 88,205,128,137,200,141,101,248, 91, 94,
/* 0x0220 */ 201,195,184,  0,240,255,255,195, 85,137,229, 87, 86, 83,129,236,
/* 0x0230 */   0, 16,  0,  0,139, 93, 12,139,117, 16,141,189,244,239,255,255,
/* 0x0240 */  86, 83, 87,232,252,255,255,255,106,  0,106,255,106, 50,106,  3,
/* 0x0250 */ 255,117,  8, 83,232,252,255,255,255,131,196, 36, 86, 87, 83,232,
/* 0x0260 */ 252,255,255,255,131,196, 12,141,101,244, 91, 94, 95,201,195,232,
/* 0x0270 */   9,  0,  0,  0, 64,  4,  2,  6,  1,  5,  3,  7,  0, 90,139, 68,
/* 0x0280 */  36,  4,139, 64, 24,131,224,  7, 15,190,  4,  2,131,224,  7,195,
/* 0x0290 */  85,137,229, 87, 86, 83,131,236,112,139, 93,  8,232,252,255,255,
/* 0x02a0 */ 255,137, 69,192,139,  3,137,218, 41,194,137, 85,188,137, 69,228,
/* 0x02b0 */ 139, 83,  4,137, 85,232,139, 67,  8,137, 69,236,139,115, 12,137,
/* 0x02c0 */ 117,240,  3,117,188, 41,243,137, 93,184,  3, 85,188,137, 85,180,
/* 0x02d0 */ 106,  0,106,255,106, 34,106,  3, 83,106,  0,232,252,255,255,255,
/* 0x02e0 */ 137, 69,176, 83, 86, 80,232,252,255,255,255,139, 77,176,131,193,
/* 0x02f0 */  24,137, 77,172,139, 93,176,139, 67, 24,139, 85, 16,137, 69,204,
/* 0x0300 */ 137, 85,208,139, 65,  4,131,192, 12,137, 69,196,137, 77,200,131,
/* 0x0310 */ 196, 36,141, 69,204, 80,141, 69,196, 80,232,117,253,255,255,139,
/* 0x0320 */ 125, 16,131,199, 52,139, 85, 16, 15,183, 66, 44,193,224,  5,  1,
/* 0x0330 */ 248,137, 69,144,131,196,  8,131,122, 52,  1,116,  8,131,199, 32,
/* 0x0340 */ 131, 63,  1,117,248,139, 77,188, 43, 79,  8,137, 77,168,246, 71,
/* 0x0350 */  24,  1, 15,132,129,  0,  0,  0,232,  4,  0,  0,  0,117,112,120,
/* 0x0360 */   0, 90,185,  0,  0,  0,  0,190,100,  1,  0,  0,137,240,137,211,
/* 0x0370 */ 205,128,137, 69,136,139,117,192,247,222,137,195,137,241,106, 93,
/* 0x0380 */  88,205,128,139, 69,172,255, 48,255,117, 16,255,117,136,232,252,
/* 0x0390 */ 255,255,255,137,240,139, 85,172, 43,  2, 80,139, 69,188,  3,  2,
/* 0x03a0 */  80,255,117,136,232,252,255,255,255, 86,255,117,188,232,252,255,
/* 0x03b0 */ 255,255,131,196, 32,106,  0,255,117,136,106, 17, 87,232,252,255,
/* 0x03c0 */ 255,255,137,  4, 36, 86,255,117,188,232,252,255,255,255,131,196,
/* 0x03d0 */  24,139, 93,136,106,  6, 88,205,128,199, 69,156,  0,  0,  0,  0,
/* 0x03e0 */  59,125,144, 15,131,163,  1,  0,  0,131, 63,  1, 15,133,142,  1,
/* 0x03f0 */   0,  0,246, 71, 24,  2, 15,133,132,  1,  0,  0,139, 87,  4,139,
/* 0x0400 */  71, 16,  1,208, 59, 69,236, 15,134,115,  1,  0,  0,139, 69,236,
/* 0x0410 */ 199, 69,152,  0,  0,  0,  0, 59, 71,  4,114,  5, 41,208,137, 69,
/* 0x0420 */ 152,199, 69,196, 12,  0,  0,  0,255,117,196,141, 69,212, 80,141,
/* 0x0430 */  69,196, 80,232, 23,252,255,255,131,109,200, 12,139, 77,152,  3,
/* 0x0440 */  79,  8,139, 93,168,141, 20, 25,139, 71, 20, 43, 69,152,137, 69,
/* 0x0450 */ 204,139, 69,192,247,208, 33,193,137, 77,140, 41,202,137, 85,208,
/* 0x0460 */   1, 77,204,190,  0,  0,  0,  0,199, 69,148,  0,  0,  0,  0,131,
/* 0x0470 */ 196, 12,246, 71, 24,  1,116, 82,232,  4,  0,  0,  0,117,112,120,
/* 0x0480 */   0, 91,186,100,  1,  0,  0,137,208,137,241,205,128,137,198,139,
/* 0x0490 */  77,204,137,195,106, 93, 88,205,128,255,117,140,255,117,208, 86,
/* 0x04a0 */ 232,252,255,255,255,255,117,204,255,117,208,232,252,255,255,255,
/* 0x04b0 */ 106,  0, 86,106, 17,106,  3,255,117,204,255,117,208,232,252,255,
/* 0x04c0 */ 255,255,137, 69,148,131,196, 44,235, 20,255,119, 24,255,117,140,
/* 0x04d0 */ 255,117,208,255,117,204,232, 77,253,255,255,131,196, 16,141, 93,
/* 0x04e0 */ 204,139, 69,140,  1, 67,  4,139, 69,212,137, 69,204,139, 69,216,
/* 0x04f0 */ 131,192, 12,137, 69,196, 83,141, 85,196, 82,232,148,251,255,255,
/* 0x0500 */ 131,196,  8,131,125,156,  0,117, 27,246, 71, 24,  1,116, 21,139,
/* 0x0510 */  69,192,247,208, 80,255,115,  4, 87,232,112,252,255,255,137, 69,
/* 0x0520 */ 156,131,196, 12,246, 71, 24,  1,116, 59,139, 69,140,  3, 69,212,
/* 0x0530 */  80,255,117,148,232,252,255,255,255,106,  0, 86,106, 17, 87,232,
/* 0x0540 */ 252,255,255,255,137,  4, 36,255,117,212,139, 69,168,  3, 71,  8,
/* 0x0550 */   3, 69,152, 80,232,252,255,255,255,131,196, 32,137,243,106,  6,
/* 0x0560 */  88,205,128,235, 27, 87,232,252,255,255,255,137,  4, 36,255,119,
/* 0x0570 */  20,139, 69,168,  3, 71,  8, 80,232,252,255,255,255,131,196, 12,
/* 0x0580 */ 131,199, 32, 59,125,144, 15,130, 93,254,255,255,255,117,184,255,
/* 0x0590 */ 117,176,232,252,255,255,255,139, 69, 12,255,112,  8,255,112,  4,
/* 0x05a0 */ 255, 48,255, 85,180,131,196, 20,139, 69,156,141,101,244, 91, 94,
/* 0x05b0 */  95,201,195,137,224,139, 72,  8,129,236,  0,  2,  0,  0, 84,131,
/* 0x05c0 */ 192, 48, 80, 81,232,252,255,255,255,129,196, 12,  2,  0,  0,137,
/* 0x05d0 */ 197, 91, 89, 90,104, 91,  0,  0,  0, 88,255,229,195, 88,255,208,
/* 0x05e0 */  89,137,240, 41,200, 90, 41,215, 89,137, 57, 91, 93,195,204,195,
/* 0x05f0 */  87,137,240,137,209,243,170, 88,195, 89,137,248, 95,137,242, 94,
/* 0x0600 */ 135, 12, 36, 87,209,233,115,  1,164,209,233,115,  2,102,165,116,
/* 0x0610 */   2,243,165,137,199,137,214, 88, 90,131,236, 12, 82,195, 83,141,
/* 0x0620 */  92, 36,  8,139,  3, 37,255, 15,  0,  0, 41,  3,  1, 67,  4,106,
/* 0x0630 */  90, 88,205,128, 61,  0,240,255,255,118,  1,244, 91,195,135, 92,
/* 0x0640 */  36,  4,137,217,129,227,  0,240,255,255, 41,217,  3, 76, 36,  8,
/* 0x0650 */ 139, 84, 36, 12,106,125, 88,205,128, 61,  0,240,255,255,118,  1,
/* 0x0660 */ 244,139, 92, 36,  4,195, 85,137,229, 83,139, 93,  8,137,216, 37,
/* 0x0670 */ 255, 15,  0,  0, 41,195,139, 77, 12,  1,193,106, 91, 88,205,128,
/* 0x0680 */  61,  0,240,255,255,118,  1,244, 91, 93,195,104,100,  1,  0,  0,
/* 0x0690 */ 235, 13,137,216, 37,255, 15,  0,  0, 41,195,  1,193,106,125,235,
/* 0x06a0 */   2,106,  1,235,  2,106,  6,235,  2,106, 91,235,  2,106,  4, 88,
/* 0x06b0 */ 205,128,195,131,124, 36, 16, 73,117, 79, 85,137,229, 83, 86, 87,
/* 0x06c0 */ 139,117,  8,139, 77, 12,139, 85, 16,141, 76, 14,253,137,243,235,
/* 0x06d0 */  45, 57,206,115, 48, 86, 94,172, 60,128,114, 10, 60,143,119,  6,
/* 0x06e0 */ 128,126,254, 15,116,  6, 44,232, 60,  1,119,229, 57,206,115, 21,
/* 0x06f0 */  86,173, 40,208,117,224, 95, 15,200, 41,248,  1,216,171, 57,206,
/* 0x0700 */ 115,  3,172,235,225, 95, 94, 91, 93,195, 85,137,229, 87, 86, 83,
/* 0x0710 */ 232,107,  0,  0,  0, 80,139,117,  8, 15,182, 70,  9,133,192,116,
/* 0x0720 */  19, 80, 15,182, 70, 10, 80,255, 54,255,117, 12,232,130,255,255,
/* 0x0730 */ 255,131,196, 16, 88, 91, 94, 95, 93,195,139, 30,131,238,252, 17,
/* 0x0740 */ 219,138, 22,243,195,  1,219,116,241,243,195,141,  4, 47,131,249,
/* 0x0750 */   5,138, 16,118, 30,131,253,252,119, 25,131,233,  4,139, 16,131,
/* 0x0760 */ 192,  4,131,233,  4,137, 23,141,127,  4,115,241,131,193,  4,138,
/* 0x0770 */  16,116, 11, 64,136, 23, 73,138, 16,141,127,  1,117,245,243,195,
/* 0x0780 */ 139,117,  8,139,125, 12,173,139, 85, 16,137,  2, 82,173,145,173,
/* 0x0790 */  15,182,208,  1,241, 81, 87, 85, 49,219, 49,201,131,205,255,252,
/* 0x07a0 */  15,182, 86,252, 93, 88, 41,199, 88, 89,137, 57, 41,240,195,128,
/* 0x07b0 */ 250,  8, 15,133,199,  0,  0,  0,235,  4, 70,136, 23, 71,138, 22,
/* 0x07c0 */   1,219,117,  9,139, 30,131,238,252, 17,219,138, 22,114,235,106,
/* 0x07d0 */   1, 88,235, 16, 72,  1,219,117,  9,139, 30,131,238,252, 17,219,
/* 0x07e0 */ 138, 22, 17,192,  1,219,117,  9,139, 30,131,238,252, 17,219,138,
/* 0x07f0 */  22, 17,192,  1,219,117,  9,139, 30,131,238,252, 17,219,138, 22,
/* 0x0800 */ 115,210,131,232,  3,114, 26,193,224,  8, 15,182,210,  9,208, 70,
/* 0x0810 */ 131,240,255, 15,132,252,255,255,255,209,248,137,197,114, 62,235,
/* 0x0820 */  13,  1,219,117,  7,139, 30,131,238,252, 17,219,114, 47, 65,  1,
/* 0x0830 */ 219,117,  7,139, 30,131,238,252, 17,219,114, 33,  1,219,117,  9,
/* 0x0840 */ 139, 30,131,238,252, 17,219,138, 22, 17,201,  1,219,117,  7,139,
/* 0x0850 */  30,131,238,252, 17,219,115,228,131,193,  2,235, 15,  1,219,117,
/* 0x0860 */   9,139, 30,131,238,252, 17,219,138, 22, 17,201,129,253,  0,251,
/* 0x0870 */ 255,255,131,209,  2,232,148,  0,  0,  0,233, 63,255,255,255, 87,
/* 0x0880 */  94,128,250,  5, 15,133,186,  0,  0,  0,235,  4, 70,136, 23, 71,
/* 0x0890 */ 138, 22,  1,219,117,  9,139, 30,131,238,252, 17,219,138, 22,114,
/* 0x08a0 */ 235,106,  1, 88,235, 16, 72,  1,219,117,  9,139, 30,131,238,252,
/* 0x08b0 */  17,219,138, 22, 17,192,  1,219,117,  9,139, 30,131,238,252, 17,
/* 0x08c0 */ 219,138, 22, 17,192,  1,219,117,  9,139, 30,131,238,252, 17,219,
/* 0x08d0 */ 138, 22,115,210,131,232,  3,114, 24,193,224,  8, 15,182,210,  9,
/* 0x08e0 */ 208, 70,131,240,255, 15,132,252,255,255,255,209,248,137,197,235,
/* 0x08f0 */  13,  1,219,117,  9,139, 30,131,238,252, 17,219,138, 22, 17,201,
/* 0x0900 */   1,219,117,  9,139, 30,131,238,252, 17,219,138, 22, 17,201,117,
/* 0x0910 */  32, 65,  1,219,117,  9,139, 30,131,238,252, 17,219,138, 22, 17,
/* 0x0920 */ 201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,228,131,193,
/* 0x0930 */   2,129,253,  0,251,255,255,131,209,  1,232,148,  0,  0,  0,233,
/* 0x0940 */  76,255,255,255, 87, 94,128,250,  2, 15,133,167,  0,  0,  0,235,
/* 0x0950 */   4, 70,136, 23, 71,138, 22,  1,219,117,  9,139, 30,131,238,252,
/* 0x0960 */  17,219,138, 22,114,235,106,  1, 88,  1,219,117,  9,139, 30,131,
/* 0x0970 */ 238,252, 17,219,138, 22, 17,192,  1,219,117,  9,139, 30,131,238,
/* 0x0980 */ 252, 17,219,138, 22,115,226,131,232,  3,114, 20,193,224,  8, 15,
/* 0x0990 */ 182,210,  9,208, 70,131,240,255, 15,132,252,255,255,255,137,197,
/* 0x09a0 */ 106,  1, 88,  1,219,117,  9,139, 30,131,238,252, 17,219,138, 22,
/* 0x09b0 */  17,201,  1,219,117,  9,139, 30,131,238,252, 17,219,138, 22, 17,
/* 0x09c0 */ 201,117, 33,137,193,131,192,  2,  1,219,117,  9,139, 30,131,238,
/* 0x09d0 */ 252, 17,219,138, 22, 17,201,  1,219,117,  7,139, 30,131,238,252,
/* 0x09e0 */  17,219,115,228,129,253,  0,243,255,255, 17,193,232,148,  0,  0,
/* 0x09f0 */   0,233, 95,255,255,255,137,229,141,156, 36,  0,  0,  0,  0, 49,
/* 0x0a00 */ 192, 80, 57,220,117,251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,
/* 0x0a10 */ 195,  4, 83,104,  0,  0,  0,  0, 86,131,195,  4, 83, 80,199,  3,
/* 0x0a20 */   0,  0,  0,  0,137,229,139, 85,  0,172, 74,136,193, 36,  7,192,
/* 0x0a30 */ 233,  3,187,  0,253,255,255,211,227,141,164, 92,144,241,255,255,
/* 0x0a40 */ 131,228,224,106,  0,106,  0,137,227, 83,131,195,  4,139, 77,  0,
/* 0x0a50 */ 255, 49, 87, 83,131,195,  4,136, 67,  2,172, 74,136,193, 36, 15,
/* 0x0a60 */ 136,  3,192,233,  4,136, 75,  1, 82, 86, 83, 80, 85, 87, 86, 83,
/* 0x0a70 */ 131,236,124,139,148, 36,144,  0,  0,  0,199, 68, 36,116,  0,  0,
/* 0x0a80 */   0,  0,198, 68, 36,115,  0,139,172, 36,156,  0,  0,  0,141, 66,
/* 0x0a90 */   4,137, 68, 36,120,184,  1,  0,  0,  0, 15,182, 74,  2,137,195,
/* 0x0aa0 */ 211,227,137,217, 73,137, 76, 36,108, 15,182, 74,  1,211,224, 72,
/* 0x0ab0 */ 137, 68, 36,104,139,132, 36,168,  0,  0,  0, 15,182, 50,199, 69,
/* 0x0ac0 */   0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,  0,  0,199,  0,  0,
/* 0x0ad0 */   0,  0,  0,184,  0,  3,  0,  0,137,116, 36,100,199, 68, 36, 92,
/* 0x0ae0 */   1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,  0,199, 68, 36, 84,
/* 0x0af0 */   1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,  0, 15,182, 74,  1,
/* 0x0b00 */   1,241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36,116,115, 14,
/* 0x0b10 */ 139, 68, 36,120,102,199,  0,  0,  4,131,192,  2,226,246,139,156,
/* 0x0b20 */  36,148,  0,  0,  0, 49,255,199, 68, 36, 72,255,255,255,255,137,
/* 0x0b30 */ 218,  3,148, 36,152,  0,  0,  0,137, 84, 36, 76, 49,210, 59, 92,
/* 0x0b40 */  36, 76, 15,132,124,  9,  0,  0, 15,182,  3,193,231,  8, 66, 67,
/* 0x0b50 */   9,199,131,250,  4,126,231,139,140, 36,164,  0,  0,  0, 57, 76,
/* 0x0b60 */  36,116, 15,131,100,  9,  0,  0,139,116, 36,116, 35,116, 36,108,
/* 0x0b70 */ 139, 68, 36, 96,139, 84, 36,120,193,224,  4,137,116, 36, 68,  1,
/* 0x0b80 */ 240,129,124, 36, 72,255,255,255,  0,141, 44, 66,119, 24, 59, 92,
/* 0x0b90 */  36, 76, 15,132, 44,  9,  0,  0,193,100, 36, 72,  8, 15,182,  3,
/* 0x0ba0 */ 193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232,
/* 0x0bb0 */  11, 15,183,202, 15,175,193, 57,199, 15,131,221,  1,  0,  0,137,
/* 0x0bc0 */  68, 36, 72,184,  0,  8,  0,  0, 41,200,138, 76, 36,100,193,248,
/* 0x0bd0 */   5,190,  1,  0,  0,  0,141,  4,  2, 15,182, 84, 36,115,102,137,
/* 0x0be0 */  69,  0,139, 68, 36,116, 35, 68, 36,104,139,108, 36,120,211,224,
/* 0x0bf0 */ 185,  8,  0,  0,  0, 43, 76, 36,100,211,250,  1,208,105,192,  0,
/* 0x0c00 */   6,  0,  0,131,124, 36, 96,  6,141,132,  5,108, 14,  0,  0,137,
/* 0x0c10 */  68, 36, 20, 15,142,202,  0,  0,  0,139, 68, 36,116, 43, 68, 36,
/* 0x0c20 */  92,139,148, 36,160,  0,  0,  0, 15,182,  4,  2,137, 68, 36, 64,
/* 0x0c30 */ 209,100, 36, 64,139, 76, 36, 64,141, 20, 54,139,108, 36, 20,129,
/* 0x0c40 */ 225,  0,  1,  0,  0,129,124, 36, 72,255,255,255,  0,141, 68, 77,
/* 0x0c50 */   0,137, 76, 36, 60,141, 44, 16,119, 24, 59, 92, 36, 76, 15,132,
/* 0x0c60 */  96,  8,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,
/* 0x0c70 */   9,199,139, 68, 36, 72,102,139,141,  0,  2,  0,  0,193,232, 11,
/* 0x0c80 */  15,183,241, 15,175,198, 57,199,115, 35,137, 68, 36, 72,184,  0,
/* 0x0c90 */   8,  0,  0, 41,240,137,214,193,248,  5,131,124, 36, 60,  0,141,
/* 0x0ca0 */   4,  1,102,137,133,  0,  2,  0,  0,116, 34,235, 46, 41, 68, 36,
/* 0x0cb0 */  72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,131,
/* 0x0cc0 */ 124, 36, 60,  0,102,137,141,  0,  2,  0,  0,116, 14,129,254,255,
/* 0x0cd0 */   0,  0,  0, 15,142, 87,255,255,255,235,121,129,254,255,  0,  0,
/* 0x0ce0 */   0,127,113,141, 20, 54,139,108, 36, 20,  1,213,129,124, 36, 72,
/* 0x0cf0 */ 255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,196,  7,  0,  0,
/* 0x0d00 */ 193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68,
/* 0x0d10 */  36, 72,102,139, 77,  0,193,232, 11, 15,183,241, 15,175,198, 57,
/* 0x0d20 */ 199,115, 25,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,
/* 0x0d30 */ 193,248,  5,141,  4,  1,102,137, 69,  0,235,159, 41, 68, 36, 72,
/* 0x0d40 */  41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,102,137,
/* 0x0d50 */  77,  0,235,135,139, 84, 36,116,137,240,139,140, 36,160,  0,  0,
/* 0x0d60 */   0,136, 68, 36,115,136,  4, 10, 66,131,124, 36, 96,  3,137, 84,
/* 0x0d70 */  36,116,127, 13,199, 68, 36, 96,  0,  0,  0,  0,233, 27,  7,  0,
/* 0x0d80 */   0,131,124, 36, 96,  9,127, 10,131,108, 36, 96,  3,233, 10,  7,
/* 0x0d90 */   0,  0,131,108, 36, 96,  6,233,  0,  7,  0,  0,139, 76, 36, 72,
/* 0x0da0 */  41,199,139,116, 36, 96, 41,193,137,208,102,193,232,  5,102, 41,
/* 0x0db0 */ 194,129,249,255,255,255,  0,102,137, 85,  0,139,108, 36,120,141,
/* 0x0dc0 */ 116,117,  0,137,116, 36, 56,119, 22, 59, 92, 36, 76, 15,132,241,
/* 0x0dd0 */   6,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,139,
/* 0x0de0 */ 108, 36, 56,137,200,193,232, 11,102,139,149,128,  1,  0,  0, 15,
/* 0x0df0 */ 183,234, 15,175,197, 57,199,115, 82,137,198,184,  0,  8,  0,  0,
/* 0x0e00 */  41,232,139,108, 36, 88,193,248,  5,139, 76, 36, 84,141,  4,  2,
/* 0x0e10 */ 139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,120,102,137,130,128,
/* 0x0e20 */   1,  0,  0,139, 68, 36, 92,137,108, 36, 84,137, 68, 36, 88, 49,
/* 0x0e30 */ 192,131,124, 36, 96,  6, 15,159,192,129,193,100,  6,  0,  0,141,
/* 0x0e40 */   4, 64,137, 68, 36, 96,233,116,  2,  0,  0,137,206, 41,199, 41,
/* 0x0e50 */ 198,137,208,102,193,232,  5,139, 76, 36, 56,102, 41,194,129,254,
/* 0x0e60 */ 255,255,255,  0,102,137,145,128,  1,  0,  0,119, 22, 59, 92, 36,
/* 0x0e70 */  76, 15,132, 77,  6,  0,  0, 15,182,  3,193,231,  8,193,230,  8,
/* 0x0e80 */  67,  9,199,139,108, 36, 56,137,242,193,234, 11,102,139,141,152,
/* 0x0e90 */   1,  0,  0, 15,183,193, 15,175,208, 57,215, 15,131,227,  0,  0,
/* 0x0ea0 */   0,189,  0,  8,  0,  0,137,214, 41,197,199, 68, 36, 52,  0,  8,
/* 0x0eb0 */   0,  0,137,232,193,248,  5,141,  4,  1,139, 76, 36, 56,102,137,
/* 0x0ec0 */ 129,152,  1,  0,  0,139, 68, 36, 96,139, 76, 36, 68,193,224,  5,
/* 0x0ed0 */   3, 68, 36,120,129,250,255,255,255,  0,141, 44, 72,119, 22, 59,
/* 0x0ee0 */  92, 36, 76, 15,132,219,  5,  0,  0, 15,182,  3,193,231,  8,193,
/* 0x0ef0 */ 230,  8, 67,  9,199,102,139,149,224,  1,  0,  0,137,240,193,232,
/* 0x0f00 */  11, 15,183,202, 15,175,193, 57,199,115, 96, 41, 76, 36, 52,193,
/* 0x0f10 */ 124, 36, 52,  5,139,116, 36, 52,137, 68, 36, 72,131,124, 36,116,
/* 0x0f20 */   0,141,  4, 50,102,137,133,224,  1,  0,  0, 15,132,147,  5,  0,
/* 0x0f30 */   0, 49,192,131,124, 36, 96,  6,139,172, 36,160,  0,  0,  0,139,
/* 0x0f40 */  84, 36,116, 15,159,192,141, 68,  0,  9,137, 68, 36, 96,139, 68,
/* 0x0f50 */  36,116, 43, 68, 36, 92,138, 68,  5,  0,136, 68, 36,115,136,  4,
/* 0x0f60 */  42, 66,137, 84, 36,116,233, 49,  5,  0,  0, 41,198, 41,199,137,
/* 0x0f70 */ 208,102,193,232,  5,102, 41,194,102,137,149,224,  1,  0,  0,233,
/* 0x0f80 */  31,  1,  0,  0,137,200, 41,214,102,193,232,  5,139,108, 36, 56,
/* 0x0f90 */ 102, 41,193, 41,215,129,254,255,255,255,  0,102,137,141,152,  1,
/* 0x0fa0 */   0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,  5,  0,  0, 15,182,
/* 0x0fb0 */   3,193,231,  8,193,230,  8, 67,  9,199,139, 76, 36, 56,137,240,
/* 0x0fc0 */ 193,232, 11,102,139,145,176,  1,  0,  0, 15,183,202, 15,175,193,
/* 0x0fd0 */  57,199,115, 35,137,198,184,  0,  8,  0,  0, 41,200,139,108, 36,
/* 0x0fe0 */  56,193,248,  5,141,  4,  2,102,137,133,176,  1,  0,  0,139, 68,
/* 0x0ff0 */  36, 88,233,160,  0,  0,  0,137,241, 41,199, 41,193,137,208,102,
/* 0x1000 */ 193,232,  5,102, 41,194,139, 68, 36, 56,129,249,255,255,255,  0,
/* 0x1010 */ 102,137,144,176,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,161,
/* 0x1020 */   4,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,139,
/* 0x1030 */ 116, 36, 56,137,200,193,232, 11,102,139,150,200,  1,  0,  0, 15,
/* 0x1040 */ 183,234, 15,175,197, 57,199,115, 32,137,198,184,  0,  8,  0,  0,
/* 0x1050 */  41,232,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,200,
/* 0x1060 */   1,  0,  0,139, 68, 36, 84,235, 38,137,206, 41,199, 41,198,137,
/* 0x1070 */ 208,102,193,232,  5,102, 41,194,139, 68, 36, 56,102,137,144,200,
/* 0x1080 */   1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,137, 84, 36, 80,139,
/* 0x1090 */  76, 36, 88,137, 76, 36, 84,139,108, 36, 92,137, 68, 36, 92,137,
/* 0x10a0 */ 108, 36, 88, 49,192,131,124, 36, 96,  6,139, 76, 36,120, 15,159,
/* 0x10b0 */ 192,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 96,129,
/* 0x10c0 */ 254,255,255,255,  0,119, 22, 59, 92, 36, 76, 15,132,243,  3,  0,
/* 0x10d0 */   0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 17,
/* 0x10e0 */ 137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 47,137,
/* 0x10f0 */  68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,
/* 0x1100 */ 248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,  4,  2,102,137,  1,
/* 0x1110 */ 139, 68, 36, 68,141, 76,  1,  4,137, 76, 36, 16,235,114, 41,198,
/* 0x1120 */  41,199,137,208,102,193,232,  5,102, 41,194,129,254,255,255,255,
/* 0x1130 */   0,102,137, 17,119, 22, 59, 92, 36, 76, 15,132,132,  3,  0,  0,
/* 0x1140 */  15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 81,  2,
/* 0x1150 */ 137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 59,137,
/* 0x1160 */  68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,
/* 0x1170 */ 248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,  4,  2,139, 84, 36,
/* 0x1180 */  68,102,137, 65,  2,141,140, 17,  4,  1,  0,  0,137, 76, 36, 16,
/* 0x1190 */ 199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,198, 41,199,137,208,
/* 0x11a0 */ 137,116, 36, 72,102,193,232,  5,199, 68, 36, 44, 16,  0,  0,  0,
/* 0x11b0 */ 102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,102,137, 81,  2,129,
/* 0x11c0 */ 193,  4,  2,  0,  0,137, 76, 36, 16,139, 76, 36, 48,186,  1,  0,
/* 0x11d0 */   0,  0,137, 76, 36, 40,141, 44, 18,139,116, 36, 16,  1,238,129,
/* 0x11e0 */ 124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,209,
/* 0x11f0 */   2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x1200 */ 199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,175,
/* 0x1210 */ 193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,
/* 0x1220 */ 193,248,  5,141,  4,  2,137,234,102,137,  6,235, 21, 41, 68, 36,
/* 0x1230 */  72, 41,199,137,208,102,193,232,  5,102, 41,194,102,137, 22,141,
/* 0x1240 */  85,  1,139,116, 36, 40, 78,137,116, 36, 40,117,137,138, 76, 36,
/* 0x1250 */  48,184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 44,131,124,
/* 0x1260 */  36, 96,  3,137, 84, 36, 12, 15,143,231,  1,  0,  0,131, 68, 36,
/* 0x1270 */  96,  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139,116,
/* 0x1280 */  36,120,193,224,  7,199, 68, 36, 36,  6,  0,  0,  0,141,132,  6,
/* 0x1290 */  96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,141, 44,  0,
/* 0x12a0 */ 139,116, 36,  8,  1,238,129,124, 36, 72,255,255,255,  0,119, 24,
/* 0x12b0 */  59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,100, 36, 72,  8, 15,
/* 0x12c0 */ 182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,
/* 0x12d0 */ 232, 11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,
/* 0x12e0 */ 184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,  6,
/* 0x12f0 */ 137,232,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,
/* 0x1300 */ 102, 41,194,141, 69,  1,102,137, 22,139,108, 36, 36, 77,137,108,
/* 0x1310 */  36, 36,117,137,141, 80,192,131,250,  3,137, 20, 36, 15,142, 39,
/* 0x1320 */   1,  0,  0,137,208,137,214,209,248,131,230,  1,141, 72,255,131,
/* 0x1330 */ 206,  2,131,250, 13,137, 76, 36, 32,127, 28,139,108, 36,120,211,
/* 0x1340 */ 230,  1,210,137, 52, 36,141, 68,117,  0, 41,208,  5, 94,  5,  0,
/* 0x1350 */   0,137, 68, 36,  4,235, 86,141, 80,251,129,124, 36, 72,255,255,
/* 0x1360 */ 255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,  1,  0,  0,193,100,
/* 0x1370 */  36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,209,108, 36, 72,
/* 0x1380 */   1,246, 59,124, 36, 72,114,  7, 43,124, 36, 72,131,206,  1, 74,
/* 0x1390 */ 117,200,139, 68, 36,120,193,230,  4,137, 52, 36,  5, 68,  6,  0,
/* 0x13a0 */   0,199, 68, 36, 32,  4,  0,  0,  0,137, 68, 36,  4,199, 68, 36,
/* 0x13b0 */  28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,108, 36,  4,  1,192,
/* 0x13c0 */ 137, 68, 36, 24,  1,197,129,124, 36, 72,255,255,255,  0,119, 24,
/* 0x13d0 */  59, 92, 36, 76, 15,132,234,  0,  0,  0,193,100, 36, 72,  8, 15,
/* 0x13e0 */ 182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,
/* 0x13f0 */ 193,232, 11, 15,183,242, 15,175,198, 57,199,115, 27,137, 68, 36,
/* 0x1400 */  72,184,  0,  8,  0,  0, 41,240,193,248,  5,141,  4,  2,102,137,
/* 0x1410 */  69,  0,139, 68, 36, 24,235, 31, 41, 68, 36, 72, 41,199,137,208,
/* 0x1420 */ 102,193,232,  5,102, 41,194,139, 68, 36, 24,102,137, 85,  0,139,
/* 0x1430 */  84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,209,100, 36, 28, 73,
/* 0x1440 */ 137, 76, 36, 32, 15,133,112,255,255,255,139, 52, 36, 70,137,116,
/* 0x1450 */  36, 92,116, 89,139, 76, 36, 12,139,108, 36,116,131,193,  2, 57,
/* 0x1460 */ 108, 36, 92,119, 95,139,132, 36,160,  0,  0,  0,137,234, 43, 68,
/* 0x1470 */  36, 92,  3,148, 36,160,  0,  0,  0,141, 52, 40,138,  6, 70,136,
/* 0x1480 */  68, 36,115,136,  2, 66,255, 68, 36,116, 73,116, 15,139,172, 36,
/* 0x1490 */ 164,  0,  0,  0, 57,108, 36,116,114,226,235, 17,139,132, 36,164,
/* 0x14a0 */   0,  0,  0, 57, 68, 36,116, 15,130,187,246,255,255,129,124, 36,
/* 0x14b0 */  72,255,255,255,  0,119, 21, 59, 92, 36, 76,184,  1,  0,  0,  0,
/* 0x14c0 */ 116, 41,235,  7,184,  1,  0,  0,  0,235, 32, 67, 43,156, 36,148,
/* 0x14d0 */   0,  0,  0, 49,192,139,148, 36,156,  0,  0,  0,139, 76, 36,116,
/* 0x14e0 */ 137, 26,139,156, 36,168,  0,  0,  0,137, 11,131,196,124, 91, 94,
/* 0x14f0 */  95, 93, 85, 87, 86, 83,131,236,124,139,148, 36,144,  0,  0,  0,
/* 0x1500 */ 199, 68, 36,116,  0,  0,  0,  0,198, 68, 36,115,  0,139,172, 36,
/* 0x1510 */ 156,  0,  0,  0,141, 66,  4,137, 68, 36,120,184,  1,  0,  0,  0,
/* 0x1520 */  15,182, 74,  2,137,195,211,227,137,217, 73,137, 76, 36,108, 15,
/* 0x1530 */ 182, 74,  1,211,224, 72,137, 68, 36,104,139,132, 36,168,  0,  0,
/* 0x1540 */   0, 15,182, 50,199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,
/* 0x1550 */   0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,116,
/* 0x1560 */  36,100,199, 68, 36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,
/* 0x1570 */   0,  0,199, 68, 36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,
/* 0x1580 */   0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0,
/* 0x1590 */  57, 76, 36,116,115, 14,139, 68, 36,120,102,199,  0,  0,  4,131,
/* 0x15a0 */ 192,  2,226,246,139,156, 36,148,  0,  0,  0, 49,255,199, 68, 36,
/* 0x15b0 */  72,255,255,255,255,137,218,  3,148, 36,152,  0,  0,  0,137, 84,
/* 0x15c0 */  36, 76, 49,210, 59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,
/* 0x15d0 */   3,193,231,  8, 66, 67,  9,199,131,250,  4,126,231,139,140, 36,
/* 0x15e0 */ 164,  0,  0,  0, 57, 76, 36,116, 15,131,100,  9,  0,  0,139,116,
/* 0x15f0 */  36,116, 35,116, 36,108,139, 68, 36, 96,139, 84, 36,120,193,224,
/* 0x1600 */   4,137,116, 36, 68,  1,240,129,124, 36, 72,255,255,255,  0,141,
/* 0x1610 */  44, 66,119, 24, 59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,100,
/* 0x1620 */  36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,
/* 0x1630 */ 102,139, 85,  0,193,232, 11, 15,183,202, 15,175,193, 57,199, 15,
/* 0x1640 */ 131,221,  1,  0,  0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,
/* 0x1650 */ 138, 76, 36,100,193,248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,
/* 0x1660 */ 182, 84, 36,115,102,137, 69,  0,139, 68, 36,116, 35, 68, 36,104,
/* 0x1670 */ 139,108, 36,120,211,224,185,  8,  0,  0,  0, 43, 76, 36,100,211,
/* 0x1680 */ 250,  1,208,105,192,  0,  6,  0,  0,131,124, 36, 96,  6,141,132,
/* 0x1690 */   5,108, 14,  0,  0,137, 68, 36, 20, 15,142,202,  0,  0,  0,139,
/* 0x16a0 */  68, 36,116, 43, 68, 36, 92,139,148, 36,160,  0,  0,  0, 15,182,
/* 0x16b0 */   4,  2,137, 68, 36, 64,209,100, 36, 64,139, 76, 36, 64,141, 20,
/* 0x16c0 */  54,139,108, 36, 20,129,225,  0,  1,  0,  0,129,124, 36, 72,255,
/* 0x16d0 */ 255,255,  0,141, 68, 77,  0,137, 76, 36, 60,141, 44, 16,119, 24,
/* 0x16e0 */  59, 92, 36, 76, 15,132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,
/* 0x16f0 */ 182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,141,  0,
/* 0x1700 */   2,  0,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 35,
/* 0x1710 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,
/* 0x1720 */ 131,124, 36, 60,  0,141,  4,  1,102,137,133,  0,  2,  0,  0,116,
/* 0x1730 */  34,235, 46, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,
/* 0x1740 */ 232,  5,102, 41,193,131,124, 36, 60,  0,102,137,141,  0,  2,  0,
/* 0x1750 */   0,116, 14,129,254,255,  0,  0,  0, 15,142, 87,255,255,255,235,
/* 0x1760 */ 121,129,254,255,  0,  0,  0,127,113,141, 20, 54,139,108, 36, 20,
/* 0x1770 */   1,213,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76,
/* 0x1780 */  15,132,196,  7,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,
/* 0x1790 */   8, 67,  9,199,139, 68, 36, 72,102,139, 77,  0,193,232, 11, 15,
/* 0x17a0 */ 183,241, 15,175,198, 57,199,115, 25,137, 68, 36, 72,184,  0,  8,
/* 0x17b0 */   0,  0, 41,240,137,214,193,248,  5,141,  4,  1,102,137, 69,  0,
/* 0x17c0 */ 235,159, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,
/* 0x17d0 */   5,102, 41,193,102,137, 77,  0,235,135,139, 84, 36,116,137,240,
/* 0x17e0 */ 139,140, 36,160,  0,  0,  0,136, 68, 36,115,136,  4, 10, 66,131,
/* 0x17f0 */ 124, 36, 96,  3,137, 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,
/* 0x1800 */   0,  0,233, 27,  7,  0,  0,131,124, 36, 96,  9,127, 10,131,108,
/* 0x1810 */  36, 96,  3,233, 10,  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,
/* 0x1820 */   0,  0,139, 76, 36, 72, 41,199,139,116, 36, 96, 41,193,137,208,
/* 0x1830 */ 102,193,232,  5,102, 41,194,129,249,255,255,255,  0,102,137, 85,
/* 0x1840 */   0,139,108, 36,120,141,116,117,  0,137,116, 36, 56,119, 22, 59,
/* 0x1850 */  92, 36, 76, 15,132,241,  6,  0,  0, 15,182,  3,193,231,  8,193,
/* 0x1860 */ 225,  8, 67,  9,199,139,108, 36, 56,137,200,193,232, 11,102,139,
/* 0x1870 */ 149,128,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 82,137,
/* 0x1880 */ 198,184,  0,  8,  0,  0, 41,232,139,108, 36, 88,193,248,  5,139,
/* 0x1890 */  76, 36, 84,141,  4,  2,139, 84, 36, 56,137, 76, 36, 80,139, 76,
/* 0x18a0 */  36,120,102,137,130,128,  1,  0,  0,139, 68, 36, 92,137,108, 36,
/* 0x18b0 */  84,137, 68, 36, 88, 49,192,131,124, 36, 96,  6, 15,159,192,129,
/* 0x18c0 */ 193,100,  6,  0,  0,141,  4, 64,137, 68, 36, 96,233,116,  2,  0,
/* 0x18d0 */   0,137,206, 41,199, 41,198,137,208,102,193,232,  5,139, 76, 36,
/* 0x18e0 */  56,102, 41,194,129,254,255,255,255,  0,102,137,145,128,  1,  0,
/* 0x18f0 */   0,119, 22, 59, 92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,
/* 0x1900 */ 193,231,  8,193,230,  8, 67,  9,199,139,108, 36, 56,137,242,193,
/* 0x1910 */ 234, 11,102,139,141,152,  1,  0,  0, 15,183,193, 15,175,208, 57,
/* 0x1920 */ 215, 15,131,227,  0,  0,  0,189,  0,  8,  0,  0,137,214, 41,197,
/* 0x1930 */ 199, 68, 36, 52,  0,  8,  0,  0,137,232,193,248,  5,141,  4,  1,
/* 0x1940 */ 139, 76, 36, 56,102,137,129,152,  1,  0,  0,139, 68, 36, 96,139,
/* 0x1950 */  76, 36, 68,193,224,  5,  3, 68, 36,120,129,250,255,255,255,  0,
/* 0x1960 */ 141, 44, 72,119, 22, 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,
/* 0x1970 */ 182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139,149,224,  1,
/* 0x1980 */   0,  0,137,240,193,232, 11, 15,183,202, 15,175,193, 57,199,115,
/* 0x1990 */  96, 41, 76, 36, 52,193,124, 36, 52,  5,139,116, 36, 52,137, 68,
/* 0x19a0 */  36, 72,131,124, 36,116,  0,141,  4, 50,102,137,133,224,  1,  0,
/* 0x19b0 */   0, 15,132,147,  5,  0,  0, 49,192,131,124, 36, 96,  6,139,172,
/* 0x19c0 */  36,160,  0,  0,  0,139, 84, 36,116, 15,159,192,141, 68,  0,  9,
/* 0x19d0 */ 137, 68, 36, 96,139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,
/* 0x19e0 */ 136, 68, 36,115,136,  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,
/* 0x19f0 */   0, 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,102,137,
/* 0x1a00 */ 149,224,  1,  0,  0,233, 31,  1,  0,  0,137,200, 41,214,102,193,
/* 0x1a10 */ 232,  5,139,108, 36, 56,102, 41,193, 41,215,129,254,255,255,255,
/* 0x1a20 */   0,102,137,141,152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,
/* 0x1a30 */  22,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,
/* 0x1a40 */ 139, 76, 36, 56,137,240,193,232, 11,102,139,145,176,  1,  0,  0,
/* 0x1a50 */  15,183,202, 15,175,193, 57,199,115, 35,137,198,184,  0,  8,  0,
/* 0x1a60 */   0, 41,200,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,
/* 0x1a70 */ 176,  1,  0,  0,139, 68, 36, 88,233,160,  0,  0,  0,137,241, 41,
/* 0x1a80 */ 199, 41,193,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,
/* 0x1a90 */ 129,249,255,255,255,  0,102,137,144,176,  1,  0,  0,119, 22, 59,
/* 0x1aa0 */  92, 36, 76, 15,132,161,  4,  0,  0, 15,182,  3,193,231,  8,193,
/* 0x1ab0 */ 225,  8, 67,  9,199,139,116, 36, 56,137,200,193,232, 11,102,139,
/* 0x1ac0 */ 150,200,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 32,137,
/* 0x1ad0 */ 198,184,  0,  8,  0,  0, 41,232,139,108, 36, 56,193,248,  5,141,
/* 0x1ae0 */   4,  2,102,137,133,200,  1,  0,  0,139, 68, 36, 84,235, 38,137,
/* 0x1af0 */ 206, 41,199, 41,198,137,208,102,193,232,  5,102, 41,194,139, 68,
/* 0x1b00 */  36, 56,102,137,144,200,  1,  0,  0,139, 84, 36, 84,139, 68, 36,
/* 0x1b10 */  80,137, 84, 36, 80,139, 76, 36, 88,137, 76, 36, 84,139,108, 36,
/* 0x1b20 */  92,137, 68, 36, 92,137,108, 36, 88, 49,192,131,124, 36, 96,  6,
/* 0x1b30 */ 139, 76, 36,120, 15,159,192,129,193,104, 10,  0,  0,141, 68, 64,
/* 0x1b40 */   8,137, 68, 36, 96,129,254,255,255,255,  0,119, 22, 59, 92, 36,
/* 0x1b50 */  76, 15,132,243,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8,
/* 0x1b60 */  67,  9,199,102,139, 17,137,240,193,232, 11, 15,183,234, 15,175,
/* 0x1b70 */ 197, 57,199,115, 47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,
/* 0x1b80 */ 193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,
/* 0x1b90 */ 141,  4,  2,102,137,  1,139, 68, 36, 68,141, 76,  1,  4,137, 76,
/* 0x1ba0 */  36, 16,235,114, 41,198, 41,199,137,208,102,193,232,  5,102, 41,
/* 0x1bb0 */ 194,129,254,255,255,255,  0,102,137, 17,119, 22, 59, 92, 36, 76,
/* 0x1bc0 */  15,132,132,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,
/* 0x1bd0 */   9,199,102,139, 81,  2,137,240,193,232, 11, 15,183,234, 15,175,
/* 0x1be0 */ 197, 57,199,115, 59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,
/* 0x1bf0 */ 193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,
/* 0x1c00 */ 141,  4,  2,139, 84, 36, 68,102,137, 65,  2,141,140, 17,  4,  1,
/* 0x1c10 */   0,  0,137, 76, 36, 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47,
/* 0x1c20 */  41,198, 41,199,137,208,137,116, 36, 72,102,193,232,  5,199, 68,
/* 0x1c30 */  36, 44, 16,  0,  0,  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,
/* 0x1c40 */   0,102,137, 81,  2,129,193,  4,  2,  0,  0,137, 76, 36, 16,139,
/* 0x1c50 */  76, 36, 48,186,  1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,
/* 0x1c60 */ 116, 36, 16,  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59,
/* 0x1c70 */  92, 36, 76, 15,132,209,  2,  0,  0,193,100, 36, 72,  8, 15,182,
/* 0x1c80 */   3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232,
/* 0x1c90 */  11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,
/* 0x1ca0 */   0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,137,234,102,137,
/* 0x1cb0 */   6,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102,
/* 0x1cc0 */  41,194,102,137, 22,141, 85,  1,139,116, 36, 40, 78,137,116, 36,
/* 0x1cd0 */  40,117,137,138, 76, 36, 48,184,  1,  0,  0,  0,211,224, 41,194,
/* 0x1ce0 */   3, 84, 36, 44,131,124, 36, 96,  3,137, 84, 36, 12, 15,143,231,
/* 0x1cf0 */   1,  0,  0,131, 68, 36, 96,  7,131,250,  3,137,208,126,  5,184,
/* 0x1d00 */   3,  0,  0,  0,139,116, 36,120,193,224,  7,199, 68, 36, 36,  6,
/* 0x1d10 */   0,  0,  0,141,132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,
/* 0x1d20 */   0,  0,  0,141, 44,  0,139,116, 36,  8,  1,238,129,124, 36, 72,
/* 0x1d30 */ 255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,
/* 0x1d40 */ 193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68,
/* 0x1d50 */  36, 72,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,
/* 0x1d60 */ 115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,
/* 0x1d70 */ 141,  4,  2,102,137,  6,137,232,235, 21, 41, 68, 36, 72, 41,199,
/* 0x1d80 */ 137,208,102,193,232,  5,102, 41,194,141, 69,  1,102,137, 22,139,
/* 0x1d90 */ 108, 36, 36, 77,137,108, 36, 36,117,137,141, 80,192,131,250,  3,
/* 0x1da0 */ 137, 20, 36, 15,142, 39,  1,  0,  0,137,208,137,214,209,248,131,
/* 0x1db0 */ 230,  1,141, 72,255,131,206,  2,131,250, 13,137, 76, 36, 32,127,
/* 0x1dc0 */  28,139,108, 36,120,211,230,  1,210,137, 52, 36,141, 68,117,  0,
/* 0x1dd0 */  41,208,  5, 94,  5,  0,  0,137, 68, 36,  4,235, 86,141, 80,251,
/* 0x1de0 */ 129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,
/* 0x1df0 */  86,  1,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,
/* 0x1e00 */   9,199,209,108, 36, 72,  1,246, 59,124, 36, 72,114,  7, 43,124,
/* 0x1e10 */  36, 72,131,206,  1, 74,117,200,139, 68, 36,120,193,230,  4,137,
/* 0x1e20 */  52, 36,  5, 68,  6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137,
/* 0x1e30 */  68, 36,  4,199, 68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,
/* 0x1e40 */ 139,108, 36,  4,  1,192,137, 68, 36, 24,  1,197,129,124, 36, 72,
/* 0x1e50 */ 255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,
/* 0x1e60 */ 193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68,
/* 0x1e70 */  36, 72,102,139, 85,  0,193,232, 11, 15,183,242, 15,175,198, 57,
/* 0x1e80 */ 199,115, 27,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,193,248,
/* 0x1e90 */   5,141,  4,  2,102,137, 69,  0,139, 68, 36, 24,235, 31, 41, 68,
/* 0x1ea0 */  36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,139, 68, 36,
/* 0x1eb0 */  24,102,137, 85,  0,139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36,
/* 0x1ec0 */  32,209,100, 36, 28, 73,137, 76, 36, 32, 15,133,112,255,255,255,
/* 0x1ed0 */ 139, 52, 36, 70,137,116, 36, 92,116, 89,139, 76, 36, 12,139,108,
/* 0x1ee0 */  36,116,131,193,  2, 57,108, 36, 92,119, 95,139,132, 36,160,  0,
/* 0x1ef0 */   0,  0,137,234, 43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,141,
/* 0x1f00 */  52, 40,138,  6, 70,136, 68, 36,115,136,  2, 66,255, 68, 36,116,
/* 0x1f10 */  73,116, 15,139,172, 36,164,  0,  0,  0, 57,108, 36,116,114,226,
/* 0x1f20 */ 235, 17,139,132, 36,164,  0,  0,  0, 57, 68, 36,116, 15,130,187,
/* 0x1f30 */ 246,255,255,129,124, 36, 72,255,255,255,  0,119, 21, 59, 92, 36,
/* 0x1f40 */  76,184,  1,  0,  0,  0,116, 41,235,  7,184,  1,  0,  0,  0,235,
/* 0x1f50 */  32, 67, 43,156, 36,148,  0,  0,  0, 49,192,139,148, 36,156,  0,
/* 0x1f60 */   0,  0,139, 76, 36,116,137, 26,139,156, 36,168,  0,  0,  0,137,
/* 0x1f70 */  11,131,196,124, 91, 94, 95, 93,  3,115,252,  3,123,248, 49,192,
/* 0x1f80 */ 141,140, 36,  0,255,255,255,137,236, 80, 57,204,117,251,137,236,
/* 0x1f90 */  49,201,  0, 46,115,121,109,116, 97, 98,  0, 46,115,116,114,116,
/* 0x1fa0 */  97, 98,  0, 46,115,104,115,116,114,116, 97, 98,  0, 46,114,101,
/* 0x1fb0 */ 108, 83, 79, 95, 77, 65, 73, 78,  0, 46,114,101,108, 83, 79, 95,
/* 0x1fc0 */  72, 69, 65, 68,  0,112,116,114, 95, 78, 69, 88, 84,  0, 83, 79,
/* 0x1fd0 */  95, 84, 65, 73, 76,  0, 69, 88, 80, 95, 72, 69, 65, 68,  0, 69,
/* 0x1fe0 */  88, 80, 95, 84, 65, 73, 76,  0, 46,114,101,108, 78, 82, 86, 50,
/* 0x1ff0 */  69,  0, 46,114,101,108, 78, 82, 86, 50, 68,  0, 46,114,101,108,
/* 0x2000 */  78, 82, 86, 50, 66,  0, 46,114,101,108, 76, 90, 77, 65, 95, 68,
/* 0x2010 */  69, 67, 48, 48,  0, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  0,
/* 0x2020 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  0, 76, 90, 77, 65, 95,
/* 0x2030 */  68, 69, 67, 50, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x2040 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2050 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2060 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 31,  0,  0,  0,
/* 0x2070 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,
/* 0x2080 */ 127,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x2090 */   0,  0,  0,  0, 27,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x20a0 */   0,  0,  0,  0, 52, 39,  0,  0,184,  0,  0,  0, 22,  0,  0,  0,
/* 0x20b0 */   1,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 43,  0,  0,  0,
/* 0x20c0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,179,  5,  0,  0,
/* 0x20d0 */  42,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x20e0 */   0,  0,  0,  0, 39,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x20f0 */   0,  0,  0,  0,236, 39,  0,  0,  8,  0,  0,  0, 22,  0,  0,  0,
/* 0x2100 */   3,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 51,  0,  0,  0,
/* 0x2110 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,221,  5,  0,  0,
/* 0x2120 */   3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2130 */   0,  0,  0,  0, 60,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2140 */   0,  0,  0,  0,224,  5,  0,  0,211,  0,  0,  0,  0,  0,  0,  0,
/* 0x2150 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 68,  0,  0,  0,
/* 0x2160 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,179,  6,  0,  0,
/* 0x2170 */ 241,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2180 */   0,  0,  0,  0, 77,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2190 */   0,  0,  0,  0,164,  7,  0,  0, 11,  0,  0,  0,  0,  0,  0,  0,
/* 0x21a0 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 90,  0,  0,  0,
/* 0x21b0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,175,  7,  0,  0,
/* 0x21c0 */ 210,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x21d0 */   0,  0,  0,  0, 86,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x21e0 */   0,  0,  0,  0,244, 39,  0,  0, 16,  0,  0,  0, 22,  0,  0,  0,
/* 0x21f0 */   9,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,100,  0,  0,  0,
/* 0x2200 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,129,  8,  0,  0,
/* 0x2210 */ 197,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2220 */   0,  0,  0,  0, 96,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2230 */   0,  0,  0,  0,  4, 40,  0,  0, 16,  0,  0,  0, 22,  0,  0,  0,
/* 0x2240 */  11,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,110,  0,  0,  0,
/* 0x2250 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 70,  9,  0,  0,
/* 0x2260 */ 176,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2270 */   0,  0,  0,  0,106,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2280 */   0,  0,  0,  0, 20, 40,  0,  0, 16,  0,  0,  0, 22,  0,  0,  0,
/* 0x2290 */  13,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,120,  0,  0,  0,
/* 0x22a0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,246,  9,  0,  0,
/* 0x22b0 */  46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x22c0 */   0,  0,  0,  0,116,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x22d0 */   0,  0,  0,  0, 36, 40,  0,  0, 32,  0,  0,  0, 22,  0,  0,  0,
/* 0x22e0 */  15,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,131,  0,  0,  0,
/* 0x22f0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 36, 10,  0,  0,
/* 0x2300 */  72,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2310 */   0,  0,  0,  0,142,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2320 */   0,  0,  0,  0,108, 10,  0,  0,134, 10,  0,  0,  0,  0,  0,  0,
/* 0x2330 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,153,  0,  0,  0,
/* 0x2340 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,242, 20,  0,  0,
/* 0x2350 */ 134, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2360 */   0,  0,  0,  0,164,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2370 */   0,  0,  0,  0,120, 31,  0,  0, 26,  0,  0,  0,  0,  0,  0,  0,
/* 0x2380 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0,  0,
/* 0x2390 */   3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,146, 31,  0,  0,
/* 0x23a0 */ 175,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x23b0 */   0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,
/* 0x23c0 */   0,  0,  0,  0,  4, 36,  0,  0, 96,  2,  0,  0, 23,  0,  0,  0,
/* 0x23d0 */  15,  0,  0,  0,  4,  0,  0,  0, 16,  0,  0,  0,  9,  0,  0,  0,
/* 0x23e0 */   3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,100, 38,  0,  0,
/* 0x23f0 */ 208,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2400 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2410 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2420 */   3,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2430 */   3,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2440 */   3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2450 */   3,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2460 */   3,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2470 */   3,  0,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2480 */   3,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2490 */   3,  0, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24a0 */   3,  0, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24b0 */   3,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24c0 */   3,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24d0 */   3,  0, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24e0 */   3,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24f0 */   3,  0, 20,  0,  1,  0,  0,  0, 62,  0,  0,  0,  0,  0,  0,  0,
/* 0x2500 */  16,  0,  6,  0,  6,  0,  0,  0, 87,  0,  0,  0,  0,  0,  0,  0,
/* 0x2510 */  16,  0,  7,  0, 15,  0,  0,  0,201,  0,  0,  0,  0,  0,  0,  0,
/* 0x2520 */  16,  0,  6,  0, 22,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2530 */  16,  0,  0,  0, 40,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2540 */  16,  0,  0,  0, 56,  0,  0,  0, 25,  0,  0,  0,  0,  0,  0,  0,
/* 0x2550 */  16,  0,  6,  0, 63,  0,  0,  0, 62,  0,  0,  0,  0,  0,  0,  0,
/* 0x2560 */  16,  0,  6,  0, 68,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2570 */  18,  0,  6,  0, 72,  0,  0,  0,205,  0,  0,  0,  0,  0,  0,  0,
/* 0x2580 */  16,  0,  6,  0, 78,  0,  0,  0, 59,  2,  0,  0, 33,  0,  0,  0,
/* 0x2590 */  18,  0,  1,  0, 89,  0,  0,  0,171,  0,  0,  0,  0,  0,  0,  0,
/* 0x25a0 */  16,  0,  6,  0,102,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,
/* 0x25b0 */  16,  0,  6,  0,109,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25c0 */  16,  0,  0,  0,120,  0,  0,  0,238,  1,  0,  0,  6,  0,  0,  0,
/* 0x25d0 */  18,  0,  1,  0,134,  0,  0,  0, 14,  0,  0,  0,  0,  0,  0,  0,
/* 0x25e0 */  16,  0,  6,  0,142,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25f0 */  16,  0,  0,  0,153,  0,  0,  0, 94,  0,  0,  0,  0,  0,  0,  0,
/* 0x2600 */  16,  0,  6,  0,162,  0,  0,  0,205,  0,  0,  0,  0,  0,  0,  0,
/* 0x2610 */  16,  0,  6,  0,169,  0,  0,  0,134,  0,  0,  0,  0,  0,  0,  0,
/* 0x2620 */  16,  0,  6,  0,176,  0,  0,  0,193,  0,  0,  0,  0,  0,  0,  0,
/* 0x2630 */  16,  0,  6,  0,181,  0,  0,  0,178,  0,  0,  0,  0,  0,  0,  0,
/* 0x2640 */  16,  0,  6,  0,190,  0,  0,  0,197,  0,  0,  0,  0,  0,  0,  0,
/* 0x2650 */  16,  0,  6,  0,196,  0,  0,  0, 92,  2,  0,  0, 35,  3,  0,  0,
/* 0x2660 */  18,  0,  1,  0,  0, 80,109, 97,112,  0,102, 95,101,120,112, 97,
/* 0x2670 */ 110,100,  0,109,117,110,109, 97,112,  0,108,122,109, 97, 95,115,
/* 0x2680 */ 116, 97, 99,107, 95, 97,100,106,117,115,116,  0,108,122,109, 97,
/* 0x2690 */  95,112,114,111,112,101,114,116,105,101,115,  0,109,101,109, 99,
/* 0x26a0 */ 112,121,  0,109,109, 97,112,  0,101,111,102,  0,119,114,105,116,
/* 0x26b0 */ 101,  0, 80, 70, 95,116,111, 95, 80, 82, 79, 84,  0,109,101,109,
/* 0x26c0 */ 102,100, 95, 99,114,101, 97,116,101,  0,109,101,109,115,101,116,
/* 0x26d0 */   0,108,122,109, 97, 95, 99, 95,108,101,110,  0,103,101,116, 95,
/* 0x26e0 */  80, 65, 71, 69, 95, 77, 65, 83, 75,  0,109,121, 95, 98,107,112,
/* 0x26f0 */ 116,  0,108,122,109, 97, 95,117, 95,108,101,110,  0, 80,112,114,
/* 0x2700 */ 111,116,101, 99,116,  0, 80,119,114,105,116,101,  0, 80,117,110,
/* 0x2710 */ 109, 97,112,  0,101,120,105,116,  0,109,112,114,111,116,101, 99,
/* 0x2720 */ 116,  0, 99,108,111,115,101,  0,117,112,120, 95,115,111, 95,109,
/* 0x2730 */  97,105,110,  0,  8,  0,  0,  0,  2, 29,  0,  0,253,  0,  0,  0,
/* 0x2740 */   2, 16,  0,  0,213,  1,  0,  0,  2, 21,  0,  0, 16,  2,  0,  0,
/* 0x2750 */   2, 20,  0,  0, 33,  2,  0,  0,  2, 21,  0,  0, 44,  2,  0,  0,
/* 0x2760 */   2, 20,  0,  0,105,  2,  0,  0,  2, 28,  0,  0,168,  2,  0,  0,
/* 0x2770 */   2, 21,  0,  0,179,  2,  0,  0,  2, 20,  0,  0, 91,  3,  0,  0,
/* 0x2780 */   2, 32,  0,  0,113,  3,  0,  0,  2, 32,  0,  0,122,  3,  0,  0,
/* 0x2790 */   2, 33,  0,  0,138,  3,  0,  0,  2, 24,  0,  0,150,  3,  0,  0,
/* 0x27a0 */   2, 15,  0,  0,109,  4,  0,  0,  2, 32,  0,  0,120,  4,  0,  0,
/* 0x27b0 */   2, 33,  0,  0,138,  4,  0,  0,  2, 15,  0,  0,  1,  5,  0,  0,
/* 0x27c0 */   2, 33,  0,  0, 12,  5,  0,  0,  2, 24,  0,  0, 33,  5,  0,  0,
/* 0x27d0 */   2, 15,  0,  0, 51,  5,  0,  0,  2, 24,  0,  0, 69,  5,  0,  0,
/* 0x27e0 */   2, 31,  0,  0, 95,  5,  0,  0,  2, 33,  0,  0, 18,  0,  0,  0,
/* 0x27f0 */   2, 37,  0,  0,199,  0,  0,  0,  2,  1,  0,  0,102,  0,  0,  0,
/* 0x2800 */   2,  2,  0,  0,186,  0,  0,  0,  2,  1,  0,  0,102,  0,  0,  0,
/* 0x2810 */   2,  2,  0,  0,167,  0,  0,  0,  2,  1,  0,  0, 84,  0,  0,  0,
/* 0x2820 */   2,  2,  0,  0,  5,  0,  0,  0,  1, 18,  0,  0, 20,  0,  0,  0,
/* 0x2830 */   1, 30,  0,  0, 30,  0,  0,  0,  1, 27,  0,  0, 42,  0,  0,  0,
/* 0x2840 */   1, 19,  0,  0,102,105,108,101, 32,102,111,114,109, 97,116, 32,
/* 0x2850 */ 101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,
/* 0x2860 */ 105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32,
/* 0x2870 */  32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32,
/* 0x2880 */  32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32,
/* 0x2890 */  32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32,
/* 0x28a0 */  65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32,
/* 0x28b0 */  83, 79, 95, 77, 65, 73, 78, 32, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x28c0 */  55,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50,
/* 0x28d0 */  42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x28e0 */  49, 32, 83, 79, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 32,
/* 0x28f0 */  48, 50, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 98, 51, 32,
/* 0x2900 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2910 */  32, 32, 50, 32,112,116,114, 95, 78, 69, 88, 84, 32, 32, 32, 32,
/* 0x2920 */  32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53,100,100,
/* 0x2930 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2940 */  10, 32, 32, 51, 32, 83, 79, 95, 84, 65, 73, 76, 32, 32, 32, 32,
/* 0x2950 */  32, 32, 32, 48,100, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53,
/* 0x2960 */ 101, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2970 */  84, 83, 10, 32, 32, 52, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32,
/* 0x2980 */  32, 32, 32, 32, 32, 48,102, 49, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2990 */  48, 54, 98, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x29a0 */  69, 78, 84, 83, 10, 32, 32, 53, 32, 69, 88, 80, 95, 84, 65, 73,
/* 0x29b0 */  76, 32, 32, 32, 32, 32, 32, 48, 98, 32, 32, 48, 32, 32, 48, 32,
/* 0x29c0 */  32, 48, 55, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x29d0 */  84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 78, 82, 86, 50, 69, 32,
/* 0x29e0 */  32, 32, 32, 32, 32, 32, 32, 32, 48,100, 50, 32, 32, 48, 32, 32,
/* 0x29f0 */  48, 32, 32, 48, 55, 97,102, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2a00 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32, 78, 82, 86, 50,
/* 0x2a10 */  68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 99, 53, 32, 32, 48,
/* 0x2a20 */  32, 32, 48, 32, 32, 48, 56, 56, 49, 32, 32, 50, 42, 42, 48, 32,
/* 0x2a30 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 78, 82,
/* 0x2a40 */  86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 98, 48, 32,
/* 0x2a50 */  32, 48, 32, 32, 48, 32, 32, 48, 57, 52, 54, 32, 32, 50, 42, 42,
/* 0x2a60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32,
/* 0x2a70 */  76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 32, 32, 32, 48, 50,
/* 0x2a80 */ 101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57,102, 54, 32, 32, 50,
/* 0x2a90 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49,
/* 0x2aa0 */  48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32,
/* 0x2ab0 */  48, 52, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 50, 52, 32,
/* 0x2ac0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2ad0 */  32, 49, 49, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32,
/* 0x2ae0 */  32, 32, 48, 97, 56, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97,
/* 0x2af0 */  54, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2b00 */  84, 83, 10, 32, 49, 50, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2b10 */  48, 32, 32, 32, 32, 48, 97, 56, 54, 32, 32, 48, 32, 32, 48, 32,
/* 0x2b20 */  32, 48, 49, 52,102, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2b30 */  78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32, 76, 90, 77, 65, 95,
/* 0x2b40 */  68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 49, 97, 32, 32, 48, 32,
/* 0x2b50 */  32, 48, 32, 32, 48, 49,102, 55, 56, 32, 32, 50, 42, 42, 48, 32,
/* 0x2b60 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76,
/* 0x2b70 */  32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2b80 */  32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95, 72, 69, 65,
/* 0x2b90 */  68, 32, 48, 32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48, 48,
/* 0x2ba0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88,
/* 0x2bb0 */  80, 95, 84, 65, 73, 76, 32, 48, 32, 69, 88, 80, 95, 84, 65, 73,
/* 0x2bc0 */  76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2bd0 */ 100, 32, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 32, 83, 79, 95,
/* 0x2be0 */  77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2bf0 */  32, 32, 32,100, 32, 32, 83, 79, 95, 72, 69, 65, 68, 32, 48, 32,
/* 0x2c00 */  83, 79, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c10 */  32,108, 32, 32, 32, 32,100, 32, 32,112,116,114, 95, 78, 69, 88,
/* 0x2c20 */  84, 32, 48, 32,112,116,114, 95, 78, 69, 88, 84, 10, 48, 48, 48,
/* 0x2c30 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 79,
/* 0x2c40 */  95, 84, 65, 73, 76, 32, 48, 32, 83, 79, 95, 84, 65, 73, 76, 10,
/* 0x2c50 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2c60 */  32, 78, 82, 86, 50, 69, 32, 48, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x2c70 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2c80 */  78, 82, 86, 50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x2c90 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x2ca0 */  82, 86, 50, 66, 32, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x2cb0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x2cc0 */  77, 65, 95, 68, 69, 67, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x2cd0 */  68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2ce0 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x2cf0 */  48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48,
/* 0x2d00 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2d10 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77,
/* 0x2d20 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d30 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2d40 */  67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2d50 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2d60 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76,
/* 0x2d70 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x2d80 */  51,101, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x2d90 */  73, 76, 32, 48, 32, 80,109, 97,112, 10, 48, 48, 48, 48, 48, 48,
/* 0x2da0 */  53, 55, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72,
/* 0x2db0 */  69, 65, 68, 32, 48, 32,102, 95,101,120,112, 97,110,100, 10, 48,
/* 0x2dc0 */  48, 48, 48, 48, 48, 99, 57, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x2dd0 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,117,110,109, 97,112,
/* 0x2de0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x2df0 */  32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,115,
/* 0x2e00 */ 116, 97, 99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48,
/* 0x2e10 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x2e20 */  68, 42, 32, 48, 32,108,122,109, 97, 95,112,114,111,112,101,114,
/* 0x2e30 */ 116,105,101,115, 10, 48, 48, 48, 48, 48, 48, 49, 57, 32,103, 32,
/* 0x2e40 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,
/* 0x2e50 */ 109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 48, 51,101, 32,
/* 0x2e60 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x2e70 */  48, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2e80 */ 103, 32, 32, 32, 32, 32, 70, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x2e90 */  48, 32,101,111,102, 10, 48, 48, 48, 48, 48, 48, 99,100, 32,103,
/* 0x2ea0 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x2eb0 */  32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 50, 51, 98, 32,
/* 0x2ec0 */ 103, 32, 32, 32, 32, 32, 70, 32, 83, 79, 95, 77, 65, 73, 78, 32,
/* 0x2ed0 */  48, 50, 49, 32, 80, 70, 95,116,111, 95, 80, 82, 79, 84, 10, 48,
/* 0x2ee0 */  48, 48, 48, 48, 48, 97, 98, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ef0 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,101,109,102,100, 95,
/* 0x2f00 */  99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32,
/* 0x2f10 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x2f20 */  48, 32,109,101,109,115,101,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f30 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x2f40 */  48, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48,
/* 0x2f50 */  48, 48, 49,101,101, 32,103, 32, 32, 32, 32, 32, 70, 32, 83, 79,
/* 0x2f60 */  95, 77, 65, 73, 78, 32, 48, 54, 32,103,101,116, 95, 80, 65, 71,
/* 0x2f70 */  69, 95, 77, 65, 83, 75, 10, 48, 48, 48, 48, 48, 48, 48,101, 32,
/* 0x2f80 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x2f90 */  48, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x2fa0 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x2fb0 */  32, 48, 32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48,
/* 0x2fc0 */  48, 48, 48, 48, 53,101, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x2fd0 */  79, 95, 84, 65, 73, 76, 32, 48, 32, 80,112,114,111,116,101, 99,
/* 0x2fe0 */ 116, 10, 48, 48, 48, 48, 48, 48, 99,100, 32,103, 32, 32, 32, 32,
/* 0x2ff0 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 80,119,114,
/* 0x3000 */ 105,116,101, 10, 48, 48, 48, 48, 48, 48, 56, 54, 32,103, 32, 32,
/* 0x3010 */  32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 80,
/* 0x3020 */ 117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 99, 49, 32,103,
/* 0x3030 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x3040 */  32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 98, 50, 32,103,
/* 0x3050 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x3060 */  32,109,112,114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x3070 */  99, 53, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x3080 */  73, 76, 32, 48, 32, 99,108,111,115,101, 10, 48, 48, 48, 48, 48,
/* 0x3090 */  50, 53, 99, 32,103, 32, 32, 32, 32, 32, 70, 32, 83, 79, 95, 77,
/* 0x30a0 */  65, 73, 78, 32, 48, 51, 50, 51, 32,117,112,120, 95,115,111, 95,
/* 0x30b0 */ 109, 97,105,110, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x30c0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 79,
/* 0x30d0 */  95, 77, 65, 73, 78, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x30e0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x30f0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3100 */  56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x3110 */  32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48,
/* 0x3120 */  48, 48,102,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x3130 */  32, 32, 32, 32, 32, 32, 32,102, 95,101,120,112, 97,110,100, 10,
/* 0x3140 */  48, 48, 48, 48, 48, 49,100, 53, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x3150 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,112, 10,
/* 0x3160 */  48, 48, 48, 48, 48, 50, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x3170 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109, 99,112,
/* 0x3180 */ 121, 10, 48, 48, 48, 48, 48, 50, 50, 49, 32, 82, 95, 51, 56, 54,
/* 0x3190 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,
/* 0x31a0 */ 112, 10, 48, 48, 48, 48, 48, 50, 50, 99, 32, 82, 95, 51, 56, 54,
/* 0x31b0 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,
/* 0x31c0 */  99,112,121, 10, 48, 48, 48, 48, 48, 50, 54, 57, 32, 82, 95, 51,
/* 0x31d0 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,103,
/* 0x31e0 */ 101,116, 95, 80, 65, 71, 69, 95, 77, 65, 83, 75, 10, 48, 48, 48,
/* 0x31f0 */  48, 48, 50, 97, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x3200 */  32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48,
/* 0x3210 */  48, 48, 50, 98, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x3220 */  32, 32, 32, 32, 32, 32, 32, 32,109,101,109, 99,112,121, 10, 48,
/* 0x3230 */  48, 48, 48, 48, 51, 53, 98, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x3240 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 80,119,114,105,116,101,
/* 0x3250 */  10, 48, 48, 48, 48, 48, 51, 55, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x3260 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 80,119,114,105,
/* 0x3270 */ 116,101, 10, 48, 48, 48, 48, 48, 51, 55, 97, 32, 82, 95, 51, 56,
/* 0x3280 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 80,117,
/* 0x3290 */ 110,109, 97,112, 10, 48, 48, 48, 48, 48, 51, 56, 97, 32, 82, 95,
/* 0x32a0 */  51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x32b0 */  80, 70, 95,116,111, 95, 80, 82, 79, 84, 10, 48, 48, 48, 48, 48,
/* 0x32c0 */  51, 57, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32,
/* 0x32d0 */  32, 32, 32, 32, 32, 32, 80,109, 97,112, 10, 48, 48, 48, 48, 48,
/* 0x32e0 */  52, 54,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32,
/* 0x32f0 */  32, 32, 32, 32, 32, 32, 80,119,114,105,116,101, 10, 48, 48, 48,
/* 0x3300 */  48, 48, 52, 55, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x3310 */  32, 32, 32, 32, 32, 32, 32, 32, 80,117,110,109, 97,112, 10, 48,
/* 0x3320 */  48, 48, 48, 48, 52, 56, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x3330 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 80,109, 97,112, 10, 48,
/* 0x3340 */  48, 48, 48, 48, 53, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x3350 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 80,117,110,109, 97,112,
/* 0x3360 */  10, 48, 48, 48, 48, 48, 53, 48, 99, 32, 82, 95, 51, 56, 54, 95,
/* 0x3370 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 80, 70, 95,116,
/* 0x3380 */ 111, 95, 80, 82, 79, 84, 10, 48, 48, 48, 48, 48, 53, 50, 49, 32,
/* 0x3390 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x33a0 */  32, 32, 80,109, 97,112, 10, 48, 48, 48, 48, 48, 53, 51, 51, 32,
/* 0x33b0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x33c0 */  32, 32, 80, 70, 95,116,111, 95, 80, 82, 79, 84, 10, 48, 48, 48,
/* 0x33d0 */  48, 48, 53, 52, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x33e0 */  32, 32, 32, 32, 32, 32, 32, 32, 80,112,114,111,116,101, 99,116,
/* 0x33f0 */  10, 48, 48, 48, 48, 48, 53, 53,102, 32, 82, 95, 51, 56, 54, 95,
/* 0x3400 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 80,117,110,109,
/* 0x3410 */  97,112, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x3420 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 79, 95, 72,
/* 0x3430 */  69, 65, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x3440 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3450 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x3460 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x3470 */  32, 32,117,112,120, 95,115,111, 95,109, 97,105,110, 10, 10, 82,
/* 0x3480 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x3490 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79,
/* 0x34a0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x34b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x34c0 */  48, 48, 48, 48, 48, 48, 99, 55, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x34d0 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72,
/* 0x34e0 */  69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 54, 54, 32, 82, 95, 51,
/* 0x34f0 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x3500 */  88, 80, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x3510 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x3520 */  91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x3530 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3540 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x3550 */  98, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x3560 */  32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48,
/* 0x3570 */  48, 48, 48, 48, 54, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x3580 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73,
/* 0x3590 */  76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x35a0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66,
/* 0x35b0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x35c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x35d0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 97, 55, 32, 82, 95, 51,
/* 0x35e0 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x35f0 */  88, 80, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 53, 52,
/* 0x3600 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x3610 */  32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76,
/* 0x3620 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x3630 */  70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 93,
/* 0x3640 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x3650 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x3660 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56,
/* 0x3670 */  54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,
/* 0x3680 */ 109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,116, 10,
/* 0x3690 */  48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x36a0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,
/* 0x36b0 */ 117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82,
/* 0x36c0 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x36d0 */  32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48,
/* 0x36e0 */  48, 48, 50, 97, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x36f0 */  32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,112,114,111,112,
/* 0x3700 */ 101,114,116,105,101,115, 10
};
