/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.tools.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.ws.api.wsdl.TWSDLParserContext;
import com.sun.tools.ws.util.xml.XmlUtil;
import com.sun.tools.ws.wsdl.document.WSDLConstants;
import com.sun.tools.ws.wsdl.document.mime.MIMEConstants;
import com.sun.tools.ws.wsdl.document.mime.MIMEContent;
import com.sun.tools.ws.wsdl.document.mime.MIMEMultipartRelated;
import com.sun.tools.ws.wsdl.document.mime.MIMEPart;
import com.sun.tools.ws.wsdl.document.mime.MIMEXml;
import com.sun.tools.ws.wsdl.parser.AbstractExtensionHandler;
import com.sun.tools.ws.wsdl.parser.Util;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIMEExtensionHandler
extends AbstractExtensionHandler {
    public MIMEExtensionHandler(Map<String, AbstractExtensionHandler> extensionHandlerMap) {
        super(extensionHandlerMap);
    }

    @Override
    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/wsdl/mime/";
    }

    @Override
    public boolean doHandleExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (parent.getWSDLElementName().equals(WSDLConstants.QNAME_OUTPUT)) {
            return this.handleInputOutputExtension(context, parent, e);
        }
        if (parent.getWSDLElementName().equals(WSDLConstants.QNAME_INPUT)) {
            return this.handleInputOutputExtension(context, parent, e);
        }
        if (parent.getWSDLElementName().equals(MIMEConstants.QNAME_PART)) {
            return this.handleMIMEPartExtension(context, parent, e);
        }
        return false;
    }

    protected boolean handleInputOutputExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, MIMEConstants.QNAME_MULTIPART_RELATED)) {
            Element e2;
            context.push();
            context.registerNamespaces(e);
            MIMEMultipartRelated mpr = new MIMEMultipartRelated(context.getLocation(e));
            Iterator iter = XmlUtil.getAllChildren(e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, MIMEConstants.QNAME_PART)) {
                    Element e3;
                    context.push();
                    context.registerNamespaces(e2);
                    MIMEPart part = new MIMEPart(context.getLocation(e2));
                    String name = XmlUtil.getAttributeOrNull(e2, "name");
                    if (name != null) {
                        part.setName(name);
                    }
                    Iterator iter2 = XmlUtil.getAllChildren(e2);
                    while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                        String required;
                        AbstractExtensionHandler h = this.getExtensionHandlers().get(e3.getNamespaceURI());
                        boolean handled = false;
                        if (h != null) {
                            handled = h.doHandleExtension(context, part, e3);
                        }
                        if (handled || (required = XmlUtil.getAttributeNSOrNull(e3, "required", "http://schemas.xmlsoap.org/wsdl/")) == null || !required.equals("true")) continue;
                        Util.fail("parsing.requiredExtensibilityElement", e3.getTagName(), e3.getNamespaceURI());
                    }
                    mpr.add(part);
                    context.pop();
                    continue;
                }
                Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
            }
            parent.addExtension(mpr);
            context.pop();
            return true;
        }
        if (XmlUtil.matchesTagNS(e, MIMEConstants.QNAME_CONTENT)) {
            MIMEContent content = this.parseMIMEContent(context, e);
            parent.addExtension(content);
            return true;
        }
        if (XmlUtil.matchesTagNS(e, MIMEConstants.QNAME_MIME_XML)) {
            MIMEXml mimeXml = this.parseMIMEXml(context, e);
            parent.addExtension(mimeXml);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    @Override
    protected boolean handleMIMEPartExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, MIMEConstants.QNAME_CONTENT)) {
            MIMEContent content = this.parseMIMEContent(context, e);
            parent.addExtension(content);
            return true;
        }
        if (XmlUtil.matchesTagNS(e, MIMEConstants.QNAME_MIME_XML)) {
            MIMEXml mimeXml = this.parseMIMEXml(context, e);
            parent.addExtension(mimeXml);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected MIMEContent parseMIMEContent(TWSDLParserContext context, Element e) {
        String type;
        context.push();
        context.registerNamespaces(e);
        MIMEContent content = new MIMEContent(context.getLocation(e));
        String part = XmlUtil.getAttributeOrNull(e, "part");
        if (part != null) {
            content.setPart(part);
        }
        if ((type = XmlUtil.getAttributeOrNull(e, "type")) != null) {
            content.setType(type);
        }
        context.pop();
        return content;
    }

    protected MIMEXml parseMIMEXml(TWSDLParserContext context, Element e) {
        context.push();
        context.registerNamespaces(e);
        MIMEXml mimeXml = new MIMEXml(context.getLocation(e));
        String part = XmlUtil.getAttributeOrNull(e, "part");
        if (part != null) {
            mimeXml.setPart(part);
        }
        context.pop();
        return mimeXml;
    }
}

