// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package discoveryengine provides access to the Discovery Engine API.
//
// For product documentation, see: https://cloud.google.com/discovery-engine/docs
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/discoveryengine/v1beta"
//	...
//	ctx := context.Background()
//	discoveryengineService, err := discoveryengine.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	discoveryengineService, err := discoveryengine.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	discoveryengineService, err := discoveryengine.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package discoveryengine // import "google.golang.org/api/discoveryengine/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "discoveryengine:v1beta"
const apiName = "discoveryengine"
const apiVersion = "v1beta"
const basePath = "https://discoveryengine.googleapis.com/"
const mtlsBasePath = "https://discoveryengine.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Collections = NewProjectsLocationsCollectionsService(s)
	rs.DataStores = NewProjectsLocationsDataStoresService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Collections *ProjectsLocationsCollectionsService

	DataStores *ProjectsLocationsDataStoresService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsCollectionsService(s *Service) *ProjectsLocationsCollectionsService {
	rs := &ProjectsLocationsCollectionsService{s: s}
	rs.DataStores = NewProjectsLocationsCollectionsDataStoresService(s)
	rs.Engines = NewProjectsLocationsCollectionsEnginesService(s)
	rs.Operations = NewProjectsLocationsCollectionsOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsService struct {
	s *Service

	DataStores *ProjectsLocationsCollectionsDataStoresService

	Engines *ProjectsLocationsCollectionsEnginesService

	Operations *ProjectsLocationsCollectionsOperationsService
}

func NewProjectsLocationsCollectionsDataStoresService(s *Service) *ProjectsLocationsCollectionsDataStoresService {
	rs := &ProjectsLocationsCollectionsDataStoresService{s: s}
	rs.Branches = NewProjectsLocationsCollectionsDataStoresBranchesService(s)
	rs.Models = NewProjectsLocationsCollectionsDataStoresModelsService(s)
	rs.Operations = NewProjectsLocationsCollectionsDataStoresOperationsService(s)
	rs.Schemas = NewProjectsLocationsCollectionsDataStoresSchemasService(s)
	rs.ServingConfigs = NewProjectsLocationsCollectionsDataStoresServingConfigsService(s)
	rs.UserEvents = NewProjectsLocationsCollectionsDataStoresUserEventsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresService struct {
	s *Service

	Branches *ProjectsLocationsCollectionsDataStoresBranchesService

	Models *ProjectsLocationsCollectionsDataStoresModelsService

	Operations *ProjectsLocationsCollectionsDataStoresOperationsService

	Schemas *ProjectsLocationsCollectionsDataStoresSchemasService

	ServingConfigs *ProjectsLocationsCollectionsDataStoresServingConfigsService

	UserEvents *ProjectsLocationsCollectionsDataStoresUserEventsService
}

func NewProjectsLocationsCollectionsDataStoresBranchesService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesService{s: s}
	rs.Documents = NewProjectsLocationsCollectionsDataStoresBranchesDocumentsService(s)
	rs.Operations = NewProjectsLocationsCollectionsDataStoresBranchesOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesService struct {
	s *Service

	Documents *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService

	Operations *ProjectsLocationsCollectionsDataStoresBranchesOperationsService
}

func NewProjectsLocationsCollectionsDataStoresBranchesDocumentsService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresBranchesOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresModelsService(s *Service) *ProjectsLocationsCollectionsDataStoresModelsService {
	rs := &ProjectsLocationsCollectionsDataStoresModelsService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresModelsOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresModelsService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresModelsOperationsService
}

func NewProjectsLocationsCollectionsDataStoresModelsOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresModelsOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSchemasService(s *Service) *ProjectsLocationsCollectionsDataStoresSchemasService {
	rs := &ProjectsLocationsCollectionsDataStoresSchemasService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSchemasOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSchemasService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSchemasOperationsService
}

func NewProjectsLocationsCollectionsDataStoresSchemasOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSchemasOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSchemasOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSchemasOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresServingConfigsService(s *Service) *ProjectsLocationsCollectionsDataStoresServingConfigsService {
	rs := &ProjectsLocationsCollectionsDataStoresServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresUserEventsService(s *Service) *ProjectsLocationsCollectionsDataStoresUserEventsService {
	rs := &ProjectsLocationsCollectionsDataStoresUserEventsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresUserEventsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesService(s *Service) *ProjectsLocationsCollectionsEnginesService {
	rs := &ProjectsLocationsCollectionsEnginesService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsEnginesOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsEnginesService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsEnginesOperationsService
}

func NewProjectsLocationsCollectionsEnginesOperationsService(s *Service) *ProjectsLocationsCollectionsEnginesOperationsService {
	rs := &ProjectsLocationsCollectionsEnginesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsOperationsService(s *Service) *ProjectsLocationsCollectionsOperationsService {
	rs := &ProjectsLocationsCollectionsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresService(s *Service) *ProjectsLocationsDataStoresService {
	rs := &ProjectsLocationsDataStoresService{s: s}
	rs.Branches = NewProjectsLocationsDataStoresBranchesService(s)
	rs.Models = NewProjectsLocationsDataStoresModelsService(s)
	rs.Operations = NewProjectsLocationsDataStoresOperationsService(s)
	rs.ServingConfigs = NewProjectsLocationsDataStoresServingConfigsService(s)
	rs.UserEvents = NewProjectsLocationsDataStoresUserEventsService(s)
	return rs
}

type ProjectsLocationsDataStoresService struct {
	s *Service

	Branches *ProjectsLocationsDataStoresBranchesService

	Models *ProjectsLocationsDataStoresModelsService

	Operations *ProjectsLocationsDataStoresOperationsService

	ServingConfigs *ProjectsLocationsDataStoresServingConfigsService

	UserEvents *ProjectsLocationsDataStoresUserEventsService
}

func NewProjectsLocationsDataStoresBranchesService(s *Service) *ProjectsLocationsDataStoresBranchesService {
	rs := &ProjectsLocationsDataStoresBranchesService{s: s}
	rs.Documents = NewProjectsLocationsDataStoresBranchesDocumentsService(s)
	rs.Operations = NewProjectsLocationsDataStoresBranchesOperationsService(s)
	return rs
}

type ProjectsLocationsDataStoresBranchesService struct {
	s *Service

	Documents *ProjectsLocationsDataStoresBranchesDocumentsService

	Operations *ProjectsLocationsDataStoresBranchesOperationsService
}

func NewProjectsLocationsDataStoresBranchesDocumentsService(s *Service) *ProjectsLocationsDataStoresBranchesDocumentsService {
	rs := &ProjectsLocationsDataStoresBranchesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresBranchesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresBranchesOperationsService(s *Service) *ProjectsLocationsDataStoresBranchesOperationsService {
	rs := &ProjectsLocationsDataStoresBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresModelsService(s *Service) *ProjectsLocationsDataStoresModelsService {
	rs := &ProjectsLocationsDataStoresModelsService{s: s}
	rs.Operations = NewProjectsLocationsDataStoresModelsOperationsService(s)
	return rs
}

type ProjectsLocationsDataStoresModelsService struct {
	s *Service

	Operations *ProjectsLocationsDataStoresModelsOperationsService
}

func NewProjectsLocationsDataStoresModelsOperationsService(s *Service) *ProjectsLocationsDataStoresModelsOperationsService {
	rs := &ProjectsLocationsDataStoresModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresOperationsService(s *Service) *ProjectsLocationsDataStoresOperationsService {
	rs := &ProjectsLocationsDataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresServingConfigsService(s *Service) *ProjectsLocationsDataStoresServingConfigsService {
	rs := &ProjectsLocationsDataStoresServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresUserEventsService(s *Service) *ProjectsLocationsDataStoresUserEventsService {
	rs := &ProjectsLocationsDataStoresUserEventsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresUserEventsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It
// should only be used for payload formats that can't be represented as
// JSON, such as raw binary or an HTML page. This message can be used
// both in streaming and non-streaming API methods in the request as
// well as the response. It can be used as a top-level request field,
// which is convenient if one wants to extract parameters from either
// the URL or HTTP template into the request fields and also want access
// to the raw HTTP body. Example: message GetResourceRequest { // A
// unique request id. string request_id = 1; // The raw HTTP body is
// bound to this field. google.api.HttpBody http_body = 2; } service
// ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody)
// returns (google.protobuf.Empty); } Example with streaming methods:
// service CaldavService { rpc GetCalendar(stream google.api.HttpBody)
// returns (stream google.api.HttpBody); rpc UpdateCalendar(stream
// google.api.HttpBody) returns (stream google.api.HttpBody); } Use of
// this type only changes how the request and response bodies are
// handled, all other features will continue to work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the
	// content type of the body.
	ContentType string `json:"contentType,omitempty"`

	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`

	// Extensions: Application specific response metadata. Must be set in
	// the first response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingErrorContext: A description of the
// context in which an error occurred.
type GoogleCloudDiscoveryengineLoggingErrorContext struct {
	// HttpRequest: The HTTP request which was processed when the error was
	// triggered.
	HttpRequest *GoogleCloudDiscoveryengineLoggingHttpRequestContext `json:"httpRequest,omitempty"`

	// ReportLocation: The location in the source code where the decision
	// was made to report the error, usually the place where it was logged.
	ReportLocation *GoogleCloudDiscoveryengineLoggingSourceLocation `json:"reportLocation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HttpRequest") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HttpRequest") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingErrorContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingErrorLog: An error log which is
// reported to the Error Reporting system.
type GoogleCloudDiscoveryengineLoggingErrorLog struct {
	// Context: A description of the context in which the error occurred.
	Context *GoogleCloudDiscoveryengineLoggingErrorContext `json:"context,omitempty"`

	// ImportPayload: The error payload that is populated on LRO import
	// APIs.
	ImportPayload *GoogleCloudDiscoveryengineLoggingImportErrorContext `json:"importPayload,omitempty"`

	// Message: A message describing the error.
	Message string `json:"message,omitempty"`

	// RequestPayload: The API request payload, represented as a protocol
	// buffer. Most API request types are supported—for example: *
	// `type.googleapis.com/google.cloud.discoveryengine.v1alpha.DocumentServ
	// ice.CreateDocumentRequest` *
	// `type.googleapis.com/google.cloud.discoveryengine.v1alpha.UserEventSer
	// vice.WriteUserEventRequest`
	RequestPayload googleapi.RawMessage `json:"requestPayload,omitempty"`

	// ResponsePayload: The API response payload, represented as a protocol
	// buffer. This is used to log some "soft errors", where the response is
	// valid but we consider there are some quality issues like unjoined
	// events. The following API responses are supported, and no PII is
	// included: *
	// `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend`
	//  *
	// `google.cloud.discoveryengine.v1alpha.UserEventService.WriteUserEvent`
	//  *
	// `google.cloud.discoveryengine.v1alpha.UserEventService.CollectUserEven
	// t`
	ResponsePayload googleapi.RawMessage `json:"responsePayload,omitempty"`

	// ServiceContext: The service context in which this error has occurred.
	ServiceContext *GoogleCloudDiscoveryengineLoggingServiceContext `json:"serviceContext,omitempty"`

	// Status: The RPC status associated with the error log.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Context") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Context") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingErrorLog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingErrorLog
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingHttpRequestContext: HTTP request
// data that is related to a reported error.
type GoogleCloudDiscoveryengineLoggingHttpRequestContext struct {
	// ResponseStatusCode: The HTTP response status code for the request.
	ResponseStatusCode int64 `json:"responseStatusCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResponseStatusCode")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResponseStatusCode") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingHttpRequestContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingHttpRequestContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingImportErrorContext: The error
// payload that is populated on LRO import APIs, including the
// following: *
// `google.cloud.discoveryengine.v1alpha.DocumentService.ImportDocuments`
//
//	*
//
// `google.cloud.discoveryengine.v1alpha.UserEventService.ImportUserEvent
// s`
type GoogleCloudDiscoveryengineLoggingImportErrorContext struct {
	// Document: The detailed content which caused the error on importing a
	// document.
	Document string `json:"document,omitempty"`

	// GcsPath: Google Cloud Storage file path of the import source. Can be
	// set for batch operation error.
	GcsPath string `json:"gcsPath,omitempty"`

	// LineNumber: Line number of the content in file. Should be empty for
	// permission or batch operation error.
	LineNumber string `json:"lineNumber,omitempty"`

	// Operation: The operation resource name of the LRO.
	Operation string `json:"operation,omitempty"`

	// UserEvent: The detailed content which caused the error on importing a
	// user event.
	UserEvent string `json:"userEvent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Document") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingImportErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingImportErrorContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingServiceContext: Describes a running
// service that sends errors.
type GoogleCloudDiscoveryengineLoggingServiceContext struct {
	// Service: An identifier of the service—for example,
	// `discoveryengine.googleapis.com`.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Service") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Service") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingServiceContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingServiceContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingSourceLocation: Indicates a location
// in the source code of the service for which errors are reported.
type GoogleCloudDiscoveryengineLoggingSourceLocation struct {
	// FunctionName: Human-readable name of a function or method—for
	// example,
	// `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend`
	// .
	FunctionName string `json:"functionName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FunctionName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FunctionName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingSourceLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingSourceLocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsMetadata: Metadata related
// to the progress of the ImportDocuments operation. This is returned by
// the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsResponse: Response of the
// ImportDocumentsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1ImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportErrorConfig: Configuration of
// destination for Import related errors.
type GoogleCloudDiscoveryengineV1ImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an
	// empty, existing Cloud Storage directory. Import errors are written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportErrorConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsMetadata: Metadata
// related to the progress of the Import operation. This is returned by
// the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1ImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// JoinedEventsCount: Count of user events imported with complete
	// existing Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata: Metadata related
// to the progress of the PurgeDocuments operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsResponse: Response message
// for DocumentService.PurgeDocuments method. If the long running
// operation is successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1PurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`

	// PurgeSample: A sample of document names that will be deleted. Only
	// populated if `force` is set to false. A max of 100 names will be
	// returned and the names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgeCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1PurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Schema: Defines the structure and layout
// of a type of document data.
type GoogleCloudDiscoveryengineV1Schema struct {
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`

	// Name: Immutable. The full resource name of the schema, in the format
	// of
	// `projects/{project}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/schemas/{schema}`. This field must be a UTF-8
	// encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`

	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`

	// ForceSendFields is a list of field names (e.g. "JsonSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JsonSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1Schema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Schema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse:
// Response message for SiteSearchEngineService.BatchCreateTargetSites
// method.
type GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse struct {
	// TargetSites: TargetSites created.
	TargetSites []*GoogleCloudDiscoveryengineV1alphaTargetSite `json:"targetSites,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TargetSites") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TargetSites") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata: Metadata
// related to the progress of the ImportDocuments operation. This is
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse: Response of
// the ImportDocumentsRequest. If the long running operation is done,
// then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportErrorConfig: Configuration of
// destination for Import related errors.
type GoogleCloudDiscoveryengineV1alphaImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an
	// empty, existing Cloud Storage directory. Import errors are written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportErrorConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata: Metadata
// related to the progress of the Import operation. This is returned by
// the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse: Response
// of the ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// JoinedEventsCount: Count of user events imported with complete
	// existing Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata: Metadata
// related to the progress of the PurgeDocuments operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse: Response
// message for DocumentService.PurgeDocuments method. If the long
// running operation is successfully done, then this message is returned
// by the google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`

	// PurgeSample: A sample of document names that will be deleted. Only
	// populated if `force` is set to false. A max of 100 names will be
	// returned and the names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgeCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata: Metadata
// related to the progress of the PurgeUserEvents operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse: Response of
// the PurgeUserEventsRequest. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse struct {
	// PurgeCount: The total count of events purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgeCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSchema: Defines the structure and
// layout of a type of document data.
type GoogleCloudDiscoveryengineV1alphaSchema struct {
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`

	// Name: Immutable. The full resource name of the schema, in the format
	// of
	// `projects/{project}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/schemas/{schema}`. This field must be a UTF-8
	// encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`

	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`

	// ForceSendFields is a list of field names (e.g. "JsonSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JsonSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSchema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTargetSite: A target site for the
// SiteSearchEngine.
type GoogleCloudDiscoveryengineV1alphaTargetSite struct {
	// ExactMatch: Input only. If set to false, a uri_pattern is generated
	// to include all pages whose address contains the provided_uri_pattern.
	// If set to true, an uri_pattern is generated to try to be an exact
	// match of the provided_uri_pattern or just the specific page if the
	// provided_uri_pattern is a specific one. provided_uri_pattern is
	// always normalized to generate the URI pattern to be used by the
	// search engine.
	ExactMatch bool `json:"exactMatch,omitempty"`

	// GeneratedUriPattern: Output only. This is system-generated based on
	// the provided_uri_pattern.
	GeneratedUriPattern string `json:"generatedUriPattern,omitempty"`

	// Name: Output only. The fully qualified resource name of the target
	// site.
	// `projects/{project}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/siteSearchEngine/targetSites/{target_site}` The
	// `target_site_id` is system-generated.
	Name string `json:"name,omitempty"`

	// ProvidedUriPattern: Required. Input only. The user provided URI
	// pattern from which the `generated_uri_pattern` is generated.
	ProvidedUriPattern string `json:"providedUriPattern,omitempty"`

	// Type: The type of the target site, e.g. whether the site is to be
	// included or excluded.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - This value is unused. In this case, server
	// behavior defaults to Type.INCLUDE.
	//   "INCLUDE" - Include the target site.
	//   "EXCLUDE" - Exclude the target site.
	Type string `json:"type,omitempty"`

	// UpdateTime: Output only. The target site's last updated time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExactMatch") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaTargetSite) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTargetSite
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaBigQuerySource: BigQuery source
// import data from.
type GoogleCloudDiscoveryengineV1betaBigQuerySource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for user event imports: * `user_event` (default):
	// One UserEvent per row. Supported values for document imports: *
	// `document` (default): One Document format per row. Each document must
	// have a valid Document.id and one of Document.json_data or
	// Document.struct_data. * `custom`: One custom data per row in
	// arbitrary format that conforms to the defined Schema of the data
	// store. This can only be used by Gen App Builder.
	DataSchema string `json:"dataSchema,omitempty"`

	// DatasetId: Required. The BigQuery data set to copy the data from with
	// a length limit of 1,024 characters.
	DatasetId string `json:"datasetId,omitempty"`

	// GcsStagingDir: Intermediate Cloud Storage directory used for the
	// import with a length limit of 2,000 characters. Can be specified if
	// one wants to have the BigQuery export to a specific Cloud Storage
	// directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`

	// PartitionDate: BigQuery time partitioned table's _PARTITIONDATE in
	// YYYY-MM-DD format.
	PartitionDate *GoogleTypeDate `json:"partitionDate,omitempty"`

	// ProjectId: The project ID (can be project # or ID) that the BigQuery
	// source is in with a length limit of 128 characters. If not specified,
	// inherits the project ID from the parent request.
	ProjectId string `json:"projectId,omitempty"`

	// TableId: Required. The BigQuery table to copy the data from with a
	// length limit of 1,024 characters.
	TableId string `json:"tableId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaBigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaBigQuerySource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCompletionInfo: Detailed completion
// information including completion attribution token and clicked
// completion info.
type GoogleCloudDiscoveryengineV1betaCompletionInfo struct {
	// SelectedPosition: End user selected
	// CompleteQueryResponse.QuerySuggestion.suggestion position, starting
	// from 0.
	SelectedPosition int64 `json:"selectedPosition,omitempty"`

	// SelectedSuggestion: End user selected
	// CompleteQueryResponse.QuerySuggestion.suggestion.
	SelectedSuggestion string `json:"selectedSuggestion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SelectedPosition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SelectedPosition") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaCompletionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCompletionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCustomAttribute: A custom attribute
// that is not explicitly modeled in a resource, e.g. UserEvent.
type GoogleCloudDiscoveryengineV1betaCustomAttribute struct {
	// Numbers: The numerical values of this custom attribute. For example,
	// `[2.3, 15.4]` when the key is "lengths_cm". Exactly one of
	// CustomAttribute.text or CustomAttribute.numbers should be set.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	Numbers []float64 `json:"numbers,omitempty"`

	// Text: The textual values of this custom attribute. For example,
	// `["yellow", "green"]` when the key is "color". Empty string is not
	// allowed. Otherwise, an `INVALID_ARGUMENT` error is returned. Exactly
	// one of CustomAttribute.text or CustomAttribute.numbers should be set.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	Text []string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Numbers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Numbers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaCustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCustomAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaCustomAttribute) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaCustomAttribute
	var s1 struct {
		Numbers []gensupport.JSONFloat64 `json:"numbers"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Numbers = make([]float64, len(s1.Numbers))
	for i := range s1.Numbers {
		s.Numbers[i] = float64(s1.Numbers[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1betaDocument: Document captures all raw
// metadata information of items to be recommended or searched.
type GoogleCloudDiscoveryengineV1betaDocument struct {
	// Id: Immutable. The identifier of the document. Id should conform to
	// RFC-1034 (https://tools.ietf.org/html/rfc1034) standard with a length
	// limit of 63 characters.
	Id string `json:"id,omitempty"`

	// JsonData: The JSON string representation of the document. It should
	// conform to the registered Schema or an `INVALID_ARGUMENT` error is
	// thrown.
	JsonData string `json:"jsonData,omitempty"`

	// Name: Immutable. The full resource name of the document. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/branches/{branch}/documents/{document_id}`. This
	// field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	Name string `json:"name,omitempty"`

	// ParentDocumentId: The identifier of the parent document. Currently
	// supports at most two level document hierarchy. Id should conform to
	// RFC-1034 (https://tools.ietf.org/html/rfc1034) standard with a length
	// limit of 63 characters.
	ParentDocumentId string `json:"parentDocumentId,omitempty"`

	// SchemaId: The identifier of the schema located in the same data
	// store.
	SchemaId string `json:"schemaId,omitempty"`

	// StructData: The structured JSON data for the document. It should
	// conform to the registered Schema or an `INVALID_ARGUMENT` error is
	// thrown.
	StructData googleapi.RawMessage `json:"structData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocument
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDocumentInfo: Detailed document
// information associated with a user event.
type GoogleCloudDiscoveryengineV1betaDocumentInfo struct {
	// Id: The Document resource ID.
	Id string `json:"id,omitempty"`

	// Name: The Document resource full name, of the form:
	// `projects/{project_id}/locations/{location}/collections/{collection_id
	// }/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_
	// id}`
	Name string `json:"name,omitempty"`

	// PromotionIds: The promotion IDs associated with this Document.
	// Currently, this field is restricted to at most one ID.
	PromotionIds []string `json:"promotionIds,omitempty"`

	// Quantity: Quantity of the Document associated with the user event.
	// Defaults to 1. For example, this field will be 2 if two quantities of
	// the same Document are involved in a `add-to-cart` event. Required for
	// events of the following event types: * `add-to-cart` * `purchase`
	Quantity int64 `json:"quantity,omitempty"`

	// Uri: The Document URI - only allowed for website data stores.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDocumentInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaGcsSource: Cloud Storage location for
// input content.
type GoogleCloudDiscoveryengineV1betaGcsSource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for document imports: * `document` (default): One
	// JSON Document per line. Each document must have a valid Document.id.
	// * `content`: Unstructured data (e.g. PDF, HTML). Each file matched by
	// `input_uris` becomes a document, with the ID set to the first 128
	// bits of SHA256(URI) encoded as a hex string. * `custom`: One custom
	// data JSON per row in arbitrary format that conforms to the defined
	// Schema of the data store. This can only be used by Gen App Builder. *
	// `csv`: A CSV file with header conforming to the defined Schema of the
	// data store. Each entry after the header is imported as a Document.
	// This can only be used by Gen App Builder. Supported values for user
	// even imports: * `user_event` (default): One JSON UserEvent per line.
	DataSchema string `json:"dataSchema,omitempty"`

	// InputUris: Required. Cloud Storage URIs to input files. URI can be up
	// to 2000 characters long. URIs can match the full object path (for
	// example, `gs://bucket/directory/object.json`) or a pattern matching
	// one or more files, such as `gs://bucket/directory/*.json`. A request
	// can contain at most 100 files (or 100,000 files if `data_schema` is
	// `content`). Each file can be up to 2 GB (or 100 MB if `data_schema`
	// is `content`).
	InputUris []string `json:"inputUris,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaGcsSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata: Metadata
// related to the progress of the ImportDocuments operation. This is
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsRequest: Request
// message for Import methods.
type GoogleCloudDiscoveryengineV1betaImportDocumentsRequest struct {
	// AutoGenerateIds: Whether to automatically generate IDs for the
	// documents if absent. If set to `true`, Document.ids are automatically
	// generated based on the hash of the payload, where IDs may not be
	// consistent during multiple imports. In which case
	// ReconciliationMode.FULL is highly recommended to avoid duplicate
	// contents. If unset or set to `false`, Document.ids have to be
	// specified using id_field, otherwise, documents without IDs fail to be
	// imported. Only set this field when using GcsSource or BigQuerySource,
	// and when GcsSource.data_schema or BigQuerySource.data_schema is
	// `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
	AutoGenerateIds bool `json:"autoGenerateIds,omitempty"`

	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1betaBigQuerySource `json:"bigquerySource,omitempty"`

	// ErrorConfig: The desired location of errors incurred during the
	// Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`

	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1betaGcsSource `json:"gcsSource,omitempty"`

	// IdField: The field in the Cloud Storage and BigQuery sources that
	// indicates the unique IDs of the documents. For GcsSource it is the
	// key of the JSON field. For instance, `my_id` for JSON `{"my_id":
	// "some_uuid"}`. For BigQuerySource it is the column name of the
	// BigQuery table where the unique ids are stored. The values of the
	// JSON field or the BigQuery column are used as the Document.ids. The
	// JSON field or the BigQuery column must be of string type, and the
	// values must be set as valid strings conform to RFC-1034
	// (https://tools.ietf.org/html/rfc1034) with 1-63 characters.
	// Otherwise, documents without valid IDs fail to be imported. Only set
	// this field when using GcsSource or BigQuerySource, and when
	// GcsSource.data_schema or BigQuerySource.data_schema is `custom`. And
	// only set this field when auto_generate_ids is unset or set as
	// `false`. Otherwise, an INVALID_ARGUMENT error is thrown. If it is
	// unset, a default value `_id` is used when importing from the allowed
	// data sources.
	IdField string `json:"idField,omitempty"`

	// InlineSource: The Inline source for the input content for documents.
	InlineSource *GoogleCloudDiscoveryengineV1betaImportDocumentsRequestInlineSource `json:"inlineSource,omitempty"`

	// ReconciliationMode: The mode of reconciliation between existing
	// documents and the documents to be imported. Defaults to
	// ReconciliationMode.INCREMENTAL.
	//
	// Possible values:
	//   "RECONCILIATION_MODE_UNSPECIFIED" - Defaults to `INCREMENTAL`.
	//   "INCREMENTAL" - Inserts new documents or updates existing
	// documents.
	//   "FULL" - Calculates diff and replaces the entire document dataset.
	// Existing documents may be deleted if they are not present in the
	// source location.
	ReconciliationMode string `json:"reconciliationMode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoGenerateIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoGenerateIds") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsRequestInlineSource:
// The inline source for the input config for ImportDocuments method.
type GoogleCloudDiscoveryengineV1betaImportDocumentsRequestInlineSource struct {
	// Documents: Required. A list of documents to update/create. Each
	// document must have a valid Document.id. Recommended max of 100 items.
	Documents []*GoogleCloudDiscoveryengineV1betaDocument `json:"documents,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Documents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportDocumentsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsRequestInlineSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsResponse: Response of
// the ImportDocumentsRequest. If the long running operation is done,
// then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1betaImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportErrorConfig: Configuration of
// destination for Import related errors.
type GoogleCloudDiscoveryengineV1betaImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an
	// empty, existing Cloud Storage directory. Import errors are written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportErrorConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata: Metadata
// related to the progress of the Import operation. This is returned by
// the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsRequest: Request
// message for the ImportUserEvents request.
type GoogleCloudDiscoveryengineV1betaImportUserEventsRequest struct {
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1betaBigQuerySource `json:"bigquerySource,omitempty"`

	// ErrorConfig: The desired location of errors incurred during the
	// Import. Cannot be set for inline user event imports.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`

	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1betaGcsSource `json:"gcsSource,omitempty"`

	// InlineSource: The Inline source for the input content for UserEvents.
	InlineSource *GoogleCloudDiscoveryengineV1betaImportUserEventsRequestInlineSource `json:"inlineSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigquerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsRequestInlineSource:
// The inline source for the input config for ImportUserEvents method.
type GoogleCloudDiscoveryengineV1betaImportUserEventsRequestInlineSource struct {
	// UserEvents: Required. A list of user events to import. Recommended
	// max of 10k items.
	UserEvents []*GoogleCloudDiscoveryengineV1betaUserEvent `json:"userEvents,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserEvents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserEvents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportUserEventsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsRequestInlineSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsResponse: Response of
// the ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1betaImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// JoinedEventsCount: Count of user events imported with complete
	// existing Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaListDocumentsResponse: Response
// message for DocumentService.ListDocuments method.
type GoogleCloudDiscoveryengineV1betaListDocumentsResponse struct {
	// Documents: The Documents.
	Documents []*GoogleCloudDiscoveryengineV1betaDocument `json:"documents,omitempty"`

	// NextPageToken: A token that can be sent as
	// ListDocumentsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Documents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaListDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaListDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaMediaInfo: Media-specific user event
// information.
type GoogleCloudDiscoveryengineV1betaMediaInfo struct {
	// MediaProgressDuration: The media progress time in seconds, if
	// applicable. For example, if the end user has finished 90 seconds of a
	// playback video, then MediaInfo.media_progress_duration.seconds should
	// be set to 90.
	MediaProgressDuration string `json:"mediaProgressDuration,omitempty"`

	// MediaProgressPercentage: Media progress should be computed using only
	// the media_progress_duration relative to the media total length. This
	// value must be between `[0, 1.0]` inclusive. If this is not a playback
	// or the progress cannot be computed (e.g. ongoing livestream), this
	// field should be unset.
	MediaProgressPercentage float64 `json:"mediaProgressPercentage,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MediaProgressDuration") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MediaProgressDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaMediaInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaMediaInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaMediaInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaMediaInfo
	var s1 struct {
		MediaProgressPercentage gensupport.JSONFloat64 `json:"mediaProgressPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MediaProgressPercentage = float64(s1.MediaProgressPercentage)
	return nil
}

// GoogleCloudDiscoveryengineV1betaPageInfo: Detailed page information.
type GoogleCloudDiscoveryengineV1betaPageInfo struct {
	// PageCategory: The most specific category associated with a category
	// page. To represent full path of category, use '>' sign to separate
	// different hierarchies. If '>' is part of the category name, please
	// replace it with other character(s). Category pages include special
	// pages such as sales or promotions. For instance, a special sale page
	// may have the category hierarchy: "pageCategory" : "Sales > 2017
	// Black Friday Deals". Required for `view-category-page` events. Other
	// event types should not set this field. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	PageCategory string `json:"pageCategory,omitempty"`

	// PageviewId: A unique ID of a web page view. This should be kept the
	// same for all user events triggered from the same pageview. For
	// example, an item detail page view could trigger multiple events as
	// the user is browsing the page. The `pageview_id` property should be
	// kept the same for all these events so that they can be grouped
	// together properly. When using the client side event reporting with
	// JavaScript pixel and Google Tag Manager, this value is filled in
	// automatically.
	PageviewId string `json:"pageviewId,omitempty"`

	// ReferrerUri: The referrer URL of the current page. When using the
	// client side event reporting with JavaScript pixel and Google Tag
	// Manager, this value is filled in automatically. However, some browser
	// privacy restrictions may cause this field to be empty.
	ReferrerUri string `json:"referrerUri,omitempty"`

	// Uri: Complete URL (window.location.href) of the user's current page.
	// When using the client side event reporting with JavaScript pixel and
	// Google Tag Manager, this value is filled in automatically. Maximum
	// length 5,000 characters.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PageCategory") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageCategory") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaPageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPanelInfo: Detailed panel information
// associated with a user event.
type GoogleCloudDiscoveryengineV1betaPanelInfo struct {
	// DisplayName: The display name of the panel.
	DisplayName string `json:"displayName,omitempty"`

	// PanelId: Required. The panel ID.
	PanelId string `json:"panelId,omitempty"`

	// PanelPosition: The ordered position of the panel, if shown to the
	// user with other panels. If set, then total_panels must also be set.
	PanelPosition int64 `json:"panelPosition,omitempty"`

	// TotalPanels: The total number of panels, including this one, shown to
	// the user. Must be set if panel_position is set.
	TotalPanels int64 `json:"totalPanels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaPanelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPanelInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata: Metadata
// related to the progress of the PurgeDocuments operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest: Request
// message for DocumentService.PurgeDocuments method.
type GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest struct {
	// Filter: Required. Filter matching documents to purge. Only currently
	// supported value is `*` (all items).
	Filter string `json:"filter,omitempty"`

	// Force: Actually performs the purge. If `force` is set to false,
	// return the expected purge count without deleting any documents.
	Force bool `json:"force,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse: Response
// message for DocumentService.PurgeDocuments method. If the long
// running operation is successfully done, then this message is returned
// by the google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`

	// PurgeSample: A sample of document names that will be deleted. Only
	// populated if `force` is set to false. A max of 100 names will be
	// returned and the names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgeCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaRecommendRequest: Request message for
// Recommend method.
type GoogleCloudDiscoveryengineV1betaRecommendRequest struct {
	// Filter: Filter for restricting recommendation results with a length
	// limit of 5,000 characters. Currently, only filter expressions on the
	// `filter_tags` attribute is supported. Examples: * `(filter_tags:
	// ANY("Red", "Blue") OR filter_tags: ANY("Hot", "Cold"))` *
	// `(filter_tags: ANY("Red", "Blue")) AND NOT (filter_tags:
	// ANY("Green"))` If your filter blocks all results, the API will return
	// generic (unfiltered) popular Documents. If you only want results
	// strictly matching the filters, set `strictFiltering` to True in
	// RecommendRequest.params to receive empty results instead. Note that
	// the API will never return Documents with `storageStatus` of `EXPIRED`
	// or `DELETED` regardless of filter choices.
	Filter string `json:"filter,omitempty"`

	// PageSize: Maximum number of results to return. Set this property to
	// the number of recommendation results needed. If zero, the service
	// will choose a reasonable default. The maximum allowed value is 100.
	// Values above 100 will be coerced to 100.
	PageSize int64 `json:"pageSize,omitempty"`

	// Params: Additional domain specific parameters for the
	// recommendations. Allowed values: * `returnDocument`: Boolean. If set
	// to true, the associated Document object will be returned in
	// RecommendResponse.RecommendationResult.document. * `returnScore`:
	// Boolean. If set to true, the recommendation 'score' corresponding to
	// each returned Document will be set in
	// RecommendResponse.RecommendationResult.metadata. The given 'score'
	// indicates the probability of a Document conversion given the user's
	// context and history. * `strictFiltering`: Boolean. True by default.
	// If set to false, the service will return generic (unfiltered) popular
	// Documents instead of empty if your filter blocks all recommendation
	// results. * `diversityLevel`: String. Default empty. If set to be
	// non-empty, then it needs to be one of: * `no-diversity` *
	// `low-diversity` * `medium-diversity` * `high-diversity` *
	// `auto-diversity` This gives request-level control and adjusts
	// recommendation results based on Document category.
	Params googleapi.RawMessage `json:"params,omitempty"`

	// UserEvent: Required. Context about the user, what they are looking at
	// and what action they took to trigger the Recommend request. Note that
	// this user event detail won't be ingested to userEvent logs. Thus, a
	// separate userEvent write request is required for event logging. Don't
	// set UserEvent.user_pseudo_id or UserEvent.user_info.user_id to the
	// same fixed ID for different users. If you are trying to receive
	// non-personalized recommendations (not recommended; this can
	// negatively impact model performance), instead set
	// UserEvent.user_pseudo_id to a random unique ID and leave
	// UserEvent.user_info.user_id unset.
	UserEvent *GoogleCloudDiscoveryengineV1betaUserEvent `json:"userEvent,omitempty"`

	// UserLabels: The user labels applied to a resource must meet the
	// following requirements: * Each resource can have multiple labels, up
	// to a maximum of 64. * Each label must be a key-value pair. * Keys
	// have a minimum length of 1 character and a maximum length of 63
	// characters and cannot be empty. Values can be empty and have a
	// maximum length of 63 characters. * Keys and values can contain only
	// lowercase letters, numeric characters, underscores, and dashes. All
	// characters must use UTF-8 encoding, and international characters are
	// allowed. * The key portion of a label must be unique. However, you
	// can use the same key with multiple resources. * Keys must start with
	// a lowercase letter or international character. See Requirements for
	// labels
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`

	// ValidateOnly: Use validate only mode for this recommendation query.
	// If set to true, a fake model will be used that returns arbitrary
	// Document IDs. Note that the validate only mode should only be used
	// for testing the API, or if the model is not ready.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaRecommendRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaRecommendRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaRecommendResponse: Response message
// for Recommend method.
type GoogleCloudDiscoveryengineV1betaRecommendResponse struct {
	// AttributionToken: A unique attribution token. This should be included
	// in the UserEvent logs resulting from this recommendation, which
	// enables accurate attribution of recommendation model performance.
	AttributionToken string `json:"attributionToken,omitempty"`

	// MissingIds: IDs of documents in the request that were missing from
	// the default Branch associated with the requested ServingConfig.
	MissingIds []string `json:"missingIds,omitempty"`

	// Results: A list of recommended Documents. The order represents the
	// ranking (from the most relevant Document to the least).
	Results []*GoogleCloudDiscoveryengineV1betaRecommendResponseRecommendationResult `json:"results,omitempty"`

	// ValidateOnly: True if RecommendRequest.validate_only was set.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributionToken") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaRecommendResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaRecommendResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaRecommendResponseRecommendationResult:
//
//	RecommendationResult represents a generic recommendation result with
//
// associated metadata.
type GoogleCloudDiscoveryengineV1betaRecommendResponseRecommendationResult struct {
	// Document: Set if `returnDocument` is set to true in
	// RecommendRequest.params.
	Document *GoogleCloudDiscoveryengineV1betaDocument `json:"document,omitempty"`

	// Id: Resource ID of the recommended Document.
	Id string `json:"id,omitempty"`

	// Metadata: Additional Document metadata / annotations. Possible
	// values: * `score`: Recommendation score in double value. Is set if
	// `returnScore` is set to true in RecommendRequest.params.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Document") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaRecommendResponseRecommendationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaRecommendResponseRecommendationResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSchema: Defines the structure and
// layout of a type of document data.
type GoogleCloudDiscoveryengineV1betaSchema struct {
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`

	// Name: Immutable. The full resource name of the schema, in the format
	// of
	// `projects/{project}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/schemas/{schema}`. This field must be a UTF-8
	// encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`

	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`

	// ForceSendFields is a list of field names (e.g. "JsonSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JsonSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSchema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSearchInfo: Detailed search
// information.
type GoogleCloudDiscoveryengineV1betaSearchInfo struct {
	// Offset: An integer that specifies the current offset for pagination
	// (the 0-indexed starting location, amongst the products deemed by the
	// API as relevant). See SearchRequest.offset for definition. If this
	// field is negative, an `INVALID_ARGUMENT` is returned. This can only
	// be set for `search` events. Other event types should not set this
	// field. Otherwise, an `INVALID_ARGUMENT` error is returned.
	Offset int64 `json:"offset,omitempty"`

	// OrderBy: The order in which products are returned, if applicable. See
	// SearchRequest.order_by for definition and syntax. The value must be a
	// UTF-8 encoded string with a length limit of 1,000 characters.
	// Otherwise, an `INVALID_ARGUMENT` error is returned. This can only be
	// set for `search` events. Other event types should not set this field.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	OrderBy string `json:"orderBy,omitempty"`

	// SearchQuery: The user's search query. See SearchRequest.query for
	// definition. The value must be a UTF-8 encoded string with a length
	// limit of 5,000 characters. Otherwise, an `INVALID_ARGUMENT` error is
	// returned. At least one of search_query or PageInfo.page_category is
	// required for `search` events. Other event types should not set this
	// field. Otherwise, an `INVALID_ARGUMENT` error is returned.
	SearchQuery string `json:"searchQuery,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Offset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Offset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaSearchInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSearchInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaTransactionInfo: A transaction
// represents the entire purchase transaction.
type GoogleCloudDiscoveryengineV1betaTransactionInfo struct {
	// Cost: All the costs associated with the products. These can be
	// manufacturing costs, shipping expenses not borne by the end user, or
	// any other costs, such that: * Profit = value - tax - cost
	Cost float64 `json:"cost,omitempty"`

	// Currency: Required. Currency code. Use three-character ISO-4217 code.
	Currency string `json:"currency,omitempty"`

	// DiscountValue: The total discount(s) value applied to this
	// transaction. This figure should be excluded from
	// TransactionInfo.value For example, if a user paid
	// TransactionInfo.value amount, then nominal (pre-discount) value of
	// the transaction is the sum of TransactionInfo.value and
	// TransactionInfo.discount_value This means that profit is calculated
	// the same way, regardless of the discount value, and that
	// TransactionInfo.discount_value can be larger than
	// TransactionInfo.value: * Profit = value - tax - cost
	DiscountValue float64 `json:"discountValue,omitempty"`

	// Tax: All the taxes associated with the transaction.
	Tax float64 `json:"tax,omitempty"`

	// TransactionId: The transaction ID with a length limit of 128
	// characters.
	TransactionId string `json:"transactionId,omitempty"`

	// Value: Required. Total non-zero value associated with the
	// transaction. This value may include shipping, tax, or other
	// adjustments to the total value that you want to include.
	Value float64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cost") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cost") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaTransactionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaTransactionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1betaTransactionInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1betaTransactionInfo
	var s1 struct {
		Cost          gensupport.JSONFloat64 `json:"cost"`
		DiscountValue gensupport.JSONFloat64 `json:"discountValue"`
		Tax           gensupport.JSONFloat64 `json:"tax"`
		Value         gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cost = float64(s1.Cost)
	s.DiscountValue = float64(s1.DiscountValue)
	s.Tax = float64(s1.Tax)
	s.Value = float64(s1.Value)
	return nil
}

// GoogleCloudDiscoveryengineV1betaUserEvent: UserEvent captures all
// metadata information Discovery Engine API needs to know about how end
// users interact with customers' website.
type GoogleCloudDiscoveryengineV1betaUserEvent struct {
	// Attributes: Extra user event features to include in the
	// recommendation model. These attributes must NOT contain data that
	// needs to be parsed or processed further, e.g. JSON or other
	// encodings. If you provide custom attributes for ingested user events,
	// also include them in the user events that you associate with
	// prediction requests. Custom attribute formatting must be consistent
	// between imported events and events provided with prediction requests.
	// This lets the Discovery Engine API use those custom attributes when
	// training models and serving predictions, which helps improve
	// recommendation quality. This field needs to pass all below criteria,
	// otherwise an `INVALID_ARGUMENT` error is returned: * The key must be
	// a UTF-8 encoded string with a length limit of 5,000 characters. * For
	// text attributes, at most 400 values are allowed. Empty values are not
	// allowed. Each value must be a UTF-8 encoded string with a length
	// limit of 256 characters. * For number attributes, at most 400 values
	// are allowed. For product recommendations, an example of extra user
	// information is `traffic_channel`, which is how a user arrives at the
	// site. Users can arrive at the site by coming to the site directly,
	// coming through Google search, or in other ways.
	Attributes map[string]GoogleCloudDiscoveryengineV1betaCustomAttribute `json:"attributes,omitempty"`

	// AttributionToken: Token to attribute an API response to user
	// action(s) to trigger the event. Highly recommended for user events
	// that are the result of RecommendationService.Recommend. This field
	// enables accurate attribution of recommendation model performance. The
	// value must be one of: * RecommendResponse.attribution_token for
	// events that are the result of RecommendationService.Recommend. *
	// SearchResponse.attribution_token for events that are the result of
	// SearchService.Search. This token enables us to accurately attribute
	// page view or conversion completion back to the event and the
	// particular predict response containing this clicked/purchased
	// product. If user clicks on product K in the recommendation results,
	// pass RecommendResponse.attribution_token as a URL parameter to
	// product K's page. When recording events on product K's page, log the
	// RecommendResponse.attribution_token to this field.
	AttributionToken string `json:"attributionToken,omitempty"`

	// CompletionInfo: CompletionService.CompleteQuery details related to
	// the event. This field should be set for `search` event when
	// autocomplete function is enabled and the user clicks a suggestion for
	// search.
	CompletionInfo *GoogleCloudDiscoveryengineV1betaCompletionInfo `json:"completionInfo,omitempty"`

	// DirectUserRequest: Should set to true if the request is made directly
	// from the end user, in which case the UserEvent.user_info.user_agent
	// can be populated from the HTTP request. This flag should be set only
	// if the API request is made directly from the end user such as a
	// mobile app (and not if a gateway or a server is processing and
	// pushing the user events). This should not be set when using the
	// JavaScript tag in UserEventService.CollectUserEvent.
	DirectUserRequest bool `json:"directUserRequest,omitempty"`

	// Documents: List of Documents associated with this user event. This
	// field is optional except for the following event types: * `view-item`
	// * `add-to-cart` * `purchase` * `media-play` * `media-complete` In a
	// `search` event, this field represents the documents returned to the
	// end user on the current page (the end user may have not finished
	// browsing the whole page yet). When a new page is returned to the end
	// user, after pagination/filtering/ordering even for the same query, a
	// new `search` event with different UserEvent.documents is desired.
	Documents []*GoogleCloudDiscoveryengineV1betaDocumentInfo `json:"documents,omitempty"`

	// EventTime: Only required for UserEventService.ImportUserEvents
	// method. Timestamp of when the user event happened.
	EventTime string `json:"eventTime,omitempty"`

	// EventType: Required. User event type. Allowed values are: Generic
	// values: * `search`: Search for Documents. * `view-item`: Detailed
	// page view of a Document. * `view-item-list`: View of a panel or
	// ordered list of Documents. * `view-home-page`: View of the home page.
	// * `view-category-page`: View of a category page, e.g. Home > Men >
	// Jeans Retail-related values: * `add-to-cart`: Add an item(s) to cart,
	// e.g. in Retail online shopping * `purchase`: Purchase an item(s)
	// Media-related values: * `media-play`: Start/resume watching a video,
	// playing a song, etc. * `media-complete`: Finished or stopped midway
	// through a video, song, etc.
	EventType string `json:"eventType,omitempty"`

	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents
	// being filtered. One example is for `search` events, the associated
	// SearchRequest may contain a filter expression in SearchRequest.filter
	// conforming to https://google.aip.dev/160#filtering. Similarly, for
	// `view-item-list` events that are generated from a
	// RecommendationService.RecommendRequest, this field may be populated
	// directly from RecommendationService.RecommendRequest.filter
	// conforming to https://google.aip.dev/160#filtering. The value must be
	// a UTF-8 encoded string with a length limit of 1,000 characters.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	Filter string `json:"filter,omitempty"`

	// MediaInfo: Media-specific info.
	MediaInfo *GoogleCloudDiscoveryengineV1betaMediaInfo `json:"mediaInfo,omitempty"`

	// PageInfo: Page metadata such as categories and other critical
	// information for certain event types such as `view-category-page`.
	PageInfo *GoogleCloudDiscoveryengineV1betaPageInfo `json:"pageInfo,omitempty"`

	// Panel: Panel metadata associated with this user event.
	Panel *GoogleCloudDiscoveryengineV1betaPanelInfo `json:"panel,omitempty"`

	// PromotionIds: The promotion IDs if this is an event associated with
	// promotions. Currently, this field is restricted to at most one ID.
	PromotionIds []string `json:"promotionIds,omitempty"`

	// SearchInfo: SearchService.Search details related to the event. This
	// field should be set for `search` event.
	SearchInfo *GoogleCloudDiscoveryengineV1betaSearchInfo `json:"searchInfo,omitempty"`

	// SessionId: A unique identifier for tracking a visitor session with a
	// length limit of 128 bytes. A session is an aggregation of an end user
	// behavior in a time span. A general guideline to populate the
	// session_id: 1. If user has no activity for 30 min, a new session_id
	// should be assigned. 2. The session_id should be unique across users,
	// suggest use uuid or add UserEvent.user_pseudo_id as prefix.
	SessionId string `json:"sessionId,omitempty"`

	// TagIds: A list of identifiers for the independent experiment groups
	// this user event belongs to. This is used to distinguish between user
	// events associated with different experiment setups on the customer
	// end.
	TagIds []string `json:"tagIds,omitempty"`

	// TransactionInfo: The transaction metadata (if any) associated with
	// this user event.
	TransactionInfo *GoogleCloudDiscoveryengineV1betaTransactionInfo `json:"transactionInfo,omitempty"`

	// UserInfo: Information about the end user.
	UserInfo *GoogleCloudDiscoveryengineV1betaUserInfo `json:"userInfo,omitempty"`

	// UserPseudoId: Required. A unique identifier for tracking visitors.
	// For example, this could be implemented with an HTTP cookie, which
	// should be able to uniquely identify a visitor on a single device.
	// This unique identifier should not change if the visitor log in/out of
	// the website. Do not set the field to the same fixed ID for different
	// users. This mixes the event history of those users together, which
	// results in degraded model quality. The field must be a UTF-8 encoded
	// string with a length limit of 128 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned. The field should not contain
	// PII or user-data. We recommend to use Google Analytics Client ID
	// (https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
	// for this field.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaUserEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaUserEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaUserInfo: Information of an end user.
type GoogleCloudDiscoveryengineV1betaUserInfo struct {
	// UserAgent: User agent as included in the HTTP header. The field must
	// be a UTF-8 encoded string with a length limit of 1,000 characters.
	// Otherwise, an `INVALID_ARGUMENT` error is returned. This should not
	// be set when using the client side event reporting with GTM or
	// JavaScript tag in UserEventService.CollectUserEvent or if
	// UserEvent.direct_user_request is set.
	UserAgent string `json:"userAgent,omitempty"`

	// UserId: Highly recommended for logged-in users. Unique identifier for
	// logged-in user, such as a user name. Don't set for anonymous users.
	// Always use a hashed value for this ID. Don't set the field to the
	// same fixed ID for different users. This mixes the event history of
	// those users together, which results in degraded model quality. The
	// field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	UserId string `json:"userId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserAgent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserAgent") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaUserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaUserInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as
// a birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values. * A month and day, with a
// zero year (for example, an anniversary). * A year on its own, with a
// zero month and a zero day. * A year and month, with a zero day (for
// example, a credit card expiration date). Related types: *
// google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.create":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall struct {
	s                                        *Service
	parent                                   string
	googleclouddiscoveryenginev1betadocument *GoogleCloudDiscoveryengineV1betaDocument
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Create: Creates a Document.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Create(parent string, googleclouddiscoveryenginev1betadocument *GoogleCloudDiscoveryengineV1betaDocument) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1betadocument = googleclouddiscoveryenginev1betadocument
	return c
}

// DocumentId sets the optional parameter "documentId": Required. The ID
// to use for the Document, which will become the final component of the
// Document.name. If the caller does not have permission to create the
// Document, regardless of whether or not it exists, a
// `PERMISSION_DENIED` error is returned. This field must be unique
// among all Documents with the same parent. Otherwise, an
// `ALREADY_EXISTS` error is returned. This field must conform to
// RFC-1034 (https://tools.ietf.org/html/rfc1034) standard with a length
// limit of 63 characters. Otherwise, an `INVALID_ARGUMENT` error is
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) DocumentId(documentId string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c.urlParams_.Set("documentId", documentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betadocument)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/documents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.create" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaDocument or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1betaDocument.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaDocument, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaDocument{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a Document.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "documentId": {
	//       "description": "Required. The ID to use for the Document, which will become the final component of the Document.name. If the caller does not have permission to create the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. This field must be unique among all Documents with the same parent. Otherwise, an `ALREADY_EXISTS` error is returned. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/documents",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaDocument"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaDocument"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.delete":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Document.
//
//   - name: Full resource name of Document, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}/documents/{document}`. If
//     the caller does not have permission to delete the Document,
//     regardless of whether or not it exists, a `PERMISSION_DENIED` error
//     is returned. If the Document to delete does not exist, a
//     `NOT_FOUND` error is returned.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Delete(name string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a Document.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents/{documentsId}",
	//   "httpMethod": "DELETE",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Document, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`. If the caller does not have permission to delete the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. If the Document to delete does not exist, a `NOT_FOUND` error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+/documents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.get":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Document.
//
//   - name: Full resource name of Document, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}/documents/{document}`. If
//     the caller does not have permission to access the Document,
//     regardless of whether or not it exists, a `PERMISSION_DENIED` error
//     is returned. If the requested Document does not exist, a
//     `NOT_FOUND` error is returned.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Get(name string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.get" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaDocument or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1betaDocument.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaDocument, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaDocument{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a Document.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents/{documentsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Document, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`. If the caller does not have permission to access the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. If the requested Document does not exist, a `NOT_FOUND` error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+/documents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaDocument"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.import":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall struct {
	s                                                      *Service
	parent                                                 string
	googleclouddiscoveryenginev1betaimportdocumentsrequest *GoogleCloudDiscoveryengineV1betaImportDocumentsRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// Import: Bulk import of multiple Documents. Request processing may be
// synchronous. Non-existing items will be created. Note: It is possible
// for a subset of the Documents to be successfully updated.
//
//   - parent: The parent branch resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`. Requires create/update
//     permission.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Import(parent string, googleclouddiscoveryenginev1betaimportdocumentsrequest *GoogleCloudDiscoveryengineV1betaImportDocumentsRequest) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1betaimportdocumentsrequest = googleclouddiscoveryenginev1betaimportdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betaimportdocumentsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/documents:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Bulk import of multiple Documents. Request processing may be synchronous. Non-existing items will be created. Note: It is possible for a subset of the Documents to be successfully updated.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents:import",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent branch resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`. Requires create/update permission.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/documents:import",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaImportDocumentsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.list":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets a list of Documents.
//
//   - parent: The parent branch resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`. Use `default_branch` as
//     the branch ID, to list documents under the default branch. If the
//     caller does not have permission to list Documents under this
//     branch, regardless of whether or not this branch exists, a
//     `PERMISSION_DENIED` error is returned.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) List(parent string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// Documents to return. If unspecified, defaults to 100. The maximum
// allowed value is 1000. Values above 1000 will be coerced to 1000. If
// this field is negative, an `INVALID_ARGUMENT` error is returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// ListDocumentsResponse.next_page_token, received from a previous
// DocumentService.ListDocuments call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// DocumentService.ListDocuments must match the call that provided the
// page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/documents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.list" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaListDocumentsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDiscoveryengineV1betaListDocumentsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaListDocumentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaListDocumentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a list of Documents.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Maximum number of Documents to return. If unspecified, defaults to 100. The maximum allowed value is 1000. Values above 1000 will be coerced to 1000. If this field is negative, an `INVALID_ARGUMENT` error is returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token ListDocumentsResponse.next_page_token, received from a previous DocumentService.ListDocuments call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to DocumentService.ListDocuments must match the call that provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent branch resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`. Use `default_branch` as the branch ID, to list documents under the default branch. If the caller does not have permission to list Documents under this branch, regardless of whether or not this branch exists, a `PERMISSION_DENIED` error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/documents",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaListDocumentsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1betaListDocumentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.patch":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall struct {
	s                                        *Service
	name                                     string
	googleclouddiscoveryenginev1betadocument *GoogleCloudDiscoveryengineV1betaDocument
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Patch: Updates a Document.
//
//   - name: Immutable. The full resource name of the document. Format:
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}/documents/{document_id}`.
//     This field must be a UTF-8 encoded string with a length limit of
//     1024 characters.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Patch(name string, googleclouddiscoveryenginev1betadocument *GoogleCloudDiscoveryengineV1betaDocument) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1betadocument = googleclouddiscoveryenginev1betadocument
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the Document is not found, a new Document will be created.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betadocument)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.patch" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaDocument or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1betaDocument.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaDocument, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaDocument{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a Document.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents/{documentsId}",
	//   "httpMethod": "PATCH",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the Document is not found, a new Document will be created.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Immutable. The full resource name of the document. Format: `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+/documents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaDocument"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaDocument"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.purge":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall struct {
	s                                                     *Service
	parent                                                string
	googleclouddiscoveryenginev1betapurgedocumentsrequest *GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// Purge: Permanently deletes all selected Documents in a branch. This
// process is asynchronous. Depending on the number of Documents to be
// deleted, this operation can take hours to complete. Before the delete
// operation completes, some Documents might still be returned by
// DocumentService.GetDocument or DocumentService.ListDocuments. To get
// a list of the Documents to be deleted, set
// PurgeDocumentsRequest.force to false.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Purge(parent string, googleclouddiscoveryenginev1betapurgedocumentsrequest *GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1betapurgedocumentsrequest = googleclouddiscoveryenginev1betapurgedocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betapurgedocumentsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/documents:purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.purge" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Permanently deletes all selected Documents in a branch. This process is asynchronous. Depending on the number of Documents to be deleted, this operation can take hours to complete. Before the delete operation completes, some Documents might still be returned by DocumentService.GetDocument or DocumentService.ListDocuments. To get a list of the Documents to be deleted, set PurgeDocumentsRequest.force to false.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents:purge",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.purge",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/documents:purge",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.operations.get":

type ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresBranchesOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.operations.list":

type ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresBranchesOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.models.operations.get":

type ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresModelsOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.models.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/models/{modelsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.models.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/models/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.models.operations.list":

type ProjectsLocationsCollectionsDataStoresModelsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresModelsOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresModelsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.models.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/models/{modelsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.models.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/models/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.operations.get":

type ProjectsLocationsCollectionsDataStoresOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.operations.list":

type ProjectsLocationsCollectionsDataStoresOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.schemas.operations.get":

type ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresSchemasOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/schemas/{schemasId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.schemas.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/schemas/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.schemas.operations.list":

type ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresSchemasOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/schemas/{schemasId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.schemas.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/schemas/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.servingConfigs.recommend":

type ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall struct {
	s                                                *Service
	servingConfig                                    string
	googleclouddiscoveryenginev1betarecommendrequest *GoogleCloudDiscoveryengineV1betaRecommendRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Recommend: Makes a recommendation, which requires a contextual user
// event.
//
//   - servingConfig: Full resource name of the format:
//     `projects/*/locations/global/collections/*/dataStores/*/servingConfi
//     gs/*` Before you can request recommendations from your model, you
//     must create at least one serving config for it.
func (r *ProjectsLocationsCollectionsDataStoresServingConfigsService) Recommend(servingConfig string, googleclouddiscoveryenginev1betarecommendrequest *GoogleCloudDiscoveryengineV1betaRecommendRequest) *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall {
	c := &ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.servingConfig = servingConfig
	c.googleclouddiscoveryenginev1betarecommendrequest = googleclouddiscoveryenginev1betarecommendrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betarecommendrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+servingConfig}:recommend")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"servingConfig": c.servingConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.servingConfigs.recommend" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaRecommendResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1betaRecommendResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaRecommendResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaRecommendResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Makes a recommendation, which requires a contextual user event.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/servingConfigs/{servingConfigsId}:recommend",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.servingConfigs.recommend",
	//   "parameterOrder": [
	//     "servingConfig"
	//   ],
	//   "parameters": {
	//     "servingConfig": {
	//       "description": "Required. Full resource name of the format: `projects/*/locations/global/collections/*/dataStores/*/servingConfigs/*` Before you can request recommendations from your model, you must create at least one serving config for it.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/servingConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+servingConfig}:recommend",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaRecommendRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaRecommendResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.userEvents.collect":

type ProjectsLocationsCollectionsDataStoresUserEventsCollectCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Collect: Writes a single user event from the browser. This uses a GET
// request to due to browser restriction of POST-ing to a third-party
// domain. This method is used only by the Discovery Engine API
// JavaScript pixel and Google Tag Manager. Users should not call this
// method directly.
//
//   - parent: The parent DataStore resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}`.
func (r *ProjectsLocationsCollectionsDataStoresUserEventsService) Collect(parent string) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c := &ProjectsLocationsCollectionsDataStoresUserEventsCollectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Ets sets the optional parameter "ets": The event timestamp in
// milliseconds. This prevents browser caching of otherwise identical
// get requests. The name is abbreviated to reduce the payload bytes.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Ets(ets int64) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("ets", fmt.Sprint(ets))
	return c
}

// Uri sets the optional parameter "uri": The URL including
// cgi-parameters but excluding the hash fragment with a length limit of
// 5,000 characters. This is often more useful than the referer URL,
// because many browsers only send the domain for third-party requests.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Uri(uri string) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("uri", uri)
	return c
}

// UserEvent sets the optional parameter "userEvent": Required. URL
// encoded UserEvent proto with a length limit of 2,000,000 characters.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) UserEvent(userEvent string) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("userEvent", userEvent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/userEvents:collect")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.userEvents.collect" call.
// Exactly one of *GoogleApiHttpBody or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleApiHttpBody.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Do(opts ...googleapi.CallOption) (*GoogleApiHttpBody, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleApiHttpBody{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Writes a single user event from the browser. This uses a GET request to due to browser restriction of POST-ing to a third-party domain. This method is used only by the Discovery Engine API JavaScript pixel and Google Tag Manager. Users should not call this method directly.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/userEvents:collect",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.userEvents.collect",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "ets": {
	//       "description": "The event timestamp in milliseconds. This prevents browser caching of otherwise identical get requests. The name is abbreviated to reduce the payload bytes.",
	//       "format": "int64",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent DataStore resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "uri": {
	//       "description": "The URL including cgi-parameters but excluding the hash fragment with a length limit of 5,000 characters. This is often more useful than the referer URL, because many browsers only send the domain for third-party requests.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "userEvent": {
	//       "description": "Required. URL encoded UserEvent proto with a length limit of 2,000,000 characters.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/userEvents:collect",
	//   "response": {
	//     "$ref": "GoogleApiHttpBody"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.userEvents.import":

type ProjectsLocationsCollectionsDataStoresUserEventsImportCall struct {
	s                                                       *Service
	parent                                                  string
	googleclouddiscoveryenginev1betaimportusereventsrequest *GoogleCloudDiscoveryengineV1betaImportUserEventsRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// Import: Bulk import of User events. Request processing might be
// synchronous. Events that already exist are skipped. Use this method
// for backfilling historical user events. Operation.response is of type
// ImportResponse. Note that it is possible for a subset of the items to
// be successfully inserted. Operation.metadata is of type
// ImportMetadata.
//
//   - parent: Parent DataStore resource name, of the form
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}`.
func (r *ProjectsLocationsCollectionsDataStoresUserEventsService) Import(parent string, googleclouddiscoveryenginev1betaimportusereventsrequest *GoogleCloudDiscoveryengineV1betaImportUserEventsRequest) *ProjectsLocationsCollectionsDataStoresUserEventsImportCall {
	c := &ProjectsLocationsCollectionsDataStoresUserEventsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1betaimportusereventsrequest = googleclouddiscoveryenginev1betaimportusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresUserEventsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsImportCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresUserEventsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresUserEventsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betaimportusereventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/userEvents:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.userEvents.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Bulk import of User events. Request processing might be synchronous. Events that already exist are skipped. Use this method for backfilling historical user events. Operation.response is of type ImportResponse. Note that it is possible for a subset of the items to be successfully inserted. Operation.metadata is of type ImportMetadata.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/userEvents:import",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.userEvents.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Parent DataStore resource name, of the form `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/userEvents:import",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaImportUserEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.userEvents.write":

type ProjectsLocationsCollectionsDataStoresUserEventsWriteCall struct {
	s                                         *Service
	parent                                    string
	googleclouddiscoveryenginev1betauserevent *GoogleCloudDiscoveryengineV1betaUserEvent
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Write: Writes a single user event.
//
//   - parent: The parent DataStore resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}`.
func (r *ProjectsLocationsCollectionsDataStoresUserEventsService) Write(parent string, googleclouddiscoveryenginev1betauserevent *GoogleCloudDiscoveryengineV1betaUserEvent) *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall {
	c := &ProjectsLocationsCollectionsDataStoresUserEventsWriteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1betauserevent = googleclouddiscoveryenginev1betauserevent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betauserevent)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/userEvents:write")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.userEvents.write" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaUserEvent or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1betaUserEvent.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaUserEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaUserEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Writes a single user event.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/userEvents:write",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.userEvents.write",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent DataStore resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/userEvents:write",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaUserEvent"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaUserEvent"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.operations.get":

type ProjectsLocationsCollectionsEnginesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsEnginesOperationsService) Get(name string) *ProjectsLocationsCollectionsEnginesOperationsGetCall {
	c := &ProjectsLocationsCollectionsEnginesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsEnginesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.engines.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.operations.list":

type ProjectsLocationsCollectionsEnginesOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsEnginesOperationsService) List(name string) *ProjectsLocationsCollectionsEnginesOperationsListCall {
	c := &ProjectsLocationsCollectionsEnginesOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsEnginesOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsEnginesOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsEnginesOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsEnginesOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsEnginesOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsEnginesOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsEnginesOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsEnginesOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsEnginesOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.engines.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsEnginesOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.operations.get":

type ProjectsLocationsCollectionsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsOperationsService) Get(name string) *ProjectsLocationsCollectionsOperationsGetCall {
	c := &ProjectsLocationsCollectionsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.operations.list":

type ProjectsLocationsCollectionsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsOperationsService) List(name string) *ProjectsLocationsCollectionsOperationsListCall {
	c := &ProjectsLocationsCollectionsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.dataStores.branches.documents.create":

type ProjectsLocationsDataStoresBranchesDocumentsCreateCall struct {
	s                                        *Service
	parent                                   string
	googleclouddiscoveryenginev1betadocument *GoogleCloudDiscoveryengineV1betaDocument
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Create: Creates a Document.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`.
func (r *ProjectsLocationsDataStoresBranchesDocumentsService) Create(parent string, googleclouddiscoveryenginev1betadocument *GoogleCloudDiscoveryengineV1betaDocument) *ProjectsLocationsDataStoresBranchesDocumentsCreateCall {
	c := &ProjectsLocationsDataStoresBranchesDocumentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1betadocument = googleclouddiscoveryenginev1betadocument
	return c
}

// DocumentId sets the optional parameter "documentId": Required. The ID
// to use for the Document, which will become the final component of the
// Document.name. If the caller does not have permission to create the
// Document, regardless of whether or not it exists, a
// `PERMISSION_DENIED` error is returned. This field must be unique
// among all Documents with the same parent. Otherwise, an
// `ALREADY_EXISTS` error is returned. This field must conform to
// RFC-1034 (https://tools.ietf.org/html/rfc1034) standard with a length
// limit of 63 characters. Otherwise, an `INVALID_ARGUMENT` error is
// returned.
func (c *ProjectsLocationsDataStoresBranchesDocumentsCreateCall) DocumentId(documentId string) *ProjectsLocationsDataStoresBranchesDocumentsCreateCall {
	c.urlParams_.Set("documentId", documentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresBranchesDocumentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresBranchesDocumentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresBranchesDocumentsCreateCall) Context(ctx context.Context) *ProjectsLocationsDataStoresBranchesDocumentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresBranchesDocumentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresBranchesDocumentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betadocument)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/documents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.branches.documents.create" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaDocument or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1betaDocument.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataStoresBranchesDocumentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaDocument, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaDocument{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a Document.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.dataStores.branches.documents.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "documentId": {
	//       "description": "Required. The ID to use for the Document, which will become the final component of the Document.name. If the caller does not have permission to create the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. This field must be unique among all Documents with the same parent. Otherwise, an `ALREADY_EXISTS` error is returned. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/documents",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaDocument"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaDocument"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.branches.documents.delete":

type ProjectsLocationsDataStoresBranchesDocumentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Document.
//
//   - name: Full resource name of Document, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}/documents/{document}`. If
//     the caller does not have permission to delete the Document,
//     regardless of whether or not it exists, a `PERMISSION_DENIED` error
//     is returned. If the Document to delete does not exist, a
//     `NOT_FOUND` error is returned.
func (r *ProjectsLocationsDataStoresBranchesDocumentsService) Delete(name string) *ProjectsLocationsDataStoresBranchesDocumentsDeleteCall {
	c := &ProjectsLocationsDataStoresBranchesDocumentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresBranchesDocumentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresBranchesDocumentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresBranchesDocumentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDataStoresBranchesDocumentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresBranchesDocumentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresBranchesDocumentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.branches.documents.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataStoresBranchesDocumentsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a Document.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents/{documentsId}",
	//   "httpMethod": "DELETE",
	//   "id": "discoveryengine.projects.locations.dataStores.branches.documents.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Document, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`. If the caller does not have permission to delete the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. If the Document to delete does not exist, a `NOT_FOUND` error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/branches/[^/]+/documents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.branches.documents.get":

type ProjectsLocationsDataStoresBranchesDocumentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Document.
//
//   - name: Full resource name of Document, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}/documents/{document}`. If
//     the caller does not have permission to access the Document,
//     regardless of whether or not it exists, a `PERMISSION_DENIED` error
//     is returned. If the requested Document does not exist, a
//     `NOT_FOUND` error is returned.
func (r *ProjectsLocationsDataStoresBranchesDocumentsService) Get(name string) *ProjectsLocationsDataStoresBranchesDocumentsGetCall {
	c := &ProjectsLocationsDataStoresBranchesDocumentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresBranchesDocumentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresBranchesDocumentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataStoresBranchesDocumentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataStoresBranchesDocumentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresBranchesDocumentsGetCall) Context(ctx context.Context) *ProjectsLocationsDataStoresBranchesDocumentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresBranchesDocumentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresBranchesDocumentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.branches.documents.get" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaDocument or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1betaDocument.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataStoresBranchesDocumentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaDocument, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaDocument{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a Document.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents/{documentsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.dataStores.branches.documents.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Document, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`. If the caller does not have permission to access the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. If the requested Document does not exist, a `NOT_FOUND` error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/branches/[^/]+/documents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaDocument"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.branches.documents.import":

type ProjectsLocationsDataStoresBranchesDocumentsImportCall struct {
	s                                                      *Service
	parent                                                 string
	googleclouddiscoveryenginev1betaimportdocumentsrequest *GoogleCloudDiscoveryengineV1betaImportDocumentsRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// Import: Bulk import of multiple Documents. Request processing may be
// synchronous. Non-existing items will be created. Note: It is possible
// for a subset of the Documents to be successfully updated.
//
//   - parent: The parent branch resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`. Requires create/update
//     permission.
func (r *ProjectsLocationsDataStoresBranchesDocumentsService) Import(parent string, googleclouddiscoveryenginev1betaimportdocumentsrequest *GoogleCloudDiscoveryengineV1betaImportDocumentsRequest) *ProjectsLocationsDataStoresBranchesDocumentsImportCall {
	c := &ProjectsLocationsDataStoresBranchesDocumentsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1betaimportdocumentsrequest = googleclouddiscoveryenginev1betaimportdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresBranchesDocumentsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresBranchesDocumentsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresBranchesDocumentsImportCall) Context(ctx context.Context) *ProjectsLocationsDataStoresBranchesDocumentsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresBranchesDocumentsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresBranchesDocumentsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betaimportdocumentsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/documents:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.branches.documents.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataStoresBranchesDocumentsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Bulk import of multiple Documents. Request processing may be synchronous. Non-existing items will be created. Note: It is possible for a subset of the Documents to be successfully updated.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents:import",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.dataStores.branches.documents.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent branch resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`. Requires create/update permission.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/documents:import",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaImportDocumentsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.branches.documents.list":

type ProjectsLocationsDataStoresBranchesDocumentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets a list of Documents.
//
//   - parent: The parent branch resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`. Use `default_branch` as
//     the branch ID, to list documents under the default branch. If the
//     caller does not have permission to list Documents under this
//     branch, regardless of whether or not this branch exists, a
//     `PERMISSION_DENIED` error is returned.
func (r *ProjectsLocationsDataStoresBranchesDocumentsService) List(parent string) *ProjectsLocationsDataStoresBranchesDocumentsListCall {
	c := &ProjectsLocationsDataStoresBranchesDocumentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// Documents to return. If unspecified, defaults to 100. The maximum
// allowed value is 1000. Values above 1000 will be coerced to 1000. If
// this field is negative, an `INVALID_ARGUMENT` error is returned.
func (c *ProjectsLocationsDataStoresBranchesDocumentsListCall) PageSize(pageSize int64) *ProjectsLocationsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// ListDocumentsResponse.next_page_token, received from a previous
// DocumentService.ListDocuments call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// DocumentService.ListDocuments must match the call that provided the
// page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
func (c *ProjectsLocationsDataStoresBranchesDocumentsListCall) PageToken(pageToken string) *ProjectsLocationsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresBranchesDocumentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataStoresBranchesDocumentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataStoresBranchesDocumentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresBranchesDocumentsListCall) Context(ctx context.Context) *ProjectsLocationsDataStoresBranchesDocumentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresBranchesDocumentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresBranchesDocumentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/documents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.branches.documents.list" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaListDocumentsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDiscoveryengineV1betaListDocumentsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataStoresBranchesDocumentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaListDocumentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaListDocumentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a list of Documents.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.dataStores.branches.documents.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Maximum number of Documents to return. If unspecified, defaults to 100. The maximum allowed value is 1000. Values above 1000 will be coerced to 1000. If this field is negative, an `INVALID_ARGUMENT` error is returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token ListDocumentsResponse.next_page_token, received from a previous DocumentService.ListDocuments call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to DocumentService.ListDocuments must match the call that provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent branch resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`. Use `default_branch` as the branch ID, to list documents under the default branch. If the caller does not have permission to list Documents under this branch, regardless of whether or not this branch exists, a `PERMISSION_DENIED` error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/documents",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaListDocumentsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataStoresBranchesDocumentsListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1betaListDocumentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.dataStores.branches.documents.patch":

type ProjectsLocationsDataStoresBranchesDocumentsPatchCall struct {
	s                                        *Service
	name                                     string
	googleclouddiscoveryenginev1betadocument *GoogleCloudDiscoveryengineV1betaDocument
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Patch: Updates a Document.
//
//   - name: Immutable. The full resource name of the document. Format:
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}/documents/{document_id}`.
//     This field must be a UTF-8 encoded string with a length limit of
//     1024 characters.
func (r *ProjectsLocationsDataStoresBranchesDocumentsService) Patch(name string, googleclouddiscoveryenginev1betadocument *GoogleCloudDiscoveryengineV1betaDocument) *ProjectsLocationsDataStoresBranchesDocumentsPatchCall {
	c := &ProjectsLocationsDataStoresBranchesDocumentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1betadocument = googleclouddiscoveryenginev1betadocument
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the Document is not found, a new Document will be created.
func (c *ProjectsLocationsDataStoresBranchesDocumentsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsDataStoresBranchesDocumentsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresBranchesDocumentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresBranchesDocumentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresBranchesDocumentsPatchCall) Context(ctx context.Context) *ProjectsLocationsDataStoresBranchesDocumentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresBranchesDocumentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresBranchesDocumentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betadocument)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.branches.documents.patch" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaDocument or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1betaDocument.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataStoresBranchesDocumentsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaDocument, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaDocument{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a Document.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents/{documentsId}",
	//   "httpMethod": "PATCH",
	//   "id": "discoveryengine.projects.locations.dataStores.branches.documents.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the Document is not found, a new Document will be created.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Immutable. The full resource name of the document. Format: `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/branches/[^/]+/documents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaDocument"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaDocument"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.branches.documents.purge":

type ProjectsLocationsDataStoresBranchesDocumentsPurgeCall struct {
	s                                                     *Service
	parent                                                string
	googleclouddiscoveryenginev1betapurgedocumentsrequest *GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// Purge: Permanently deletes all selected Documents in a branch. This
// process is asynchronous. Depending on the number of Documents to be
// deleted, this operation can take hours to complete. Before the delete
// operation completes, some Documents might still be returned by
// DocumentService.GetDocument or DocumentService.ListDocuments. To get
// a list of the Documents to be deleted, set
// PurgeDocumentsRequest.force to false.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`.
func (r *ProjectsLocationsDataStoresBranchesDocumentsService) Purge(parent string, googleclouddiscoveryenginev1betapurgedocumentsrequest *GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest) *ProjectsLocationsDataStoresBranchesDocumentsPurgeCall {
	c := &ProjectsLocationsDataStoresBranchesDocumentsPurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1betapurgedocumentsrequest = googleclouddiscoveryenginev1betapurgedocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresBranchesDocumentsPurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresBranchesDocumentsPurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresBranchesDocumentsPurgeCall) Context(ctx context.Context) *ProjectsLocationsDataStoresBranchesDocumentsPurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresBranchesDocumentsPurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresBranchesDocumentsPurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betapurgedocumentsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/documents:purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.branches.documents.purge" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataStoresBranchesDocumentsPurgeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Permanently deletes all selected Documents in a branch. This process is asynchronous. Depending on the number of Documents to be deleted, this operation can take hours to complete. Before the delete operation completes, some Documents might still be returned by DocumentService.GetDocument or DocumentService.ListDocuments. To get a list of the Documents to be deleted, set PurgeDocumentsRequest.force to false.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents:purge",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.dataStores.branches.documents.purge",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/documents:purge",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaPurgeDocumentsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.branches.operations.get":

type ProjectsLocationsDataStoresBranchesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsDataStoresBranchesOperationsService) Get(name string) *ProjectsLocationsDataStoresBranchesOperationsGetCall {
	c := &ProjectsLocationsDataStoresBranchesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresBranchesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresBranchesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataStoresBranchesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataStoresBranchesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresBranchesOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsDataStoresBranchesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresBranchesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresBranchesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.branches.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataStoresBranchesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/branches/{branchesId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.dataStores.branches.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/branches/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.branches.operations.list":

type ProjectsLocationsDataStoresBranchesOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsDataStoresBranchesOperationsService) List(name string) *ProjectsLocationsDataStoresBranchesOperationsListCall {
	c := &ProjectsLocationsDataStoresBranchesOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsDataStoresBranchesOperationsListCall) Filter(filter string) *ProjectsLocationsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsDataStoresBranchesOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsDataStoresBranchesOperationsListCall) PageToken(pageToken string) *ProjectsLocationsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresBranchesOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataStoresBranchesOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataStoresBranchesOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresBranchesOperationsListCall) Context(ctx context.Context) *ProjectsLocationsDataStoresBranchesOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresBranchesOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresBranchesOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.branches.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataStoresBranchesOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/branches/{branchesId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.dataStores.branches.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataStoresBranchesOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.dataStores.models.operations.get":

type ProjectsLocationsDataStoresModelsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsDataStoresModelsOperationsService) Get(name string) *ProjectsLocationsDataStoresModelsOperationsGetCall {
	c := &ProjectsLocationsDataStoresModelsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresModelsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresModelsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataStoresModelsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataStoresModelsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresModelsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsDataStoresModelsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresModelsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresModelsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.models.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataStoresModelsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/models/{modelsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.dataStores.models.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/models/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.models.operations.list":

type ProjectsLocationsDataStoresModelsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsDataStoresModelsOperationsService) List(name string) *ProjectsLocationsDataStoresModelsOperationsListCall {
	c := &ProjectsLocationsDataStoresModelsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsDataStoresModelsOperationsListCall) Filter(filter string) *ProjectsLocationsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsDataStoresModelsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsDataStoresModelsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresModelsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataStoresModelsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataStoresModelsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresModelsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsDataStoresModelsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresModelsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresModelsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.models.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataStoresModelsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/models/{modelsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.dataStores.models.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/models/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataStoresModelsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.dataStores.operations.get":

type ProjectsLocationsDataStoresOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsDataStoresOperationsService) Get(name string) *ProjectsLocationsDataStoresOperationsGetCall {
	c := &ProjectsLocationsDataStoresOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataStoresOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataStoresOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsDataStoresOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataStoresOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.dataStores.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.operations.list":

type ProjectsLocationsDataStoresOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsDataStoresOperationsService) List(name string) *ProjectsLocationsDataStoresOperationsListCall {
	c := &ProjectsLocationsDataStoresOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsDataStoresOperationsListCall) Filter(filter string) *ProjectsLocationsDataStoresOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsDataStoresOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsDataStoresOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsDataStoresOperationsListCall) PageToken(pageToken string) *ProjectsLocationsDataStoresOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataStoresOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataStoresOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresOperationsListCall) Context(ctx context.Context) *ProjectsLocationsDataStoresOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataStoresOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.dataStores.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataStoresOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.dataStores.servingConfigs.recommend":

type ProjectsLocationsDataStoresServingConfigsRecommendCall struct {
	s                                                *Service
	servingConfig                                    string
	googleclouddiscoveryenginev1betarecommendrequest *GoogleCloudDiscoveryengineV1betaRecommendRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Recommend: Makes a recommendation, which requires a contextual user
// event.
//
//   - servingConfig: Full resource name of the format:
//     `projects/*/locations/global/collections/*/dataStores/*/servingConfi
//     gs/*` Before you can request recommendations from your model, you
//     must create at least one serving config for it.
func (r *ProjectsLocationsDataStoresServingConfigsService) Recommend(servingConfig string, googleclouddiscoveryenginev1betarecommendrequest *GoogleCloudDiscoveryengineV1betaRecommendRequest) *ProjectsLocationsDataStoresServingConfigsRecommendCall {
	c := &ProjectsLocationsDataStoresServingConfigsRecommendCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.servingConfig = servingConfig
	c.googleclouddiscoveryenginev1betarecommendrequest = googleclouddiscoveryenginev1betarecommendrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresServingConfigsRecommendCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresServingConfigsRecommendCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresServingConfigsRecommendCall) Context(ctx context.Context) *ProjectsLocationsDataStoresServingConfigsRecommendCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresServingConfigsRecommendCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresServingConfigsRecommendCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betarecommendrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+servingConfig}:recommend")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"servingConfig": c.servingConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.servingConfigs.recommend" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaRecommendResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1betaRecommendResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataStoresServingConfigsRecommendCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaRecommendResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaRecommendResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Makes a recommendation, which requires a contextual user event.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/servingConfigs/{servingConfigsId}:recommend",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.dataStores.servingConfigs.recommend",
	//   "parameterOrder": [
	//     "servingConfig"
	//   ],
	//   "parameters": {
	//     "servingConfig": {
	//       "description": "Required. Full resource name of the format: `projects/*/locations/global/collections/*/dataStores/*/servingConfigs/*` Before you can request recommendations from your model, you must create at least one serving config for it.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+/servingConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+servingConfig}:recommend",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaRecommendRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaRecommendResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.userEvents.collect":

type ProjectsLocationsDataStoresUserEventsCollectCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Collect: Writes a single user event from the browser. This uses a GET
// request to due to browser restriction of POST-ing to a third-party
// domain. This method is used only by the Discovery Engine API
// JavaScript pixel and Google Tag Manager. Users should not call this
// method directly.
//
//   - parent: The parent DataStore resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}`.
func (r *ProjectsLocationsDataStoresUserEventsService) Collect(parent string) *ProjectsLocationsDataStoresUserEventsCollectCall {
	c := &ProjectsLocationsDataStoresUserEventsCollectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Ets sets the optional parameter "ets": The event timestamp in
// milliseconds. This prevents browser caching of otherwise identical
// get requests. The name is abbreviated to reduce the payload bytes.
func (c *ProjectsLocationsDataStoresUserEventsCollectCall) Ets(ets int64) *ProjectsLocationsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("ets", fmt.Sprint(ets))
	return c
}

// Uri sets the optional parameter "uri": The URL including
// cgi-parameters but excluding the hash fragment with a length limit of
// 5,000 characters. This is often more useful than the referer URL,
// because many browsers only send the domain for third-party requests.
func (c *ProjectsLocationsDataStoresUserEventsCollectCall) Uri(uri string) *ProjectsLocationsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("uri", uri)
	return c
}

// UserEvent sets the optional parameter "userEvent": Required. URL
// encoded UserEvent proto with a length limit of 2,000,000 characters.
func (c *ProjectsLocationsDataStoresUserEventsCollectCall) UserEvent(userEvent string) *ProjectsLocationsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("userEvent", userEvent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresUserEventsCollectCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataStoresUserEventsCollectCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataStoresUserEventsCollectCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresUserEventsCollectCall) Context(ctx context.Context) *ProjectsLocationsDataStoresUserEventsCollectCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresUserEventsCollectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresUserEventsCollectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/userEvents:collect")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.userEvents.collect" call.
// Exactly one of *GoogleApiHttpBody or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleApiHttpBody.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataStoresUserEventsCollectCall) Do(opts ...googleapi.CallOption) (*GoogleApiHttpBody, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleApiHttpBody{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Writes a single user event from the browser. This uses a GET request to due to browser restriction of POST-ing to a third-party domain. This method is used only by the Discovery Engine API JavaScript pixel and Google Tag Manager. Users should not call this method directly.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/userEvents:collect",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.dataStores.userEvents.collect",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "ets": {
	//       "description": "The event timestamp in milliseconds. This prevents browser caching of otherwise identical get requests. The name is abbreviated to reduce the payload bytes.",
	//       "format": "int64",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent DataStore resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "uri": {
	//       "description": "The URL including cgi-parameters but excluding the hash fragment with a length limit of 5,000 characters. This is often more useful than the referer URL, because many browsers only send the domain for third-party requests.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "userEvent": {
	//       "description": "Required. URL encoded UserEvent proto with a length limit of 2,000,000 characters.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/userEvents:collect",
	//   "response": {
	//     "$ref": "GoogleApiHttpBody"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.userEvents.import":

type ProjectsLocationsDataStoresUserEventsImportCall struct {
	s                                                       *Service
	parent                                                  string
	googleclouddiscoveryenginev1betaimportusereventsrequest *GoogleCloudDiscoveryengineV1betaImportUserEventsRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// Import: Bulk import of User events. Request processing might be
// synchronous. Events that already exist are skipped. Use this method
// for backfilling historical user events. Operation.response is of type
// ImportResponse. Note that it is possible for a subset of the items to
// be successfully inserted. Operation.metadata is of type
// ImportMetadata.
//
//   - parent: Parent DataStore resource name, of the form
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}`.
func (r *ProjectsLocationsDataStoresUserEventsService) Import(parent string, googleclouddiscoveryenginev1betaimportusereventsrequest *GoogleCloudDiscoveryengineV1betaImportUserEventsRequest) *ProjectsLocationsDataStoresUserEventsImportCall {
	c := &ProjectsLocationsDataStoresUserEventsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1betaimportusereventsrequest = googleclouddiscoveryenginev1betaimportusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresUserEventsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresUserEventsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresUserEventsImportCall) Context(ctx context.Context) *ProjectsLocationsDataStoresUserEventsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresUserEventsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresUserEventsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betaimportusereventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/userEvents:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.userEvents.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataStoresUserEventsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Bulk import of User events. Request processing might be synchronous. Events that already exist are skipped. Use this method for backfilling historical user events. Operation.response is of type ImportResponse. Note that it is possible for a subset of the items to be successfully inserted. Operation.metadata is of type ImportMetadata.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/userEvents:import",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.dataStores.userEvents.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Parent DataStore resource name, of the form `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/userEvents:import",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaImportUserEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.dataStores.userEvents.write":

type ProjectsLocationsDataStoresUserEventsWriteCall struct {
	s                                         *Service
	parent                                    string
	googleclouddiscoveryenginev1betauserevent *GoogleCloudDiscoveryengineV1betaUserEvent
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Write: Writes a single user event.
//
//   - parent: The parent DataStore resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}`.
func (r *ProjectsLocationsDataStoresUserEventsService) Write(parent string, googleclouddiscoveryenginev1betauserevent *GoogleCloudDiscoveryengineV1betaUserEvent) *ProjectsLocationsDataStoresUserEventsWriteCall {
	c := &ProjectsLocationsDataStoresUserEventsWriteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1betauserevent = googleclouddiscoveryenginev1betauserevent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataStoresUserEventsWriteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataStoresUserEventsWriteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataStoresUserEventsWriteCall) Context(ctx context.Context) *ProjectsLocationsDataStoresUserEventsWriteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataStoresUserEventsWriteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataStoresUserEventsWriteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1betauserevent)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/userEvents:write")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.dataStores.userEvents.write" call.
// Exactly one of *GoogleCloudDiscoveryengineV1betaUserEvent or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1betaUserEvent.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataStoresUserEventsWriteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1betaUserEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1betaUserEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Writes a single user event.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/dataStores/{dataStoresId}/userEvents:write",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.dataStores.userEvents.write",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent DataStore resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/userEvents:write",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaUserEvent"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1betaUserEvent"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.operations.get":

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.operations.list":

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta/projects/{projectsId}/locations/{locationsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.operations.get":

type ProjectsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsOperationsService) Get(name string) *ProjectsOperationsGetCall {
	c := &ProjectsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsOperationsGetCall) Context(ctx context.Context) *ProjectsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1beta/projects/{projectsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.operations.list":

type ProjectsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsOperationsService) List(name string) *ProjectsOperationsListCall {
	c := &ProjectsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsOperationsListCall) Filter(filter string) *ProjectsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsOperationsListCall) PageSize(pageSize int64) *ProjectsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsOperationsListCall) PageToken(pageToken string) *ProjectsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsOperationsListCall) Context(ctx context.Context) *ProjectsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1beta/projects/{projectsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
