#include "common.h"

void on_main_window_delete(GtkWidget *widget, GdkEvent *event, struct Interface *interface)
{
    frameworks_interface_quit(interface);
}

void on_quit_activate(GtkWidget *widget, struct Interface *interface)
{
    frameworks_interface_quit(interface);
}

void on_open_new_camera_activate(GtkWidget *unused, struct Interface *interface)
{
    GtkWidget *widget;

    widget = glade_xml_get_widget(interface->xml, "fileselection_camera");
    gtk_widget_show_all(widget);
}

void on_fileselection_camera_cancel(GtkWidget *widget)
{
    gtk_widget_hide(gtk_widget_get_toplevel(widget));
}

/* opening a new camera */
void on_fileselection_camera_ok(GtkWidget *widget, struct Interface *interface)
{
    GString *filename;
    
    filename = g_string_new("");
    g_string_append(filename,
                    gtk_file_selection_get_filename(
                        GTK_FILE_SELECTION(gtk_widget_get_toplevel(widget))
                        )
        );

    frameworks_camera_change_device(interface->camera, filename);

    /* flag the display thread to sync the sliders.. the interface
     * will freeze up here, not much we can do */
    frameworks_interface_sync_sliders(interface);

    gtk_widget_hide(gtk_widget_get_toplevel(widget));
}

void on_prefs_activate(const GtkWidget *unused, struct Interface *interface)
{
    GtkWidget *widget;
    widget = glade_xml_get_widget(interface->xml, "prefs");
    gtk_widget_show_all(widget);
}

void on_prefs_delete_event(GtkWidget *widget)
{
    gtk_widget_hide(gtk_widget_get_toplevel(widget));
}

void on_guides_checkbutton_toggled(GtkCheckMenuItem *button, struct Interface *interface)
{
    GtkWidget *other;
    gboolean state;

    /* Sync with the corresponding check button in the prefs box */
    state = gtk_check_menu_item_get_active(button);
    other = glade_xml_get_widget(interface->xml, "prefs_guides_checkbutton");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(other)) != state)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(other), state);
}

void on_prefs_guides_checkbutton_toggled(GtkToggleButton *button, struct Interface *interface)
{
    GtkWidget *other;
    gboolean state;

    /* Sync with the corresponding check button in the view menu */
    state = gtk_toggle_button_get_active(button);
    other = glade_xml_get_widget(interface->xml, "guides_checkbutton");
    if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(other)) != state)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(other), state);
}

void on_about_activate(GtkWidget *unused, struct Interface *interface)
{
    GtkWidget *widget;
    widget = glade_xml_get_widget(interface->xml, "about_dialog");
    gtk_widget_show_all(widget);
}

void on_about_close(GtkWidget *widget)
{
    gtk_widget_hide(gtk_widget_get_toplevel(widget));
}

void on_checkbutton_pref_bgr_toggled(GtkToggleButton *button, struct Interface *interface)
{
    interface->camera->bgr =
        gtk_toggle_button_get_active(button);
}


void on_radiobutton_size_full_toggled(GtkToggleButton *button, struct Interface *interface)
{
    radiobutton_size_toggled(button, MAXIMUM, interface);
}
void on_radiobutton_size_half_toggled(GtkToggleButton *button, struct Interface *interface)
{
    radiobutton_size_toggled(button, HALF, interface);
}
void on_radiobutton_size_quarter_toggled(GtkToggleButton *button, struct Interface *interface)
{
    radiobutton_size_toggled(button, QUARTER, interface);
}
void on_radiobutton_size_min_toggled(GtkToggleButton *button, struct Interface *interface)
{
    radiobutton_size_toggled(button, MINIMUM, interface);
}
void radiobutton_size_toggled(GtkToggleButton *button, FwksVidWinSize size,
                              struct Interface *interface)
{
    if (gtk_toggle_button_get_active(button)) {
        frameworks_camera_set_size(interface->camera, size);
    }
}

void on_checkbutton_limit_fps_toggled(GtkToggleButton *button, struct Interface *interface)
{
    interface->limit_fps = gtk_toggle_button_get_active(button);
    frameworks_interface_prefs_update_display_mode(interface);
}

void on_prefs_display_mode_changed(GtkWidget *button, struct Interface *interface)
{
    frameworks_interface_prefs_update_display_mode(interface);
}

void on_display_mode_changed(GtkWidget *button, struct Interface *interface)
{
    frameworks_interface_update_display_mode(interface);
}

void on_spinbutton_speed_changed(GtkSpinButton *spin, struct Interface *interface)
{
    interface->max_fps = gtk_spin_button_get_value(spin);
}

void on_spinbutton_continuous_speed_changed(GtkSpinButton *spin, struct Interface *interface)
{
    interface->speed = gtk_spin_button_get_value(spin);
}

void on_spinbutton_continuous_hold_changed(GtkSpinButton *spin, struct Interface *interface)
{
    interface->hold = gtk_spin_button_get_value(spin);
}

void on_spinbutton_continuous_duration_changed(GtkSpinButton *spin, struct Interface *interface)
{
    interface->duration = gtk_spin_button_get_value(spin);
}

void on_checkbutton_frameavg_toggled(GtkToggleButton *button, struct Interface *interface)
{
    GtkWidget *label;
    GtkWidget *spinbutton;
    
    label = glade_xml_get_widget(interface->xml, "label_frameavg");
    spinbutton = glade_xml_get_widget(interface->xml, "spinbutton_frameavg");
    if (gtk_toggle_button_get_active(button)) {
        gtk_widget_set_sensitive(label, TRUE);
        gtk_widget_set_sensitive(spinbutton, TRUE);
    } 
    else {
        gtk_widget_set_sensitive(label, FALSE);
        gtk_widget_set_sensitive(spinbutton, FALSE);
    }
}

void on_fileselection_frames_activate(GtkWidget *unused, struct Interface *interface)
{
    GtkWidget *widget;
    widget = glade_xml_get_widget(interface->xml, "fileselection_frames");
    gtk_widget_show_all(widget);
}

void on_fileselection_frames_ok(GtkWidget *widget, struct Interface *interface)
{
    GtkWidget *entry;
    GString *filename;
    gchar *base;
    
    filename = g_string_new("");
    g_string_append(filename,
                    gtk_file_selection_get_filename(
                        GTK_FILE_SELECTION(gtk_widget_get_toplevel(widget))
                        )
        );
    frameworks_animation_set_filename(interface->animation, filename);

    entry = glade_xml_get_widget(interface->xml, "entry_filename");
    base = g_path_get_basename(filename->str);
    gtk_entry_set_text(GTK_ENTRY(entry), base);
    g_string_free(filename, TRUE);
    g_free(base);
    gtk_widget_hide(gtk_widget_get_toplevel(widget));
}

void on_fileselection_frames_cancel(GtkWidget *widget)
{
    gtk_widget_hide(gtk_widget_get_toplevel(widget));
}

void on_spinbutton_currentframe_value_changed(GtkSpinButton *spin, struct Interface *interface)
{
    gint value;

    value = gtk_spin_button_get_value_as_int(spin);
    frameworks_interface_set_current_frame(interface, value, TRUE);
}

void on_checkbutton_frameoverlay_toggled(GtkToggleButton *button, struct Interface *interface)
{
    GtkWidget *widget;
    gboolean state;

    state = gtk_toggle_button_get_active(button);
    
    widget = glade_xml_get_widget(interface->xml, "label_pastframes");
    gtk_widget_set_sensitive(widget, state);
    widget = glade_xml_get_widget(interface->xml, "spinbutton_pastframes");
    gtk_widget_set_sensitive(widget, state);
    widget = glade_xml_get_widget(interface->xml, "label_futureframes");
    gtk_widget_set_sensitive(widget, state);
    widget = glade_xml_get_widget(interface->xml, "spinbutton_futureframes");
    gtk_widget_set_sensitive(widget, state);
}

void on_treeview_frames_selection_changed(GtkTreeSelection *selection, struct Interface *interface)
{
    GtkTreeIter iter;
    GtkTreePath *path;
    gchar *string;
    gint current_frame;
    
    gtk_tree_selection_get_selected(selection, NULL, &iter);
    path = gtk_tree_model_get_path(GTK_TREE_MODEL(interface->liststore), &iter);
    string = gtk_tree_path_to_string(path);
    current_frame = 1 + atoi(string);
    frameworks_interface_set_current_frame(interface, current_frame, FALSE);

    gtk_tree_path_free(path);
    g_free(string);
}
