#ifndef _OPEN_OUTPUT_FILE_H
#define _OPEN_OUTPUT_FILE_H

#include "gimme_config_h.h"

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#include "args.h"

/** Perform the (actually rather extensive) work of determining the final
  * output path and filename for a track and open the file, returning the
  * open file handle.
  * This takes into account all kinds of things, the output directory selected,
  * and any values in the format string, including cddb-based variables which
  * need to be substituted/expanded.  It also has to handle on-the-fly creation
  * of an arbitrarily-deep previously non-existent path structure based on this
  * data.
  * @param[in] cdsargs program settings
  * @param[in] counter track number (base 1, not base 0)
  * @return opened file handle, as an int; caveat: function can/will call exit()
  * directly if there is a problem with trying to create the output files/dirs.
  */
/*@null@*/ FILE *openOutputFile(const char *, Encoders, unsigned int, const char *);

#endif
