/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.ExecutorDeadException;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.BlockTransferService;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.netty.NettyBlockRpcServer;
import org.apache.spark.network.netty.NettyBlockTransferService$;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.shuffle.protocol.UploadBlockStream;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tec!\u0002\u0011\"\u0001\u0015Z\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011Y\u0002!\u0011!Q\u0001\n]B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0011\u0002\u0011)\u0019!C!\u0013\"A!\n\u0001B\u0001B\u0003%1\b\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\u0001\u0006A!A!\u0002\u0013a\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u000ba\u0003A\u0011A-\t\u000f\r\u0004!\u0019!C\u0005I\"1!\u000e\u0001Q\u0001\n\u0015Dqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004q\u0001\u0001\u0006I!\u001c\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u0019I\b\u0001)A\u0005g\"I!\u0010\u0001a\u0001\u0002\u0003\u0006Ka\u001f\u0005\n}\u0002\u0001\r\u0011!Q!\n}Dq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u0011Q\u000b\u0001\u0005B\u0005]\u0003bBA0\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\t)\u0010\u0001C!\u0003oDA\"!?\u0001!\u0003\u0005\t\u0011!C\u0001\u0003wDAB!\u0004\u0001!\u0003\u0005\t\u0011!C\u0001\u0005\u001fAAB!\t\u0001!\u0003\u0005\t\u0011!C\u0001\u0005G9!Ba\r\"\u0003\u0003E\t!\nB\u001b\r%\u0001\u0013%!A\t\u0002\u0015\u00129\u0004\u0003\u0004Y;\u0011\u0005!q\b\u0005\n\u0005\u0003j\u0012\u0013!C\u0001\u0005\u0007\u0012\u0011DT3uif\u0014En\\2l)J\fgn\u001d4feN+'O^5dK*\u0011!eI\u0001\u0006]\u0016$H/\u001f\u0006\u0003I\u0015\nqA\\3uo>\u00148N\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h'\t\u0001A\u0006\u0005\u0002.]5\t1%\u0003\u00020G\t!\"\t\\8dWR\u0013\u0018M\\:gKJ\u001cVM\u001d<jG\u0016\fAaY8oM\u000e\u0001\u0001CA\u001a5\u001b\u0005)\u0013BA\u001b&\u0005%\u0019\u0006/\u0019:l\u0007>tg-A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\t\u0019\u0004(\u0003\u0002:K\ty1+Z2ve&$\u00180T1oC\u001e,'/A\u0006cS:$\u0017\t\u001a3sKN\u001c\bC\u0001\u001fF\u001d\ti4\t\u0005\u0002?\u00036\tqH\u0003\u0002Ac\u00051AH]8pizR\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011A)Q\u0001\tQ>\u001cHOT1nKV\t1(A\u0005i_N$h*Y7fA\u0005)q\f]8siB\u0011QJT\u0007\u0002\u0003&\u0011q*\u0011\u0002\u0004\u0013:$\u0018\u0001\u00038v[\u000e{'/Z:\u0002#\u0011\u0014\u0018N^3s\u000b:$\u0007k\\5oiJ+g\r\u0005\u0002T-6\tAK\u0003\u0002VK\u0005\u0019!\u000f]2\n\u0005]#&A\u0004*qG\u0016sG\r]8j]R\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011icVLX0aC\n\u0004\"a\u0017\u0001\u000e\u0003\u0005BQ\u0001M\u0005A\u0002IBQAN\u0005A\u0002]BQAO\u0005A\u0002mBQ\u0001S\u0005A\u0002mBQaS\u0005A\u00021CQ\u0001U\u0005A\u00021Cq!U\u0005\u0011\u0002\u0003\u0007!+\u0001\u0006tKJL\u0017\r\\5{KJ,\u0012!\u001a\t\u0003M\"l\u0011a\u001a\u0006\u0003G\u0016J!![4\u0003\u001d)\u000bg/Y*fe&\fG.\u001b>fe\u0006Y1/\u001a:jC2L'0\u001a:!\u0003-\tW\u000f\u001e5F]\u0006\u0014G.\u001a3\u0016\u00035\u0004\"!\u00148\n\u0005=\f%a\u0002\"p_2,\u0017M\\\u0001\rCV$\b.\u00128bE2,G\rI\u0001\u000eiJ\fgn\u001d9peR\u001cuN\u001c4\u0016\u0003M\u0004\"\u0001^<\u000e\u0003UT!A^\u0012\u0002\tU$\u0018\u000e\\\u0005\u0003qV\u0014Q\u0002\u0016:b]N\u0004xN\u001d;D_:4\u0017A\u0004;sC:\u001c\bo\u001c:u\u0007>tg\rI\u0001\u0011iJ\fgn\u001d9peR\u001cuN\u001c;fqR\u0004\"!\f?\n\u0005u\u001c#\u0001\u0005+sC:\u001c\bo\u001c:u\u0007>tG/\u001a=u\u0003\u0019\u0019XM\u001d<feB!\u0011\u0011AA\u0003\u001b\t\t\u0019A\u0003\u0002\u007fG%!\u0011qAA\u0002\u0005=!&/\u00198ta>\u0014HoU3sm\u0016\u0014\u0018\u0001B5oSR$B!!\u0004\u0002\u0014A\u0019Q*a\u0004\n\u0007\u0005E\u0011I\u0001\u0003V]&$\bbBA\u000b%\u0001\u0007\u0011qC\u0001\u0011E2|7m\u001b#bi\u0006l\u0015M\\1hKJ\u00042!LA\r\u0013\r\tYb\t\u0002\u0011\u00052|7m\u001b#bi\u0006l\u0015M\\1hKJ\fAb\u0019:fCR,7+\u001a:wKJ$2a`A\u0011\u0011\u001d\t\u0019c\u0005a\u0001\u0003K\t!BY8piN$(/\u00199t!\u0019\t9#!\r\u000289!\u0011\u0011FA\u0017\u001d\rq\u00141F\u0005\u0002\u0005&\u0019\u0011qF!\u0002\u000fA\f7m[1hK&!\u00111GA\u001b\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005=\u0012\t\u0005\u0003\u0002\u0002\u0005e\u0012\u0002BA\u001e\u0003\u0007\u0011\u0001\u0004\u0016:b]N\u0004xN\u001d;TKJ4XM\u001d\"p_R\u001cHO]1q\u00039\u0019\b.\u001e4gY\u0016lU\r\u001e:jGN$\"!!\u0011\u0011\t\u0005\r\u0013\u0011K\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u00059Q.\u001a;sS\u000e\u001c(\u0002BA&\u0003\u001b\n\u0001bY8eC\"\fG.\u001a\u0006\u0003\u0003\u001f\n1aY8n\u0013\u0011\t\u0019&!\u0012\u0003\u00135+GO]5d'\u0016$\u0018a\u00034fi\u000eD'\t\\8dWN$b\"!\u0004\u0002Z\u0005u\u0013\u0011MA3\u0003_\ny\b\u0003\u0004\u0002\\U\u0001\raO\u0001\u0005Q>\u001cH\u000f\u0003\u0004\u0002`U\u0001\r\u0001T\u0001\u0005a>\u0014H\u000f\u0003\u0004\u0002dU\u0001\raO\u0001\u0007Kb,7-\u00133\t\u000f\u0005\u001dT\u00031\u0001\u0002j\u0005A!\r\\8dW&#7\u000f\u0005\u0003N\u0003WZ\u0014bAA7\u0003\n)\u0011I\u001d:bs\"9\u0011\u0011O\u000bA\u0002\u0005M\u0014\u0001\u00037jgR,g.\u001a:\u0011\t\u0005U\u00141P\u0007\u0003\u0003oR1!!\u001f$\u0003\u001d\u0019\b.\u001e4gY\u0016LA!! \u0002x\t)\"\t\\8dW\u001a+Go\u00195j]\u001ed\u0015n\u001d;f]\u0016\u0014\bbBAA+\u0001\u0007\u00111Q\u0001\u0010i\u0016l\u0007OR5mK6\u000bg.Y4feB!\u0011QOAC\u0013\u0011\t9)a\u001e\u0003'\u0011{wO\u001c7pC\u00124\u0015\u000e\\3NC:\fw-\u001a:\u0016\u00031\u000b1\"\u001e9m_\u0006$'\t\\8dWR\u0001\u0012qRAN\u0003?\u000b\t+a)\u00024\u0006\r\u0017Q\u001a\t\u0007\u0003#\u000b9*!\u0004\u000e\u0005\u0005M%bAAK\u0003\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005e\u00151\u0013\u0002\u0007\rV$XO]3\t\r\u0005uu\u00031\u0001<\u0003!Awn\u001d;oC6,\u0007BBA0/\u0001\u0007A\n\u0003\u0004\u0002d]\u0001\ra\u000f\u0005\b\u0003K;\u0002\u0019AAT\u0003\u001d\u0011Gn\\2l\u0013\u0012\u0004B!!+\u000206\u0011\u00111\u0016\u0006\u0004\u0003[+\u0013aB:u_J\fw-Z\u0005\u0005\u0003c\u000bYKA\u0004CY>\u001c7.\u00133\t\u000f\u0005Uv\u00031\u0001\u00028\u0006I!\r\\8dW\u0012\u000bG/\u0019\t\u0005\u0003s\u000by,\u0004\u0002\u0002<*\u0019\u0011QX\u0012\u0002\r\t,hMZ3s\u0013\u0011\t\t-a/\u0003\u001b5\u000bg.Y4fI\n+hMZ3s\u0011\u001d\t)m\u0006a\u0001\u0003\u000f\fQ\u0001\\3wK2\u0004B!!+\u0002J&!\u00111ZAV\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011\u001d\tym\u0006a\u0001\u0003#\f\u0001b\u00197bgN$\u0016m\u001a\u0019\u0005\u0003'\f\u0019\u000f\u0005\u0004\u0002V\u0006m\u0017q\\\u0007\u0003\u0003/T1!!7B\u0003\u001d\u0011XM\u001a7fGRLA!!8\u0002X\nA1\t\\1tgR\u000bw\r\u0005\u0003\u0002b\u0006\rH\u0002\u0001\u0003\r\u0003K\fi-!A\u0001\u0002\u000b\u0005\u0011q\u001d\u0002\u0004?\u0012\n\u0014\u0003BAu\u0003_\u00042!TAv\u0013\r\ti/\u0011\u0002\b\u001d>$\b.\u001b8h!\ri\u0015\u0011_\u0005\u0004\u0003g\f%aA!os\u0006)1\r\\8tKR\u0011\u0011QB\u0001\u0018aJ|G/Z2uK\u0012$3\r\\5f]R4\u0015m\u0019;pef$B!!@\u0003\nA!\u0011q B\u0003\u001b\t\u0011\tAC\u0002\u0003\u0004\r\naa\u00197jK:$\u0018\u0002\u0002B\u0004\u0005\u0003\u0011a\u0003\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e$bGR|'/\u001f\u0005\t\u0005\u0017I\u0012\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000e^3di\u0016$G%\u00199q\u0013\u0012$BA!\u0005\u0003 A!!1\u0003B\u000f\u001b\t\u0011)B\u0003\u0003\u0003\u0018\te\u0011\u0001\u00027b]\u001eT!Aa\u0007\u0002\t)\fg/Y\u0005\u0004\r\nU\u0001\u0002\u0003B\u00065\u0005\u0005\t\u0019\u0001.\u0002!A\u0014x\u000e^3di\u0016$G\u0005\\8hO\u0016\u0014H\u0003\u0002B\u0013\u0005c\u0001BAa\n\u0003.5\u0011!\u0011\u0006\u0006\u0004\u0005WI\u0013!B:mMRR\u0017\u0002\u0002B\u0018\u0005S\u0011a\u0001T8hO\u0016\u0014\b\u0002\u0003B\u00067\u0005\u0005\t\u0019\u0001.\u000239+G\u000f^=CY>\u001c7\u000e\u0016:b]N4WM]*feZL7-\u001a\t\u00037v\u00192!\bB\u001d!\ri%1H\u0005\u0004\u0005{\t%AB!osJ+g\r\u0006\u0002\u00036\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"A!\u0012+\u0007I\u00139e\u000b\u0002\u0003JA!!1\nB+\u001b\t\u0011iE\u0003\u0003\u0003P\tE\u0013!C;oG\",7m[3e\u0015\r\u0011\u0019&Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B,\u0005\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class NettyBlockTransferService
extends BlockTransferService {
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private final String bindAddress;
    private final String hostName;
    private final int _port;
    public final RpcEndpointRef org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef;
    private final JavaSerializer serializer;
    private final boolean authEnabled;
    private final TransportConf org$apache$spark$network$netty$NettyBlockTransferService$$transportConf;
    private TransportContext transportContext;
    public TransportServer org$apache$spark$network$netty$NettyBlockTransferService$$server;

    public static RpcEndpointRef $lessinit$greater$default$7() {
        return NettyBlockTransferService$.MODULE$.$lessinit$greater$default$7();
    }

    public /* synthetic */ TransportClientFactory protected$clientFactory(NettyBlockTransferService x$1) {
        return x$1.clientFactory;
    }

    public /* synthetic */ String protected$appId(NettyBlockTransferService x$1) {
        return x$1.appId;
    }

    public /* synthetic */ Logger protected$logger(NettyBlockTransferService x$1) {
        return x$1.logger;
    }

    @Override
    public String hostName() {
        return this.hostName;
    }

    private JavaSerializer serializer() {
        return this.serializer;
    }

    private boolean authEnabled() {
        return this.authEnabled;
    }

    public TransportConf org$apache$spark$network$netty$NettyBlockTransferService$$transportConf() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf;
    }

    @Override
    public void init(BlockDataManager blockDataManager) {
        NettyBlockRpcServer rpcHandler = new NettyBlockRpcServer(this.conf.getAppId(), this.serializer(), blockDataManager);
        None$ serverBootstrap = None$.MODULE$;
        None$ clientBootstrap = None$.MODULE$;
        if (this.authEnabled()) {
            serverBootstrap = new Some((Object)new AuthServerBootstrap(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), (SecretKeyHolder)this.securityManager));
            clientBootstrap = new Some((Object)new AuthClientBootstrap(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), this.conf.getAppId(), (SecretKeyHolder)this.securityManager));
        }
        this.transportContext = new TransportContext(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), (RpcHandler)rpcHandler);
        this.clientFactory = this.transportContext.createClientFactory((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(Option$.MODULE$.option2Iterable((Option)clientBootstrap).toSeq()).asJava());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$server = this.createServer((List<TransportServerBootstrap>)serverBootstrap.toList());
        this.appId = this.conf.getAppId();
        this.logger.info(new StringBuilder(19).append("Server created on ").append(this.hostName()).append(":").append(this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort()).toString());
    }

    private TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return (TransportServer)Utils$.MODULE$.startServiceOnPort(this._port, (Function1 & Serializable & scala.Serializable)port -> this.startService$1(BoxesRunTime.unboxToInt((Object)port), bootstraps), this.conf, this.getClass().getName())._1();
    }

    public MetricSet shuffleMetrics() {
        Predef$.MODULE$.require(this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null && this.clientFactory != null, (Function0 & Serializable & scala.Serializable)() -> "NettyBlockTransferServer is not initialized");
        return new MetricSet(this){
            private final HashMap<String, Metric> allMetrics;
            private final /* synthetic */ NettyBlockTransferService $outer;

            private HashMap<String, Metric> allMetrics() {
                return this.allMetrics;
            }

            public Map<String, Metric> getMetrics() {
                this.allMetrics().putAll(this.$outer.protected$clientFactory(this.$outer).getAllMetrics().getMetrics());
                this.allMetrics().putAll(this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$server.getAllMetrics().getMetrics());
                return this.allMetrics();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allMetrics = new HashMap<K, V>();
            }
        };
    }

    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener, DownloadFileManager tempFileManager) {
        block4: {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(new StringBuilder(34).append("Fetch blocks from ").append(host).append(":").append(port).append(" (executor id ").append(execId).append(")").toString());
            }
            try {
                int maxRetries = this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf().maxIORetries();
                RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = new RetryingBlockFetcher.BlockFetchStarter(this, host, port, maxRetries, execId, tempFileManager){
                    private final /* synthetic */ NettyBlockTransferService $outer;
                    private final String host$1;
                    private final int port$1;
                    private final int maxRetries$1;
                    private final String execId$1;
                    private final DownloadFileManager tempFileManager$1;

                    public void createAndStart(String[] blockIds, BlockFetchingListener listener) {
                        try {
                            TransportClient client = this.$outer.protected$clientFactory(this.$outer).createClient(this.host$1, this.port$1, this.maxRetries$1 > 0);
                            new OneForOneBlockFetcher(client, this.$outer.protected$appId(this.$outer), this.execId$1, blockIds, listener, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), this.tempFileManager$1).start();
                        }
                        catch (IOException e) {
                            Success success;
                            boolean v;
                            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean($this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef.askSync(new BlockManagerMessages.IsExecutorAlive($this.execId$1), ClassTag$.MODULE$.Boolean())));
                            if (try_ instanceof Success && !(v = BoxesRunTime.unboxToBoolean((Object)(success = (Success)try_).value()))) {
                                throw new ExecutorDeadException(new StringBuilder(84).append("The relative remote executor(Id: ").append(this.execId$1).append("),").append(" which maintains the block data to fetch is dead.").toString());
                            }
                            throw e;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.host$1 = host$1;
                        this.port$1 = port$1;
                        this.maxRetries$1 = maxRetries$1;
                        this.execId$1 = execId$1;
                        this.tempFileManager$1 = tempFileManager$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createAndStart$1(org.apache.spark.network.netty.NettyBlockTransferService$$anon$2 )}, serializedLambda);
                    }
                };
                if (maxRetries > 0) {
                    new RetryingBlockFetcher(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), blockFetchStarter, blockIds, listener).start();
                    break block4;
                }
                blockFetchStarter.createAndStart(blockIds, listener);
            }
            catch (Exception e) {
                this.logger.error("Exception while beginning fetchBlocks", (Throwable)e);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    listener.onBlockFetchFailure(x$1, (Throwable)e);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    @Override
    public int port() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort();
    }

    @Override
    public Future<BoxedUnit> uploadBlock(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        long l;
        Promise result = Promise$.MODULE$.apply();
        TransportClient client = this.clientFactory.createClient(hostname, port);
        byte[] metadata = JavaUtils.bufferToArray((ByteBuffer)this.serializer().newInstance().serialize(new Tuple2((Object)level, classTag), ClassTag$.MODULE$.apply(Tuple2.class)));
        boolean asStream = blockData.size() > BoxesRunTime.unboxToLong((Object)this.conf.get(package$.MODULE$.MAX_REMOTE_BLOCK_SIZE_FETCH_TO_MEM())) || blockId.isShuffle();
        RpcResponseCallback callback = new RpcResponseCallback(this, blockId, asStream, result){
            private final /* synthetic */ NettyBlockTransferService $outer;
            private final BlockId blockId$1;
            private final boolean asStream$1;
            private final Promise result$1;

            public void onSuccess(ByteBuffer response) {
                if (this.$outer.protected$logger(this.$outer).isTraceEnabled()) {
                    this.$outer.protected$logger(this.$outer).trace(new StringBuilder(28).append("Successfully uploaded block ").append(this.blockId$1).append((Object)(this.asStream$1 ? " as stream" : "")).toString());
                }
                this.result$1.success((Object)BoxedUnit.UNIT);
            }

            public void onFailure(Throwable e) {
                this.$outer.protected$logger(this.$outer).error(new StringBuilder(22).append("Error while uploading ").append(this.blockId$1).append((Object)(this.asStream$1 ? " as stream" : "")).toString(), e);
                this.result$1.failure(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
                this.asStream$1 = asStream$1;
                this.result$1 = result$1;
            }
        };
        if (asStream) {
            ByteBuffer streamHeader = new UploadBlockStream(blockId.name(), metadata).toByteBuffer();
            l = client.uploadStream((ManagedBuffer)new NioManagedBuffer(streamHeader), blockData, callback);
        } else {
            byte[] array = JavaUtils.bufferToArray((ByteBuffer)blockData.nioByteBuffer());
            l = client.sendRpc(new UploadBlock(this.appId, execId, blockId.name(), metadata, array).toByteBuffer(), callback);
        }
        return result.future();
    }

    public void close() {
        block2: {
            if (this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null) {
                this.org$apache$spark$network$netty$NettyBlockTransferService$$server.close();
            }
            if (this.clientFactory != null) {
                this.clientFactory.close();
            }
            if (this.transportContext == null) break block2;
            this.transportContext.close();
        }
    }

    private final Tuple2 startService$1(int port, List bootstraps$1) {
        TransportServer server = this.transportContext.createServer(this.bindAddress, port, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstraps$1).asJava());
        return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)server.getPort()));
    }

    public NettyBlockTransferService(SparkConf conf, SecurityManager securityManager, String bindAddress, String hostName, int _port, int numCores, RpcEndpointRef driverEndPointRef) {
        this.conf = conf;
        this.securityManager = securityManager;
        this.bindAddress = bindAddress;
        this.hostName = hostName;
        this._port = _port;
        this.org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef = driverEndPointRef;
        this.serializer = new JavaSerializer(conf);
        this.authEnabled = securityManager.isAuthenticationEnabled();
        this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", numCores, SparkTransportConf$.MODULE$.fromSparkConf$default$4());
    }
}

