/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExcludedExecutor;
import org.apache.spark.scheduler.ExecutorFailuresInTaskSet;
import org.apache.spark.scheduler.HealthTracker$;
import org.apache.spark.scheduler.HealthTracker$ExecutorFailureList$TaskId$;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerExecutorBlacklisted;
import org.apache.spark.scheduler.SparkListenerExecutorExcluded;
import org.apache.spark.scheduler.SparkListenerExecutorUnblacklisted;
import org.apache.spark.scheduler.SparkListenerExecutorUnexcluded;
import org.apache.spark.scheduler.SparkListenerNodeBlacklisted;
import org.apache.spark.scheduler.SparkListenerNodeExcluded;
import org.apache.spark.scheduler.SparkListenerNodeUnblacklisted;
import org.apache.spark.scheduler.SparkListenerNodeUnexcluded;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Iterable$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r}c!B-[\u0001i\u0013\u0007\u0002C8\u0001\u0005\u000b\u0007I\u0011B9\t\u0011Y\u0004!\u0011!Q\u0001\nID\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\ty\u0002\u0011\t\u0011)A\u0005{\"Q\u0011q\u0001\u0001\u0003\u0002\u0003\u0006I!!\u0003\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011Q\u0003\u0001\u0005\u0002\u0005\r\u0002\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0011!\tY\u0004\u0001Q\u0001\n\u0005U\u0002\"CA\u001f\u0001\t\u0007I\u0011BA\u001a\u0011!\ty\u0004\u0001Q\u0001\n\u0005U\u0002\"CA!\u0001\t\u0007I\u0011AA\"\u0011!\tY\u0005\u0001Q\u0001\n\u0005\u0015\u0003\"CA'\u0001\t\u0007I\u0011BA(\u0011!\t9\u0006\u0001Q\u0001\n\u0005E\u0003\"CA-\u0001\t\u0007I\u0011BA.\u0011!\u0011\u0019\n\u0001Q\u0001\n\u0005u\u0003\"\u0003BK\u0001\t\u0007I\u0011\u0001BL\u0011!\u0011\t\u000b\u0001Q\u0001\n\te\u0005\"\u0003BR\u0001\t\u0007I\u0011\u0001BS\u0011!\u0011I\u000b\u0001Q\u0001\n\t\u001d\u0006\"\u0003BV\u0001\t\u0007I\u0011\u0002BW\u0011!\u00119\r\u0001Q\u0001\n\t=\u0006\"\u0003Be\u0001\u0001\u0007I\u0011AA\"\u0011%\u0011Y\r\u0001a\u0001\n\u0003\u0011i\r\u0003\u0005\u0003R\u0002\u0001\u000b\u0015BA#\u0011%\u0011\u0019\u000e\u0001b\u0001\n\u0003\u0011)\u000e\u0003\u0005\u0003`\u0002\u0001\u000b\u0011\u0002Bl\u0011\u001d\u0011\t\u000f\u0001C\u0001\u0005GDqA!:\u0001\t\u0013\u0011\u0019\u000fC\u0004\u0003h\u0002!IA!;\t\u000f\tM\b\u0001\"\u0003\u0003v\"A!\u0011 \u0001\u0005\u0002i\u0013Y\u0010C\u0004\u0003\u0000\u0002!Ia!\u0001\t\u000f\r\u001d\u0001\u0001\"\u0001\u0004\n!91\u0011\u0003\u0001\u0005\u0002\rM\u0001bBB\u0012\u0001\u0011\u00051Q\u0005\u0005\b\u0007W\u0001A\u0011AB\u0017\u0011\u001d\u0019y\u0003\u0001C\u0001\u0007cAqa!\u000e\u0001\t\u0003\u00199DB\u0004\u0002\b\u0002\u0011!,!#\t\u000f\u0005U\u0011\u0006\"\u0001\u0002\f\u001a1\u0011QR\u0015E\u0003\u001fC!\"!(,\u0005+\u0007I\u0011AA\u001a\u0011)\tyj\u000bB\tB\u0003%\u0011Q\u0007\u0005\u000b\u0003C[#Q3A\u0005\u0002\u0005M\u0002BCARW\tE\t\u0015!\u0003\u00026!Q\u0011QU\u0016\u0003\u0016\u0004%\t!a\r\t\u0015\u0005\u001d6F!E!\u0002\u0013\t)\u0004C\u0004\u0002\u0016-\"\t!!+\t\u0013\u0005U6&!A\u0005\u0002\u0005]\u0006\"CA`WE\u0005I\u0011AAa\u0011%\t9nKI\u0001\n\u0003\t\t\rC\u0005\u0002Z.\n\n\u0011\"\u0001\u0002B\"I\u00111\\\u0016\u0002\u0002\u0013\u0005\u0013Q\u001c\u0005\n\u0003[\\\u0013\u0011!C\u0001\u0003gA\u0011\"a<,\u0003\u0003%\t!!=\t\u0013\u0005u8&!A\u0005B\u0005}\b\"\u0003B\u0005W\u0005\u0005I\u0011\u0001B\u0006\u0011%\u0011yaKA\u0001\n\u0003\u0012\t\u0002C\u0005\u0003\u0014-\n\t\u0011\"\u0011\u0003\u0016!I!qC\u0016\u0002\u0002\u0013\u0005#\u0011D\u0004\n\u0005;I\u0013\u0011!E\u0005\u0005?1\u0011\"!$*\u0003\u0003EIA!\t\t\u000f\u0005U\u0001\t\"\u0001\u00030!I!1\u0003!\u0002\u0002\u0013\u0015#Q\u0003\u0005\n\u0005c\u0001\u0015\u0011!CA\u0005gA\u0011Ba\u000fA\u0003\u0003%\tI!\u0010\t\u0013\t-\u0013\u00061A\u0005\n\t5\u0003\"\u0003B.S\u0001\u0007I\u0011\u0002B/\u0011!\u00119'\u000bQ!\n\t=\u0003\"\u0003B5S\u0001\u0007I\u0011BA\"\u0011%\u0011Y'\u000ba\u0001\n\u0013\u0011i\u0007\u0003\u0005\u0003r%\u0002\u000b\u0015BA#\u0011\u001d\u0011\u0019(\u000bC\u0001\u0005kBqA!\"*\t\u0003\t\u0019\u0004C\u0004\u0003\b&\"\t!a\u0014\t\u000f\t%\u0015\u0006\"\u0001\u0003\f\"9!1C\u0015\u0005B\tEu\u0001CB\u001e5\"\u0005Al!\u0010\u0007\u000feS\u0006\u0012\u0001/\u0004@!9\u0011QC)\u0005\u0002\r\u0005\u0003\"CB\"#\n\u0007I\u0011BAo\u0011!\u0019)%\u0015Q\u0001\n\u0005}\u0007bBB$#\u0012\u00051\u0011\n\u0005\b\u0007\u001b\nF\u0011AB(\u0011\u001d\u0019\u0019&\u0015C\u0001\u0007+B\u0011b!\u0017R#\u0003%\taa\u0017\u0003\u001b!+\u0017\r\u001c;i)J\f7m[3s\u0015\tYF,A\u0005tG\",G-\u001e7fe*\u0011QLX\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0002\fa!\u00199bG\",'\"A1\u0002\u0007=\u0014xmE\u0002\u0001G&\u0004\"\u0001Z4\u000e\u0003\u0015T\u0011AZ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0016\u0014a!\u00118z%\u00164\u0007C\u00016n\u001b\u0005Y'B\u00017]\u0003!Ig\u000e^3s]\u0006d\u0017B\u00018l\u0005\u001daunZ4j]\u001e\f1\u0002\\5ti\u0016tWM\u001d\"vg\u000e\u0001Q#\u0001:\u0011\u0005M$X\"\u0001.\n\u0005UT&a\u0004'jm\u0016d\u0015n\u001d;f]\u0016\u0014()^:\u0002\u00191L7\u000f^3oKJ\u0014Uo\u001d\u0011\u0002\t\r|gN\u001a\t\u0003sjl\u0011\u0001X\u0005\u0003wr\u0013\u0011b\u00159be.\u001cuN\u001c4\u0002!\u0005dGn\\2bi&|gn\u00117jK:$\b\u0003\u00023\u007f\u0003\u0003I!a`3\u0003\r=\u0003H/[8o!\rI\u00181A\u0005\u0004\u0003\u000ba&\u0001G#yK\u000e,Ho\u001c:BY2|7-\u0019;j_:\u001cE.[3oi\u0006)1\r\\8dWB!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010q\u000bA!\u001e;jY&!\u00111CA\u0007\u0005\u0015\u0019En\\2l\u0003\u0019a\u0014N\\5u}QQ\u0011\u0011DA\u000e\u0003;\ty\"!\t\u0011\u0005M\u0004\u0001\"B8\u0007\u0001\u0004\u0011\b\"B<\u0007\u0001\u0004A\b\"\u0002?\u0007\u0001\u0004i\b\"CA\u0004\rA\u0005\t\u0019AA\u0005)\u0019\tI\"!\n\u00020!9\u0011qE\u0004A\u0002\u0005%\u0012AA:d!\rI\u00181F\u0005\u0004\u0003[a&\u0001D*qCJ\\7i\u001c8uKb$\b\"\u0002?\b\u0001\u0004i\u0018!F'B1~3\u0015)\u0013'V%\u0016\u001bv\fU#S?\u0016CViQ\u000b\u0003\u0003k\u00012\u0001ZA\u001c\u0013\r\tI$\u001a\u0002\u0004\u0013:$\u0018AF'B1~3\u0015)\u0013'V%\u0016\u001bv\fU#S?\u0016CVi\u0011\u0011\u000215\u000b\u0005l\u0018$B\u00132+EiX#Y\u000b\u000e{\u0006+\u0012*`\u001d>#U)A\rN\u0003b{f)Q%M\u000b\u0012{V\tW#D?B+%k\u0018(P\t\u0016\u0003\u0013!I#Y\u00072+F)R0P\u001d~3\u0015)\u0013'V%\u0016{F+S'F\u001fV#v,T%M\u0019&\u001bVCAA#!\r!\u0017qI\u0005\u0004\u0003\u0013*'\u0001\u0002'p]\u001e\f!%\u0012-D\u0019V#UiX(O?\u001a\u000b\u0015\nT+S\u000b~#\u0016*T#P+R{V*\u0013'M\u0013N\u0003\u0013!H#Y\u00072+F)R0G\u000bR\u001b\u0005j\u0018$B\u00132+&+R0F\u001d\u0006\u0013E*\u0012#\u0016\u0005\u0005E\u0003c\u00013\u0002T%\u0019\u0011QK3\u0003\u000f\t{w\u000e\\3b]\u0006qR\tW\"M+\u0012+uLR#U\u0007\"{f)Q%M+J+u,\u0012(B\u00052+E\tI\u0001\u0018Kb,7-\u001e;pe&#Gk\u001c$bS2,(/\u001a'jgR,\"!!\u0018\u0011\u0011\u0005}\u0013\u0011NA7\u0003\u0007k!!!\u0019\u000b\t\u0005\r\u0014QM\u0001\b[V$\u0018M\u00197f\u0015\r\t9'Z\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA6\u0003C\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002p\u0005ud\u0002BA9\u0003s\u00022!a\u001df\u001b\t\t)HC\u0002\u0002xA\fa\u0001\u0010:p_Rt\u0014bAA>K\u00061\u0001K]3eK\u001aLA!a \u0002\u0002\n11\u000b\u001e:j]\u001eT1!a\u001ff!\r\t))K\u0007\u0002\u0001\t\u0019R\t_3dkR|'OR1jYV\u0014X\rT5tiN\u0019\u0011fY5\u0015\u0005\u0005\r%A\u0002+bg.LEm\u0005\u0004,G\u0006E\u0015q\u0013\t\u0004I\u0006M\u0015bAAKK\n9\u0001K]8ek\u000e$\bc\u00013\u0002\u001a&\u0019\u00111T3\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000bM$\u0018mZ3\u0002\rM$\u0018mZ3!\u00031\u0019H/Y4f\u0003R$X-\u001c9u\u00035\u0019H/Y4f\u0003R$X-\u001c9uA\u0005IA/Y:l\u0013:$W\r_\u0001\u000bi\u0006\u001c8.\u00138eKb\u0004C\u0003CAV\u0003_\u000b\t,a-\u0011\u0007\u000556&D\u0001*\u0011\u001d\tiJ\ra\u0001\u0003kAq!!)3\u0001\u0004\t)\u0004C\u0004\u0002&J\u0002\r!!\u000e\u0002\t\r|\u0007/\u001f\u000b\t\u0003W\u000bI,a/\u0002>\"I\u0011QT\u001a\u0011\u0002\u0003\u0007\u0011Q\u0007\u0005\n\u0003C\u001b\u0004\u0013!a\u0001\u0003kA\u0011\"!*4!\u0003\u0005\r!!\u000e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0019\u0016\u0005\u0003k\t)m\u000b\u0002\u0002HB!\u0011\u0011ZAj\u001b\t\tYM\u0003\u0003\u0002N\u0006=\u0017!C;oG\",7m[3e\u0015\r\t\t.Z\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAk\u0003\u0017\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/\u0001\u0003mC:<'BAAu\u0003\u0011Q\u0017M^1\n\t\u0005}\u00141]\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u00190!?\u0011\u0007\u0011\f)0C\u0002\u0002x\u0016\u00141!\u00118z\u0011%\tY0OA\u0001\u0002\u0004\t)$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u0003\u0001bAa\u0001\u0003\u0006\u0005MXBAA3\u0013\u0011\u00119!!\u001a\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003#\u0012i\u0001C\u0005\u0002|n\n\t\u00111\u0001\u0002t\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00026\u0005AAo\\*ue&tw\r\u0006\u0002\u0002`\u00061Q-];bYN$B!!\u0015\u0003\u001c!I\u00111  \u0002\u0002\u0003\u0007\u00111_\u0001\u0007)\u0006\u001c8.\u00133\u0011\u0007\u00055\u0006iE\u0003A\u0005G\t9\n\u0005\u0007\u0003&\t-\u0012QGA\u001b\u0003k\tY+\u0004\u0002\u0003()\u0019!\u0011F3\u0002\u000fI,h\u000e^5nK&!!Q\u0006B\u0014\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005?\tQ!\u00199qYf$\u0002\"a+\u00036\t]\"\u0011\b\u0005\b\u0003;\u001b\u0005\u0019AA\u001b\u0011\u001d\t\tk\u0011a\u0001\u0003kAq!!*D\u0001\u0004\t)$A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t}\"q\t\t\u0005Iz\u0014\t\u0005E\u0005e\u0005\u0007\n)$!\u000e\u00026%\u0019!QI3\u0003\rQ+\b\u000f\\34\u0011%\u0011I\u0005RA\u0001\u0002\u0004\tY+A\u0002yIA\naCZ1jYV\u0014Xm]!oI\u0016C\b/\u001b:z)&lWm]\u000b\u0003\u0005\u001f\u0002b!a\u0018\u0003R\tU\u0013\u0002\u0002B*\u0003C\u00121\"\u0011:sCf\u0014UO\u001a4feB9AMa\u0016\u0002,\u0006\u0015\u0013b\u0001B-K\n1A+\u001e9mKJ\n!DZ1jYV\u0014Xm]!oI\u0016C\b/\u001b:z)&lWm]0%KF$BAa\u0018\u0003fA\u0019AM!\u0019\n\u0007\t\rTM\u0001\u0003V]&$\b\"CA~\r\u0006\u0005\t\u0019\u0001B(\u0003]1\u0017-\u001b7ve\u0016\u001c\u0018I\u001c3FqBL'/\u001f+j[\u0016\u001c\b%A\u0007nS:,\u0005\u0010]5ssRKW.Z\u0001\u0012[&tW\t\u001f9jef$\u0016.\\3`I\u0015\fH\u0003\u0002B0\u0005_B\u0011\"a?J\u0003\u0003\u0005\r!!\u0012\u0002\u001d5Lg.\u0012=qSJLH+[7fA\u0005Y\u0011\r\u001a3GC&dWO]3t)!\u0011yFa\u001e\u0003z\tm\u0004bBAO\u0017\u0002\u0007\u0011Q\u0007\u0005\b\u0003C[\u0005\u0019AA\u001b\u0011\u001d\u0011ih\u0013a\u0001\u0005\u007f\n\u0011CZ1jYV\u0014Xm]%o)\u0006\u001c8nU3u!\r\u0019(\u0011Q\u0005\u0004\u0005\u0007S&!G#yK\u000e,Ho\u001c:GC&dWO]3t\u0013:$\u0016m]6TKR\fQC\\;n+:L\u0017/^3UCN\\g)Y5mkJ,7/A\u0004jg\u0016k\u0007\u000f^=\u0002;\u0011\u0014x\u000e\u001d$bS2,(/Z:XSRDG+[7f_V$()\u001a4pe\u0016$BAa\u0018\u0003\u000e\"9!q\u0012(A\u0002\u0005\u0015\u0013A\u00033s_B\u0014UMZ8sKR\u0011\u0011QN\u0001\u0019Kb,7-\u001e;pe&#Gk\u001c$bS2,(/\u001a'jgR\u0004\u0013AG3yK\u000e,Ho\u001c:JIR{W\t_2mk\u0012,Gm\u0015;biV\u001cXC\u0001BM!!\ty&!\u001b\u0002n\tm\u0005cA:\u0003\u001e&\u0019!q\u0014.\u0003!\u0015C8\r\\;eK\u0012,\u00050Z2vi>\u0014\u0018aG3yK\u000e,Ho\u001c:JIR{W\t_2mk\u0012,Gm\u0015;biV\u001c\b%\u0001\u000eo_\u0012,\u0017\n\u001a+p\u000bb\u001cG.\u001e3fI\u0016C\b/\u001b:z)&lW-\u0006\u0002\u0003(BA\u0011qLA5\u0003[\n)%A\u000eo_\u0012,\u0017\n\u001a+p\u000bb\u001cG.\u001e3fI\u0016C\b/\u001b:z)&lW\rI\u0001\u0012?\u0016D8\r\\;eK\u0012tu\u000eZ3MSN$XC\u0001BX!\u0019\u0011\tL!0\u0003B6\u0011!1\u0017\u0006\u0005\u0005k\u00139,\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0005s\u0013Y,\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\u0004\u0002h&!!q\u0018BZ\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CBA8\u0005\u0007\fi'\u0003\u0003\u0003F\u0006\u0005%aA*fi\u0006\u0011r,\u001a=dYV$W\r\u001a(pI\u0016d\u0015n\u001d;!\u00039qW\r\u001f;FqBL'/\u001f+j[\u0016\f!C\\3yi\u0016C\b/\u001b:z)&lWm\u0018\u0013fcR!!q\fBh\u0011%\tY0GA\u0001\u0002\u0004\t)%A\boKb$X\t\u001f9jef$\u0016.\\3!\u0003Mqw\u000eZ3U_\u0016C8\r\\;eK\u0012,\u00050Z2t+\t\u00119\u000e\u0005\u0005\u0002`\u0005%\u0014Q\u000eBm!\u0019\tyFa7\u0002n%!!Q\\A1\u0005\u001dA\u0015m\u001d5TKR\fAC\\8eKR{W\t_2mk\u0012,G-\u0012=fGN\u0004\u0013\u0001H1qa2LX\t_2mk\u0012,wJ\u001c$bS2,(/\u001a+j[\u0016|W\u000f\u001e\u000b\u0003\u0005?\nA#\u001e9eCR,g*\u001a=u\u000bb\u0004\u0018N]=US6,\u0017\u0001D6jY2,\u00050Z2vi>\u0014HC\u0002B0\u0005W\u0014y\u000fC\u0004\u0003n~\u0001\r!!\u001c\u0002\t\u0015DXm\u0019\u0005\b\u0005c|\u0002\u0019AA7\u0003\ri7oZ\u0001\u0015W&dG.\u0012=dYV$W\rZ#yK\u000e,Ho\u001c:\u0015\t\t}#q\u001f\u0005\b\u0005[\u0004\u0003\u0019AA7\u0003aY\u0017\u000e\u001c7Fq\u000edW\u000fZ3e\u0013\u0012dW-\u0012=fGV$xN\u001d\u000b\u0005\u0005?\u0012i\u0010C\u0004\u0003n\u0006\u0002\r!!\u001c\u00027-LG\u000e\\#yK\u000e,Ho\u001c:t\u001f:,\u0005p\u00197vI\u0016$gj\u001c3f)\u0011\u0011yfa\u0001\t\u000f\r\u0015!\u00051\u0001\u0002n\u0005!an\u001c3f\u0003u)\b\u000fZ1uK\u0016C8\r\\;eK\u00124uN\u001d$fi\u000eDg)Y5mkJ,GC\u0002B0\u0007\u0017\u0019y\u0001C\u0004\u0004\u000e\r\u0002\r!!\u001c\u0002\t!|7\u000f\u001e\u0005\b\u0005[\u001c\u0003\u0019AA7\u0003\t*\b\u000fZ1uK\u0016C8\r\\;eK\u00124uN]*vG\u000e,7o\u001d4vYR\u000b7o[*fiRA!qLB\u000b\u00073\u0019i\u0002C\u0004\u0004\u0018\u0011\u0002\r!!\u000e\u0002\u000fM$\u0018mZ3JI\"911\u0004\u0013A\u0002\u0005U\u0012AD:uC\u001e,\u0017\t\u001e;f[B$\u0018\n\u001a\u0005\b\u0007?!\u0003\u0019AB\u0011\u000391\u0017-\u001b7ve\u0016\u001c()_#yK\u000e\u0004\u0002\"a\u0018\u0002j\u00055$qP\u0001\u0013SN,\u00050Z2vi>\u0014X\t_2mk\u0012,G\r\u0006\u0003\u0002R\r\u001d\u0002bBB\u0015K\u0001\u0007\u0011QN\u0001\u000bKb,7-\u001e;pe&#\u0017\u0001E3yG2,H-\u001a3O_\u0012,G*[:u)\t\u0011\t-\u0001\bjg:{G-Z#yG2,H-\u001a3\u0015\t\u0005E31\u0007\u0005\b\u0007\u000b9\u0003\u0019AA7\u0003UA\u0017M\u001c3mKJ+Wn\u001c<fI\u0016CXmY;u_J$BAa\u0018\u0004:!91\u0011\u0006\u0015A\u0002\u00055\u0014!\u0004%fC2$\b\u000e\u0016:bG.,'\u000f\u0005\u0002t#N\u0019\u0011kY5\u0015\u0005\ru\u0012a\u0004#F\r\u0006+F\nV0U\u00136+u*\u0016+\u0002!\u0011+e)Q+M)~#\u0016*T#P+R\u0003\u0013!G5t\u000bb\u001cG.\u001e3f\u001f:4\u0015-\u001b7ve\u0016,e.\u00192mK\u0012$B!!\u0015\u0004L!)q/\u0016a\u0001q\u0006Ir-\u001a;Fq2,H-Z(o\r\u0006LG.\u001e:f)&lWm\\;u)\u0011\t)e!\u0015\t\u000b]4\u0006\u0019\u0001=\u0002;Y\fG.\u001b3bi\u0016,\u0005p\u00197vI\u0016|eNR1jYV\u0014XmQ8oMN$BAa\u0018\u0004X!)qo\u0016a\u0001q\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"a!\u0018+\t\u0005%\u0011Q\u0019")
public class HealthTracker
implements Logging {
    private final LiveListenerBus listenerBus;
    private final SparkConf conf;
    private final Option<ExecutorAllocationClient> allocationClient;
    private final Clock clock;
    private final int MAX_FAILURES_PER_EXEC;
    private final int MAX_FAILED_EXEC_PER_NODE;
    private final long EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS;
    private final boolean EXCLUDE_FETCH_FAILURE_ENABLED;
    private final HashMap<String, ExecutorFailureList> executorIdToFailureList;
    private final HashMap<String, ExcludedExecutor> executorIdToExcludedStatus;
    private final HashMap<String, Object> nodeIdToExcludedExpiryTime;
    private final AtomicReference<Set<String>> _excludedNodeList;
    private long nextExpiryTime;
    private final HashMap<String, HashSet<String>> nodeToExcludedExecs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$4() {
        return HealthTracker$.MODULE$.$lessinit$greater$default$4();
    }

    public static void validateExcludeOnFailureConfs(SparkConf sparkConf) {
        HealthTracker$.MODULE$.validateExcludeOnFailureConfs(sparkConf);
    }

    public static long getExludeOnFailureTimeout(SparkConf sparkConf) {
        return HealthTracker$.MODULE$.getExludeOnFailureTimeout(sparkConf);
    }

    public static boolean isExcludeOnFailureEnabled(SparkConf sparkConf) {
        return HealthTracker$.MODULE$.isExcludeOnFailureEnabled(sparkConf);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    private int MAX_FAILURES_PER_EXEC() {
        return this.MAX_FAILURES_PER_EXEC;
    }

    private int MAX_FAILED_EXEC_PER_NODE() {
        return this.MAX_FAILED_EXEC_PER_NODE;
    }

    public long EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS() {
        return this.EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS;
    }

    private boolean EXCLUDE_FETCH_FAILURE_ENABLED() {
        return this.EXCLUDE_FETCH_FAILURE_ENABLED;
    }

    private HashMap<String, ExecutorFailureList> executorIdToFailureList() {
        return this.executorIdToFailureList;
    }

    public HashMap<String, ExcludedExecutor> executorIdToExcludedStatus() {
        return this.executorIdToExcludedStatus;
    }

    public HashMap<String, Object> nodeIdToExcludedExpiryTime() {
        return this.nodeIdToExcludedExpiryTime;
    }

    private AtomicReference<Set<String>> _excludedNodeList() {
        return this._excludedNodeList;
    }

    public long nextExpiryTime() {
        return this.nextExpiryTime;
    }

    public void nextExpiryTime_$eq(long x$1) {
        this.nextExpiryTime = x$1;
    }

    public HashMap<String, HashSet<String>> nodeToExcludedExecs() {
        return this.nodeToExcludedExecs;
    }

    public void applyExcludeOnFailureTimeout() {
        block2: {
            Iterable nodesToInclude;
            long now = this.clock.getTimeMillis();
            if (now <= this.nextExpiryTime()) break block2;
            Iterable execsToInclude = ((MapLike)this.executorIdToExcludedStatus().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HealthTracker.$anonfun$applyExcludeOnFailureTimeout$1(now, x$1)))).keys();
            if (execsToInclude.nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Removing executors ").append(execsToInclude).append(" from exclude list because the ").append("the executors have reached the timed out").toString());
                execsToInclude.foreach((Function1 & Serializable & scala.Serializable)exec -> {
                    ExcludedExecutor status = (ExcludedExecutor)this.executorIdToExcludedStatus().remove(exec).get();
                    HashSet failedExecsOnNode = (HashSet)this.nodeToExcludedExecs().apply((Object)status.node());
                    this.listenerBus().post(new SparkListenerExecutorUnblacklisted(now, (String)exec));
                    this.listenerBus().post(new SparkListenerExecutorUnexcluded(now, (String)exec));
                    failedExecsOnNode.remove(exec);
                    return failedExecsOnNode.isEmpty() ? this.nodeToExcludedExecs().remove((Object)status.node()) : BoxedUnit.UNIT;
                });
            }
            if ((nodesToInclude = ((MapLike)this.nodeIdToExcludedExpiryTime().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HealthTracker.$anonfun$applyExcludeOnFailureTimeout$4(now, x$2)))).keys()).nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Removing nodes ").append(nodesToInclude).append(" from exclude list because the ").append("nodes have reached has timed out").toString());
                nodesToInclude.foreach((Function1 & Serializable & scala.Serializable)node -> {
                    HealthTracker.$anonfun$applyExcludeOnFailureTimeout$6(this, now, node);
                    return BoxedUnit.UNIT;
                });
                this._excludedNodeList().set((Set<String>)this.nodeIdToExcludedExpiryTime().keySet().toSet());
            }
            this.updateNextExpiryTime();
        }
    }

    private void updateNextExpiryTime() {
        long execMinExpiry = this.executorIdToExcludedStatus().nonEmpty() ? BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.executorIdToExcludedStatus().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)HealthTracker.$anonfun$updateNextExpiryTime$1(x$3)), Iterable$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        long nodeMinExpiry = this.nodeIdToExcludedExpiryTime().nonEmpty() ? BoxesRunTime.unboxToLong((Object)this.nodeIdToExcludedExpiryTime().values().min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        this.nextExpiryTime_$eq(package$.MODULE$.min(execMinExpiry, nodeMinExpiry));
    }

    private void killExecutor(String exec, String msg) {
        Option<ExecutorAllocationClient> option = this.allocationClient;
        if (option instanceof Some) {
            Some some = (Some)option;
            ExecutorAllocationClient a = (ExecutorAllocationClient)some.value();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
            a.killExecutors((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{exec}))), false, false, true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append("Not attempting to kill excluded executor id ").append(exec).append(" ").append("since allocation client is not defined.").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private void killExcludedExecutor(String exec) {
        block0: {
            if (!BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_KILL_ENABLED()))) break block0;
            this.killExecutor(exec, new StringBuilder(44).append("Killing excluded executor id ").append(exec).append(" since ").append(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_KILL_ENABLED().key()).append(" is set.").toString());
        }
    }

    public void killExcludedIdleExecutor(String exec) {
        this.killExecutor(exec, new StringBuilder(105).append("Killing excluded idle executor id ").append(exec).append(" because of task unschedulability and trying ").append("to acquire a new executor.").toString());
    }

    private void killExecutorsOnExcludedNode(String node) {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_KILL_ENABLED()))) {
            Option<ExecutorAllocationClient> option = this.allocationClient;
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                ExecutorAllocationClient a = (ExecutorAllocationClient)some.value();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Killing all executors on excluded host ").append(node).append(" ").append("since ").append(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_KILL_ENABLED().key()).append(" is set.").toString());
                if (!a.killExecutorsOnHost(node)) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Killing executors on node ").append(node).append(" failed.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Not attempting to kill executors on excluded host ").append(node).append(" ").append("since allocation client is not defined.").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
    }

    public void updateExcludedForFetchFailure(String host, String exec) {
        block0: {
            long expiryTimeForNewExcludes;
            long now;
            block1: {
                if (!this.EXCLUDE_FETCH_FAILURE_ENABLED()) break block0;
                now = this.clock.getTimeMillis();
                expiryTimeForNewExcludes = now + this.EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS();
                if (!BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) break block1;
                if (this.nodeIdToExcludedExpiryTime().contains((Object)host)) break block0;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("excluding node ").append(host).append(" due to fetch failure of external shuffle service").toString());
                this.nodeIdToExcludedExpiryTime().put((Object)host, (Object)BoxesRunTime.boxToLong((long)expiryTimeForNewExcludes));
                this.listenerBus().post(new SparkListenerNodeBlacklisted(now, host, 1));
                this.listenerBus().post(new SparkListenerNodeExcluded(now, host, 1));
                this._excludedNodeList().set((Set<String>)this.nodeIdToExcludedExpiryTime().keySet().toSet());
                this.killExecutorsOnExcludedNode(host);
                this.updateNextExpiryTime();
                break block0;
            }
            if (this.executorIdToExcludedStatus().contains((Object)exec)) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Excluding executor ").append(exec).append(" due to fetch failure").toString());
            this.executorIdToExcludedStatus().put((Object)exec, (Object)new ExcludedExecutor(host, expiryTimeForNewExcludes));
            this.listenerBus().post(new SparkListenerExecutorBlacklisted(now, exec, 1));
            this.listenerBus().post(new SparkListenerExecutorExcluded(now, exec, 1));
            this.updateNextExpiryTime();
            this.killExcludedExecutor(exec);
            HashSet excludedExecsOnNode = (HashSet)this.nodeToExcludedExecs().getOrElseUpdate((Object)host, (Function0 & Serializable & scala.Serializable)() -> (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
            excludedExecsOnNode.$plus$eq((Object)exec);
        }
    }

    public void updateExcludedForSuccessfulTaskSet(int stageId, int stageAttemptId, HashMap<String, ExecutorFailuresInTaskSet> failuresByExec) {
        long now = this.clock.getTimeMillis();
        failuresByExec.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HealthTracker.$anonfun$updateExcludedForSuccessfulTaskSet$1(this, stageId, stageAttemptId, now, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isExecutorExcluded(String executorId) {
        return this.executorIdToExcludedStatus().contains((Object)executorId);
    }

    public Set<String> excludedNodeList() {
        return this._excludedNodeList().get();
    }

    public boolean isNodeExcluded(String node) {
        return this.nodeIdToExcludedExpiryTime().contains((Object)node);
    }

    public void handleRemovedExecutor(String executorId) {
        this.executorIdToFailureList().$minus$eq((Object)executorId);
    }

    public static final /* synthetic */ boolean $anonfun$applyExcludeOnFailureTimeout$1(long now$1, Tuple2 x$1) {
        return ((ExcludedExecutor)x$1._2()).expiryTime() < now$1;
    }

    public static final /* synthetic */ boolean $anonfun$applyExcludeOnFailureTimeout$4(long now$1, Tuple2 x$2) {
        return x$2._2$mcJ$sp() < now$1;
    }

    public static final /* synthetic */ void $anonfun$applyExcludeOnFailureTimeout$6(HealthTracker $this, long now$1, String node) {
        $this.nodeIdToExcludedExpiryTime().remove((Object)node);
        $this.listenerBus().post(new SparkListenerNodeUnblacklisted(now$1, node));
        $this.listenerBus().post(new SparkListenerNodeUnexcluded(now$1, node));
    }

    public static final /* synthetic */ long $anonfun$updateNextExpiryTime$1(Tuple2 x$3) {
        return ((ExcludedExecutor)x$3._2()).expiryTime();
    }

    public static final /* synthetic */ void $anonfun$updateExcludedForSuccessfulTaskSet$1(HealthTracker $this, int stageId$1, int stageAttemptId$1, long now$2, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String exec = (String)tuple2._1();
            ExecutorFailuresInTaskSet failuresInTaskSet = (ExecutorFailuresInTaskSet)tuple2._2();
            ExecutorFailureList appFailuresOnExecutor = (ExecutorFailureList)$this.executorIdToFailureList().getOrElseUpdate((Object)exec, (Function0 & Serializable & scala.Serializable)() -> $this.new ExecutorFailureList());
            appFailuresOnExecutor.addFailures(stageId$1, stageAttemptId$1, failuresInTaskSet);
            appFailuresOnExecutor.dropFailuresWithTimeoutBefore(now$2);
            int newTotal = appFailuresOnExecutor.numUniqueTaskFailures();
            long expiryTimeForNewExcludes = now$2 + $this.EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS();
            if (newTotal >= $this.MAX_FAILURES_PER_EXEC() && !$this.executorIdToExcludedStatus().contains((Object)exec)) {
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Excluding executor id: ").append(exec).append(" because it has ").append(newTotal).append(" task failures in successful task sets").toString());
                String node = failuresInTaskSet.node();
                $this.executorIdToExcludedStatus().put((Object)exec, (Object)new ExcludedExecutor(node, expiryTimeForNewExcludes));
                $this.listenerBus().post(new SparkListenerExecutorBlacklisted(now$2, exec, newTotal));
                $this.listenerBus().post(new SparkListenerExecutorExcluded(now$2, exec, newTotal));
                $this.executorIdToFailureList().remove((Object)exec);
                $this.updateNextExpiryTime();
                $this.killExcludedExecutor(exec);
                HashSet excludedExecsOnNode = (HashSet)$this.nodeToExcludedExecs().getOrElseUpdate((Object)node, (Function0 & Serializable & scala.Serializable)() -> (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                excludedExecsOnNode.$plus$eq((Object)exec);
                if (excludedExecsOnNode.size() >= $this.MAX_FAILED_EXEC_PER_NODE() && !$this.nodeIdToExcludedExpiryTime().contains((Object)node)) {
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Excluding node ").append(node).append(" because it has ").append(excludedExecsOnNode.size()).append(" ").append("executors excluded: ").append(excludedExecsOnNode).toString());
                    $this.nodeIdToExcludedExpiryTime().put((Object)node, (Object)BoxesRunTime.boxToLong((long)expiryTimeForNewExcludes));
                    $this.listenerBus().post(new SparkListenerNodeBlacklisted(now$2, node, excludedExecsOnNode.size()));
                    $this.listenerBus().post(new SparkListenerNodeExcluded(now$2, node, excludedExecsOnNode.size()));
                    $this._excludedNodeList().set((Set<String>)$this.nodeIdToExcludedExpiryTime().keySet().toSet());
                    $this.killExecutorsOnExcludedNode(node);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public HealthTracker(LiveListenerBus listenerBus, SparkConf conf, Option<ExecutorAllocationClient> allocationClient, Clock clock) {
        this.listenerBus = listenerBus;
        this.conf = conf;
        this.allocationClient = allocationClient;
        this.clock = clock;
        Logging.$init$(this);
        HealthTracker$.MODULE$.validateExcludeOnFailureConfs(conf);
        this.MAX_FAILURES_PER_EXEC = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILURES_PER_EXEC()));
        this.MAX_FAILED_EXEC_PER_NODE = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE()));
        this.EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS = HealthTracker$.MODULE$.getExludeOnFailureTimeout(conf);
        this.EXCLUDE_FETCH_FAILURE_ENABLED = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_FETCH_FAILURE_ENABLED()));
        this.executorIdToFailureList = new HashMap();
        this.executorIdToExcludedStatus = new HashMap();
        this.nodeIdToExcludedExpiryTime = new HashMap();
        this._excludedNodeList = new AtomicReference<GenTraversable>(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
        this.nextExpiryTime = Long.MAX_VALUE;
        this.nodeToExcludedExecs = new HashMap();
    }

    public HealthTracker(SparkContext sc, Option<ExecutorAllocationClient> allocationClient) {
        this(sc.listenerBus(), sc.conf(), allocationClient, HealthTracker$.MODULE$.$lessinit$greater$default$4());
    }

    public final class ExecutorFailureList
    implements Logging {
        private volatile HealthTracker$ExecutorFailureList$TaskId$ TaskId$module;
        private ArrayBuffer<Tuple2<TaskId, Object>> failuresAndExpiryTimes;
        private long minExpiryTime;
        private transient Logger org$apache$spark$internal$Logging$$log_;

        @Override
        public String logName() {
            return Logging.logName$(this);
        }

        @Override
        public Logger log() {
            return Logging.log$(this);
        }

        @Override
        public void logInfo(Function0<String> msg) {
            Logging.logInfo$(this, msg);
        }

        @Override
        public void logDebug(Function0<String> msg) {
            Logging.logDebug$(this, msg);
        }

        @Override
        public void logTrace(Function0<String> msg) {
            Logging.logTrace$(this, msg);
        }

        @Override
        public void logWarning(Function0<String> msg) {
            Logging.logWarning$(this, msg);
        }

        @Override
        public void logError(Function0<String> msg) {
            Logging.logError$(this, msg);
        }

        @Override
        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$(this, msg, throwable);
        }

        @Override
        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$(this, msg, throwable);
        }

        @Override
        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$(this, msg, throwable);
        }

        @Override
        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$(this, msg, throwable);
        }

        @Override
        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$(this, msg, throwable);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$(this, isInterpreter);
        }

        @Override
        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
        }

        @Override
        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$(this);
        }

        @Override
        public void initializeForcefully(boolean isInterpreter, boolean silent) {
            Logging.initializeForcefully$(this, isInterpreter, silent);
        }

        private HealthTracker$ExecutorFailureList$TaskId$ TaskId() {
            if (this.TaskId$module == null) {
                this.TaskId$lzycompute$1();
            }
            return this.TaskId$module;
        }

        @Override
        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        @Override
        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        private ArrayBuffer<Tuple2<TaskId, Object>> failuresAndExpiryTimes() {
            return this.failuresAndExpiryTimes;
        }

        private void failuresAndExpiryTimes_$eq(ArrayBuffer<Tuple2<TaskId, Object>> x$1) {
            this.failuresAndExpiryTimes = x$1;
        }

        private long minExpiryTime() {
            return this.minExpiryTime;
        }

        private void minExpiryTime_$eq(long x$1) {
            this.minExpiryTime = x$1;
        }

        public void addFailures(int stage, int stageAttempt, ExecutorFailuresInTaskSet failuresInTaskSet) {
            failuresInTaskSet.taskToFailureCountAndFailureTime().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExecutorFailureList.$anonfun$addFailures$1(this, stage, stageAttempt, x0$1);
                return BoxedUnit.UNIT;
            });
        }

        public int numUniqueTaskFailures() {
            return this.failuresAndExpiryTimes().size();
        }

        public boolean isEmpty() {
            return this.failuresAndExpiryTimes().isEmpty();
        }

        public void dropFailuresWithTimeoutBefore(long dropBefore) {
            block0: {
                if (this.minExpiryTime() >= dropBefore) break block0;
                LongRef newMinExpiry = LongRef.create((long)Long.MAX_VALUE);
                ArrayBuffer newFailures = new ArrayBuffer();
                this.failuresAndExpiryTimes().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    ExecutorFailureList.$anonfun$dropFailuresWithTimeoutBefore$1(dropBefore, newFailures, newMinExpiry, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.failuresAndExpiryTimes_$eq((ArrayBuffer<Tuple2<TaskId, Object>>)newFailures);
                this.minExpiryTime_$eq(newMinExpiry.elem);
            }
        }

        public String toString() {
            return new StringBuilder(11).append("failures = ").append(this.failuresAndExpiryTimes()).toString();
        }

        private final void TaskId$lzycompute$1() {
            ExecutorFailureList executorFailureList = this;
            synchronized (executorFailureList) {
                if (this.TaskId$module == null) {
                    this.TaskId$module = new HealthTracker$ExecutorFailureList$TaskId$(this);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final /* synthetic */ void $anonfun$addFailures$1(ExecutorFailureList $this, int stage$1, int stageAttempt$1, Tuple2 x0$1) {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int taskIdx = tuple2._1$mcI$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            long failureTime = tuple22._2$mcJ$sp();
            long expiryTime = failureTime + $this.HealthTracker.this.EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS();
            $this.failuresAndExpiryTimes().$plus$eq((Object)new Tuple2((Object)new TaskId($this, stage$1, stageAttempt$1, taskIdx), (Object)BoxesRunTime.boxToLong((long)expiryTime)));
            if (expiryTime < $this.minExpiryTime()) {
                $this.minExpiryTime_$eq(expiryTime);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public static final /* synthetic */ void $anonfun$dropFailuresWithTimeoutBefore$1(long dropBefore$1, ArrayBuffer newFailures$1, LongRef newMinExpiry$1, Tuple2 x0$1) {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TaskId task = (TaskId)tuple2._1();
                long expiryTime = tuple2._2$mcJ$sp();
                if (expiryTime >= dropBefore$1) {
                    newFailures$1.$plus$eq((Object)new Tuple2((Object)task, (Object)BoxesRunTime.boxToLong((long)expiryTime)));
                    if (expiryTime < newMinExpiry$1.elem) {
                        newMinExpiry$1.elem = expiryTime;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public ExecutorFailureList() {
            if (HealthTracker.this == null) {
                throw null;
            }
            Logging.$init$(this);
            this.failuresAndExpiryTimes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.minExpiryTime = Long.MAX_VALUE;
        }

        public class TaskId
        implements Product,
        scala.Serializable {
            private final int stage;
            private final int stageAttempt;
            private final int taskIndex;
            public final /* synthetic */ ExecutorFailureList $outer;

            public int stage() {
                return this.stage;
            }

            public int stageAttempt() {
                return this.stageAttempt;
            }

            public int taskIndex() {
                return this.taskIndex;
            }

            public TaskId copy(int stage, int stageAttempt, int taskIndex) {
                return new TaskId(this.org$apache$spark$scheduler$HealthTracker$ExecutorFailureList$TaskId$$$outer(), stage, stageAttempt, taskIndex);
            }

            public int copy$default$1() {
                return this.stage();
            }

            public int copy$default$2() {
                return this.stageAttempt();
            }

            public int copy$default$3() {
                return this.taskIndex();
            }

            public String productPrefix() {
                return "TaskId";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Integer n;
                int n2 = x$1;
                switch (n2) {
                    case 0: {
                        n = BoxesRunTime.boxToInteger((int)this.stage());
                        break;
                    }
                    case 1: {
                        n = BoxesRunTime.boxToInteger((int)this.stageAttempt());
                        break;
                    }
                    case 2: {
                        n = BoxesRunTime.boxToInteger((int)this.taskIndex());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return n;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof TaskId;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.stage());
                n = Statics.mix((int)n, (int)this.stageAttempt());
                n = Statics.mix((int)n, (int)this.taskIndex());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof TaskId)) return false;
                if (((TaskId)object).org$apache$spark$scheduler$HealthTracker$ExecutorFailureList$TaskId$$$outer() != this.org$apache$spark$scheduler$HealthTracker$ExecutorFailureList$TaskId$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                TaskId taskId = (TaskId)x$1;
                if (this.stage() != taskId.stage()) return false;
                if (this.stageAttempt() != taskId.stageAttempt()) return false;
                if (this.taskIndex() != taskId.taskIndex()) return false;
                if (!taskId.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ ExecutorFailureList org$apache$spark$scheduler$HealthTracker$ExecutorFailureList$TaskId$$$outer() {
                return this.$outer;
            }

            public TaskId(ExecutorFailureList $outer, int stage, int stageAttempt, int taskIndex) {
                this.stage = stage;
                this.stageAttempt = stageAttempt;
                this.taskIndex = taskIndex;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

