/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$ClientType$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStoreImpl;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStoreImpl$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3QAB\u0004\u0001\u001bMAQ\u0001\n\u0001\u0005\u0002\u0019BQ!\u000b\u0001\u0005B)BQa\u000f\u0001\u0005BqBQa\u0012\u0001\u0005B!CQa\u0014\u0001\u0005BA\u0013\u0001dS;cKJtW\r^3t\u00072,8\u000f^3s\u001b\u0006t\u0017mZ3s\u0015\tA\u0011\"A\u0002lqMT!AC\u0006\u0002\u000f\rdWo\u001d;fe*\u0011A\"D\u0001\ng\u000eDW\rZ;mKJT!AD\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\n\u0005\u0001QQb\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037qi\u0011aC\u0005\u0003;-\u0011a#\u0012=uKJt\u0017\r\\\"mkN$XM]'b]\u0006<WM\u001d\t\u0003?\tj\u0011\u0001\t\u0006\u0003C5\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003G\u0001\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGOP\u0002\u0001)\u00059\u0003C\u0001\u0015\u0001\u001b\u00059\u0011!C2b]\u000e\u0013X-\u0019;f)\tYc\u0006\u0005\u0002\u0016Y%\u0011QF\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015y#\u00011\u00011\u0003%i\u0017m\u001d;feV\u0013F\n\u0005\u00022q9\u0011!G\u000e\t\u0003gYi\u0011\u0001\u000e\u0006\u0003k\u0015\na\u0001\u0010:p_Rt\u0014BA\u001c\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]2\u0012aE2sK\u0006$X\rV1tWN\u001b\u0007.\u001a3vY\u0016\u0014HcA\u001fA\rB\u00111DP\u0005\u0003\u007f-\u0011Q\u0002V1tWN\u001b\u0007.\u001a3vY\u0016\u0014\b\"B!\u0004\u0001\u0004\u0011\u0015AA:d!\t\u0019E)D\u0001\u000e\u0013\t)UB\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u00030\u0007\u0001\u0007\u0001'\u0001\fde\u0016\fG/Z*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e)\u0011IE*\u0014(\u0011\u0005mQ\u0015BA&\f\u0005A\u00196\r[3ek2,'OQ1dW\u0016tG\rC\u0003B\t\u0001\u0007!\tC\u00030\t\u0001\u0007\u0001\u0007C\u0003\r\t\u0001\u0007Q(\u0001\u0006j]&$\u0018.\u00197ju\u0016$2!\u0015+V!\t)\"+\u0003\u0002T-\t!QK\\5u\u0011\u0015aQ\u00011\u0001>\u0011\u00151V\u00011\u0001J\u0003\u001d\u0011\u0017mY6f]\u0012\u0004")
public class KubernetesClusterManager
implements ExternalClusterManager,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean canCreate(String masterURL) {
        return masterURL.startsWith("k8s");
    }

    public TaskScheduler createTaskScheduler(SparkContext sc, String masterURL) {
        return new TaskSchedulerImpl(sc);
    }

    public SchedulerBackend createSchedulerBackend(SparkContext sc, String masterURL, TaskScheduler scheduler) {
        Tuple4 tuple4;
        Tuple4 tuple42;
        boolean wasSparkSubmittedInClusterMode = BoxesRunTime.unboxToBoolean((Object)sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK()));
        if (wasSparkSubmittedInClusterMode) {
            Predef$.MODULE$.require(((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME())).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "If the application is deployed using spark-submit in cluster mode, the driver pod name must be provided.");
            Option serviceAccountToken = new Some((Object)new File("/var/run/secrets/kubernetes.io/serviceaccount/token")).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.exists()));
            Option serviceAccountCaCrt = new Some((Object)new File("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt")).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.exists()));
            tuple42 = new Tuple4((Object)Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_MASTER_URL()), (Object)serviceAccountToken, (Object)serviceAccountCaCrt);
        } else {
            tuple42 = tuple4 = new Tuple4((Object)Config$.MODULE$.KUBERNETES_AUTH_CLIENT_MODE_PREFIX(), (Object)KubernetesUtils$.MODULE$.parseMasterUrl(masterURL), (Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        String authConfPrefix = (String)tuple4._1();
        String apiServerUri = (String)tuple4._2();
        Option defaultServiceAccountToken = (Option)tuple4._3();
        Option defaultServiceAccountCaCrt = (Option)tuple4._4();
        Tuple4 tuple43 = new Tuple4((Object)authConfPrefix, (Object)apiServerUri, (Object)defaultServiceAccountToken, (Object)defaultServiceAccountCaCrt);
        Tuple4 tuple44 = tuple43;
        String authConfPrefix2 = (String)tuple44._1();
        String apiServerUri2 = (String)tuple44._2();
        Option defaultServiceAccountToken2 = (Option)tuple44._3();
        Option defaultServiceAccountCaCrt2 = (Option)tuple44._4();
        Object object = !sc.conf().contains(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX()) ? sc.conf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)KubernetesConf$.MODULE$.getResourceNamePrefix(sc.conf().get("spark.app.name"))) : BoxedUnit.UNIT;
        KubernetesClient kubernetesClient = SparkKubernetesClientFactory$.MODULE$.createKubernetesClient(apiServerUri2, (Option<String>)new Some(sc.conf().get(Config$.MODULE$.KUBERNETES_NAMESPACE())), authConfPrefix2, (Enumeration.Value)SparkKubernetesClientFactory$ClientType$.MODULE$.Driver(), sc.conf(), (Option<File>)defaultServiceAccountToken2, (Option<File>)defaultServiceAccountCaCrt2);
        Object object2 = ((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE())).isDefined() ? KubernetesUtils$.MODULE$.loadPodFromTemplate(kubernetesClient, new File((String)((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE())).get()), (Option<String>)((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_CONTAINER_NAME()))) : BoxedUnit.UNIT;
        ScheduledExecutorService schedulerExecutorService = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kubernetes-executor-maintenance");
        ExecutorPodsSnapshot$.MODULE$.setShouldCheckAllContainers(BoxesRunTime.unboxToBoolean((Object)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_CHECK_ALL_CONTAINERS())));
        String sparkContainerName = (String)((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_CONTAINER_NAME())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME());
        ExecutorPodsSnapshot$.MODULE$.setSparkContainerName(sparkContainerName);
        ScheduledExecutorService subscribersExecutor = ThreadUtils$.MODULE$.newDaemonThreadPoolScheduledExecutor("kubernetes-executor-snapshots-subscribers", 2);
        ExecutorPodsSnapshotsStoreImpl snapshotsStore = new ExecutorPodsSnapshotsStoreImpl(subscribersExecutor, ExecutorPodsSnapshotsStoreImpl$.MODULE$.$lessinit$greater$default$2());
        Cache removedExecutorsCache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).build();
        ExecutorPodsLifecycleManager executorPodsLifecycleEventHandler = new ExecutorPodsLifecycleManager(sc.conf(), kubernetesClient, snapshotsStore, (Cache<Long, Long>)removedExecutorsCache);
        ExecutorPodsAllocator executorPodsAllocator = new ExecutorPodsAllocator(sc.conf(), sc.env().securityManager(), new KubernetesExecutorBuilder(), kubernetesClient, snapshotsStore, (Clock)new SystemClock());
        ExecutorPodsWatchSnapshotSource podsWatchEventSource = new ExecutorPodsWatchSnapshotSource(snapshotsStore, kubernetesClient);
        ScheduledExecutorService eventsPollingExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kubernetes-executor-pod-polling-sync");
        ExecutorPodsPollingSnapshotSource podsPollingEventSource = new ExecutorPodsPollingSnapshotSource(sc.conf(), kubernetesClient, snapshotsStore, eventsPollingExecutor);
        return new KubernetesClusterSchedulerBackend((TaskSchedulerImpl)scheduler, sc, kubernetesClient, schedulerExecutorService, snapshotsStore, executorPodsAllocator, executorPodsLifecycleEventHandler, podsWatchEventSource, podsPollingEventSource);
    }

    public void initialize(TaskScheduler scheduler, SchedulerBackend backend) {
        ((TaskSchedulerImpl)scheduler).initialize(backend);
    }

    public KubernetesClusterManager() {
        Logging.$init$((Logging)this);
    }
}

