/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.json;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.json.JsonOutputWriter;
import org.apache.spark.sql.execution.datasources.v2.FileWriteBuilder;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]4Aa\u0002\u0005\u00013!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u00056\u0001\t\u0005\t\u0015!\u0003.\u0011!1\u0004A!A!\u0002\u00139\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b5\u0003A\u0011\u0001(\t\u000bU\u0003A\u0011\t,\u0003!)\u001bxN\\,sSR,')^5mI\u0016\u0014(BA\u0005\u000b\u0003\u0011Q7o\u001c8\u000b\u0005-a\u0011A\u0001<3\u0015\tia\"A\u0006eCR\f7o\\;sG\u0016\u001c(BA\b\u0011\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0012%\u0005\u00191/\u001d7\u000b\u0005M!\u0012!B:qCJ\\'BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00015A\u00111\u0004H\u0007\u0002\u0015%\u0011QD\u0003\u0002\u0011\r&dWm\u0016:ji\u0016\u0014U/\u001b7eKJ\fQ\u0001]1uQN\u00042\u0001\t\u0016.\u001d\t\tsE\u0004\u0002#K5\t1E\u0003\u0002%1\u00051AH]8pizJ\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q%\nq\u0001]1dW\u0006<WMC\u0001'\u0013\tYCFA\u0002TKFT!\u0001K\u0015\u0011\u00059\u0012dBA\u00181!\t\u0011\u0013&\u0003\u00022S\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\rM#(/\u001b8h\u0015\t\t\u0014&\u0001\u0006g_Jl\u0017\r\u001e(b[\u0016\f\u0001c];qa>\u0014Ho\u001d#bi\u0006$\u0016\u0010]3\u0011\taJ4(Q\u0007\u0002S%\u0011!(\u000b\u0002\n\rVt7\r^5p]F\u0002\"\u0001P \u000e\u0003uR!A\u0010\t\u0002\u000bQL\b/Z:\n\u0005\u0001k$\u0001\u0003#bi\u0006$\u0016\u0010]3\u0011\u0005a\u0012\u0015BA\"*\u0005\u001d\u0011un\u001c7fC:\fA!\u001b8g_B\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0006oJLG/\u001a\u0006\u0003\u0015B\t\u0011bY8o]\u0016\u001cGo\u001c:\n\u00051;%\u0001\u0005'pO&\u001c\u0017\r\\,sSR,\u0017J\u001c4p\u0003\u0019a\u0014N\\5u}Q)q*\u0015*T)B\u0011\u0001\u000bA\u0007\u0002\u0011!)a$\u0002a\u0001?!)Q'\u0002a\u0001[!)a'\u0002a\u0001o!)A)\u0002a\u0001\u000b\u0006a\u0001O]3qCJ,wK]5uKR)qkW2neB\u0011\u0001,W\u0007\u0002\u0019%\u0011!\f\u0004\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u00069\u001a\u0001\r!X\u0001\bgFd7i\u001c8g!\tq\u0016-D\u0001`\u0015\t\u0001\u0007#\u0001\u0005j]R,'O\\1m\u0013\t\u0011wLA\u0004T#2\u001buN\u001c4\t\u000b\u00114\u0001\u0019A3\u0002\u0007)|'\r\u0005\u0002gW6\tqM\u0003\u0002iS\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0003UR\ta\u0001[1e_>\u0004\u0018B\u00017h\u0005\rQuN\u0019\u0005\u0006]\u001a\u0001\ra\\\u0001\b_B$\u0018n\u001c8t!\u0011q\u0003/L\u0017\n\u0005E$$aA'ba\")1O\u0002a\u0001i\u0006QA-\u0019;b'\u000eDW-\\1\u0011\u0005q*\u0018B\u0001<>\u0005)\u0019FO];diRK\b/\u001a")
public class JsonWriteBuilder
extends FileWriteBuilder {
    @Override
    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        JSONOptions parsedOptions = new JSONOptions(options, sqlConf.sessionLocalTimeZone(), sqlConf.columnNameOfCorruptRecord());
        parsedOptions.compressionCodec().foreach((Function1 & Serializable & scala.Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, parsedOptions){
            private final JSONOptions parsedOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new JsonOutputWriter(path, this.parsedOptions$1, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(5).append(".json").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
            }
        };
    }

    public JsonWriteBuilder(Seq<String> paths, String formatName, Function1<DataType, Object> supportsDataType, LogicalWriteInfo info) {
        super(paths, formatName, supportsDataType, info);
    }
}

