/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.avro.ipc.HttpServer;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.SaslSocketServer;
import org.apache.avro.ipc.SaslSocketTransceiver;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.Transceiver;

public class Ipc {
    private Ipc() {
    }

    public static Transceiver createTransceiver(URI uri) throws IOException {
        if ("http".equals(uri.getScheme())) {
            return new HttpTransceiver(uri.toURL());
        }
        if ("avro".equals(uri.getScheme())) {
            return new SaslSocketTransceiver(new InetSocketAddress(uri.getHost(), uri.getPort()));
        }
        throw new IOException("unknown uri scheme: " + uri);
    }

    public static Server createServer(Responder responder, URI uri) throws IOException {
        if ("http".equals(uri.getScheme())) {
            return new HttpServer(responder, uri.getPort());
        }
        if ("avro".equals(uri.getScheme())) {
            return new SaslSocketServer(responder, new InetSocketAddress(uri.getHost(), uri.getPort()));
        }
        throw new IOException("unknown uri scheme: " + uri);
    }
}

