/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.github.fommil.netlib.BLAS;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.feature.VocabWord;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001\u0002\u001e<\u0001\u0019CQA\u0016\u0001\u0005\u0002]CqA\u0017\u0001A\u0002\u0013%1\fC\u0004`\u0001\u0001\u0007I\u0011\u00021\t\r\u0019\u0004\u0001\u0015)\u0003]\u0011\u001d9\u0007\u00011A\u0005\n!Dq\u0001\u001c\u0001A\u0002\u0013%Q\u000e\u0003\u0004p\u0001\u0001\u0006K!\u001b\u0005\ba\u0002\u0001\r\u0011\"\u0003\\\u0011\u001d\t\b\u00011A\u0005\nIDa\u0001\u001e\u0001!B\u0013a\u0006bB;\u0001\u0001\u0004%Ia\u0017\u0005\bm\u0002\u0001\r\u0011\"\u0003x\u0011\u0019I\b\u0001)Q\u00059\"9!\u0010\u0001a\u0001\n\u0013Y\b\u0002C@\u0001\u0001\u0004%I!!\u0001\t\u000f\u0005\u0015\u0001\u0001)Q\u0005y\"A\u0011q\u0001\u0001A\u0002\u0013%1\fC\u0005\u0002\n\u0001\u0001\r\u0011\"\u0003\u0002\f!9\u0011q\u0002\u0001!B\u0013a\u0006\u0002CA\t\u0001\u0001\u0007I\u0011B.\t\u0013\u0005M\u0001\u00011A\u0005\n\u0005U\u0001bBA\r\u0001\u0001\u0006K\u0001\u0018\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003_\u0002A\u0011AA9\u0011!\tY\b\u0001b\u0001\n\u0013Y\u0006bBA?\u0001\u0001\u0006I\u0001\u0018\u0005\t\u0003\u007f\u0002!\u0019!C\u00057\"9\u0011\u0011\u0011\u0001!\u0002\u0013a\u0006\u0002CAB\u0001\t\u0007I\u0011B.\t\u000f\u0005\u0015\u0005\u0001)A\u00059\"A\u0011q\r\u0001A\u0002\u0013%1\fC\u0005\u0002\b\u0002\u0001\r\u0011\"\u0003\u0002\n\"9\u0011Q\u0012\u0001!B\u0013a\u0006\u0002CAH\u0001\u0001\u0007I\u0011B>\t\u0013\u0005E\u0005\u00011A\u0005\n\u0005M\u0005bBAL\u0001\u0001\u0006K\u0001 \u0005\t\u00033\u0003\u0001\u0019!C\u00057\"I\u00111\u0014\u0001A\u0002\u0013%\u0011Q\u0014\u0005\b\u0003C\u0003\u0001\u0015)\u0003]\u0011%\t\u0019\u000b\u0001a\u0001\n\u0013\t)\u000bC\u0005\u00024\u0002\u0001\r\u0011\"\u0003\u00026\"A\u0011\u0011\u0018\u0001!B\u0013\t9\u000bC\u0005\u0002D\u0002\u0001\r\u0011\"\u0003\u0002F\"I\u0011Q\u001e\u0001A\u0002\u0013%\u0011q\u001e\u0005\t\u0003g\u0004\u0001\u0015)\u0003\u0002H\"9\u0011q\u001f\u0001\u0005\n\u0005e\bb\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0011\u001d\u0011y\u0004\u0001C\u0001\u0005\u0003BqA!\u0016\u0001\t\u0013\u00119\u0006C\u0004\u0003@\u0001!\tAa#\u0003\u0011]{'\u000f\u001a\u001aWK\u000eT!\u0001P\u001f\u0002\u000f\u0019,\u0017\r^;sK*\u0011ahP\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u0001\u0006\u000bQa\u001d9be.T!AQ\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0015aA8sO\u000e\u00011\u0003\u0002\u0001H\u001bB\u0003\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013a!\u00118z%\u00164\u0007C\u0001%O\u0013\ty\u0015J\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002R)6\t!K\u0003\u0002T\u007f\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002V%\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001Y!\tI\u0006!D\u0001<\u0003)1Xm\u0019;peNK'0Z\u000b\u00029B\u0011\u0001*X\u0005\u0003=&\u00131!\u00138u\u000391Xm\u0019;peNK'0Z0%KF$\"!\u00193\u0011\u0005!\u0013\u0017BA2J\u0005\u0011)f.\u001b;\t\u000f\u0015\u001c\u0011\u0011!a\u00019\u0006\u0019\u0001\u0010J\u0019\u0002\u0017Y,7\r^8s'&TX\rI\u0001\rY\u0016\f'O\\5oOJ\u000bG/Z\u000b\u0002SB\u0011\u0001J[\u0005\u0003W&\u0013a\u0001R8vE2,\u0017\u0001\u00057fCJt\u0017N\\4SCR,w\fJ3r)\t\tg\u000eC\u0004f\r\u0005\u0005\t\u0019A5\u0002\u001b1,\u0017M\u001d8j]\u001e\u0014\u0016\r^3!\u00035qW/\u001c)beRLG/[8og\u0006\tb.^7QCJ$\u0018\u000e^5p]N|F%Z9\u0015\u0005\u0005\u001c\bbB3\n\u0003\u0003\u0005\r\u0001X\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u00035qW/\\%uKJ\fG/[8og\u0006\tb.^7Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0005D\bbB3\r\u0003\u0003\u0005\r\u0001X\u0001\u000f]Vl\u0017\n^3sCRLwN\\:!\u0003\u0011\u0019X-\u001a3\u0016\u0003q\u0004\"\u0001S?\n\u0005yL%\u0001\u0002'p]\u001e\f\u0001b]3fI~#S-\u001d\u000b\u0004C\u0006\r\u0001bB3\u0010\u0003\u0003\u0005\r\u0001`\u0001\u0006g\u0016,G\rI\u0001\t[&t7i\\;oi\u0006aQ.\u001b8D_VtGo\u0018\u0013fcR\u0019\u0011-!\u0004\t\u000f\u0015\u0014\u0012\u0011!a\u00019\u0006IQ.\u001b8D_VtG\u000fI\u0001\u0012[\u0006D8+\u001a8uK:\u001cW\rT3oORD\u0017!F7bqN+g\u000e^3oG\u0016dUM\\4uQ~#S-\u001d\u000b\u0004C\u0006]\u0001bB3\u0016\u0003\u0003\u0005\r\u0001X\u0001\u0013[\u0006D8+\u001a8uK:\u001cW\rT3oORD\u0007%\u0001\u000btKRl\u0015\r_*f]R,gnY3MK:<G\u000f\u001b\u000b\u0005\u0003?\t\t#D\u0001\u0001\u0011\u0019\t\tb\u0006a\u00019\"*q#!\n\u00022A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,}\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty#!\u000b\u0003\u000bMKgnY3\"\u0005\u0005M\u0012!\u0002\u001a/a9\u0002\u0014!D:fiZ+7\r^8s'&TX\r\u0006\u0003\u0002 \u0005e\u0002\"\u0002.\u0019\u0001\u0004a\u0006&\u0002\r\u0002&\u0005u\u0012EAA \u0003\u0015\td&\r\u00181\u0003=\u0019X\r\u001e'fCJt\u0017N\\4SCR,G\u0003BA\u0010\u0003\u000bBQaZ\rA\u0002%DS!GA\u0013\u0003{\t\u0001c]3u\u001dVl\u0007+\u0019:uSRLwN\\:\u0015\t\u0005}\u0011Q\n\u0005\u0006aj\u0001\r\u0001\u0018\u0015\u00065\u0005\u0015\u0012QH\u0001\u0011g\u0016$h*^7Ji\u0016\u0014\u0018\r^5p]N$B!a\b\u0002V!)Qo\u0007a\u00019\"*1$!\n\u0002>\u000591/\u001a;TK\u0016$G\u0003BA\u0010\u0003;BQA\u001f\u000fA\u0002qDS\u0001HA\u0013\u0003{\tQb]3u/&tGm\\<TSj,G\u0003BA\u0010\u0003KBa!a\u001a\u001e\u0001\u0004a\u0016AB<j]\u0012|w\u000fK\u0003\u001e\u0003K\tY'\t\u0002\u0002n\u0005)\u0011G\f\u001c/a\u0005Y1/\u001a;NS:\u001cu.\u001e8u)\u0011\ty\"a\u001d\t\r\u0005\u001da\u00041\u0001]Q\u0015q\u0012QEA<C\t\tI(A\u00032]Mr\u0003'\u0001\bF1B{F+\u0011\"M\u000b~\u001b\u0016JW#\u0002\u001f\u0015C\u0006k\u0018+B\u00052+ulU%[\u000b\u0002\nq!T!Y?\u0016C\u0006+\u0001\u0005N\u0003b{V\t\u0017)!\u0003=i\u0015\tW0D\u001f\u0012+u\fT#O\u000fRC\u0015\u0001E'B1~\u001bu\nR#`\u0019\u0016su\t\u0016%!\u0003)9\u0018N\u001c3po~#S-\u001d\u000b\u0004C\u0006-\u0005bB3'\u0003\u0003\u0005\r\u0001X\u0001\bo&tGm\\<!\u0003=!(/Y5o/>\u0014Hm]\"pk:$\u0018a\u0005;sC&twk\u001c:eg\u000e{WO\u001c;`I\u0015\fHcA1\u0002\u0016\"9Q-KA\u0001\u0002\u0004a\u0018\u0001\u0005;sC&twk\u001c:eg\u000e{WO\u001c;!\u0003%1xnY1c'&TX-A\u0007w_\u000e\f'mU5{K~#S-\u001d\u000b\u0004C\u0006}\u0005bB3-\u0003\u0003\u0005\r\u0001X\u0001\u000bm>\u001c\u0017MY*ju\u0016\u0004\u0013!\u0002<pG\u0006\u0014WCAAT!\u0015A\u0015\u0011VAW\u0013\r\tY+\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00043\u0006=\u0016bAAYw\tIak\\2bE^{'\u000fZ\u0001\nm>\u001c\u0017MY0%KF$2!YA\\\u0011!)w&!AA\u0002\u0005\u001d\u0016A\u0002<pG\u0006\u0014\u0007\u0005K\u00021\u0003{\u00032\u0001SA`\u0013\r\t\t-\u0013\u0002\niJ\fgn]5f]R\f\u0011B^8dC\nD\u0015m\u001d5\u0016\u0005\u0005\u001d\u0007cBAe\u0003'\f9\u000eX\u0007\u0003\u0003\u0017TA!!4\u0002P\u00069Q.\u001e;bE2,'bAAi\u0013\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u00171\u001a\u0002\b\u0011\u0006\u001c\b.T1q!\u0011\tI.a:\u000f\t\u0005m\u00171\u001d\t\u0004\u0003;LUBAAp\u0015\r\t\t/R\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015\u0018*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003S\fYO\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003KL\u0015!\u0004<pG\u0006\u0014\u0007*Y:i?\u0012*\u0017\u000fF\u0002b\u0003cD\u0001\"\u001a\u001a\u0002\u0002\u0003\u0007\u0011qY\u0001\u000bm>\u001c\u0017M\u0019%bg\"\u0004\u0003fA\u001a\u0002>\u0006QA.Z1s]Z{7-\u00192\u0016\t\u0005m(\u0011\u0003\u000b\u0004C\u0006u\bbBA\u0000i\u0001\u0007!\u0011A\u0001\bI\u0006$\u0018m]3u!\u0019\u0011\u0019A!\u0003\u0003\u000e5\u0011!Q\u0001\u0006\u0004\u0005\u000fy\u0014a\u0001:eI&!!1\u0002B\u0003\u0005\r\u0011F\t\u0012\t\u0005\u0005\u001f\u0011\t\u0002\u0004\u0001\u0005\u000f\tMAG1\u0001\u0003\u0016\t\t1+\u0005\u0003\u0003\u0018\tu\u0001c\u0001%\u0003\u001a%\u0019!1D%\u0003\u000f9{G\u000f[5oOB1!q\u0004B\u0015\u0003/tAA!\t\u0003&9!\u0011Q\u001cB\u0012\u0013\u0005Q\u0015b\u0001B\u0014\u0013\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0016\u0005[\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005OI\u0015AD2sK\u0006$X-\u0012=q)\u0006\u0014G.\u001a\u000b\u0003\u0005g\u0001R\u0001SAU\u0005k\u00012\u0001\u0013B\u001c\u0013\r\u0011I$\u0013\u0002\u0006\r2|\u0017\r^\u0001\u0011GJ,\u0017\r^3CS:\f'/\u001f+sK\u0016$\u0012!Y\u0001\u0004M&$X\u0003\u0002B\"\u0005#\"BA!\u0012\u0003LA\u0019\u0011La\u0012\n\u0007\t%3HA\u0007X_J$'GV3d\u001b>$W\r\u001c\u0005\b\u0003\u007f<\u0004\u0019\u0001B'!\u0019\u0011\u0019A!\u0003\u0003PA!!q\u0002B)\t\u001d\u0011\u0019b\u000eb\u0001\u0005+ASaNA\u0013\u0003{\tQ\u0001Z8GSR,BA!\u0017\u0003bQa!Q\tB.\u0005G\u0012yGa \u0003\u0006\"9\u0011q \u001dA\u0002\tu\u0003C\u0002B\u0002\u0005\u0013\u0011y\u0006\u0005\u0003\u0003\u0010\t\u0005Da\u0002B\nq\t\u0007!Q\u0003\u0005\b\u0005KB\u0004\u0019\u0001B4\u0003\t\u00198\r\u0005\u0003\u0003j\t-T\"A \n\u0007\t5tH\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0004\u0003ra\u0002\rAa\u001d\u0002\u0011\u0015D\b\u000fV1cY\u0016\u0004bA!\u001e\u0003|\tMRB\u0001B<\u0015\r\u0011IhP\u0001\nEJ|\u0017\rZ2bgRLAA! \u0003x\tI!I]8bI\u000e\f7\u000f\u001e\u0005\b\u0005\u0003C\u0004\u0019\u0001BB\u0003\u001d\u00117MV8dC\n\u0004bA!\u001e\u0003|\u0005\u001d\u0006b\u0002BDq\u0001\u0007!\u0011R\u0001\fE\u000e4vnY1c\u0011\u0006\u001c\b\u000e\u0005\u0004\u0003v\tm\u0014qY\u000b\u0005\u0005\u001b\u0013\u0019\u000b\u0006\u0003\u0003F\t=\u0005bBA\u0000s\u0001\u0007!\u0011\u0013\t\u0007\u0005'\u0013iJ!)\u000e\u0005\tU%\u0002\u0002BL\u00053\u000bAA[1wC*\u0019!1T \u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003 \nU%a\u0002&bm\u0006\u0014F\t\u0012\t\u0005\u0005\u001f\u0011\u0019\u000bB\u0004\u0003\u0014e\u0012\rA!*\u0012\t\t]!q\u0015\t\u0007\u0005S\u0013\t,a6\u000e\u0005\t-&\u0002\u0002BW\u0005_\u000bA\u0001\\1oO*\u0011!qS\u0005\u0005\u0005W\u0011Y\u000bK\u0003:\u0003K\ti\u0004K\u0003\u0001\u0003K\ti\u0004")
public class Word2Vec
implements scala.Serializable,
Logging {
    private int vectorSize;
    private double learningRate;
    private int numPartitions;
    private int numIterations;
    private long seed;
    private int minCount;
    private int maxSentenceLength;
    private final int EXP_TABLE_SIZE;
    private final int MAX_EXP;
    private final int MAX_CODE_LENGTH;
    private int window;
    private long trainWordsCount;
    private int vocabSize;
    private transient VocabWord[] vocab;
    private transient HashMap<String, Object> vocabHash;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int vectorSize() {
        return this.vectorSize;
    }

    private void vectorSize_$eq(int x$1) {
        this.vectorSize = x$1;
    }

    private double learningRate() {
        return this.learningRate;
    }

    private void learningRate_$eq(double x$1) {
        this.learningRate = x$1;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(int x$1) {
        this.numPartitions = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private int minCount() {
        return this.minCount;
    }

    private void minCount_$eq(int x$1) {
        this.minCount = x$1;
    }

    private int maxSentenceLength() {
        return this.maxSentenceLength;
    }

    private void maxSentenceLength_$eq(int x$1) {
        this.maxSentenceLength = x$1;
    }

    public Word2Vec setMaxSentenceLength(int maxSentenceLength) {
        Predef$.MODULE$.require(maxSentenceLength > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Maximum length of sentences must be positive but got ").append(maxSentenceLength).toString());
        this.maxSentenceLength_$eq(maxSentenceLength);
        return this;
    }

    public Word2Vec setVectorSize(int vectorSize) {
        Predef$.MODULE$.require(vectorSize > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("vector size must be positive but got ").append(vectorSize).toString());
        this.vectorSize_$eq(vectorSize);
        return this;
    }

    public Word2Vec setLearningRate(double learningRate) {
        Predef$.MODULE$.require(learningRate > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Initial learning rate must be positive but got ").append(learningRate).toString());
        this.learningRate_$eq(learningRate);
        return this;
    }

    public Word2Vec setNumPartitions(int numPartitions) {
        Predef$.MODULE$.require(numPartitions > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Number of partitions must be positive but got ").append(numPartitions).toString());
        this.numPartitions_$eq(numPartitions);
        return this;
    }

    public Word2Vec setNumIterations(int numIterations) {
        Predef$.MODULE$.require(numIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Number of iterations must be nonnegative but got ").append(numIterations).toString());
        this.numIterations_$eq(numIterations);
        return this;
    }

    public Word2Vec setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public Word2Vec setWindowSize(int window) {
        Predef$.MODULE$.require(window > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Window of words must be positive but got ").append(window).toString());
        this.window_$eq(window);
        return this;
    }

    public Word2Vec setMinCount(int minCount) {
        Predef$.MODULE$.require(minCount >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Minimum number of times must be nonnegative but got ").append(minCount).toString());
        this.minCount_$eq(minCount);
        return this;
    }

    private int EXP_TABLE_SIZE() {
        return this.EXP_TABLE_SIZE;
    }

    private int MAX_EXP() {
        return this.MAX_EXP;
    }

    private int MAX_CODE_LENGTH() {
        return this.MAX_CODE_LENGTH;
    }

    private int window() {
        return this.window;
    }

    private void window_$eq(int x$1) {
        this.window = x$1;
    }

    private long trainWordsCount() {
        return this.trainWordsCount;
    }

    private void trainWordsCount_$eq(long x$1) {
        this.trainWordsCount = x$1;
    }

    private int vocabSize() {
        return this.vocabSize;
    }

    private void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    private VocabWord[] vocab() {
        return this.vocab;
    }

    private void vocab_$eq(VocabWord[] x$1) {
        this.vocab = x$1;
    }

    private HashMap<String, Object> vocabHash() {
        return this.vocabHash;
    }

    private void vocabHash_$eq(HashMap<String, Object> x$1) {
        this.vocabHash = x$1;
    }

    private <S extends Iterable<String>> void learnVocab(RDD<S> dataset) {
        RDD words = dataset.flatMap((Function1 & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.apply(String.class));
        this.vocab_$eq((VocabWord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(words.map((Function1 & Serializable & scala.Serializable)w -> new Tuple2(w, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Word2Vec.$anonfun$learnVocab$4(this, x$3))).map((Function1 & Serializable & scala.Serializable)x -> new VocabWord((String)x._1(), x._2$mcI$sp(), new int[this.MAX_CODE_LENGTH()], new int[this.MAX_CODE_LENGTH()], 0), ClassTag$.MODULE$.apply(VocabWord.class)).collect())).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.cn()), package$.MODULE$.Ordering().apply((Ordering)Ordering.Long$.MODULE$).reverse()));
        this.vocabSize_$eq(this.vocab().length);
        Predef$.MODULE$.require(this.vocabSize() > 0, (Function0 & Serializable & scala.Serializable)() -> "The vocabulary size should be > 0. You may need to check the setting of minCount, which could be large enough to remove all your words in sentences.");
        for (int a = 0; a < this.vocabSize(); ++a) {
            this.vocabHash().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.vocab()[a].word()), (Object)BoxesRunTime.boxToInteger((int)a)));
            this.trainWordsCount_$eq(this.trainWordsCount() + this.vocab()[a].cn());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("vocabSize = ").append(this.vocabSize()).append(", trainWordsCount = ").append(this.trainWordsCount()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private float[] createExpTable() {
        void var1_1;
        float[] expTable = new float[this.EXP_TABLE_SIZE()];
        for (int i = 0; i < this.EXP_TABLE_SIZE(); ++i) {
            double tmp = scala.math.package$.MODULE$.exp((2.0 * (double)i / (double)this.EXP_TABLE_SIZE() - 1.0) * (double)this.MAX_EXP());
            expTable[i] = (float)(tmp / (tmp + 1.0));
        }
        return var1_1;
    }

    private void createBinaryTree() {
        int a;
        long[] count = new long[this.vocabSize() * 2 + 1];
        int[] binary = new int[this.vocabSize() * 2 + 1];
        int[] parentNode = new int[this.vocabSize() * 2 + 1];
        int[] code = new int[this.MAX_CODE_LENGTH()];
        int[] point = new int[this.MAX_CODE_LENGTH()];
        for (a = 0; a < this.vocabSize(); ++a) {
            count[a] = this.vocab()[a].cn();
        }
        while (a < 2 * this.vocabSize()) {
            count[a] = Long.MAX_VALUE;
            ++a;
        }
        int pos1 = this.vocabSize() - 1;
        int pos2 = this.vocabSize();
        int min1i = 0;
        int min2i = 0;
        for (a = 0; a < this.vocabSize() - 1; ++a) {
            min1i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            min2i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            Predef$.MODULE$.assert(count[min1i] < Long.MAX_VALUE);
            Predef$.MODULE$.assert(count[min2i] < Long.MAX_VALUE);
            count[this.vocabSize() + a] = count[min1i] + count[min2i];
            parentNode[min1i] = this.vocabSize() + a;
            parentNode[min2i] = this.vocabSize() + a;
            binary[min2i] = 1;
        }
        int i = 0;
        for (a = 0; a < this.vocabSize(); ++a) {
            int b = a;
            i = 0;
            while (b != this.vocabSize() * 2 - 2) {
                code[i] = binary[b];
                point[i] = b;
                ++i;
                b = parentNode[b];
            }
            this.vocab()[a].codeLen_$eq(i);
            this.vocab()[a].point()[0] = this.vocabSize() - 2;
            for (b = 0; b < i; ++b) {
                this.vocab()[a].code()[i - b - 1] = code[b];
                this.vocab()[a].point()[i - b] = point[b] - this.vocabSize();
            }
        }
    }

    public <S extends Iterable<String>> Word2VecModel fit(RDD<S> dataset) {
        Word2VecModel word2VecModel;
        this.learnVocab(dataset);
        this.createBinaryTree();
        SparkContext sc = dataset.context();
        Broadcast expTable = sc.broadcast((Object)this.createExpTable(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
        Broadcast bcVocab = sc.broadcast((Object)this.vocab(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VocabWord.class)));
        Broadcast bcVocabHash = sc.broadcast(this.vocabHash(), ClassTag$.MODULE$.apply(HashMap.class));
        try {
            word2VecModel = this.doFit(dataset, sc, (Broadcast<float[]>)expTable, (Broadcast<VocabWord[]>)bcVocab, (Broadcast<HashMap<String, Object>>)bcVocabHash);
        }
        finally {
            expTable.destroy();
            bcVocab.destroy();
            bcVocabHash.destroy();
        }
        return word2VecModel;
    }

    private <S extends Iterable<String>> Word2VecModel doFit(RDD<S> dataset, SparkContext sc, Broadcast<float[]> expTable, Broadcast<VocabWord[]> bcVocab, Broadcast<HashMap<String, Object>> bcVocabHash) {
        RDD sentences = dataset.mapPartitions((Function1 & Serializable & scala.Serializable)sentenceIter -> sentenceIter.flatMap((Function1 & Serializable & scala.Serializable)sentence -> {
            HashMap hashMap = (HashMap)bcVocabHash.value();
            Iterable wordIndexes = (Iterable)sentence.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(hashMap.get(key)), Iterable$.MODULE$.canBuildFrom());
            return wordIndexes.grouped(this.maxSentenceLength()).map((Function1 & Serializable & scala.Serializable)x$5 -> (int[])x$5.toArray(ClassTag$.MODULE$.Int()));
        }), dataset.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        int x$1 = this.numPartitions();
        Ordering x$2 = sentences.repartition$default$2(x$1);
        RDD newSentences = sentences.repartition(x$1, x$2).cache();
        XORShiftRandom initRandom = new XORShiftRandom(this.seed());
        if ((long)this.vocabSize() * (long)this.vectorSize() >= Integer.MAX_VALUE) {
            throw new RuntimeException(new StringBuilder(184).append("Please increase minCount or decrease vectorSize in Word2Vec to avoid an OOM. You are highly recommended to make your vocabSize*vectorSize, which is ").append(this.vocabSize()).append("*").append(this.vectorSize()).append(" for now, less than `Int.MaxValue`.").toString());
        }
        float[] syn0Global = (float[])Array$.MODULE$.fill(this.vocabSize() * this.vectorSize(), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> (initRandom.nextFloat() - 0.5f) / (float)this.vectorSize(), ClassTag$.MODULE$.Float());
        float[] syn1Global = new float[this.vocabSize() * this.vectorSize()];
        long totalWordsCounts = (long)this.numIterations() * this.trainWordsCount() + 1L;
        DoubleRef alpha = DoubleRef.create((double)this.learningRate());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numIterations()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
            Broadcast bcSyn0Global = sc.broadcast((Object)syn0Global, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
            Broadcast bcSyn1Global = sc.broadcast((Object)syn1Global, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
            long numWordsProcessedInPreviousIterations = (long)(k - 1) * this.trainWordsCount();
            RDD partial = newSentences.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> Word2Vec.$anonfun$doFit$7(this, k, bcSyn0Global, bcSyn1Global, alpha, numWordsProcessedInPreviousIterations, totalWordsCounts, bcVocab, expTable, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), newSentences.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            Tuple2[] synAgg = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(partial.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> iter.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int id = tuple2._1$mcI$sp();
                float[] vec = (float[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)new Tuple2((Object)vec, (Object)BoxesRunTime.boxToInteger((int)1)));
                return tuple22;
            }), partial.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(vc1, vc2) -> {
                BLAS.getInstance().saxpy(this.vectorSize(), 1.0f, (float[])vc2._1(), 1, (float[])vc1._1(), 1);
                return new Tuple2(vc1._1(), (Object)BoxesRunTime.boxToInteger((int)(vc1._2$mcI$sp() + vc2._2$mcI$sp())));
            }).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2;
                int id;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$4;
                        if (tuple22 == null) break block2;
                        id = tuple22._1$mcI$sp();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                float[] vec = (float[])tuple2._1();
                int count = tuple2._2$mcI$sp();
                BLAS.getInstance().sscal(this.vectorSize(), 1.0f / (float)count, vec, 1);
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)vec);
                return tuple23;
            }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
            for (int i = 0; i < synAgg.length; ++i) {
                int index = synAgg[i]._1$mcI$sp();
                if (index < this.vocabSize()) {
                    Array$.MODULE$.copy(synAgg[i]._2(), 0, (Object)syn0Global, index * this.vectorSize(), this.vectorSize());
                    continue;
                }
                Array$.MODULE$.copy(synAgg[i]._2(), 0, (Object)syn1Global, (index - this.vocabSize()) * this.vectorSize(), this.vectorSize());
            }
            bcSyn0Global.destroy();
            bcSyn1Global.destroy();
        });
        newSentences.unpersist(newSentences.unpersist$default$1());
        String[] wordArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.vocab())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.word(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new Word2VecModel((Map<String, Object>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])wordArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()), syn0Global);
    }

    public <S extends java.lang.Iterable<String>> Word2VecModel fit(JavaRDD<S> dataset) {
        return this.fit(dataset.rdd().map((Function1 & Serializable & scala.Serializable)x$7 -> (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$7).asScala(), ClassTag$.MODULE$.apply(Iterable.class)));
    }

    public static final /* synthetic */ boolean $anonfun$learnVocab$4(Word2Vec $this, Tuple2 x$3) {
        return x$3._2$mcI$sp() >= $this.minCount();
    }

    public static final /* synthetic */ Option $anonfun$doFit$10(Word2Vec $this, int[] syn0Modify$1, float[] syn0Local$1, int index) {
        return syn0Modify$1[index] > 0 ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(syn0Local$1)).slice(index * $this.vectorSize(), (index + 1) * $this.vectorSize()))) : None$.MODULE$;
    }

    public static final /* synthetic */ Option $anonfun$doFit$13(Word2Vec $this, int[] syn1Modify$1, float[] syn1Local$1, int index) {
        return syn1Modify$1[index] > 0 ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)(index + $this.vocabSize())), new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(syn1Local$1)).slice(index * $this.vectorSize(), (index + 1) * $this.vectorSize()))) : None$.MODULE$;
    }

    public static final /* synthetic */ Iterator $anonfun$doFit$7(Word2Vec $this, int k$1, Broadcast bcSyn0Global$1, Broadcast bcSyn1Global$1, DoubleRef alpha$1, long numWordsProcessedInPreviousIterations$1, long totalWordsCounts$1, Broadcast bcVocab$1, Broadcast expTable$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int idx = tuple2._1$mcI$sp();
        Iterator iter = (Iterator)tuple2._2();
        XORShiftRandom random = new XORShiftRandom($this.seed() ^ (long)(idx + 1 << 16) ^ (long)(-k$1 - 1 << 8));
        int[] syn0Modify = new int[$this.vocabSize()];
        int[] syn1Modify = new int[$this.vocabSize()];
        Tuple4 model = (Tuple4)iter.foldLeft((Object)new Tuple4(bcSyn0Global$1.value(), bcSyn1Global$1.value(), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple4 tuple4 = (Tuple4)tuple2._1();
            int[] sentence = (int[])tuple2._2();
            if (tuple4 == null) throw new MatchError((Object)tuple2);
            float[] syn0 = (float[])tuple4._1();
            float[] syn1 = (float[])tuple4._2();
            long lastWordCount = BoxesRunTime.unboxToLong((Object)tuple4._3());
            long wordCount = BoxesRunTime.unboxToLong((Object)tuple4._4());
            long lwc = lastWordCount;
            long wc = wordCount;
            if (wordCount - lastWordCount > 10000L) {
                lwc = wordCount;
                alpha$1.elem = $this.learningRate() * (1.0 - ((double)$this.numPartitions() * (double)wordCount + (double)numWordsProcessedInPreviousIterations$1) / (double)totalWordsCounts$1);
                if (alpha$1.elem < $this.learningRate() * 1.0E-4) {
                    alpha$1.elem = $this.learningRate() * 1.0E-4;
                }
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("wordCount = ").append(wordCount + numWordsProcessedInPreviousIterations$1).append(", ").append("alpha = ").append(alpha$1.elem).toString());
            }
            wc += (long)sentence.length;
            int pos = 0;
            while (pos < sentence.length) {
                int b;
                int word = sentence[pos];
                for (int a = b = random.nextInt($this.window()); a < $this.window() * 2 + 1 - b; ++a) {
                    int c;
                    if (a == $this.window() || (c = pos - $this.window() + a) < 0 || c >= sentence.length) continue;
                    int lastWord = sentence[c];
                    int l1 = lastWord * $this.vectorSize();
                    float[] neu1e = new float[$this.vectorSize()];
                    for (int d = 0; d < ((VocabWord[])bcVocab$1.value())[word].codeLen(); ++d) {
                        int inner = ((VocabWord[])bcVocab$1.value())[word].point()[d];
                        int l2 = inner * $this.vectorSize();
                        float f = BLAS.getInstance().sdot($this.vectorSize(), syn0, l1, 1, syn1, l2, 1);
                        if (!(f > (float)(-$this.MAX_EXP())) || !(f < (float)$this.MAX_EXP())) continue;
                        int ind = (int)((double)(f + (float)$this.MAX_EXP()) * ((double)($this.EXP_TABLE_SIZE() / $this.MAX_EXP()) / 2.0));
                        f = ((float[])expTable$1.value())[ind];
                        float g = (float)((double)((float)(1 - ((VocabWord[])bcVocab$1.value())[word].code()[d]) - f) * alpha$1.elem);
                        BLAS.getInstance().saxpy($this.vectorSize(), g, syn1, l2, 1, neu1e, 0, 1);
                        BLAS.getInstance().saxpy($this.vectorSize(), g, syn0, l1, 1, syn1, l2, 1);
                        syn1Modify$1[inner] = syn1Modify[inner] + 1;
                    }
                    BLAS.getInstance().saxpy($this.vectorSize(), 1.0f, neu1e, 0, 1, syn0, l1, 1);
                    syn0Modify$1[lastWord] = syn0Modify[lastWord] + 1;
                }
                ++pos;
            }
            return new Tuple4((Object)syn0, (Object)syn1, (Object)BoxesRunTime.boxToLong((long)lwc), (Object)BoxesRunTime.boxToLong((long)wc));
        });
        float[] syn0Local = (float[])model._1();
        float[] syn1Local = (float[])model._2();
        Iterator iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)package$.MODULE$.Iterator().tabulate($this.vocabSize(), (Function1 & Serializable & scala.Serializable)index -> Word2Vec.$anonfun$doFit$10($this, syn0Modify, syn0Local, BoxesRunTime.unboxToInt((Object)index))), (Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)).flatten().$plus$plus((Function0 & Serializable & scala.Serializable)() -> TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)package$.MODULE$.Iterator().tabulate($this.vocabSize(), (Function1 & Serializable & scala.Serializable)index -> Word2Vec.$anonfun$doFit$13($this, syn1Modify, syn1Local, BoxesRunTime.unboxToInt((Object)index))), (Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)).flatten());
        return iterator;
    }

    public Word2Vec() {
        Logging.$init$((Logging)this);
        this.vectorSize = 100;
        this.learningRate = 0.025;
        this.numPartitions = 1;
        this.numIterations = 1;
        this.seed = Utils$.MODULE$.random().nextLong();
        this.minCount = 5;
        this.maxSentenceLength = 1000;
        this.EXP_TABLE_SIZE = 1000;
        this.MAX_EXP = 6;
        this.MAX_CODE_LENGTH = 40;
        this.window = 5;
        this.trainWordsCount = 0L;
        this.vocabSize = 0;
        this.vocab = null;
        this.vocabHash = HashMap$.MODULE$.empty();
    }
}

