/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.page;

import java.io.IOException;
import org.apache.parquet.Ints;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.Page;

public class DictionaryPage
extends Page {
    private final BytesInput bytes;
    private final int dictionarySize;
    private final Encoding encoding;

    public DictionaryPage(BytesInput bytes, int dictionarySize, Encoding encoding) {
        this(bytes, (int)bytes.size(), dictionarySize, encoding);
    }

    public DictionaryPage(BytesInput bytes, int uncompressedSize, int dictionarySize, Encoding encoding) {
        super(Ints.checkedCast((long)bytes.size()), uncompressedSize);
        this.bytes = (BytesInput)Preconditions.checkNotNull((Object)bytes, (String)"bytes");
        this.dictionarySize = dictionarySize;
        this.encoding = (Encoding)((Object)Preconditions.checkNotNull((Object)((Object)encoding), (String)"encoding"));
    }

    public BytesInput getBytes() {
        return this.bytes;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public DictionaryPage copy() throws IOException {
        return new DictionaryPage(BytesInput.copy((BytesInput)this.bytes), this.getUncompressedSize(), this.dictionarySize, this.encoding);
    }

    public String toString() {
        return "Page [bytes.size=" + this.bytes.size() + ", entryCount=" + this.dictionarySize + ", uncompressedSize=" + this.getUncompressedSize() + ", encoding=" + (Object)((Object)this.encoding) + "]";
    }
}

