/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedColumnReader;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ValuesType;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedPrimitiveColumnReader
implements VectorizedColumnReader {
    private static final Logger LOG = LoggerFactory.getLogger(VectorizedPrimitiveColumnReader.class);
    private boolean skipTimestampConversion = false;
    private long valuesRead;
    private long endOfPageValueCount;
    private final Dictionary dictionary;
    private boolean isCurrentPageDictionaryEncoded;
    private final int maxDefLevel;
    private int definitionLevel;
    private int repetitionLevel;
    private IntIterator repetitionLevelColumn;
    private IntIterator definitionLevelColumn;
    private ValuesReader dataColumn;
    private int pageValueCount;
    private final PageReader pageReader;
    private final ColumnDescriptor descriptor;
    private final Type type;

    public VectorizedPrimitiveColumnReader(ColumnDescriptor descriptor, PageReader pageReader, boolean skipTimestampConversion, Type type) throws IOException {
        this.descriptor = descriptor;
        this.type = type;
        this.pageReader = pageReader;
        this.maxDefLevel = descriptor.getMaxDefinitionLevel();
        this.skipTimestampConversion = skipTimestampConversion;
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException("could not decode the dictionary for " + descriptor, e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
    }

    @Override
    public void readBatch(int total, ColumnVector column, TypeInfo columnType) throws IOException {
        int rowId = 0;
        while (total > 0) {
            int leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            if (leftInPage == 0) {
                this.readPage();
                leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            }
            int num = Math.min(total, leftInPage);
            if (this.isCurrentPageDictionaryEncoded) {
                LongColumnVector dictionaryIds = new LongColumnVector();
                this.readDictionaryIDs(num, dictionaryIds, rowId);
                this.decodeDictionaryIds(rowId, num, column, dictionaryIds);
            } else {
                this.readBatchHelper(num, column, columnType, rowId);
            }
            rowId += num;
            total -= num;
        }
    }

    private void readBatchHelper(int num, ColumnVector column, TypeInfo columnType, int rowId) throws IOException {
        PrimitiveTypeInfo primitiveColumnType = (PrimitiveTypeInfo)columnType;
        switch (primitiveColumnType.getPrimitiveCategory()) {
            case INT: 
            case BYTE: 
            case SHORT: {
                this.readIntegers(num, (LongColumnVector)column, rowId);
                break;
            }
            case DATE: 
            case INTERVAL_YEAR_MONTH: 
            case LONG: {
                this.readLongs(num, (LongColumnVector)column, rowId);
                break;
            }
            case BOOLEAN: {
                this.readBooleans(num, (LongColumnVector)column, rowId);
                break;
            }
            case DOUBLE: {
                this.readDoubles(num, (DoubleColumnVector)column, rowId);
                break;
            }
            case BINARY: 
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                this.readBinaries(num, (BytesColumnVector)column, rowId);
                break;
            }
            case FLOAT: {
                this.readFloats(num, (DoubleColumnVector)column, rowId);
                break;
            }
            case DECIMAL: {
                this.readDecimal(num, (DecimalColumnVector)column, rowId);
                break;
            }
            default: {
                throw new IOException("Unsupported type: " + this.type);
            }
        }
    }

    private void readDictionaryIDs(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readValueDictionaryId();
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
            } else {
                c.isNull[rowId] = true;
                c.isRepeating = false;
                c.noNulls = false;
            }
            ++rowId;
        }
    }

    private void readIntegers(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readInteger();
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
            } else {
                c.isNull[rowId] = true;
                c.isRepeating = false;
                c.noNulls = false;
            }
            ++rowId;
        }
    }

    private void readDoubles(int total, DoubleColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readDouble();
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
            } else {
                c.isNull[rowId] = true;
                c.isRepeating = false;
                c.noNulls = false;
            }
            ++rowId;
        }
    }

    private void readBooleans(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readBoolean() ? 1L : 0L;
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
            } else {
                c.isNull[rowId] = true;
                c.isRepeating = false;
                c.noNulls = false;
            }
            ++rowId;
        }
    }

    private void readLongs(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readLong();
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
            } else {
                c.isNull[rowId] = true;
                c.isRepeating = false;
                c.noNulls = false;
            }
            ++rowId;
        }
    }

    private void readFloats(int total, DoubleColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readFloat();
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
            } else {
                c.isNull[rowId] = true;
                c.isRepeating = false;
                c.noNulls = false;
            }
            ++rowId;
        }
    }

    private void readDecimal(int total, DecimalColumnVector c, int rowId) throws IOException {
        c.precision = (short)this.type.asPrimitiveType().getDecimalMetadata().getPrecision();
        c.scale = (short)this.type.asPrimitiveType().getDecimalMetadata().getScale();
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId].set(this.dataColumn.readBytes().getBytesUnsafe(), (int)c.scale);
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
            } else {
                c.isNull[rowId] = true;
                c.isRepeating = false;
                c.noNulls = false;
            }
            ++rowId;
        }
    }

    private void readBinaries(int total, BytesColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.setVal(rowId, this.dataColumn.readBytes().getBytesUnsafe());
                c.isNull[rowId] = false;
                c.isRepeating = false;
            } else {
                c.isNull[rowId] = true;
                c.isRepeating = false;
                c.noNulls = false;
            }
            ++rowId;
        }
    }

    private void decodeDictionaryIds(int rowId, int num, ColumnVector column, LongColumnVector dictionaryIds) {
        System.arraycopy(dictionaryIds.isNull, rowId, column.isNull, rowId, num);
        if (column.noNulls) {
            column.noNulls = dictionaryIds.noNulls;
        }
        column.isRepeating = column.isRepeating && dictionaryIds.isRepeating;
        switch (this.descriptor.getType()) {
            case INT32: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((LongColumnVector)column).vector[i] = this.dictionary.decodeToInt((int)dictionaryIds.vector[i]);
                }
                break;
            }
            case INT64: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((LongColumnVector)column).vector[i] = this.dictionary.decodeToLong((int)dictionaryIds.vector[i]);
                }
                break;
            }
            case FLOAT: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((DoubleColumnVector)column).vector[i] = this.dictionary.decodeToFloat((int)dictionaryIds.vector[i]);
                }
                break;
            }
            case DOUBLE: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((DoubleColumnVector)column).vector[i] = this.dictionary.decodeToDouble((int)dictionaryIds.vector[i]);
                }
                break;
            }
            case INT96: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ByteBuffer buf = this.dictionary.decodeToBinary((int)dictionaryIds.vector[i]).toByteBuffer();
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    long timeOfDayNanos = buf.getLong();
                    int julianDay = buf.getInt();
                    NanoTime nt = new NanoTime(julianDay, timeOfDayNanos);
                    Timestamp ts = NanoTimeUtils.getTimestamp(nt, this.skipTimestampConversion);
                    ((TimestampColumnVector)column).set(i, ts);
                }
                break;
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                if (column instanceof BytesColumnVector) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        ((BytesColumnVector)column).setVal(i, this.dictionary.decodeToBinary((int)dictionaryIds.vector[i]).getBytesUnsafe());
                    }
                } else {
                    DecimalColumnVector decimalColumnVector = (DecimalColumnVector)column;
                    decimalColumnVector.precision = (short)this.type.asPrimitiveType().getDecimalMetadata().getPrecision();
                    decimalColumnVector.scale = (short)this.type.asPrimitiveType().getDecimalMetadata().getScale();
                    for (int i = rowId; i < rowId + num; ++i) {
                        decimalColumnVector.vector[i].set(this.dictionary.decodeToBinary((int)dictionaryIds.vector[i]).getBytesUnsafe(), (int)decimalColumnVector.scale);
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + this.descriptor.getType());
            }
        }
    }

    private void readRepetitionAndDefinitionLevels() {
        this.repetitionLevel = this.repetitionLevelColumn.nextInt();
        this.definitionLevel = this.definitionLevelColumn.nextInt();
        ++this.valuesRead;
    }

    private void readPage() throws IOException {
        DataPage page = this.pageReader.readPage();
        page.accept((DataPage.Visitor)new DataPage.Visitor<Void>(){

            public Void visit(DataPageV1 dataPageV1) {
                VectorizedPrimitiveColumnReader.this.readPageV1(dataPageV1);
                return null;
            }

            public Void visit(DataPageV2 dataPageV2) {
                VectorizedPrimitiveColumnReader.this.readPageV2(dataPageV2);
                return null;
            }
        });
    }

    private void initDataReader(Encoding dataEncoding, byte[] bytes, int offset, int valueCount) throws IOException {
        this.pageValueCount = valueCount;
        this.endOfPageValueCount = this.valuesRead + (long)this.pageValueCount;
        if (dataEncoding.usesDictionary()) {
            this.dataColumn = null;
            if (this.dictionary == null) {
                throw new IOException("could not read page in col " + this.descriptor + " as the dictionary was missing for encoding " + dataEncoding);
            }
            this.dataColumn = dataEncoding.getDictionaryBasedValuesReader(this.descriptor, ValuesType.VALUES, this.dictionary);
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            if (dataEncoding != Encoding.PLAIN) {
                throw new UnsupportedOperationException("Unsupported encoding: " + dataEncoding);
            }
            this.dataColumn = dataEncoding.getValuesReader(this.descriptor, ValuesType.VALUES);
            this.isCurrentPageDictionaryEncoded = false;
        }
        try {
            this.dataColumn.initFromPage(this.pageValueCount, bytes, offset);
        }
        catch (IOException e) {
            throw new IOException("could not read page in col " + this.descriptor, e);
        }
    }

    private void readPageV1(DataPageV1 page) {
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL);
        ValuesReader dlReader = page.getDlEncoding().getValuesReader(this.descriptor, ValuesType.DEFINITION_LEVEL);
        this.repetitionLevelColumn = new ValuesReaderIntIterator(rlReader);
        this.definitionLevelColumn = new ValuesReaderIntIterator(dlReader);
        try {
            byte[] bytes = page.getBytes().toByteArray();
            LOG.debug("page size " + bytes.length + " bytes and " + this.pageValueCount + " records");
            LOG.debug("reading repetition levels at 0");
            rlReader.initFromPage(this.pageValueCount, bytes, 0);
            int next = rlReader.getNextOffset();
            LOG.debug("reading definition levels at " + next);
            dlReader.initFromPage(this.pageValueCount, bytes, next);
            next = dlReader.getNextOffset();
            LOG.debug("reading data at " + next);
            this.initDataReader(page.getValueEncoding(), bytes, next, page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page " + page + " in col " + this.descriptor, (Throwable)e);
        }
    }

    private void readPageV2(DataPageV2 page) {
        this.pageValueCount = page.getValueCount();
        this.repetitionLevelColumn = this.newRLEIterator(this.descriptor.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionLevelColumn = this.newRLEIterator(this.descriptor.getMaxDefinitionLevel(), page.getDefinitionLevels());
        try {
            LOG.debug("page data size " + page.getData().size() + " bytes and " + this.pageValueCount + " records");
            this.initDataReader(page.getDataEncoding(), page.getData().toByteArray(), 0, page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page " + page + " in col " + this.descriptor, (Throwable)e);
        }
    }

    private IntIterator newRLEIterator(int maxLevel, BytesInput bytes) {
        try {
            if (maxLevel == 0) {
                return new NullIntIterator();
            }
            return new RLEIntIterator(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), new ByteArrayInputStream(bytes.toByteArray())));
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read levels in page for col " + this.descriptor, (Throwable)e);
        }
    }

    protected static final class NullIntIterator
    extends IntIterator {
        protected NullIntIterator() {
        }

        @Override
        int nextInt() {
            return 0;
        }
    }

    protected static final class RLEIntIterator
    extends IntIterator {
        RunLengthBitPackingHybridDecoder delegate;

        public RLEIntIterator(RunLengthBitPackingHybridDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() {
            try {
                return this.delegate.readInt();
            }
            catch (IOException e) {
                throw new ParquetDecodingException((Throwable)e);
            }
        }
    }

    protected static final class ValuesReaderIntIterator
    extends IntIterator {
        ValuesReader delegate;

        public ValuesReaderIntIterator(ValuesReader delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() {
            return this.delegate.readInteger();
        }
    }

    static abstract class IntIterator {
        IntIterator() {
        }

        abstract int nextInt();
    }
}

