/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.codahale.metrics.MetricSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.BlockStoreClient;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.network.shuffle.ErrorHandler;
import org.apache.spark.network.shuffle.MergeFinalizerListener;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.OneForOneBlockPusher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.BlocksRemoved;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.shuffle.protocol.FinalizeShuffleMerge;
import org.apache.spark.network.shuffle.protocol.MergeStatuses;
import org.apache.spark.network.shuffle.protocol.RegisterExecutor;
import org.apache.spark.network.shuffle.protocol.RemoveBlocks;
import org.apache.spark.network.util.TransportConf;
import org.sparkproject.guava.collect.Lists;

public class ExternalBlockStoreClient
extends BlockStoreClient {
    private static final ErrorHandler PUSH_ERROR_HANDLER = new ErrorHandler.BlockPushErrorHandler();
    private final TransportConf conf;
    private final boolean authEnabled;
    private final SecretKeyHolder secretKeyHolder;
    private final long registrationTimeoutMs;

    public ExternalBlockStoreClient(TransportConf conf, SecretKeyHolder secretKeyHolder, boolean authEnabled, long registrationTimeoutMs) {
        this.conf = conf;
        this.secretKeyHolder = secretKeyHolder;
        this.authEnabled = authEnabled;
        this.registrationTimeoutMs = registrationTimeoutMs;
    }

    public void init(String appId) {
        this.appId = appId;
        TransportContext context = new TransportContext(this.conf, (RpcHandler)new NoOpRpcHandler(), true, true);
        ArrayList bootstraps = Lists.newArrayList();
        if (this.authEnabled) {
            bootstraps.add(new AuthClientBootstrap(this.conf, appId, this.secretKeyHolder));
        }
        this.clientFactory = context.createClientFactory((List)bootstraps);
    }

    @Override
    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener, DownloadFileManager downloadFileManager) {
        this.checkInit();
        this.logger.debug("External shuffle fetch from {}:{} (executor id {})", new Object[]{host, port, execId});
        try {
            int maxRetries = this.conf.maxIORetries();
            RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = (inputBlockId, inputListener) -> {
                if (this.clientFactory != null) {
                    TransportClient client = this.clientFactory.createClient(host, port, maxRetries > 0);
                    new OneForOneBlockFetcher(client, this.appId, execId, inputBlockId, inputListener, this.conf, downloadFileManager).start();
                } else {
                    this.logger.info("This clientFactory was closed. Skipping further block fetch retries.");
                }
            };
            if (maxRetries > 0) {
                new RetryingBlockFetcher(this.conf, blockFetchStarter, blockIds, listener).start();
            } else {
                blockFetchStarter.createAndStart(blockIds, listener);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while beginning fetchBlocks", (Throwable)e);
            for (String blockId : blockIds) {
                listener.onBlockFetchFailure(blockId, e);
            }
        }
    }

    @Override
    public void pushBlocks(String host, int port, String[] blockIds, ManagedBuffer[] buffers, BlockFetchingListener listener) {
        this.checkInit();
        assert (blockIds.length == buffers.length) : "Number of block ids and buffers do not match.";
        HashMap<String, ManagedBuffer> buffersWithId = new HashMap<String, ManagedBuffer>();
        for (int i = 0; i < blockIds.length; ++i) {
            buffersWithId.put(blockIds[i], buffers[i]);
        }
        this.logger.debug("Push {} shuffle blocks to {}:{}", new Object[]{blockIds.length, host, port});
        try {
            RetryingBlockFetcher.BlockFetchStarter blockPushStarter = (inputBlockId, inputListener) -> {
                TransportClient client = this.clientFactory.createClient(host, port);
                new OneForOneBlockPusher(client, this.appId, inputBlockId, inputListener, buffersWithId).start();
            };
            int maxRetries = this.conf.maxIORetries();
            if (maxRetries > 0) {
                new RetryingBlockFetcher(this.conf, blockPushStarter, blockIds, listener, PUSH_ERROR_HANDLER).start();
            } else {
                blockPushStarter.createAndStart(blockIds, listener);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while beginning pushBlocks", (Throwable)e);
            for (String blockId : blockIds) {
                listener.onBlockFetchFailure(blockId, e);
            }
        }
    }

    @Override
    public void finalizeShuffleMerge(String host, int port, int shuffleId, final MergeFinalizerListener listener) {
        this.checkInit();
        try {
            TransportClient client = this.clientFactory.createClient(host, port);
            ByteBuffer finalizeShuffleMerge = new FinalizeShuffleMerge(this.appId, shuffleId).toByteBuffer();
            client.sendRpc(finalizeShuffleMerge, new RpcResponseCallback(){

                public void onSuccess(ByteBuffer response) {
                    listener.onShuffleMergeSuccess((MergeStatuses)BlockTransferMessage.Decoder.fromByteBuffer(response));
                }

                public void onFailure(Throwable e) {
                    listener.onShuffleMergeFailure(e);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Exception while sending finalizeShuffleMerge request to {}:{}", new Object[]{host, port, e});
            listener.onShuffleMergeFailure(e);
        }
    }

    @Override
    public MetricSet shuffleMetrics() {
        this.checkInit();
        return this.clientFactory.getAllMetrics();
    }

    public void registerWithShuffleServer(String host, int port, String execId, ExecutorShuffleInfo executorInfo) throws IOException, InterruptedException {
        this.checkInit();
        try (TransportClient client = this.clientFactory.createClient(host, port);){
            ByteBuffer registerMessage = new RegisterExecutor(this.appId, execId, executorInfo).toByteBuffer();
            client.sendRpcSync(registerMessage, this.registrationTimeoutMs);
        }
    }

    public Future<Integer> removeBlocks(String host, int port, final String execId, final String[] blockIds) throws IOException, InterruptedException {
        this.checkInit();
        final CompletableFuture<Integer> numRemovedBlocksFuture = new CompletableFuture<Integer>();
        ByteBuffer removeBlocksMessage = new RemoveBlocks(this.appId, execId, blockIds).toByteBuffer();
        TransportClient client = this.clientFactory.createClient(host, port);
        client.sendRpc(removeBlocksMessage, new RpcResponseCallback(){

            public void onSuccess(ByteBuffer response) {
                try {
                    BlockTransferMessage msgObj = BlockTransferMessage.Decoder.fromByteBuffer(response);
                    numRemovedBlocksFuture.complete(((BlocksRemoved)msgObj).numRemovedBlocks);
                }
                catch (Throwable t) {
                    ExternalBlockStoreClient.this.logger.warn("Error trying to remove RDD blocks " + Arrays.toString(blockIds) + " via external shuffle service from executor: " + execId, t);
                    numRemovedBlocksFuture.complete(0);
                }
            }

            public void onFailure(Throwable e) {
                ExternalBlockStoreClient.this.logger.warn("Error trying to remove RDD blocks " + Arrays.toString(blockIds) + " via external shuffle service from executor: " + execId, e);
                numRemovedBlocksFuture.complete(0);
            }
        });
        return numRemovedBlocksFuture;
    }

    @Override
    public void close() {
        this.checkInit();
        if (this.clientFactory != null) {
            this.clientFactory.close();
            this.clientFactory = null;
        }
    }
}

