/*
 * Decompiled with CFR 0.152.
 */
package spire.math.prime;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.prime.BitSet;
import spire.math.prime.BitSet$;
import spire.math.prime.FactorHeap;
import spire.math.prime.SieveSegment;
import spire.math.prime.SieveUtil;
import spire.math.prime.SieveUtil$FastFactors$;
import spire.math.prime.Siever$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0017/\u0001VB\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\"A\u0001\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005O\u0001\tE\t\u0015!\u0003K\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u001d)\u0006A1A\u0005\u0002YCaA\u0017\u0001!\u0002\u00139\u0006bB.\u0001\u0001\u0004%\t!\u0013\u0005\b9\u0002\u0001\r\u0011\"\u0001^\u0011\u0019\u0019\u0007\u0001)Q\u0005\u0015\"9A\r\u0001a\u0001\n\u0003I\u0005bB3\u0001\u0001\u0004%\tA\u001a\u0005\u0007Q\u0002\u0001\u000b\u0015\u0002&\t\u000f%\u0004!\u0019!C\u0001U\"1!\u000f\u0001Q\u0001\n-Dqa\u001d\u0001C\u0002\u0013\u0005A\u000f\u0003\u0004y\u0001\u0001\u0006I!\u001e\u0005\bs\u0002\u0001\r\u0011\"\u0001{\u0011\u001dq\b\u00011A\u0005\u0002}Dq!a\u0001\u0001A\u0003&1\u0010C\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bB\u0011\"!\u0016\u0001\u0003\u0003%\t!a\u0016\t\u0013\u0005u\u0003!%A\u0005\u0002\u0005}\u0003\"CA;\u0001E\u0005I\u0011AA<\u0011%\tY\bAA\u0001\n\u0003\ni\b\u0003\u0005\u0002\u0010\u0002\t\t\u0011\"\u0001D\u0011%\t\t\nAA\u0001\n\u0003\t\u0019\nC\u0005\u0002\u001e\u0002\t\t\u0011\"\u0011\u0002 \"I\u0011Q\u0016\u0001\u0002\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003s\u0003\u0011\u0011!C!\u0003wC\u0011\"!0\u0001\u0003\u0003%\t%a0\t\u0013\u0005\u0005\u0007!!A\u0005B\u0005\rw!CAd]\u0005\u0005\t\u0012AAe\r!ic&!A\t\u0002\u0005-\u0007BB((\t\u0003\tI\u000eC\u0005\u0002>\u001e\n\t\u0011\"\u0012\u0002@\"I\u00111\\\u0014\u0002\u0002\u0013\u0005\u0015Q\u001c\u0005\n\u0003G<\u0013\u0011!CA\u0003KD\u0011\"a>(\u0003\u0003%I!!?\u0003\rMKWM^3s\u0015\ty\u0003'A\u0003qe&lWM\u0003\u00022e\u0005!Q.\u0019;i\u0015\u0005\u0019\u0014!B:qSJ,7\u0001A\n\u0005\u0001Ybt\b\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004B]f\u0014VM\u001a\t\u0003ouJ!A\u0010\u001d\u0003\u000fA\u0013x\u000eZ;diB\u0011q\u0007Q\u0005\u0003\u0003b\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011b\u00195v].\u001c\u0016N_3\u0016\u0003\u0011\u0003\"aN#\n\u0005\u0019C$aA%oi\u0006Q1\r[;oWNK'0\u001a\u0011\u0002\r\r,Ho\u001c4g+\u0005Q\u0005CA&M\u001b\u0005\u0001\u0014BA'1\u0005!\u0019\u0016MZ3M_:<\u0017aB2vi>4g\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007E\u001bF\u000b\u0005\u0002S\u00015\ta\u0006C\u0003C\u000b\u0001\u0007A\tC\u0003I\u000b\u0001\u0007!*A\u0002beJ,\u0012a\u0016\t\u0003%bK!!\u0017\u0018\u0003\r\tKGoU3u\u0003\u0011\t'O\u001d\u0011\u0002\u000bM$\u0018M\u001d;\u0002\u0013M$\u0018M\u001d;`I\u0015\fHC\u00010b!\t9t,\u0003\u0002aq\t!QK\\5u\u0011\u001d\u0011\u0017\"!AA\u0002)\u000b1\u0001\u001f\u00132\u0003\u0019\u0019H/\u0019:uA\u0005)A.[7ji\u0006IA.[7ji~#S-\u001d\u000b\u0003=\u001eDqA\u0019\u0007\u0002\u0002\u0003\u0007!*\u0001\u0004mS6LG\u000fI\u0001\u0006M\u0006\u001cH/]\u000b\u0002WB\u0011An\u001c\b\u0003%6L!A\u001c\u0018\u0002\u0013MKWM^3Vi&d\u0017B\u00019r\u0005-1\u0015m\u001d;GC\u000e$xN]:\u000b\u00059t\u0013A\u00024bgR\f\b%A\u0003tY><\u0018/F\u0001v!\t\u0011f/\u0003\u0002x]\tQa)Y2u_JDU-\u00199\u0002\rMdwn^9!\u0003\u0015\u0019\u0018.\u001a<f+\u0005Y\bC\u0001*}\u0013\tihF\u0001\u0007TS\u00164XmU3h[\u0016tG/A\u0005tS\u00164Xm\u0018\u0013fcR\u0019a,!\u0001\t\u000f\t\u001c\u0012\u0011!a\u0001w\u000611/[3wK\u0002\nA\u0002\\1sO\u0016\u001cHOQ3m_^$2ASA\u0005\u0011\u0019\tY!\u0006a\u0001\u0015\u0006\ta.A\u0002oi\"$2ASA\t\u0011\u001d\tYA\u0006a\u0001\u0003'\u00012aNA\u000b\u0013\r\t9\u0002\u000f\u0002\u0005\u0019>tw-A\u0007j]&$h*\u001a=u'&,g/\u001a\u000b\u0002=\u0006Ia.\u001a=u\u0003\u001a$XM\u001d\u000b\u0004\u0015\u0006\u0005\u0002BBA\u00061\u0001\u0007!*A\u0006tiJ,\u0017-\\!gi\u0016\u0014H\u0003BA\u0014\u0003\u007f\u0001R!!\u000b\u0002:)sA!a\u000b\u000269!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022Q\na\u0001\u0010:p_Rt\u0014\"A\u001d\n\u0007\u0005]\u0002(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0012Q\b\u0002\u0007'R\u0014X-Y7\u000b\u0007\u0005]\u0002\b\u0003\u0004\u0002Be\u0001\rAS\u0001\u0003aB\nq!\u0019:sCf\fE\u000f\u0006\u0004\u0002H\u00055\u0013\u0011\u000b\t\u0005o\u0005%#*C\u0002\u0002La\u0012Q!\u0011:sCfDa!a\u0014\u001b\u0001\u0004Q\u0015!\u00019\t\r\u0005M#\u00041\u0001E\u0003\u0011\u0019\u0018N_3\u0002\t\r|\u0007/\u001f\u000b\u0006#\u0006e\u00131\f\u0005\b\u0005n\u0001\n\u00111\u0001E\u0011\u001dA5\u0004%AA\u0002)\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002b)\u001aA)a\u0019,\u0005\u0005\u0015\u0004\u0003BA4\u0003cj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001c9\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\nIGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002z)\u001a!*a\u0019\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\b\u0005\u0003\u0002\u0002\u0006-UBAAB\u0015\u0011\t))a\"\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\u000bAA[1wC&!\u0011QRAB\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAK\u00037\u00032aNAL\u0013\r\tI\n\u000f\u0002\u0004\u0003:L\bb\u00022!\u0003\u0003\u0005\r\u0001R\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0015\t\u0007\u0003G\u000bI+!&\u000e\u0005\u0005\u0015&bAATq\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0016Q\u0015\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00022\u0006]\u0006cA\u001c\u00024&\u0019\u0011Q\u0017\u001d\u0003\u000f\t{w\u000e\\3b]\"A!MIA\u0001\u0002\u0004\t)*\u0001\u0005iCND7i\u001c3f)\u0005!\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0014AB3rk\u0006d7\u000f\u0006\u0003\u00022\u0006\u0015\u0007\u0002\u00032&\u0003\u0003\u0005\r!!&\u0002\rMKWM^3s!\t\u0011ve\u0005\u0003(\u0003\u001b|\u0004cBAh\u0003+$%*U\u0007\u0003\u0003#T1!a59\u0003\u001d\u0011XO\u001c;j[\u0016LA!a6\u0002R\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005%\u0017!B1qa2LH#B)\u0002`\u0006\u0005\b\"\u0002\"+\u0001\u0004!\u0005\"\u0002%+\u0001\u0004Q\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003O\f\u0019\u0010E\u00038\u0003S\fi/C\u0002\u0002lb\u0012aa\u00149uS>t\u0007#B\u001c\u0002p\u0012S\u0015bAAyq\t1A+\u001e9mKJB\u0001\"!>,\u0003\u0003\u0005\r!U\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a?\u0011\t\u0005\u0005\u0015Q`\u0005\u0005\u0003\u007f\f\u0019I\u0001\u0004PE*,7\r\u001e")
public class Siever
implements Product,
scala.Serializable {
    private final int chunkSize;
    private final SafeLong cutoff;
    private final BitSet arr;
    private SafeLong start;
    private SafeLong limit;
    private final SieveUtil.FastFactors fastq;
    private final FactorHeap slowq;
    private SieveSegment sieve;

    public static Option<Tuple2<Object, SafeLong>> unapply(Siever siever) {
        return Siever$.MODULE$.unapply(siever);
    }

    public static Siever apply(int n, SafeLong safeLong) {
        return Siever$.MODULE$.apply(n, safeLong);
    }

    public static Function1<Tuple2<Object, SafeLong>, Siever> tupled() {
        return Siever$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<SafeLong, Siever>> curried() {
        return Siever$.MODULE$.curried();
    }

    public int chunkSize() {
        return this.chunkSize;
    }

    public SafeLong cutoff() {
        return this.cutoff;
    }

    public BitSet arr() {
        return this.arr;
    }

    public SafeLong start() {
        return this.start;
    }

    public void start_$eq(SafeLong x$1) {
        this.start = x$1;
    }

    public SafeLong limit() {
        return this.limit;
    }

    public void limit_$eq(SafeLong x$1) {
        this.limit = x$1;
    }

    public SieveUtil.FastFactors fastq() {
        return this.fastq;
    }

    public FactorHeap slowq() {
        return this.slowq;
    }

    public SieveSegment sieve() {
        return this.sieve;
    }

    public void sieve_$eq(SieveSegment x$1) {
        this.sieve = x$1;
    }

    public SafeLong largestBelow(SafeLong n) {
        if (n.$less((Object)SafeLong$.MODULE$.apply(3L))) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("invalid argument: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        if (BoxesRunTime.equalsNumObject((Number)((Object)n), (Object)BoxesRunTime.boxToInteger((int)3))) {
            return SafeLong$.MODULE$.apply(2L);
        }
        int i = 3;
        SafeLong k = n.$minus(1L);
        SafeLong last = SafeLong$.MODULE$.apply(2L);
        while (true) {
            int i2;
            BitSet primes = this.sieve().primes();
            int len = primes.length();
            if (n.$minus(this.start()).$less((Object)SafeLong$.MODULE$.apply(len))) {
                int goal = n.$minus(this.start()).toInt();
                for (int i3 = 1; i3 < goal; i3 += 2) {
                    if (!primes.apply(i3)) continue;
                    last = this.start().$plus(i3);
                }
                return last;
            }
            for (i2 = len - 1; 1 <= i2 && !primes.apply(i2); i2 -= 2) {
            }
            if (1 <= i2) {
                last = this.start().$plus(i2);
            }
            this.initNextSieve();
            i = 1;
        }
    }

    public SafeLong nth(long n) {
        if (n == 1L) {
            return SafeLong$.MODULE$.apply(2L);
        }
        int i = 3;
        long k = n - 1L;
        while (true) {
            BitSet primes = this.sieve().primes();
            int len = primes.length();
            while (i < len) {
                if (primes.apply(i) && --k < 1L) {
                    return this.sieve().start().$plus(i);
                }
                i += 2;
            }
            this.initNextSieve();
            i = 1;
        }
    }

    private void initNextSieve() {
        this.start_$eq(this.start().$plus(this.chunkSize()));
        this.limit_$eq(this.limit().$plus(this.chunkSize()));
        SafeLong csq = this.cutoff().$times$times(2);
        if (this.limit().$greater$eq((Object)csq)) {
            throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("too big: %s > %s (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.limit(), csq, this.cutoff()})));
        }
        this.arr().clear();
        this.sieve_$eq(new SieveSegment(this.start(), this.arr(), this.cutoff()));
        this.sieve().init(this.fastq(), this.slowq());
    }

    /*
     * WARNING - void declaration
     */
    public SafeLong nextAfter(SafeLong n) {
        void var2_2;
        SafeLong nn = this.sieve().nextAfter(n);
        while (BoxesRunTime.equalsNumObject((Number)((Object)nn), (Object)BoxesRunTime.boxToLong((long)-1L))) {
            this.initNextSieve();
            nn = this.sieve().nextAfter(this.start().$minus(1L));
        }
        return var2_2;
    }

    public Stream<SafeLong> streamAfter(SafeLong p0) {
        SafeLong p;
        SafeLong safeLong = p = this.nextAfter(p0);
        return Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> this.streamAfter(p)).$hash$colon$colon((Object)safeLong);
    }

    /*
     * WARNING - void declaration
     */
    public SafeLong[] arrayAt(SafeLong p, int size) {
        void var3_3;
        SafeLong[] arr = new SafeLong[size];
        this.loop$1(0, p, arr);
        return var3_3;
    }

    public Siever copy(int chunkSize, SafeLong cutoff) {
        return new Siever(chunkSize, cutoff);
    }

    public int copy$default$1() {
        return this.chunkSize();
    }

    public SafeLong copy$default$2() {
        return this.cutoff();
    }

    public String productPrefix() {
        return "Siever";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.chunkSize());
                break;
            }
            case 1: {
                object = this.cutoff();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Siever;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.chunkSize());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)((Object)this.cutoff())));
        return Statics.finalizeHash((int)n, (int)2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Siever)) return false;
        boolean bl = true;
        if (!bl) return false;
        Siever siever = (Siever)x$1;
        if (this.chunkSize() != siever.chunkSize()) return false;
        if (!BoxesRunTime.equalsNumNum((Number)((Object)this.cutoff()), (Number)((Object)siever.cutoff()))) return false;
        if (!siever.canEqual(this)) return false;
        return true;
    }

    private final void loop$1(int i, SafeLong p, SafeLong[] arr$1) {
        while (i < arr$1.length) {
            arr$1[i] = p;
            p = this.nextAfter(p);
            ++i;
        }
    }

    public Siever(int chunkSize, SafeLong cutoff) {
        this.chunkSize = chunkSize;
        this.cutoff = cutoff;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(chunkSize % 480 == 0, (Function0 & Serializable & scala.Serializable)() -> "chunkSize must be a multiple of 480");
        this.arr = BitSet$.MODULE$.alloc(chunkSize);
        this.start = SafeLong$.MODULE$.apply(0L);
        this.limit = this.start().$plus(chunkSize);
        this.fastq = SieveUtil$FastFactors$.MODULE$.empty();
        this.slowq = new FactorHeap();
        this.sieve = new SieveSegment(this.start(), this.arr(), cutoff);
        this.sieve().init(this.fastq(), this.slowq());
    }
}

