/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.examples.LocalLR;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public final class LocalLR$ {
    public static LocalLR$ MODULE$;
    private final int N;
    private final int D;
    private final double R;
    private final int ITERATIONS;
    private final Random rand;

    static {
        new LocalLR$();
    }

    public int N() {
        return this.N;
    }

    public int D() {
        return this.D;
    }

    public double R() {
        return this.R;
    }

    public int ITERATIONS() {
        return this.ITERATIONS;
    }

    public Random rand() {
        return this.rand;
    }

    public LocalLR.DataPoint[] generateData() {
        return (LocalLR.DataPoint[])Array$.MODULE$.tabulate(this.N(), (Function1 & Serializable & scala.Serializable)i -> this.generatePoint$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(LocalLR.DataPoint.class));
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of Logistic Regression and is given as an example!\n        |Please use org.apache.spark.ml.classification.LogisticRegression\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        this.showWarning();
        LocalLR.DataPoint[] data = this.generateData();
        DenseVector w = DenseVector$.MODULE$.fill$mDc$sp(this.D(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> (double)2 * MODULE$.rand().nextDouble() - 1.0, ClassTag$.MODULE$.Double());
        Predef$.MODULE$.println((Object)new StringBuilder(11).append("Initial w: ").append(w).toString());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.ITERATIONS()).foreach((Function1 & Serializable & scala.Serializable)i -> LocalLR$.$anonfun$main$2(data, w, BoxesRunTime.unboxToInt((Object)i)));
        Predef$.MODULE$.println((Object)new StringBuilder(9).append("Final w: ").append(w).toString());
    }

    private final LocalLR.DataPoint generatePoint$1(int i) {
        int y = i % 2 == 0 ? -1 : 1;
        DenseVector x = DenseVector$.MODULE$.fill$mDc$sp(this.D(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> MODULE$.rand().nextGaussian() + (double)y * MODULE$.R(), ClassTag$.MODULE$.Double());
        return new LocalLR.DataPoint((Vector<Object>)x, y);
    }

    public static final /* synthetic */ DenseVector $anonfun$main$2(LocalLR.DataPoint[] data$1, DenseVector w$1, int i) {
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("On iteration ").append(i).toString());
        DenseVector gradient = DenseVector$.MODULE$.zeros$mDc$sp(MODULE$.D(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data$1)).foreach((Function1 & Serializable & scala.Serializable)p -> {
            double scale = (1.0 / (1.0 + package$.MODULE$.exp(-p.y() * BoxesRunTime.unboxToDouble((Object)w$1.dot(p.x(), DenseVector$.MODULE$.canDot_DV_V_Double())))) - 1.0) * p.y();
            return (DenseVector)gradient.$plus$eq(p.x().$times((Object)BoxesRunTime.boxToDouble((double)scale), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()), (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
        });
        return (DenseVector)w$1.$minus$eq((Object)gradient, DenseVector$.MODULE$.canSubIntoD());
    }

    private LocalLR$() {
        MODULE$ = this;
        this.N = 10000;
        this.D = 10;
        this.R = 0.7;
        this.ITERATIONS = 5;
        this.rand = new Random(42L);
    }
}

