/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Locale;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.LDAExample;
import org.apache.spark.examples.mllib.LDAExample$;
import org.apache.spark.examples.mllib.LDAExample$Params$;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.feature.CountVectorizer;
import org.apache.spark.ml.feature.CountVectorizerModel;
import org.apache.spark.ml.feature.RegexTokenizer;
import org.apache.spark.ml.feature.StopWordsRemover;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class LDAExample$ {
    public static LDAExample$ MODULE$;

    static {
        new LDAExample$();
    }

    public void main(String[] args) {
        LDAExample.Params defaultParams = new LDAExample.Params(LDAExample$Params$.MODULE$.apply$default$1(), LDAExample$Params$.MODULE$.apply$default$2(), LDAExample$Params$.MODULE$.apply$default$3(), LDAExample$Params$.MODULE$.apply$default$4(), LDAExample$Params$.MODULE$.apply$default$5(), LDAExample$Params$.MODULE$.apply$default$6(), LDAExample$Params$.MODULE$.apply$default$7(), LDAExample$Params$.MODULE$.apply$default$8(), LDAExample$Params$.MODULE$.apply$default$9(), LDAExample$Params$.MODULE$.apply$default$10());
        OptionParser<LDAExample.Params> parser = new OptionParser<LDAExample.Params>(defaultParams){

            public static final /* synthetic */ LDAExample.Params $anonfun$new$1(int x, LDAExample.Params c) {
                int x$1 = x;
                Seq<String> x$2 = c.copy$default$1();
                int x$3 = c.copy$default$3();
                double x$4 = c.copy$default$4();
                double x$5 = c.copy$default$5();
                int x$6 = c.copy$default$6();
                String x$7 = c.copy$default$7();
                String x$8 = c.copy$default$8();
                Option<String> x$9 = c.copy$default$9();
                int x$10 = c.copy$default$10();
                return c.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
            }

            public static final /* synthetic */ LDAExample.Params $anonfun$new$2(int x, LDAExample.Params c) {
                int x$11 = x;
                Seq<String> x$12 = c.copy$default$1();
                int x$13 = c.copy$default$2();
                double x$14 = c.copy$default$4();
                double x$15 = c.copy$default$5();
                int x$16 = c.copy$default$6();
                String x$17 = c.copy$default$7();
                String x$18 = c.copy$default$8();
                Option<String> x$19 = c.copy$default$9();
                int x$20 = c.copy$default$10();
                return c.copy(x$12, x$13, x$11, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
            }

            public static final /* synthetic */ LDAExample.Params $anonfun$new$3(double x, LDAExample.Params c) {
                double x$21 = x;
                Seq<String> x$22 = c.copy$default$1();
                int x$23 = c.copy$default$2();
                int x$24 = c.copy$default$3();
                double x$25 = c.copy$default$5();
                int x$26 = c.copy$default$6();
                String x$27 = c.copy$default$7();
                String x$28 = c.copy$default$8();
                Option<String> x$29 = c.copy$default$9();
                int x$30 = c.copy$default$10();
                return c.copy(x$22, x$23, x$24, x$21, x$25, x$26, x$27, x$28, x$29, x$30);
            }

            public static final /* synthetic */ LDAExample.Params $anonfun$new$4(double x, LDAExample.Params c) {
                double x$31 = x;
                Seq<String> x$32 = c.copy$default$1();
                int x$33 = c.copy$default$2();
                int x$34 = c.copy$default$3();
                double x$35 = c.copy$default$4();
                int x$36 = c.copy$default$6();
                String x$37 = c.copy$default$7();
                String x$38 = c.copy$default$8();
                Option<String> x$39 = c.copy$default$9();
                int x$40 = c.copy$default$10();
                return c.copy(x$32, x$33, x$34, x$35, x$31, x$36, x$37, x$38, x$39, x$40);
            }

            public static final /* synthetic */ LDAExample.Params $anonfun$new$5(int x, LDAExample.Params c) {
                int x$41 = x;
                Seq<String> x$42 = c.copy$default$1();
                int x$43 = c.copy$default$2();
                int x$44 = c.copy$default$3();
                double x$45 = c.copy$default$4();
                double x$46 = c.copy$default$5();
                String x$47 = c.copy$default$7();
                String x$48 = c.copy$default$8();
                Option<String> x$49 = c.copy$default$9();
                int x$50 = c.copy$default$10();
                return c.copy(x$42, x$43, x$44, x$45, x$46, x$41, x$47, x$48, x$49, x$50);
            }

            public static final /* synthetic */ LDAExample.Params $anonfun$new$9(int x, LDAExample.Params c) {
                int x$81 = x;
                Seq<String> x$82 = c.copy$default$1();
                int x$83 = c.copy$default$2();
                int x$84 = c.copy$default$3();
                double x$85 = c.copy$default$4();
                double x$86 = c.copy$default$5();
                int x$87 = c.copy$default$6();
                String x$88 = c.copy$default$7();
                String x$89 = c.copy$default$8();
                Option<String> x$90 = c.copy$default$9();
                return c.copy(x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$81);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDAExample: an example LDA app for plain text data."}));
                this.opt("k", Read$.MODULE$.intRead()).text(new StringBuilder(27).append("number of topics. default: ").append(defaultParams$1.k()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("maxIterations", Read$.MODULE$.intRead()).text(new StringBuilder(43).append("number of iterations of learning. default: ").append(defaultParams$1.maxIterations()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("docConcentration", Read$.MODULE$.doubleRead()).text(new StringBuilder(62).append("amount of topic smoothing to use (> 1.0) (-1=auto).").append("  default: ").append(defaultParams$1.docConcentration()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("topicConcentration", Read$.MODULE$.doubleRead()).text(new StringBuilder(68).append("amount of term (word) smoothing to use (> 1.0) (-1=auto).").append("  default: ").append(defaultParams$1.topicConcentration()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$4(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("vocabSize", Read$.MODULE$.intRead()).text(new StringBuilder(78).append("number of distinct word types to use, chosen by frequency. (-1=all)").append("  default: ").append(defaultParams$1.vocabSize()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("stopwordFile", Read$.MODULE$.stringRead()).text(new StringBuilder(85).append("filepath for a list of stopwords. Note: This must fit on a single machine.").append("  default: ").append(defaultParams$1.stopwordFile()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$51 = x;
                    Seq<String> x$52 = c.copy$default$1();
                    int x$53 = c.copy$default$2();
                    int x$54 = c.copy$default$3();
                    double x$55 = c.copy$default$4();
                    double x$56 = c.copy$default$5();
                    int x$57 = c.copy$default$6();
                    String x$58 = c.copy$default$8();
                    Option<String> x$59 = c.copy$default$9();
                    int x$60 = c.copy$default$10();
                    return c.copy(x$52, x$53, x$54, x$55, x$56, x$57, x$51, x$58, x$59, x$60);
                });
                this.opt("algorithm", Read$.MODULE$.stringRead()).text(new StringBuilder(66).append("inference algorithm to use. em and online are supported.").append(" default: ").append(defaultParams$1.algorithm()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$61 = x;
                    Seq<String> x$62 = c.copy$default$1();
                    int x$63 = c.copy$default$2();
                    int x$64 = c.copy$default$3();
                    double x$65 = c.copy$default$4();
                    double x$66 = c.copy$default$5();
                    int x$67 = c.copy$default$6();
                    String x$68 = c.copy$default$7();
                    Option<String> x$69 = c.copy$default$9();
                    int x$70 = c.copy$default$10();
                    return c.copy(x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$61, x$69, x$70);
                });
                this.opt("checkpointDir", Read$.MODULE$.stringRead()).text(new StringBuilder(143).append("Directory for checkpointing intermediate results.").append("  Checkpointing helps with recovery and eliminates temporary shuffle files on disk.").append("  default: ").append(defaultParams$1.checkpointDir()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    Some x$71 = new Some(x);
                    Seq<String> x$72 = c.copy$default$1();
                    int x$73 = c.copy$default$2();
                    int x$74 = c.copy$default$3();
                    double x$75 = c.copy$default$4();
                    double x$76 = c.copy$default$5();
                    int x$77 = c.copy$default$6();
                    String x$78 = c.copy$default$7();
                    String x$79 = c.copy$default$8();
                    int x$80 = c.copy$default$10();
                    return c.copy(x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, (Option<String>)x$71, x$80);
                });
                this.opt("checkpointInterval", Read$.MODULE$.intRead()).text(new StringBuilder(81).append("Iterations between each checkpoint.  Only used if checkpointDir is set.").append(" default: ").append(defaultParams$1.checkpointInterval()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)x), c));
                this.arg("<input>...", Read$.MODULE$.stringRead()).text("input paths (directories) to plain text corpora.  Each text file line should hold 1 document.").unbounded().required().action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((Seq<String>)((Seq)c.input().$colon$plus(x, Seq$.MODULE$.canBuildFrom())), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$4$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$5$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$6(java.lang.String org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$7(java.lang.String org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$8(java.lang.String org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$9$adapted(java.lang.Object org.apache.spark.examples.mllib.LDAExample$Params ), $anonfun$new$10(java.lang.String org.apache.spark.examples.mllib.LDAExample$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        LDAExample.Params params = (LDAExample.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void run(LDAExample.Params params) {
        EMLDAOptimizer eMLDAOptimizer;
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(16).append("LDAExample with ").append(params).toString());
        SparkContext sc = new SparkContext(conf);
        Logger.getRootLogger().setLevel(Level.WARN);
        long preprocessStart = System.nanoTime();
        Tuple3<RDD<Tuple2<Object, Vector>>, String[], Object> tuple3 = this.preprocess(sc, params.input(), params.vocabSize(), params.stopwordFile());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        RDD corpus = (RDD)tuple3._1();
        String[] vocabArray = (String[])tuple3._2();
        long actualNumTokens = BoxesRunTime.unboxToLong((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)corpus, (Object)vocabArray, (Object)BoxesRunTime.boxToLong((long)actualNumTokens));
        Tuple3 tuple33 = tuple32;
        RDD corpus2 = (RDD)tuple33._1();
        String[] vocabArray2 = (String[])tuple33._2();
        long actualNumTokens2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
        corpus2.cache();
        long actualCorpusSize = corpus2.count();
        int actualVocabSize = vocabArray2.length;
        double preprocessElapsed = (double)(System.nanoTime() - preprocessStart) / 1.0E9;
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Corpus summary:");
        Predef$.MODULE$.println((Object)new StringBuilder(31).append("\t Training set size: ").append(actualCorpusSize).append(" documents").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(25).append("\t Vocabulary size: ").append(actualVocabSize).append(" terms").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(28).append("\t Training set size: ").append(actualNumTokens2).append(" tokens").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("\t Preprocessing time: ").append(preprocessElapsed).append(" sec").toString());
        Predef$.MODULE$.println();
        LDA lda = new LDA();
        String string = params.algorithm().toLowerCase(Locale.ROOT);
        if ("em".equals(string)) {
            eMLDAOptimizer = new EMLDAOptimizer();
        } else if ("online".equals(string)) {
            eMLDAOptimizer = new OnlineLDAOptimizer().setMiniBatchFraction(0.05 + 1.0 / (double)actualCorpusSize);
        } else {
            throw new IllegalArgumentException(new StringBuilder(39).append("Only em, online are supported but got ").append(params.algorithm()).append(".").toString());
        }
        EMLDAOptimizer optimizer = eMLDAOptimizer;
        lda.setOptimizer((LDAOptimizer)optimizer).setK(params.k()).setMaxIterations(params.maxIterations()).setDocConcentration(params.docConcentration()).setTopicConcentration(params.topicConcentration()).setCheckpointInterval(params.checkpointInterval());
        if (params.checkpointDir().nonEmpty()) {
            sc.setCheckpointDir((String)params.checkpointDir().get());
        }
        long startTime = System.nanoTime();
        LDAModel ldaModel = lda.run(corpus2);
        double elapsed = (double)(System.nanoTime() - startTime) / 1.0E9;
        Predef$.MODULE$.println((Object)"Finished training LDA model.  Summary:");
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("\t Training time: ").append(elapsed).append(" sec").toString());
        if (ldaModel instanceof DistributedLDAModel) {
            DistributedLDAModel distLDAModel = (DistributedLDAModel)ldaModel;
            double avgLogLikelihood = distLDAModel.logLikelihood() / (double)actualCorpusSize;
            Predef$.MODULE$.println((Object)new StringBuilder(40).append("\t Training data average log likelihood: ").append(avgLogLikelihood).toString());
            Predef$.MODULE$.println();
        }
        Tuple2[] topicIndices = ldaModel.describeTopics(10);
        Tuple2[][] topics = (Tuple2[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicIndices)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int[] terms = (int[])tuple2._1();
            double[] termWeights = (double[])tuple2._2();
            Tuple2[] tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(terms)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(termWeights), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int term = tuple2._1$mcI$sp();
                double weight = tuple2._2$mcD$sp();
                Tuple2 tuple22 = new Tuple2((Object)vocabArray2[term], (Object)BoxesRunTime.boxToDouble((double)weight));
                return tuple22;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            return tuple2Array;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class))));
        Predef$.MODULE$.println((Object)new StringBuilder(8).append(params.k()).append(" topics:").toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topics)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LDAExample$.$anonfun$run$3(x0$3);
            return BoxedUnit.UNIT;
        });
        sc.stop();
    }

    private Tuple3<RDD<Tuple2<Object, Vector>>, String[], Object> preprocess(SparkContext sc, Seq<String> paths, int vocabSize, String stopwordFile) {
        String[] stringArray;
        SparkSession spark = SparkSession$.MODULE$.builder().sparkContext(sc).getOrCreate();
        Dataset df = spark.implicits().rddToDatasetHolder(sc.textFile(paths.mkString(","), sc.textFile$default$2()), spark.implicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"docs"}));
        if (stopwordFile.isEmpty()) {
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        } else {
            String[] stopWordText = (String[])sc.textFile(stopwordFile, sc.textFile$default$2()).collect();
            stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stopWordText)).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$2)).stripMargin().split("\\s+"))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        }
        String[] customizedStopWords = stringArray;
        RegexTokenizer tokenizer = (RegexTokenizer)new RegexTokenizer().setInputCol("docs").setOutputCol("rawTokens");
        StopWordsRemover stopWordsRemover = new StopWordsRemover().setInputCol("rawTokens").setOutputCol("tokens");
        stopWordsRemover.setStopWords((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stopWordsRemover.getStopWords())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])customizedStopWords)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        CountVectorizer countVectorizer = new CountVectorizer().setVocabSize(vocabSize).setInputCol("tokens").setOutputCol("features");
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{tokenizer, stopWordsRemover, countVectorizer}));
        PipelineModel model = pipeline.fit(df);
        RDD documents = model.transform(df).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object features;
            Row row = x0$1;
            Some some = Row$.MODULE$.unapplySeq(row);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((features = ((SeqLike)some.get()).apply(0)) instanceof org.apache.spark.ml.linalg.Vector)) {
                throw new MatchError((Object)row);
            }
            org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)features;
            Vector vector2 = Vectors$.MODULE$.fromML(vector);
            return vector2;
        }, ClassTag$.MODULE$.apply(Vector.class)).zipWithIndex().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.swap(), ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple3((Object)documents, (Object)((CountVectorizerModel)model.stages()[2]).vocabulary(), (Object)BoxesRunTime.boxToLong((long)((long)RDD$.MODULE$.numericRDDToDoubleRDDFunctions(documents.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)LDAExample$.$anonfun$preprocess$4(x$4)), ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).sum())));
    }

    public static final /* synthetic */ void $anonfun$run$4(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String term = (String)tuple2._1();
        double weight = tuple2._2$mcD$sp();
        Predef$.MODULE$.println((Object)new StringBuilder(1).append(term).append("\t").append(weight).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$run$3(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2[] topic = (Tuple2[])tuple2._1();
        int i = tuple2._2$mcI$sp();
        Predef$.MODULE$.println((Object)new StringBuilder(6).append("TOPIC ").append(i).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topic)).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            LDAExample$.$anonfun$run$4(x0$4);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$preprocess$4(Tuple2 x$4) {
        return ((Vector)x$4._2()).numActives();
    }

    private LDAExample$() {
        MODULE$ = this;
    }
}

