/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql;

import java.io.Serializable;
import java.util.Properties;
import org.apache.spark.examples.sql.SQLDataSourceExample$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class SQLDataSourceExample$ {
    public static SQLDataSourceExample$ MODULE$;

    static {
        new SQLDataSourceExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Spark SQL data sources example").config("spark.some.config.option", "some-value").getOrCreate();
        this.runBasicDataSourceExample(spark);
        this.runGenericFileSourceOptionsExample(spark);
        this.runBasicParquetExample(spark);
        this.runParquetSchemaMergingExample(spark);
        this.runJsonDatasetExample(spark);
        this.runJdbcDatasetExample(spark);
        spark.stop();
    }

    private void runGenericFileSourceOptionsExample(SparkSession spark) {
        spark.sql("set spark.sql.files.ignoreCorruptFiles=true");
        Dataset testCorruptDF = spark.read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"examples/src/main/resources/dir1/", "examples/src/main/resources/dir1/dir2/"}));
        testCorruptDF.show();
        Dataset recursiveLoadedDF = spark.read().format("parquet").option("recursiveFileLookup", "true").load("examples/src/main/resources/dir1");
        recursiveLoadedDF.show();
        spark.sql("set spark.sql.files.ignoreCorruptFiles=false");
        Dataset testGlobFilterDF = spark.read().format("parquet").option("pathGlobFilter", "*.parquet").load("examples/src/main/resources/dir1");
        testGlobFilterDF.show();
        Dataset beforeFilterDF = spark.read().format("parquet").option("modifiedBefore", "2020-07-01T05:30:00").load("examples/src/main/resources/dir1");
        beforeFilterDF.show();
        Dataset afterFilterDF = spark.read().format("parquet").option("modifiedAfter", "2020-06-01T05:30:00").load("examples/src/main/resources/dir1");
        afterFilterDF.show();
    }

    private void runBasicDataSourceExample(SparkSession spark) {
        Dataset usersDF = spark.read().load("examples/src/main/resources/users.parquet");
        usersDF.select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"favorite_color"})).write().save("namesAndFavColors.parquet");
        Dataset peopleDF = spark.read().format("json").load("examples/src/main/resources/people.json");
        peopleDF.select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"age"})).write().format("parquet").save("namesAndAges.parquet");
        Dataset peopleDFCsv = spark.read().format("csv").option("sep", ";").option("inferSchema", "true").option("header", "true").load("examples/src/main/resources/people.csv");
        usersDF.write().format("orc").option("orc.bloom.filter.columns", "favorite_color").option("orc.dictionary.key.threshold", "1.0").option("orc.column.encoding.direct", "name").save("users_with_options.orc");
        Dataset sqlDF = spark.sql("SELECT * FROM parquet.`examples/src/main/resources/users.parquet`");
        peopleDF.write().bucketBy(42, "name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sortBy("age", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("people_bucketed");
        usersDF.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"favorite_color"})).format("parquet").save("namesPartByColor.parquet");
        usersDF.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"favorite_color"})).bucketBy(42, "name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("users_partitioned_bucketed");
        spark.sql("DROP TABLE IF EXISTS people_bucketed");
        spark.sql("DROP TABLE IF EXISTS users_partitioned_bucketed");
    }

    private void runBasicParquetExample(SparkSession spark) {
        Dataset peopleDF = spark.read().json("examples/src/main/resources/people.json");
        peopleDF.write().parquet("people.parquet");
        Dataset parquetFileDF = spark.read().parquet("people.parquet");
        parquetFileDF.createOrReplaceTempView("parquetFile");
        Dataset namesDF = spark.sql("SELECT name FROM parquetFile WHERE age BETWEEN 13 AND 19");
        namesDF.map((Function1 & Serializable & scala.Serializable)attributes -> new StringBuilder(6).append("Name: ").append(attributes.apply(0)).toString(), spark.implicits().newStringEncoder()).show();
    }

    private void runParquetSchemaMergingExample(SparkSession spark) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator5$1() {
            }
        }
        Dataset squaresDF = spark.implicits().rddToDatasetHolder(spark.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5), spark.sparkContext().makeRDD$default$2(), ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)i -> SQLDataSourceExample$.$anonfun$runParquetSchemaMergingExample$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator5$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "square"}));
        squaresDF.write().parquet("data/test_table/key=1");
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator13$1() {
            }
        }
        Dataset cubesDF = spark.implicits().rddToDatasetHolder(spark.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10), spark.sparkContext().makeRDD$default$2(), ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)i -> SQLDataSourceExample$.$anonfun$runParquetSchemaMergingExample$2(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_sql_SQLDataSourceExample$$typecreator13$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "cube"}));
        cubesDF.write().parquet("data/test_table/key=2");
        Dataset mergedDF = spark.read().option("mergeSchema", "true").parquet("data/test_table");
        mergedDF.printSchema();
    }

    private void runJsonDatasetExample(SparkSession spark) {
        String path = "examples/src/main/resources/people.json";
        Dataset peopleDF = spark.read().json(path);
        peopleDF.printSchema();
        peopleDF.createOrReplaceTempView("people");
        Dataset teenagerNamesDF = spark.sql("SELECT name FROM people WHERE age BETWEEN 13 AND 19");
        teenagerNamesDF.show();
        String string = "{\"name\":\"Yin\",\"address\":{\"city\":\"Columbus\",\"state\":\"Ohio\"}}";
        Dataset otherPeopleDataset = spark.createDataset((Seq)Nil$.MODULE$.$colon$colon((Object)string), spark.implicits().newStringEncoder());
        Dataset otherPeople = spark.read().json(otherPeopleDataset);
        otherPeople.show();
    }

    private void runJdbcDatasetExample(SparkSession spark) {
        Dataset jdbcDF = spark.read().format("jdbc").option("url", "jdbc:postgresql:dbserver").option("dbtable", "schema.tablename").option("user", "username").option("password", "password").load();
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", "username");
        connectionProperties.put("password", "password");
        Dataset jdbcDF2 = spark.read().jdbc("jdbc:postgresql:dbserver", "schema.tablename", connectionProperties);
        connectionProperties.put("customSchema", "id DECIMAL(38, 0), name STRING");
        Dataset jdbcDF3 = spark.read().jdbc("jdbc:postgresql:dbserver", "schema.tablename", connectionProperties);
        jdbcDF.write().format("jdbc").option("url", "jdbc:postgresql:dbserver").option("dbtable", "schema.tablename").option("user", "username").option("password", "password").save();
        jdbcDF2.write().jdbc("jdbc:postgresql:dbserver", "schema.tablename", connectionProperties);
        jdbcDF.write().option("createTableColumnTypes", "name CHAR(64), comments VARCHAR(1024)").jdbc("jdbc:postgresql:dbserver", "schema.tablename", connectionProperties);
    }

    public static final /* synthetic */ Tuple2 $anonfun$runParquetSchemaMergingExample$1(int i) {
        return new Tuple2.mcII.sp(i, i * i);
    }

    public static final /* synthetic */ Tuple2 $anonfun$runParquetSchemaMergingExample$2(int i) {
        return new Tuple2.mcII.sp(i, i * i * i);
    }

    private SQLDataSourceExample$() {
        MODULE$ = this;
    }
}

