// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/core/v3/base.proto

package corev3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Locality with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Locality) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Locality with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in LocalityMultiError, or nil
// if none found.
func (m *Locality) ValidateAll() error {
	return m.validate(true)
}

func (m *Locality) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Region

	// no validation rules for Zone

	// no validation rules for SubZone

	if len(errors) > 0 {
		return LocalityMultiError(errors)
	}

	return nil
}

// LocalityMultiError is an error wrapping multiple validation errors returned
// by Locality.ValidateAll() if the designated constraints aren't met.
type LocalityMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LocalityMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LocalityMultiError) AllErrors() []error { return m }

// LocalityValidationError is the validation error returned by
// Locality.Validate if the designated constraints aren't met.
type LocalityValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LocalityValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LocalityValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LocalityValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LocalityValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LocalityValidationError) ErrorName() string { return "LocalityValidationError" }

// Error satisfies the builtin error interface
func (e LocalityValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLocality.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LocalityValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LocalityValidationError{}

// Validate checks the field values on BuildVersion with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *BuildVersion) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BuildVersion with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in BuildVersionMultiError, or
// nil if none found.
func (m *BuildVersion) ValidateAll() error {
	return m.validate(true)
}

func (m *BuildVersion) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetVersion()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BuildVersionValidationError{
					field:  "Version",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BuildVersionValidationError{
					field:  "Version",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetVersion()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BuildVersionValidationError{
				field:  "Version",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BuildVersionValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BuildVersionValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BuildVersionValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return BuildVersionMultiError(errors)
	}

	return nil
}

// BuildVersionMultiError is an error wrapping multiple validation errors
// returned by BuildVersion.ValidateAll() if the designated constraints aren't met.
type BuildVersionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BuildVersionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BuildVersionMultiError) AllErrors() []error { return m }

// BuildVersionValidationError is the validation error returned by
// BuildVersion.Validate if the designated constraints aren't met.
type BuildVersionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BuildVersionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BuildVersionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BuildVersionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BuildVersionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BuildVersionValidationError) ErrorName() string { return "BuildVersionValidationError" }

// Error satisfies the builtin error interface
func (e BuildVersionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBuildVersion.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BuildVersionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BuildVersionValidationError{}

// Validate checks the field values on Extension with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Extension) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Extension with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ExtensionMultiError, or nil
// if none found.
func (m *Extension) ValidateAll() error {
	return m.validate(true)
}

func (m *Extension) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Name

	// no validation rules for Category

	// no validation rules for TypeDescriptor

	if all {
		switch v := interface{}(m.GetVersion()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ExtensionValidationError{
					field:  "Version",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ExtensionValidationError{
					field:  "Version",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetVersion()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ExtensionValidationError{
				field:  "Version",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Disabled

	if len(errors) > 0 {
		return ExtensionMultiError(errors)
	}

	return nil
}

// ExtensionMultiError is an error wrapping multiple validation errors returned
// by Extension.ValidateAll() if the designated constraints aren't met.
type ExtensionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ExtensionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ExtensionMultiError) AllErrors() []error { return m }

// ExtensionValidationError is the validation error returned by
// Extension.Validate if the designated constraints aren't met.
type ExtensionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ExtensionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ExtensionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ExtensionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ExtensionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ExtensionValidationError) ErrorName() string { return "ExtensionValidationError" }

// Error satisfies the builtin error interface
func (e ExtensionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sExtension.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ExtensionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ExtensionValidationError{}

// Validate checks the field values on Node with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Node) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Node with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in NodeMultiError, or nil if none found.
func (m *Node) ValidateAll() error {
	return m.validate(true)
}

func (m *Node) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	// no validation rules for Cluster

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, NodeValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, NodeValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return NodeValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	{
		sorted_keys := make([]string, len(m.GetDynamicParameters()))
		i := 0
		for key := range m.GetDynamicParameters() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetDynamicParameters()[key]
			_ = val

			// no validation rules for DynamicParameters[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, NodeValidationError{
							field:  fmt.Sprintf("DynamicParameters[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, NodeValidationError{
							field:  fmt.Sprintf("DynamicParameters[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return NodeValidationError{
						field:  fmt.Sprintf("DynamicParameters[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if all {
		switch v := interface{}(m.GetLocality()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, NodeValidationError{
					field:  "Locality",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, NodeValidationError{
					field:  "Locality",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLocality()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return NodeValidationError{
				field:  "Locality",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for UserAgentName

	for idx, item := range m.GetExtensions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, NodeValidationError{
						field:  fmt.Sprintf("Extensions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, NodeValidationError{
						field:  fmt.Sprintf("Extensions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return NodeValidationError{
					field:  fmt.Sprintf("Extensions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetListeningAddresses() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, NodeValidationError{
						field:  fmt.Sprintf("ListeningAddresses[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, NodeValidationError{
						field:  fmt.Sprintf("ListeningAddresses[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return NodeValidationError{
					field:  fmt.Sprintf("ListeningAddresses[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	switch v := m.UserAgentVersionType.(type) {
	case *Node_UserAgentVersion:
		if v == nil {
			err := NodeValidationError{
				field:  "UserAgentVersionType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for UserAgentVersion
	case *Node_UserAgentBuildVersion:
		if v == nil {
			err := NodeValidationError{
				field:  "UserAgentVersionType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUserAgentBuildVersion()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, NodeValidationError{
						field:  "UserAgentBuildVersion",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, NodeValidationError{
						field:  "UserAgentBuildVersion",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUserAgentBuildVersion()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return NodeValidationError{
					field:  "UserAgentBuildVersion",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return NodeMultiError(errors)
	}

	return nil
}

// NodeMultiError is an error wrapping multiple validation errors returned by
// Node.ValidateAll() if the designated constraints aren't met.
type NodeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m NodeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m NodeMultiError) AllErrors() []error { return m }

// NodeValidationError is the validation error returned by Node.Validate if the
// designated constraints aren't met.
type NodeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e NodeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e NodeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e NodeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e NodeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e NodeValidationError) ErrorName() string { return "NodeValidationError" }

// Error satisfies the builtin error interface
func (e NodeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sNode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = NodeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = NodeValidationError{}

// Validate checks the field values on Metadata with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Metadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Metadata with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in MetadataMultiError, or nil
// if none found.
func (m *Metadata) ValidateAll() error {
	return m.validate(true)
}

func (m *Metadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	{
		sorted_keys := make([]string, len(m.GetFilterMetadata()))
		i := 0
		for key := range m.GetFilterMetadata() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetFilterMetadata()[key]
			_ = val

			if utf8.RuneCountInString(key) < 1 {
				err := MetadataValidationError{
					field:  fmt.Sprintf("FilterMetadata[%v]", key),
					reason: "value length must be at least 1 runes",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, MetadataValidationError{
							field:  fmt.Sprintf("FilterMetadata[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, MetadataValidationError{
							field:  fmt.Sprintf("FilterMetadata[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return MetadataValidationError{
						field:  fmt.Sprintf("FilterMetadata[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	{
		sorted_keys := make([]string, len(m.GetTypedFilterMetadata()))
		i := 0
		for key := range m.GetTypedFilterMetadata() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetTypedFilterMetadata()[key]
			_ = val

			if utf8.RuneCountInString(key) < 1 {
				err := MetadataValidationError{
					field:  fmt.Sprintf("TypedFilterMetadata[%v]", key),
					reason: "value length must be at least 1 runes",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, MetadataValidationError{
							field:  fmt.Sprintf("TypedFilterMetadata[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, MetadataValidationError{
							field:  fmt.Sprintf("TypedFilterMetadata[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return MetadataValidationError{
						field:  fmt.Sprintf("TypedFilterMetadata[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if len(errors) > 0 {
		return MetadataMultiError(errors)
	}

	return nil
}

// MetadataMultiError is an error wrapping multiple validation errors returned
// by Metadata.ValidateAll() if the designated constraints aren't met.
type MetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m MetadataMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m MetadataMultiError) AllErrors() []error { return m }

// MetadataValidationError is the validation error returned by
// Metadata.Validate if the designated constraints aren't met.
type MetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MetadataValidationError) ErrorName() string { return "MetadataValidationError" }

// Error satisfies the builtin error interface
func (e MetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MetadataValidationError{}

// Validate checks the field values on RuntimeUInt32 with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RuntimeUInt32) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RuntimeUInt32 with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RuntimeUInt32MultiError, or
// nil if none found.
func (m *RuntimeUInt32) ValidateAll() error {
	return m.validate(true)
}

func (m *RuntimeUInt32) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for DefaultValue

	if utf8.RuneCountInString(m.GetRuntimeKey()) < 1 {
		err := RuntimeUInt32ValidationError{
			field:  "RuntimeKey",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RuntimeUInt32MultiError(errors)
	}

	return nil
}

// RuntimeUInt32MultiError is an error wrapping multiple validation errors
// returned by RuntimeUInt32.ValidateAll() if the designated constraints
// aren't met.
type RuntimeUInt32MultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RuntimeUInt32MultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RuntimeUInt32MultiError) AllErrors() []error { return m }

// RuntimeUInt32ValidationError is the validation error returned by
// RuntimeUInt32.Validate if the designated constraints aren't met.
type RuntimeUInt32ValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RuntimeUInt32ValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RuntimeUInt32ValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RuntimeUInt32ValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RuntimeUInt32ValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RuntimeUInt32ValidationError) ErrorName() string { return "RuntimeUInt32ValidationError" }

// Error satisfies the builtin error interface
func (e RuntimeUInt32ValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuntimeUInt32.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RuntimeUInt32ValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RuntimeUInt32ValidationError{}

// Validate checks the field values on RuntimePercent with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RuntimePercent) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RuntimePercent with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RuntimePercentMultiError,
// or nil if none found.
func (m *RuntimePercent) ValidateAll() error {
	return m.validate(true)
}

func (m *RuntimePercent) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetDefaultValue()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RuntimePercentValidationError{
					field:  "DefaultValue",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RuntimePercentValidationError{
					field:  "DefaultValue",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDefaultValue()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RuntimePercentValidationError{
				field:  "DefaultValue",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if utf8.RuneCountInString(m.GetRuntimeKey()) < 1 {
		err := RuntimePercentValidationError{
			field:  "RuntimeKey",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RuntimePercentMultiError(errors)
	}

	return nil
}

// RuntimePercentMultiError is an error wrapping multiple validation errors
// returned by RuntimePercent.ValidateAll() if the designated constraints
// aren't met.
type RuntimePercentMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RuntimePercentMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RuntimePercentMultiError) AllErrors() []error { return m }

// RuntimePercentValidationError is the validation error returned by
// RuntimePercent.Validate if the designated constraints aren't met.
type RuntimePercentValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RuntimePercentValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RuntimePercentValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RuntimePercentValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RuntimePercentValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RuntimePercentValidationError) ErrorName() string { return "RuntimePercentValidationError" }

// Error satisfies the builtin error interface
func (e RuntimePercentValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuntimePercent.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RuntimePercentValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RuntimePercentValidationError{}

// Validate checks the field values on RuntimeDouble with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RuntimeDouble) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RuntimeDouble with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RuntimeDoubleMultiError, or
// nil if none found.
func (m *RuntimeDouble) ValidateAll() error {
	return m.validate(true)
}

func (m *RuntimeDouble) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for DefaultValue

	if utf8.RuneCountInString(m.GetRuntimeKey()) < 1 {
		err := RuntimeDoubleValidationError{
			field:  "RuntimeKey",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RuntimeDoubleMultiError(errors)
	}

	return nil
}

// RuntimeDoubleMultiError is an error wrapping multiple validation errors
// returned by RuntimeDouble.ValidateAll() if the designated constraints
// aren't met.
type RuntimeDoubleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RuntimeDoubleMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RuntimeDoubleMultiError) AllErrors() []error { return m }

// RuntimeDoubleValidationError is the validation error returned by
// RuntimeDouble.Validate if the designated constraints aren't met.
type RuntimeDoubleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RuntimeDoubleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RuntimeDoubleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RuntimeDoubleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RuntimeDoubleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RuntimeDoubleValidationError) ErrorName() string { return "RuntimeDoubleValidationError" }

// Error satisfies the builtin error interface
func (e RuntimeDoubleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuntimeDouble.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RuntimeDoubleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RuntimeDoubleValidationError{}

// Validate checks the field values on RuntimeFeatureFlag with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RuntimeFeatureFlag) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RuntimeFeatureFlag with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RuntimeFeatureFlagMultiError, or nil if none found.
func (m *RuntimeFeatureFlag) ValidateAll() error {
	return m.validate(true)
}

func (m *RuntimeFeatureFlag) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetDefaultValue() == nil {
		err := RuntimeFeatureFlagValidationError{
			field:  "DefaultValue",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetDefaultValue()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RuntimeFeatureFlagValidationError{
					field:  "DefaultValue",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RuntimeFeatureFlagValidationError{
					field:  "DefaultValue",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDefaultValue()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RuntimeFeatureFlagValidationError{
				field:  "DefaultValue",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if utf8.RuneCountInString(m.GetRuntimeKey()) < 1 {
		err := RuntimeFeatureFlagValidationError{
			field:  "RuntimeKey",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RuntimeFeatureFlagMultiError(errors)
	}

	return nil
}

// RuntimeFeatureFlagMultiError is an error wrapping multiple validation errors
// returned by RuntimeFeatureFlag.ValidateAll() if the designated constraints
// aren't met.
type RuntimeFeatureFlagMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RuntimeFeatureFlagMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RuntimeFeatureFlagMultiError) AllErrors() []error { return m }

// RuntimeFeatureFlagValidationError is the validation error returned by
// RuntimeFeatureFlag.Validate if the designated constraints aren't met.
type RuntimeFeatureFlagValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RuntimeFeatureFlagValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RuntimeFeatureFlagValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RuntimeFeatureFlagValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RuntimeFeatureFlagValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RuntimeFeatureFlagValidationError) ErrorName() string {
	return "RuntimeFeatureFlagValidationError"
}

// Error satisfies the builtin error interface
func (e RuntimeFeatureFlagValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuntimeFeatureFlag.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RuntimeFeatureFlagValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RuntimeFeatureFlagValidationError{}

// Validate checks the field values on KeyValue with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *KeyValue) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on KeyValue with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in KeyValueMultiError, or nil
// if none found.
func (m *KeyValue) ValidateAll() error {
	return m.validate(true)
}

func (m *KeyValue) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetKey()) < 1 {
		err := KeyValueValidationError{
			field:  "Key",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetKey()) > 16384 {
		err := KeyValueValidationError{
			field:  "Key",
			reason: "value length must be at most 16384 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Value

	if len(errors) > 0 {
		return KeyValueMultiError(errors)
	}

	return nil
}

// KeyValueMultiError is an error wrapping multiple validation errors returned
// by KeyValue.ValidateAll() if the designated constraints aren't met.
type KeyValueMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m KeyValueMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m KeyValueMultiError) AllErrors() []error { return m }

// KeyValueValidationError is the validation error returned by
// KeyValue.Validate if the designated constraints aren't met.
type KeyValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e KeyValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e KeyValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e KeyValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e KeyValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e KeyValueValidationError) ErrorName() string { return "KeyValueValidationError" }

// Error satisfies the builtin error interface
func (e KeyValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sKeyValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = KeyValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = KeyValueValidationError{}

// Validate checks the field values on KeyValueAppend with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *KeyValueAppend) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on KeyValueAppend with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in KeyValueAppendMultiError,
// or nil if none found.
func (m *KeyValueAppend) ValidateAll() error {
	return m.validate(true)
}

func (m *KeyValueAppend) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetEntry() == nil {
		err := KeyValueAppendValidationError{
			field:  "Entry",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetEntry()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, KeyValueAppendValidationError{
					field:  "Entry",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, KeyValueAppendValidationError{
					field:  "Entry",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntry()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return KeyValueAppendValidationError{
				field:  "Entry",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := KeyValueAppend_KeyValueAppendAction_name[int32(m.GetAction())]; !ok {
		err := KeyValueAppendValidationError{
			field:  "Action",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return KeyValueAppendMultiError(errors)
	}

	return nil
}

// KeyValueAppendMultiError is an error wrapping multiple validation errors
// returned by KeyValueAppend.ValidateAll() if the designated constraints
// aren't met.
type KeyValueAppendMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m KeyValueAppendMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m KeyValueAppendMultiError) AllErrors() []error { return m }

// KeyValueAppendValidationError is the validation error returned by
// KeyValueAppend.Validate if the designated constraints aren't met.
type KeyValueAppendValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e KeyValueAppendValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e KeyValueAppendValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e KeyValueAppendValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e KeyValueAppendValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e KeyValueAppendValidationError) ErrorName() string { return "KeyValueAppendValidationError" }

// Error satisfies the builtin error interface
func (e KeyValueAppendValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sKeyValueAppend.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = KeyValueAppendValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = KeyValueAppendValidationError{}

// Validate checks the field values on KeyValueMutation with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *KeyValueMutation) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on KeyValueMutation with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// KeyValueMutationMultiError, or nil if none found.
func (m *KeyValueMutation) ValidateAll() error {
	return m.validate(true)
}

func (m *KeyValueMutation) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetAppend()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, KeyValueMutationValidationError{
					field:  "Append",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, KeyValueMutationValidationError{
					field:  "Append",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAppend()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return KeyValueMutationValidationError{
				field:  "Append",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetRemove()) > 16384 {
		err := KeyValueMutationValidationError{
			field:  "Remove",
			reason: "value length must be at most 16384 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return KeyValueMutationMultiError(errors)
	}

	return nil
}

// KeyValueMutationMultiError is an error wrapping multiple validation errors
// returned by KeyValueMutation.ValidateAll() if the designated constraints
// aren't met.
type KeyValueMutationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m KeyValueMutationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m KeyValueMutationMultiError) AllErrors() []error { return m }

// KeyValueMutationValidationError is the validation error returned by
// KeyValueMutation.Validate if the designated constraints aren't met.
type KeyValueMutationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e KeyValueMutationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e KeyValueMutationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e KeyValueMutationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e KeyValueMutationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e KeyValueMutationValidationError) ErrorName() string { return "KeyValueMutationValidationError" }

// Error satisfies the builtin error interface
func (e KeyValueMutationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sKeyValueMutation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = KeyValueMutationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = KeyValueMutationValidationError{}

// Validate checks the field values on QueryParameter with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *QueryParameter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on QueryParameter with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in QueryParameterMultiError,
// or nil if none found.
func (m *QueryParameter) ValidateAll() error {
	return m.validate(true)
}

func (m *QueryParameter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetKey()) < 1 {
		err := QueryParameterValidationError{
			field:  "Key",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Value

	if len(errors) > 0 {
		return QueryParameterMultiError(errors)
	}

	return nil
}

// QueryParameterMultiError is an error wrapping multiple validation errors
// returned by QueryParameter.ValidateAll() if the designated constraints
// aren't met.
type QueryParameterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m QueryParameterMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m QueryParameterMultiError) AllErrors() []error { return m }

// QueryParameterValidationError is the validation error returned by
// QueryParameter.Validate if the designated constraints aren't met.
type QueryParameterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e QueryParameterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e QueryParameterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e QueryParameterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e QueryParameterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e QueryParameterValidationError) ErrorName() string { return "QueryParameterValidationError" }

// Error satisfies the builtin error interface
func (e QueryParameterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sQueryParameter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = QueryParameterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = QueryParameterValidationError{}

// Validate checks the field values on HeaderValue with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HeaderValue) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderValue with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HeaderValueMultiError, or
// nil if none found.
func (m *HeaderValue) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderValue) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetKey()) < 1 {
		err := HeaderValueValidationError{
			field:  "Key",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetKey()) > 16384 {
		err := HeaderValueValidationError{
			field:  "Key",
			reason: "value length must be at most 16384 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_HeaderValue_Key_Pattern.MatchString(m.GetKey()) {
		err := HeaderValueValidationError{
			field:  "Key",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetValue()) > 16384 {
		err := HeaderValueValidationError{
			field:  "Value",
			reason: "value length must be at most 16384 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_HeaderValue_Value_Pattern.MatchString(m.GetValue()) {
		err := HeaderValueValidationError{
			field:  "Value",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if l := len(m.GetRawValue()); l < 0 || l > 16384 {
		err := HeaderValueValidationError{
			field:  "RawValue",
			reason: "value length must be between 0 and 16384 bytes, inclusive",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return HeaderValueMultiError(errors)
	}

	return nil
}

// HeaderValueMultiError is an error wrapping multiple validation errors
// returned by HeaderValue.ValidateAll() if the designated constraints aren't met.
type HeaderValueMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderValueMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderValueMultiError) AllErrors() []error { return m }

// HeaderValueValidationError is the validation error returned by
// HeaderValue.Validate if the designated constraints aren't met.
type HeaderValueValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderValueValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderValueValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderValueValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderValueValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderValueValidationError) ErrorName() string { return "HeaderValueValidationError" }

// Error satisfies the builtin error interface
func (e HeaderValueValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderValue.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderValueValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderValueValidationError{}

var _HeaderValue_Key_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _HeaderValue_Value_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on HeaderValueOption with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *HeaderValueOption) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderValueOption with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HeaderValueOptionMultiError, or nil if none found.
func (m *HeaderValueOption) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderValueOption) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetHeader() == nil {
		err := HeaderValueOptionValidationError{
			field:  "Header",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetHeader()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderValueOptionValidationError{
					field:  "Header",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderValueOptionValidationError{
					field:  "Header",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHeader()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderValueOptionValidationError{
				field:  "Header",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAppend()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeaderValueOptionValidationError{
					field:  "Append",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeaderValueOptionValidationError{
					field:  "Append",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAppend()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderValueOptionValidationError{
				field:  "Append",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := HeaderValueOption_HeaderAppendAction_name[int32(m.GetAppendAction())]; !ok {
		err := HeaderValueOptionValidationError{
			field:  "AppendAction",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for KeepEmptyValue

	if len(errors) > 0 {
		return HeaderValueOptionMultiError(errors)
	}

	return nil
}

// HeaderValueOptionMultiError is an error wrapping multiple validation errors
// returned by HeaderValueOption.ValidateAll() if the designated constraints
// aren't met.
type HeaderValueOptionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderValueOptionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderValueOptionMultiError) AllErrors() []error { return m }

// HeaderValueOptionValidationError is the validation error returned by
// HeaderValueOption.Validate if the designated constraints aren't met.
type HeaderValueOptionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderValueOptionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderValueOptionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderValueOptionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderValueOptionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderValueOptionValidationError) ErrorName() string {
	return "HeaderValueOptionValidationError"
}

// Error satisfies the builtin error interface
func (e HeaderValueOptionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderValueOption.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderValueOptionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderValueOptionValidationError{}

// Validate checks the field values on HeaderMap with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HeaderMap) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderMap with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HeaderMapMultiError, or nil
// if none found.
func (m *HeaderMap) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderMap) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetHeaders() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HeaderMapValidationError{
						field:  fmt.Sprintf("Headers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HeaderMapValidationError{
						field:  fmt.Sprintf("Headers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderMapValidationError{
					field:  fmt.Sprintf("Headers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return HeaderMapMultiError(errors)
	}

	return nil
}

// HeaderMapMultiError is an error wrapping multiple validation errors returned
// by HeaderMap.ValidateAll() if the designated constraints aren't met.
type HeaderMapMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderMapMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderMapMultiError) AllErrors() []error { return m }

// HeaderMapValidationError is the validation error returned by
// HeaderMap.Validate if the designated constraints aren't met.
type HeaderMapValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderMapValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderMapValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderMapValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderMapValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderMapValidationError) ErrorName() string { return "HeaderMapValidationError" }

// Error satisfies the builtin error interface
func (e HeaderMapValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderMap.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderMapValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderMapValidationError{}

// Validate checks the field values on WatchedDirectory with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *WatchedDirectory) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WatchedDirectory with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// WatchedDirectoryMultiError, or nil if none found.
func (m *WatchedDirectory) ValidateAll() error {
	return m.validate(true)
}

func (m *WatchedDirectory) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetPath()) < 1 {
		err := WatchedDirectoryValidationError{
			field:  "Path",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return WatchedDirectoryMultiError(errors)
	}

	return nil
}

// WatchedDirectoryMultiError is an error wrapping multiple validation errors
// returned by WatchedDirectory.ValidateAll() if the designated constraints
// aren't met.
type WatchedDirectoryMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WatchedDirectoryMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WatchedDirectoryMultiError) AllErrors() []error { return m }

// WatchedDirectoryValidationError is the validation error returned by
// WatchedDirectory.Validate if the designated constraints aren't met.
type WatchedDirectoryValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WatchedDirectoryValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WatchedDirectoryValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WatchedDirectoryValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WatchedDirectoryValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WatchedDirectoryValidationError) ErrorName() string { return "WatchedDirectoryValidationError" }

// Error satisfies the builtin error interface
func (e WatchedDirectoryValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWatchedDirectory.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WatchedDirectoryValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WatchedDirectoryValidationError{}

// Validate checks the field values on DataSource with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *DataSource) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DataSource with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in DataSourceMultiError, or
// nil if none found.
func (m *DataSource) ValidateAll() error {
	return m.validate(true)
}

func (m *DataSource) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetWatchedDirectory()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DataSourceValidationError{
					field:  "WatchedDirectory",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DataSourceValidationError{
					field:  "WatchedDirectory",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetWatchedDirectory()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DataSourceValidationError{
				field:  "WatchedDirectory",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	oneofSpecifierPresent := false
	switch v := m.Specifier.(type) {
	case *DataSource_Filename:
		if v == nil {
			err := DataSourceValidationError{
				field:  "Specifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofSpecifierPresent = true

		if utf8.RuneCountInString(m.GetFilename()) < 1 {
			err := DataSourceValidationError{
				field:  "Filename",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *DataSource_InlineBytes:
		if v == nil {
			err := DataSourceValidationError{
				field:  "Specifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofSpecifierPresent = true
		// no validation rules for InlineBytes
	case *DataSource_InlineString:
		if v == nil {
			err := DataSourceValidationError{
				field:  "Specifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofSpecifierPresent = true
		// no validation rules for InlineString
	case *DataSource_EnvironmentVariable:
		if v == nil {
			err := DataSourceValidationError{
				field:  "Specifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofSpecifierPresent = true

		if utf8.RuneCountInString(m.GetEnvironmentVariable()) < 1 {
			err := DataSourceValidationError{
				field:  "EnvironmentVariable",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofSpecifierPresent {
		err := DataSourceValidationError{
			field:  "Specifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return DataSourceMultiError(errors)
	}

	return nil
}

// DataSourceMultiError is an error wrapping multiple validation errors
// returned by DataSource.ValidateAll() if the designated constraints aren't met.
type DataSourceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DataSourceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DataSourceMultiError) AllErrors() []error { return m }

// DataSourceValidationError is the validation error returned by
// DataSource.Validate if the designated constraints aren't met.
type DataSourceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DataSourceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DataSourceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DataSourceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DataSourceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DataSourceValidationError) ErrorName() string { return "DataSourceValidationError" }

// Error satisfies the builtin error interface
func (e DataSourceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDataSource.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DataSourceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DataSourceValidationError{}

// Validate checks the field values on RetryPolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RetryPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RetryPolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RetryPolicyMultiError, or
// nil if none found.
func (m *RetryPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *RetryPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetRetryBackOff()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "RetryBackOff",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "RetryBackOff",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryBackOff()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "RetryBackOff",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetNumRetries()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "NumRetries",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "NumRetries",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetNumRetries()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "NumRetries",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for RetryOn

	if all {
		switch v := interface{}(m.GetRetryPriority()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "RetryPriority",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "RetryPriority",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryPriority()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "RetryPriority",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetRetryHostPredicate() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RetryPolicyValidationError{
						field:  fmt.Sprintf("RetryHostPredicate[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RetryPolicyValidationError{
						field:  fmt.Sprintf("RetryHostPredicate[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicyValidationError{
					field:  fmt.Sprintf("RetryHostPredicate[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for HostSelectionRetryMaxAttempts

	if len(errors) > 0 {
		return RetryPolicyMultiError(errors)
	}

	return nil
}

// RetryPolicyMultiError is an error wrapping multiple validation errors
// returned by RetryPolicy.ValidateAll() if the designated constraints aren't met.
type RetryPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RetryPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RetryPolicyMultiError) AllErrors() []error { return m }

// RetryPolicyValidationError is the validation error returned by
// RetryPolicy.Validate if the designated constraints aren't met.
type RetryPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicyValidationError) ErrorName() string { return "RetryPolicyValidationError" }

// Error satisfies the builtin error interface
func (e RetryPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicyValidationError{}

// Validate checks the field values on RemoteDataSource with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *RemoteDataSource) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RemoteDataSource with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RemoteDataSourceMultiError, or nil if none found.
func (m *RemoteDataSource) ValidateAll() error {
	return m.validate(true)
}

func (m *RemoteDataSource) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetHttpUri() == nil {
		err := RemoteDataSourceValidationError{
			field:  "HttpUri",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetHttpUri()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RemoteDataSourceValidationError{
					field:  "HttpUri",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RemoteDataSourceValidationError{
					field:  "HttpUri",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHttpUri()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RemoteDataSourceValidationError{
				field:  "HttpUri",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if utf8.RuneCountInString(m.GetSha256()) < 1 {
		err := RemoteDataSourceValidationError{
			field:  "Sha256",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetRetryPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RemoteDataSourceValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RemoteDataSourceValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RemoteDataSourceValidationError{
				field:  "RetryPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RemoteDataSourceMultiError(errors)
	}

	return nil
}

// RemoteDataSourceMultiError is an error wrapping multiple validation errors
// returned by RemoteDataSource.ValidateAll() if the designated constraints
// aren't met.
type RemoteDataSourceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RemoteDataSourceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RemoteDataSourceMultiError) AllErrors() []error { return m }

// RemoteDataSourceValidationError is the validation error returned by
// RemoteDataSource.Validate if the designated constraints aren't met.
type RemoteDataSourceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RemoteDataSourceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RemoteDataSourceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RemoteDataSourceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RemoteDataSourceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RemoteDataSourceValidationError) ErrorName() string { return "RemoteDataSourceValidationError" }

// Error satisfies the builtin error interface
func (e RemoteDataSourceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRemoteDataSource.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RemoteDataSourceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RemoteDataSourceValidationError{}

// Validate checks the field values on AsyncDataSource with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *AsyncDataSource) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AsyncDataSource with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AsyncDataSourceMultiError, or nil if none found.
func (m *AsyncDataSource) ValidateAll() error {
	return m.validate(true)
}

func (m *AsyncDataSource) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofSpecifierPresent := false
	switch v := m.Specifier.(type) {
	case *AsyncDataSource_Local:
		if v == nil {
			err := AsyncDataSourceValidationError{
				field:  "Specifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetLocal()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AsyncDataSourceValidationError{
						field:  "Local",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AsyncDataSourceValidationError{
						field:  "Local",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetLocal()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AsyncDataSourceValidationError{
					field:  "Local",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *AsyncDataSource_Remote:
		if v == nil {
			err := AsyncDataSourceValidationError{
				field:  "Specifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetRemote()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AsyncDataSourceValidationError{
						field:  "Remote",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AsyncDataSourceValidationError{
						field:  "Remote",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRemote()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AsyncDataSourceValidationError{
					field:  "Remote",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofSpecifierPresent {
		err := AsyncDataSourceValidationError{
			field:  "Specifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return AsyncDataSourceMultiError(errors)
	}

	return nil
}

// AsyncDataSourceMultiError is an error wrapping multiple validation errors
// returned by AsyncDataSource.ValidateAll() if the designated constraints
// aren't met.
type AsyncDataSourceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AsyncDataSourceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AsyncDataSourceMultiError) AllErrors() []error { return m }

// AsyncDataSourceValidationError is the validation error returned by
// AsyncDataSource.Validate if the designated constraints aren't met.
type AsyncDataSourceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AsyncDataSourceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AsyncDataSourceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AsyncDataSourceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AsyncDataSourceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AsyncDataSourceValidationError) ErrorName() string { return "AsyncDataSourceValidationError" }

// Error satisfies the builtin error interface
func (e AsyncDataSourceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAsyncDataSource.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AsyncDataSourceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AsyncDataSourceValidationError{}

// Validate checks the field values on TransportSocket with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *TransportSocket) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TransportSocket with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TransportSocketMultiError, or nil if none found.
func (m *TransportSocket) ValidateAll() error {
	return m.validate(true)
}

func (m *TransportSocket) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := TransportSocketValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.ConfigType.(type) {
	case *TransportSocket_TypedConfig:
		if v == nil {
			err := TransportSocketValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TransportSocketValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TransportSocketValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TransportSocketValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return TransportSocketMultiError(errors)
	}

	return nil
}

// TransportSocketMultiError is an error wrapping multiple validation errors
// returned by TransportSocket.ValidateAll() if the designated constraints
// aren't met.
type TransportSocketMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TransportSocketMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TransportSocketMultiError) AllErrors() []error { return m }

// TransportSocketValidationError is the validation error returned by
// TransportSocket.Validate if the designated constraints aren't met.
type TransportSocketValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TransportSocketValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TransportSocketValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TransportSocketValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TransportSocketValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TransportSocketValidationError) ErrorName() string { return "TransportSocketValidationError" }

// Error satisfies the builtin error interface
func (e TransportSocketValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTransportSocket.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TransportSocketValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TransportSocketValidationError{}

// Validate checks the field values on RuntimeFractionalPercent with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RuntimeFractionalPercent) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RuntimeFractionalPercent with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RuntimeFractionalPercentMultiError, or nil if none found.
func (m *RuntimeFractionalPercent) ValidateAll() error {
	return m.validate(true)
}

func (m *RuntimeFractionalPercent) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetDefaultValue() == nil {
		err := RuntimeFractionalPercentValidationError{
			field:  "DefaultValue",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetDefaultValue()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RuntimeFractionalPercentValidationError{
					field:  "DefaultValue",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RuntimeFractionalPercentValidationError{
					field:  "DefaultValue",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDefaultValue()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RuntimeFractionalPercentValidationError{
				field:  "DefaultValue",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for RuntimeKey

	if len(errors) > 0 {
		return RuntimeFractionalPercentMultiError(errors)
	}

	return nil
}

// RuntimeFractionalPercentMultiError is an error wrapping multiple validation
// errors returned by RuntimeFractionalPercent.ValidateAll() if the designated
// constraints aren't met.
type RuntimeFractionalPercentMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RuntimeFractionalPercentMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RuntimeFractionalPercentMultiError) AllErrors() []error { return m }

// RuntimeFractionalPercentValidationError is the validation error returned by
// RuntimeFractionalPercent.Validate if the designated constraints aren't met.
type RuntimeFractionalPercentValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RuntimeFractionalPercentValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RuntimeFractionalPercentValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RuntimeFractionalPercentValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RuntimeFractionalPercentValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RuntimeFractionalPercentValidationError) ErrorName() string {
	return "RuntimeFractionalPercentValidationError"
}

// Error satisfies the builtin error interface
func (e RuntimeFractionalPercentValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuntimeFractionalPercent.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RuntimeFractionalPercentValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RuntimeFractionalPercentValidationError{}

// Validate checks the field values on ControlPlane with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ControlPlane) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ControlPlane with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ControlPlaneMultiError, or
// nil if none found.
func (m *ControlPlane) ValidateAll() error {
	return m.validate(true)
}

func (m *ControlPlane) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Identifier

	if len(errors) > 0 {
		return ControlPlaneMultiError(errors)
	}

	return nil
}

// ControlPlaneMultiError is an error wrapping multiple validation errors
// returned by ControlPlane.ValidateAll() if the designated constraints aren't met.
type ControlPlaneMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ControlPlaneMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ControlPlaneMultiError) AllErrors() []error { return m }

// ControlPlaneValidationError is the validation error returned by
// ControlPlane.Validate if the designated constraints aren't met.
type ControlPlaneValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ControlPlaneValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ControlPlaneValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ControlPlaneValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ControlPlaneValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ControlPlaneValidationError) ErrorName() string { return "ControlPlaneValidationError" }

// Error satisfies the builtin error interface
func (e ControlPlaneValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sControlPlane.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ControlPlaneValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ControlPlaneValidationError{}

// Validate checks the field values on RetryPolicy_RetryPriority with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RetryPolicy_RetryPriority) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RetryPolicy_RetryPriority with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RetryPolicy_RetryPriorityMultiError, or nil if none found.
func (m *RetryPolicy_RetryPriority) ValidateAll() error {
	return m.validate(true)
}

func (m *RetryPolicy_RetryPriority) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := RetryPolicy_RetryPriorityValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.ConfigType.(type) {
	case *RetryPolicy_RetryPriority_TypedConfig:
		if v == nil {
			err := RetryPolicy_RetryPriorityValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RetryPolicy_RetryPriorityValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RetryPolicy_RetryPriorityValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicy_RetryPriorityValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return RetryPolicy_RetryPriorityMultiError(errors)
	}

	return nil
}

// RetryPolicy_RetryPriorityMultiError is an error wrapping multiple validation
// errors returned by RetryPolicy_RetryPriority.ValidateAll() if the
// designated constraints aren't met.
type RetryPolicy_RetryPriorityMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RetryPolicy_RetryPriorityMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RetryPolicy_RetryPriorityMultiError) AllErrors() []error { return m }

// RetryPolicy_RetryPriorityValidationError is the validation error returned by
// RetryPolicy_RetryPriority.Validate if the designated constraints aren't met.
type RetryPolicy_RetryPriorityValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicy_RetryPriorityValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicy_RetryPriorityValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicy_RetryPriorityValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicy_RetryPriorityValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicy_RetryPriorityValidationError) ErrorName() string {
	return "RetryPolicy_RetryPriorityValidationError"
}

// Error satisfies the builtin error interface
func (e RetryPolicy_RetryPriorityValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy_RetryPriority.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicy_RetryPriorityValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicy_RetryPriorityValidationError{}

// Validate checks the field values on RetryPolicy_RetryHostPredicate with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RetryPolicy_RetryHostPredicate) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RetryPolicy_RetryHostPredicate with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RetryPolicy_RetryHostPredicateMultiError, or nil if none found.
func (m *RetryPolicy_RetryHostPredicate) ValidateAll() error {
	return m.validate(true)
}

func (m *RetryPolicy_RetryHostPredicate) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := RetryPolicy_RetryHostPredicateValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.ConfigType.(type) {
	case *RetryPolicy_RetryHostPredicate_TypedConfig:
		if v == nil {
			err := RetryPolicy_RetryHostPredicateValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RetryPolicy_RetryHostPredicateValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RetryPolicy_RetryHostPredicateValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicy_RetryHostPredicateValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return RetryPolicy_RetryHostPredicateMultiError(errors)
	}

	return nil
}

// RetryPolicy_RetryHostPredicateMultiError is an error wrapping multiple
// validation errors returned by RetryPolicy_RetryHostPredicate.ValidateAll()
// if the designated constraints aren't met.
type RetryPolicy_RetryHostPredicateMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RetryPolicy_RetryHostPredicateMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RetryPolicy_RetryHostPredicateMultiError) AllErrors() []error { return m }

// RetryPolicy_RetryHostPredicateValidationError is the validation error
// returned by RetryPolicy_RetryHostPredicate.Validate if the designated
// constraints aren't met.
type RetryPolicy_RetryHostPredicateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicy_RetryHostPredicateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicy_RetryHostPredicateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicy_RetryHostPredicateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicy_RetryHostPredicateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicy_RetryHostPredicateValidationError) ErrorName() string {
	return "RetryPolicy_RetryHostPredicateValidationError"
}

// Error satisfies the builtin error interface
func (e RetryPolicy_RetryHostPredicateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy_RetryHostPredicate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicy_RetryHostPredicateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicy_RetryHostPredicateValidationError{}
