/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.RankList;

class VerticalPlacement
extends GraphVisitor {
    VerticalPlacement() {
    }

    @Override
    void visit(DirectedGraph g) {
        int currentY = g.getMargin().top;
        RankList ranks = g.ranks;
        g.rankLocations = new int[ranks.size() + 1];
        int row = 0;
        while (row < ranks.size()) {
            g.rankLocations[row] = currentY;
            Rank rank = ranks.getRank(row);
            int rowHeight = 0;
            rank.bottomPadding = 0;
            rank.topPadding = 0;
            for (Node node : rank) {
                Insets pad = g.getPadding(node);
                rowHeight = Math.max(node.height, rowHeight);
                rank.topPadding = Math.max(pad.top, rank.topPadding);
                rank.bottomPadding = Math.max(pad.bottom, rank.bottomPadding);
            }
            rank.setDimensions(currentY += rank.topPadding, rowHeight);
            currentY += rank.height + rank.bottomPadding;
            ++row;
        }
        g.rankLocations[row] = currentY;
        g.size.height = currentY;
    }
}

