/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.screenreaders.ScreenReader;

public class PrefPageAccessibility
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.user.interface.accessibility";
    private final DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
    private Combo cmbScreenReaderSupport;
    private Button forceFocusCheckbox;
    private IAdaptable element;

    public void init(IWorkbench workbench) {
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite composite = this.createControls(parent);
        this.initControls();
        return composite;
    }

    private Composite createControls(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group accessibilityGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_accessibility_screen_reader_group_lbl, (int)2, (int)512, (int)0);
        this.createForceFocusCheckbox(composite);
        this.cmbScreenReaderSupport = UIUtils.createLabelCombo((Composite)accessibilityGroup, (String)CoreMessages.pref_page_accessibility_screen_reader_msg, (String)CoreMessages.pref_page_accessibility_screen_reader_description, (int)12);
        return composite;
    }

    private void createForceFocusCheckbox(Composite parent) {
        this.forceFocusCheckbox = UIUtils.createCheckbox((Composite)parent, (String)CoreMessages.pref_page_accessibility_force_focus_checkbox, (String)CoreMessages.pref_page_accessibility_force_focus_tooltip, (boolean)false, (int)2);
    }

    private void initControls() {
        ScreenReader[] screenReaderArray = ScreenReader.values();
        int n = screenReaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScreenReader reader = screenReaderArray[n2];
            this.cmbScreenReaderSupport.add(reader.getScreenReaderName());
            ++n2;
        }
        this.initCombo();
        this.initForceFocusCheckbox();
    }

    private void initCombo() {
        String storedScreenReader = this.store.getString("screen.reader.accessibility");
        ScreenReader screenReader = ScreenReader.getScreenReader((String)storedScreenReader);
        this.cmbScreenReaderSupport.select(screenReader.ordinal());
    }

    private void initForceFocusCheckbox() {
        boolean forceFocus = this.store.getBoolean("screen.reader.force.focus");
        this.forceFocusCheckbox.setSelection(forceFocus);
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    protected void performDefaults() {
        this.cmbScreenReaderSupport.select(ScreenReader.DEFAULT.ordinal());
    }

    public boolean performOk() {
        ScreenReader screenReader = ScreenReader.getScreenReader((String)this.cmbScreenReaderSupport.getText());
        this.store.setValue("screen.reader.accessibility", screenReader.name());
        this.store.setValue("screen.reader.force.focus", this.forceFocusCheckbox.getSelection());
        return true;
    }
}

