/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;

public class UpsertDeParser
extends AbstractDeParser<Upsert> {
    private ExpressionDeParser expressionVisitor;
    private SelectDeParser selectVisitor;

    public UpsertDeParser(ExpressionDeParser expressionVisitor, SelectDeParser selectVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
        this.expressionVisitor.setSelectVisitor(selectVisitor);
        this.selectVisitor = selectVisitor;
        this.selectVisitor.setExpressionVisitor(expressionVisitor);
    }

    @Override
    public void deParse(Upsert upsert) {
        switch (upsert.getUpsertType()) {
            case REPLACE: 
            case REPLACE_SET: {
                this.builder.append("REPLACE ");
                break;
            }
            case INSERT_OR_ABORT: {
                this.builder.append("INSERT OR ABORT ");
                break;
            }
            case INSERT_OR_FAIL: {
                this.builder.append("INSERT OR FAIL ");
                break;
            }
            case INSERT_OR_IGNORE: {
                this.builder.append("INSERT OR IGNORE ");
                break;
            }
            case INSERT_OR_REPLACE: {
                this.builder.append("INSERT OR REPLACE ");
                break;
            }
            case INSERT_OR_ROLLBACK: {
                this.builder.append("INSERT OR ROLLBACK ");
                break;
            }
            default: {
                this.builder.append("UPSERT ");
            }
        }
        if (upsert.isUsingInto()) {
            this.builder.append("INTO ");
        }
        this.builder.append(upsert.getTable().getFullyQualifiedName());
        if (upsert.getUpdateSets() != null) {
            this.builder.append(" SET ");
            UpsertDeParser.deparseUpdateSets(upsert.getUpdateSets(), this.builder, this.expressionVisitor);
        } else {
            if (upsert.getColumns() != null) {
                upsert.getColumns().accept(this.expressionVisitor, null);
            }
            if (upsert.getExpressions() != null) {
                upsert.getExpressions().accept(this.expressionVisitor, null);
            }
            if (upsert.getSelect() != null) {
                this.builder.append(" ");
                upsert.getSelect().accept(this.selectVisitor, null);
            }
            if (upsert.getDuplicateUpdateSets() != null) {
                this.builder.append(" ON DUPLICATE KEY UPDATE ");
                UpsertDeParser.deparseUpdateSets(upsert.getDuplicateUpdateSets(), this.builder, this.expressionVisitor);
            }
        }
    }

    public ExpressionVisitor<StringBuilder> getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionDeParser visitor) {
        this.expressionVisitor = visitor;
    }

    public SelectVisitor<StringBuilder> getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectDeParser visitor) {
        this.selectVisitor = visitor;
    }
}

