#!/usr/bin/env python3


"""

""" """

Copyright 1999-2023 Gentoo Authors
Distributed under the terms of the GNU General Public License v2
"""


from os import chdir
from os import path

from subprocess import run
from sys import argv


def main():
    """! Main."""

    script_path = path.realpath(__file__)
    script_root = path.dirname(script_path)

    repo_root = path.realpath(path.join(script_root, "..", "..", ".."))
    source_path = path.join(repo_root, "Source")
    build_path = path.join(repo_root, "Build")

    v1_source_path = path.join(source_path, "v1")
    build_output_path = path.join(build_path, "v1_meson_BuildDir", "build")

    leftover_args = argv[1::]
    command_arguments = [
        "meson",
        "setup",
        build_output_path,
        "--prefix",
        "/",
        "--bindir",
        "/bin",
        "--datadir",
        "/",
    ] + leftover_args

    print(f" * Entering directory: {v1_source_path}")
    chdir(v1_source_path)

    setup_command_string = " ".join(command_arguments)
    print(f" * Executing command: {setup_command_string}")

    run(command_arguments, check=True)


if __name__ == "__main__":
    main()
