// Copyright 2023-2024 Gentoo Authors
// Distributed under the terms of the GNU General Public License v2

open System.Threading.Tasks

open System.CommandLine
open System.CommandLine.Invocation

open Gdmt.CleanTmp.Private

let CommandName = "gdmt-cleantmp"
let CommandDescription = "clean .NET artifacts from a given tmpdir"

let TmpdirArgument = new Argument<string>("tmpdir", "tmpdir to clean")
TmpdirArgument.SetDefaultValue "/tmp"

let DryRunOption = new Option<bool>([| "-d"; "--dry-run" |], "dry run")
DryRunOption.SetDefaultValue false

let CommandHandler (context: InvocationContext) : Task =
    task {
        let options = context.ParseResult

        let tmpdir = options.GetValueForArgument TmpdirArgument
        let dryRun = options.GetValueForOption DryRunOption

        CleanUnwantedFilesFromTmpdir tmpdir dryRun

        ()
    }

[<EntryPoint>]
let main argv =
    let rootCommand = RootCommand(CommandName)

    rootCommand.Name <- CommandName
    rootCommand.Description <- CommandDescription

    rootCommand.AddArgument TmpdirArgument

    rootCommand.AddOption DryRunOption

    rootCommand.SetHandler CommandHandler

    rootCommand.Invoke(argv)
