// Copyright 2023-2024 Gentoo Authors
// Distributed under the terms of the GNU General Public License v2

namespace Gdmt.Checkcore

module Private =
    open System.IO

    open Gdmt.Shared

    let WriteTempCsproj (directory: string) (dotnetVersionString: string) : unit =
        let csprojPath = Path.Combine(directory, $"Project_{dotnetVersionString}.csproj")

        let csprojContent =
            $"""<Project Sdk="Microsoft.NET.Sdk">
  <PropertyGroup>
    <IsAotCompatible>true</IsAotCompatible>
    <NoWarn>\$(NoWarn);NETSDK1138</NoWarn>
    <RollForward>Major</RollForward>
    <TargetFramework>net{dotnetVersionString}</TargetFramework>
  </PropertyGroup>
</Project>"""

        use writer = new StreamWriter(csprojPath)

        do writer.Write(csprojContent)
        writer.Flush()

    let GetSdkVersionChain (min: double) (max: double) : float list =
        let generated: List<float> = [ System.Math.Ceiling(min) .. max ]

        float min :: float max :: generated |> List.distinct |> List.sort

    // TODO: "gdmt-restore" never fails, use heuristic to determine if it has failed?
    let RunGdmtRestore (args: List<string>) : unit =
        ExecProcess("gdmt" :: "restore" :: "--no-filter" :: args).Run().Check()
