/*
 * Decompiled with CFR 0.152.
 */
package prolog;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import prolog.JavaButton;
import prolog.JavaCircle;
import prolog.JavaGraphicalObject;
import prolog.JavaLine;
import prolog.JavaList;
import prolog.JavaPixel;
import prolog.JavaRectangle;
import prolog.JavaText;
import prolog.Prolog;

public class JavaGraphicalWindow
extends JFrame {
    private List<JavaGraphicalObject> graphicalObjects = new Vector<JavaGraphicalObject>();

    public JavaGraphicalWindow(String string, int n, int n2, int n3, int n4) {
        this.setTitle(string);
        this.setLocation(n, n2);
        this.setSize(new Dimension(n3, n4));
        this.setDefaultCloseOperation(0);
        this.setLayout(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Integer n = new Integer(mouseEvent.getX());
                Integer n2 = new Integer(mouseEvent.getY());
                Prolog.PostEvent("event", JavaGraphicalWindow.this, null, "mouse_down", n, null, n2);
            }
        });
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Prolog.PostEvent("event", JavaGraphicalWindow.this, null, "close_window");
            }
        });
        Prolog.GuiCall(new Runnable(){

            @Override
            public void run() {
                JavaGraphicalWindow.this.setVisible(true);
                JavaGraphicalWindow.this.toFront();
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        for (int i = 0; i < this.graphicalObjects.size(); ++i) {
            this.graphicalObjects.get(i).draw(graphics);
        }
    }

    public JavaGraphicalObject gfxPutPixel(int n, int n2, int n3, int n4, int n5) {
        Graphics graphics = super.getGraphics();
        JavaPixel javaPixel = new JavaPixel(this, n, n2, n3, n4, n5);
        this.graphicalObjects.add(javaPixel);
        return javaPixel;
    }

    public JavaGraphicalObject gfxLine(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Graphics graphics = super.getGraphics();
        JavaLine javaLine = new JavaLine(this, n, n2, n3, n4, n5, n6, n7);
        this.graphicalObjects.add(javaLine);
        return javaLine;
    }

    public JavaGraphicalObject gfxCircle(int n, int n2, int n3, int n4, int n5, int n6) {
        Graphics graphics = super.getGraphics();
        JavaCircle javaCircle = new JavaCircle(this, n, n2, n3, n4, n5, n6, false);
        this.graphicalObjects.add(javaCircle);
        return javaCircle;
    }

    public JavaGraphicalObject gfxRectangle(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Graphics graphics = super.getGraphics();
        JavaRectangle javaRectangle = new JavaRectangle(this, n, n2, n3, n4, n5, n6, n7, false);
        this.graphicalObjects.add(javaRectangle);
        return javaRectangle;
    }

    public JavaGraphicalObject gfxCircleFilled(int n, int n2, int n3, int n4, int n5, int n6) {
        Graphics graphics = super.getGraphics();
        JavaCircle javaCircle = new JavaCircle(this, n, n2, n3, n4, n5, n6, true);
        this.graphicalObjects.add(javaCircle);
        return javaCircle;
    }

    public JavaGraphicalObject gfxRectangleFilled(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Graphics graphics = super.getGraphics();
        JavaRectangle javaRectangle = new JavaRectangle(this, n, n2, n3, n4, n5, n6, n7, true);
        this.graphicalObjects.add(javaRectangle);
        return javaRectangle;
    }

    public JavaGraphicalObject gfxDrawText(String string, int n, int n2) {
        Graphics graphics = super.getGraphics();
        JavaText javaText = new JavaText(this, string, n, n2);
        this.graphicalObjects.add(javaText);
        return javaText;
    }

    public JavaGraphicalObject gfxButton(String string, int n, int n2) {
        JavaButton javaButton = new JavaButton(this, n, n2, string);
        this.graphicalObjects.add(javaButton);
        return javaButton;
    }

    public JavaGraphicalObject gfxList(String[] stringArray, int n, int n2) {
        JavaList javaList = new JavaList(this, n, n2, stringArray);
        this.graphicalObjects.add(javaList);
        return javaList;
    }

    public void gfxDeleteObject(JavaGraphicalObject javaGraphicalObject) {
        javaGraphicalObject.delete();
        this.graphicalObjects.remove(javaGraphicalObject);
    }

    public void gfxClear() {
        for (int i = 0; i < this.graphicalObjects.size(); ++i) {
            this.graphicalObjects.get(i).delete();
        }
        this.graphicalObjects.clear();
        Graphics graphics = super.getGraphics();
        graphics.clearRect(0, 0, super.getWidth(), super.getHeight());
    }

    public void gfxClose() {
        this.gfxClear();
        super.dispose();
    }

    public static void main(String[] stringArray) throws Exception {
        JavaGraphicalWindow javaGraphicalWindow = new JavaGraphicalWindow("ola", 100, 100, 500, 500);
        javaGraphicalWindow.gfxButton("ola", 300, 400);
        javaGraphicalWindow.gfxClear();
        String[] stringArray2 = new String[]{"ola1", "ola2", "ola3"};
        JavaList javaList = (JavaList)javaGraphicalWindow.gfxList(stringArray2, 100, 100);
        while (true) {
            Thread.sleep(1000L);
            System.out.println(javaList.getSelectedItem());
        }
    }
}

