/* random-pattern.c generated by valac 0.46.3, the Vala compiler
 * generated from random-pattern.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2015  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>

#define PASANG_TYPE_PATTERN (pasang_pattern_get_type ())
#define PASANG_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_PATTERN, PasangPattern))
#define PASANG_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_PATTERN, PasangPatternClass))
#define PASANG_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_PATTERN))
#define PASANG_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_PATTERN))
#define PASANG_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_PATTERN, PasangPatternClass))

typedef struct _PasangPattern PasangPattern;
typedef struct _PasangPatternClass PasangPatternClass;
typedef struct _PasangPatternPrivate PasangPatternPrivate;

#define PASANG_TYPE_RANDOM_PATTERN (pasang_random_pattern_get_type ())
#define PASANG_RANDOM_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_RANDOM_PATTERN, PasangRandomPattern))
#define PASANG_RANDOM_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_RANDOM_PATTERN, PasangRandomPatternClass))
#define PASANG_IS_RANDOM_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_RANDOM_PATTERN))
#define PASANG_IS_RANDOM_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_RANDOM_PATTERN))
#define PASANG_RANDOM_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_RANDOM_PATTERN, PasangRandomPatternClass))

typedef struct _PasangRandomPattern PasangRandomPattern;
typedef struct _PasangRandomPatternClass PasangRandomPatternClass;
typedef struct _PasangRandomPatternPrivate PasangRandomPatternPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define PASANG_TYPE_POINT (pasang_point_get_type ())
typedef struct _PasangPoint PasangPoint;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PasangPattern {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PasangPatternPrivate * priv;
	gchar* name;
	gchar* dots;
	guint8* pixbuf_data;
	gint pixbuf_data_length1;
	gint _pixbuf_data_size_;
	GdkPixbuf* pixbuf;
	gint dot_width;
	GtkRadioButton* button;
};

struct _PasangPatternClass {
	GTypeClass parent_class;
	void (*finalize) (PasangPattern *self);
	void (*background) (PasangPattern* self, gint n, gint x, gint y);
	void (*create_pixbuf) (PasangPattern* self);
};

struct _PasangRandomPattern {
	PasangPattern parent_instance;
	PasangRandomPatternPrivate * priv;
};

struct _PasangRandomPatternClass {
	PasangPatternClass parent_class;
};

struct _PasangRandomPatternPrivate {
	gchar* spec;
	gdouble _temperature;
};

struct _PasangPoint {
	gint x;
	gint y;
};

static gint PasangRandomPattern_private_offset;
static gpointer pasang_random_pattern_parent_class = NULL;

gpointer pasang_pattern_ref (gpointer instance);
void pasang_pattern_unref (gpointer instance);
GParamSpec* pasang_param_spec_pattern (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void pasang_value_set_pattern (GValue* value,
                               gpointer v_object);
void pasang_value_take_pattern (GValue* value,
                                gpointer v_object);
gpointer pasang_value_get_pattern (const GValue* value);
GType pasang_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangPattern, pasang_pattern_unref)
GType pasang_random_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangRandomPattern, pasang_pattern_unref)
PasangRandomPattern* pasang_random_pattern_new (const gchar* name,
                                                const gchar* spec);
PasangRandomPattern* pasang_random_pattern_construct (GType object_type,
                                                      const gchar* name,
                                                      const gchar* spec);
PasangPattern* pasang_pattern_new_empty (const gchar* name);
PasangPattern* pasang_pattern_construct_empty (GType object_type,
                                               const gchar* name);
void pasang_random_pattern_next_random (PasangRandomPattern* self);
void pasang_random_pattern_set_temperature (PasangRandomPattern* self,
                                            gdouble value);
static void pasang_random_pattern_real_background (PasangPattern* base,
                                            gint n,
                                            gint x,
                                            gint y);
static gchar pasang_random_pattern_rand_char (PasangRandomPattern* self,
                                       const gchar* s);
static gchar pasang_random_pattern_read_spec (PasangRandomPattern* self,
                                       gint* index,
                                       gchar default_code);
static void pasang_random_pattern_next_random_day_and_night (PasangRandomPattern* self);
#define PASANG_NUM_WHITES 60
#define PASANG_NUM_BLACKS 60
GType pasang_point_get_type (void) G_GNUC_CONST;
PasangPoint* pasang_point_dup (const PasangPoint* self);
void pasang_point_free (PasangPoint* self);
void pasang_point_init_xy (PasangPoint *self,
                           gint x,
                           gint y);
static void pasang_random_pattern_next_random_aux (PasangRandomPattern* self);
void pasang_pattern_create_pixbuf (PasangPattern* self);
static void _vala_array_add20 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add21 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add22 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add23 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add24 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add25 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add26 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add27 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add28 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
gdouble pasang_random_pattern_get_temperature (PasangRandomPattern* self);
static void pasang_random_pattern_finalize (PasangPattern * obj);

static inline gpointer
pasang_random_pattern_get_instance_private (PasangRandomPattern* self)
{
	return G_STRUCT_MEMBER_P (self, PasangRandomPattern_private_offset);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1180 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1181 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1181 "glib-2.0.vapi"
	result = _tmp0_;
#line 1181 "glib-2.0.vapi"
	return result;
#line 213 "random-pattern.c"
}

PasangRandomPattern*
pasang_random_pattern_construct (GType object_type,
                                 const gchar* name,
                                 const gchar* spec)
{
	PasangRandomPattern* self = NULL;
	gchar* _tmp0_;
#line 67 "random-pattern.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 67 "random-pattern.vala"
	g_return_val_if_fail (spec != NULL, NULL);
#line 68 "random-pattern.vala"
	_vala_assert (string_get (spec, (glong) 0) == ' ', "spec[0] == ' '");
#line 69 "random-pattern.vala"
	self = (PasangRandomPattern*) pasang_pattern_construct_empty (object_type, name);
#line 70 "random-pattern.vala"
	_tmp0_ = g_strdup (spec);
#line 70 "random-pattern.vala"
	_g_free0 (self->priv->spec);
#line 70 "random-pattern.vala"
	self->priv->spec = _tmp0_;
#line 71 "random-pattern.vala"
	pasang_random_pattern_next_random (self);
#line 72 "random-pattern.vala"
	pasang_random_pattern_set_temperature (self, (gdouble) 0);
#line 67 "random-pattern.vala"
	return self;
#line 243 "random-pattern.c"
}

PasangRandomPattern*
pasang_random_pattern_new (const gchar* name,
                           const gchar* spec)
{
#line 67 "random-pattern.vala"
	return pasang_random_pattern_construct (PASANG_TYPE_RANDOM_PATTERN, name, spec);
#line 252 "random-pattern.c"
}

static void
pasang_random_pattern_real_background (PasangPattern* base,
                                       gint n,
                                       gint x,
                                       gint y)
{
	PasangRandomPattern * self;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
#line 88 "random-pattern.vala"
	self = (PasangRandomPattern*) base;
#line 89 "random-pattern.vala"
	_tmp0_ = ((PasangPattern*) self)->pixbuf_data;
#line 89 "random-pattern.vala"
	_tmp0__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 89 "random-pattern.vala"
	_tmp0_[n + 0] = (guint8) ((255 - (100 / (3 - ((x + y) % 3)))) * self->priv->_temperature);
#line 90 "random-pattern.vala"
	_tmp1_ = ((PasangPattern*) self)->pixbuf_data;
#line 90 "random-pattern.vala"
	_tmp1__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 90 "random-pattern.vala"
	_tmp1_[n + 1] = (guint8) ((150 - (100 / (3 - ((x + y) % 3)))) * (1 - (self->priv->_temperature / 2)));
#line 91 "random-pattern.vala"
	_tmp2_ = ((PasangPattern*) self)->pixbuf_data;
#line 91 "random-pattern.vala"
	_tmp2__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 91 "random-pattern.vala"
	_tmp2_[n + 2] = (guint8) 0;
#line 92 "random-pattern.vala"
	_tmp3_ = ((PasangPattern*) self)->pixbuf_data;
#line 92 "random-pattern.vala"
	_tmp3__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 92 "random-pattern.vala"
	_tmp3_[n + 3] = (guint8) 255;
#line 296 "random-pattern.c"
}

/**
     * Select a char randomly from s.
     */
static gchar
pasang_random_pattern_rand_char (PasangRandomPattern* self,
                                 const gchar* s)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar result = '\0';
#line 98 "random-pattern.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 98 "random-pattern.vala"
	g_return_val_if_fail (s != NULL, '\0');
#line 99 "random-pattern.vala"
	_tmp0_ = strlen (s);
#line 99 "random-pattern.vala"
	_tmp1_ = _tmp0_;
#line 99 "random-pattern.vala"
	result = (gchar) string_get (s, (glong) g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp1_)));
#line 99 "random-pattern.vala"
	return result;
#line 321 "random-pattern.c"
}

/**
     * Read a character from spec. A wild card (*,?) is replaced with
     * an appropriate instance. A space and eos is translated into default_code.
     */
static gchar
pasang_random_pattern_read_spec (PasangRandomPattern* self,
                                 gint* index,
                                 gchar default_code)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar code = '\0';
	const gchar* _tmp5_;
	gint _tmp6_;
	gchar _tmp7_ = '\0';
	gchar result = '\0';
#line 106 "random-pattern.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 108 "random-pattern.vala"
	_tmp1_ = self->priv->spec;
#line 108 "random-pattern.vala"
	_tmp2_ = strlen (_tmp1_);
#line 108 "random-pattern.vala"
	_tmp3_ = _tmp2_;
#line 108 "random-pattern.vala"
	if ((*index) >= _tmp3_) {
#line 108 "random-pattern.vala"
		_tmp0_ = TRUE;
#line 354 "random-pattern.c"
	} else {
		const gchar* _tmp4_;
#line 108 "random-pattern.vala"
		_tmp4_ = self->priv->spec;
#line 108 "random-pattern.vala"
		_tmp0_ = string_get (_tmp4_, (glong) (*index)) == ' ';
#line 361 "random-pattern.c"
	}
#line 108 "random-pattern.vala"
	if (_tmp0_) {
#line 109 "random-pattern.vala"
		result = default_code;
#line 109 "random-pattern.vala"
		return result;
#line 369 "random-pattern.c"
	}
#line 110 "random-pattern.vala"
	_tmp5_ = self->priv->spec;
#line 110 "random-pattern.vala"
	code = (gchar) string_get (_tmp5_, (glong) (*index));
#line 111 "random-pattern.vala"
	_tmp6_ = *index;
#line 111 "random-pattern.vala"
	*index = _tmp6_ + 1;
#line 112 "random-pattern.vala"
	if (code == '*') {
#line 112 "random-pattern.vala"
		_tmp7_ = pasang_random_pattern_rand_char (self, "RTELJSHXFO");
#line 383 "random-pattern.c"
	} else {
		gchar _tmp8_ = '\0';
#line 113 "random-pattern.vala"
		if (code == '?') {
#line 113 "random-pattern.vala"
			_tmp8_ = pasang_random_pattern_rand_char (self, "ifts");
#line 390 "random-pattern.c"
		} else {
#line 114 "random-pattern.vala"
			_tmp8_ = code;
#line 394 "random-pattern.c"
		}
#line 113 "random-pattern.vala"
		_tmp7_ = _tmp8_;
#line 398 "random-pattern.c"
	}
#line 112 "random-pattern.vala"
	result = _tmp7_;
#line 112 "random-pattern.vala"
	return result;
#line 404 "random-pattern.c"
}

/**
     * Build a pattern where the background and the foreground form the same pattern.
     *
     * Side effect: this.dots
     */
static void
pasang_random_pattern_next_random_day_and_night (PasangRandomPattern* self)
{
	gint seed_num = 0;
	const gchar* _tmp0_ = NULL;
	gchar* seed = NULL;
	gchar* _tmp1_;
	gchar* dots = NULL;
	gchar* _tmp2_;
	gint dots_length1;
	gint _dots_size_;
	gint j = 0;
	gchar* _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gint _tmp14__length1;
	GString* b = NULL;
	GString* _tmp50_;
	GString* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
#line 122 "random-pattern.vala"
	g_return_if_fail (self != NULL);
#line 123 "random-pattern.vala"
	seed_num = (gint) g_random_int_range ((gint32) 0, (gint32) 2);
#line 124 "random-pattern.vala"
	if (seed_num == 0) {
#line 125 "random-pattern.vala"
		_tmp0_ = "PPPPPHHHHHP HPPPPHHHHPP HHPPPHHHPPP HHHPPHHPPPP HHHHPHPPPPP HHHHH";
#line 441 "random-pattern.c"
	} else {
#line 126 "random-pattern.vala"
		_tmp0_ = "PPPPPHHHPPP PPPPPHHHPPP PPPPPHHHPPP HHHHHHHHPPP HHHHHHHHPPP HHHHH";
#line 445 "random-pattern.c"
	}
#line 124 "random-pattern.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 124 "random-pattern.vala"
	seed = _tmp1_;
#line 127 "random-pattern.vala"
	_tmp2_ = g_new0 (gchar, (PASANG_NUM_WHITES + PASANG_NUM_BLACKS) + 1);
#line 127 "random-pattern.vala"
	dots = _tmp2_;
#line 127 "random-pattern.vala"
	dots_length1 = (PASANG_NUM_WHITES + PASANG_NUM_BLACKS) + 1;
#line 127 "random-pattern.vala"
	_dots_size_ = dots_length1;
#line 128 "random-pattern.vala"
	j = 0;
#line 461 "random-pattern.c"
	{
		gint i = 0;
#line 129 "random-pattern.vala"
		i = 0;
#line 466 "random-pattern.c"
		{
			gboolean _tmp3_ = FALSE;
#line 129 "random-pattern.vala"
			_tmp3_ = TRUE;
#line 129 "random-pattern.vala"
			while (TRUE) {
#line 473 "random-pattern.c"
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gint _tmp9__length1;
				gchar* _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				gint _tmp12_;
#line 129 "random-pattern.vala"
				if (!_tmp3_) {
#line 486 "random-pattern.c"
					gint _tmp4_;
#line 129 "random-pattern.vala"
					_tmp4_ = i;
#line 129 "random-pattern.vala"
					i = _tmp4_ + 1;
#line 492 "random-pattern.c"
				}
#line 129 "random-pattern.vala"
				_tmp3_ = FALSE;
#line 129 "random-pattern.vala"
				_tmp5_ = seed;
#line 129 "random-pattern.vala"
				_tmp6_ = strlen (_tmp5_);
#line 129 "random-pattern.vala"
				_tmp7_ = _tmp6_;
#line 129 "random-pattern.vala"
				if (!(i < _tmp7_)) {
#line 129 "random-pattern.vala"
					break;
#line 506 "random-pattern.c"
				}
#line 130 "random-pattern.vala"
				_tmp8_ = seed;
#line 130 "random-pattern.vala"
				if (string_get (_tmp8_, (glong) i) == ' ') {
#line 130 "random-pattern.vala"
					continue;
#line 514 "random-pattern.c"
				}
#line 131 "random-pattern.vala"
				_tmp9_ = dots;
#line 131 "random-pattern.vala"
				_tmp9__length1 = dots_length1;
#line 131 "random-pattern.vala"
				_tmp10_ = dots;
#line 131 "random-pattern.vala"
				_tmp10__length1 = dots_length1;
#line 131 "random-pattern.vala"
				_tmp11_ = seed;
#line 131 "random-pattern.vala"
				_tmp10_[120 - j] = (gchar) string_get (_tmp11_, (glong) i);
#line 131 "random-pattern.vala"
				_tmp9_[j] = (gchar) string_get (_tmp11_, (glong) i);
#line 132 "random-pattern.vala"
				_tmp12_ = j;
#line 132 "random-pattern.vala"
				j = _tmp12_ + 1;
#line 534 "random-pattern.c"
			}
		}
	}
#line 134 "random-pattern.vala"
	_tmp13_ = dots;
#line 134 "random-pattern.vala"
	_tmp13__length1 = dots_length1;
#line 134 "random-pattern.vala"
	_tmp14_ = dots;
#line 134 "random-pattern.vala"
	_tmp14__length1 = dots_length1;
#line 134 "random-pattern.vala"
	_tmp13_[_tmp14__length1 / 2] = '-';
#line 548 "random-pattern.c"
	{
		gint n = 0;
#line 138 "random-pattern.vala"
		n = (gint) g_random_int_range ((gint32) 0, (gint32) 20);
#line 553 "random-pattern.c"
		{
			gboolean _tmp15_ = FALSE;
#line 138 "random-pattern.vala"
			_tmp15_ = TRUE;
#line 138 "random-pattern.vala"
			while (TRUE) {
#line 560 "random-pattern.c"
				PasangPoint* p = NULL;
				PasangPoint* _tmp17_;
				gint p_length1;
				gint _p_size_;
				PasangPoint* _tmp18_;
				gint _tmp18__length1;
				PasangPoint _tmp19_ = {0};
				gint _tmp20_ = 0;
				PasangPoint* _tmp25_;
				gint _tmp25__length1;
				PasangPoint* _tmp26_;
				gint _tmp26__length1;
				PasangPoint _tmp27_;
				PasangPoint _tmp28_ = {0};
				PasangPoint* _tmp29_;
				gint _tmp29__length1;
				PasangPoint* _tmp30_;
				gint _tmp30__length1;
				PasangPoint _tmp31_;
				PasangPoint* _tmp32_;
				gint _tmp32__length1;
				PasangPoint _tmp33_;
				PasangPoint _tmp34_ = {0};
				PasangPoint* _tmp35_;
				gint _tmp35__length1;
				PasangPoint* _tmp36_;
				gint _tmp36__length1;
				PasangPoint _tmp37_;
				PasangPoint* _tmp38_;
				gint _tmp38__length1;
				PasangPoint _tmp39_;
				PasangPoint _tmp40_ = {0};
				PasangPoint* _tmp41_;
				gint _tmp41__length1;
#line 138 "random-pattern.vala"
				if (!_tmp15_) {
#line 597 "random-pattern.c"
					gint _tmp16_;
#line 138 "random-pattern.vala"
					_tmp16_ = n;
#line 138 "random-pattern.vala"
					n = _tmp16_ - 1;
#line 603 "random-pattern.c"
				}
#line 138 "random-pattern.vala"
				_tmp15_ = FALSE;
#line 138 "random-pattern.vala"
				if (!(n > 0)) {
#line 138 "random-pattern.vala"
					break;
#line 611 "random-pattern.c"
				}
#line 139 "random-pattern.vala"
				_tmp17_ = g_new0 (PasangPoint, 4);
#line 139 "random-pattern.vala"
				p = _tmp17_;
#line 139 "random-pattern.vala"
				p_length1 = 4;
#line 139 "random-pattern.vala"
				_p_size_ = p_length1;
#line 140 "random-pattern.vala"
				_tmp18_ = p;
#line 140 "random-pattern.vala"
				_tmp18__length1 = p_length1;
#line 140 "random-pattern.vala"
				pasang_point_init_xy (&_tmp19_, (gint) g_random_int_range ((gint32) 1, (gint32) 6), (gint) g_random_int_range ((gint32) 0, (gint32) 6));
#line 140 "random-pattern.vala"
				_tmp18_[0] = _tmp19_;
#line 141 "random-pattern.vala"
				if (seed_num == 0) {
#line 631 "random-pattern.c"
					PasangPoint* _tmp21_;
					gint _tmp21__length1;
					PasangPoint _tmp22_;
#line 141 "random-pattern.vala"
					_tmp21_ = p;
#line 141 "random-pattern.vala"
					_tmp21__length1 = p_length1;
#line 141 "random-pattern.vala"
					_tmp22_ = _tmp21_[0];
#line 141 "random-pattern.vala"
					_tmp20_ = 6 - _tmp22_.x;
#line 643 "random-pattern.c"
				} else {
					PasangPoint* _tmp23_;
					gint _tmp23__length1;
					PasangPoint _tmp24_;
#line 141 "random-pattern.vala"
					_tmp23_ = p;
#line 141 "random-pattern.vala"
					_tmp23__length1 = p_length1;
#line 141 "random-pattern.vala"
					_tmp24_ = _tmp23_[0];
#line 141 "random-pattern.vala"
					_tmp20_ = _tmp24_.x;
#line 656 "random-pattern.c"
				}
#line 141 "random-pattern.vala"
				_tmp25_ = p;
#line 141 "random-pattern.vala"
				_tmp25__length1 = p_length1;
#line 141 "random-pattern.vala"
				_tmp26_ = p;
#line 141 "random-pattern.vala"
				_tmp26__length1 = p_length1;
#line 141 "random-pattern.vala"
				_tmp27_ = _tmp26_[0];
#line 141 "random-pattern.vala"
				pasang_point_init_xy (&_tmp28_, _tmp20_, 5 - _tmp27_.y);
#line 141 "random-pattern.vala"
				_tmp25_[1] = _tmp28_;
#line 142 "random-pattern.vala"
				_tmp29_ = p;
#line 142 "random-pattern.vala"
				_tmp29__length1 = p_length1;
#line 142 "random-pattern.vala"
				_tmp30_ = p;
#line 142 "random-pattern.vala"
				_tmp30__length1 = p_length1;
#line 142 "random-pattern.vala"
				_tmp31_ = _tmp30_[0];
#line 142 "random-pattern.vala"
				_tmp32_ = p;
#line 142 "random-pattern.vala"
				_tmp32__length1 = p_length1;
#line 142 "random-pattern.vala"
				_tmp33_ = _tmp32_[0];
#line 142 "random-pattern.vala"
				pasang_point_init_xy (&_tmp34_, -_tmp31_.y, _tmp33_.x);
#line 142 "random-pattern.vala"
				_tmp29_[2] = _tmp34_;
#line 143 "random-pattern.vala"
				_tmp35_ = p;
#line 143 "random-pattern.vala"
				_tmp35__length1 = p_length1;
#line 143 "random-pattern.vala"
				_tmp36_ = p;
#line 143 "random-pattern.vala"
				_tmp36__length1 = p_length1;
#line 143 "random-pattern.vala"
				_tmp37_ = _tmp36_[1];
#line 143 "random-pattern.vala"
				_tmp38_ = p;
#line 143 "random-pattern.vala"
				_tmp38__length1 = p_length1;
#line 143 "random-pattern.vala"
				_tmp39_ = _tmp38_[1];
#line 143 "random-pattern.vala"
				pasang_point_init_xy (&_tmp40_, -_tmp37_.y, _tmp39_.x);
#line 143 "random-pattern.vala"
				_tmp35_[3] = _tmp40_;
#line 144 "random-pattern.vala"
				_tmp41_ = p;
#line 144 "random-pattern.vala"
				_tmp41__length1 = p_length1;
#line 716 "random-pattern.c"
				{
					PasangPoint* t_collection = NULL;
					gint t_collection_length1 = 0;
					gint _t_collection_size_ = 0;
					gint t_it = 0;
#line 144 "random-pattern.vala"
					t_collection = _tmp41_;
#line 144 "random-pattern.vala"
					t_collection_length1 = _tmp41__length1;
#line 144 "random-pattern.vala"
					for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
#line 728 "random-pattern.c"
						PasangPoint t = {0};
#line 144 "random-pattern.vala"
						t = t_collection[t_it];
#line 732 "random-pattern.c"
						{
							gint xy = 0;
							PasangPoint _tmp42_;
							PasangPoint _tmp43_;
							gchar* _tmp44_;
							gint _tmp44__length1;
							gchar* _tmp45_;
							gint _tmp45__length1;
							gchar _tmp46_;
							gchar* _tmp47_;
							gint _tmp47__length1;
							gchar* _tmp48_;
							gint _tmp48__length1;
							gchar _tmp49_;
#line 145 "random-pattern.vala"
							_tmp42_ = t;
#line 145 "random-pattern.vala"
							_tmp43_ = t;
#line 145 "random-pattern.vala"
							xy = (_tmp42_.x + 5) + (11 * (_tmp43_.y + 5));
#line 146 "random-pattern.vala"
							_tmp44_ = dots;
#line 146 "random-pattern.vala"
							_tmp44__length1 = dots_length1;
#line 146 "random-pattern.vala"
							_tmp45_ = dots;
#line 146 "random-pattern.vala"
							_tmp45__length1 = dots_length1;
#line 146 "random-pattern.vala"
							_tmp46_ = _tmp45_[xy];
#line 146 "random-pattern.vala"
							_tmp44_[xy] = ('H' + 'P') - _tmp46_;
#line 147 "random-pattern.vala"
							_tmp47_ = dots;
#line 147 "random-pattern.vala"
							_tmp47__length1 = dots_length1;
#line 147 "random-pattern.vala"
							_tmp48_ = dots;
#line 147 "random-pattern.vala"
							_tmp48__length1 = dots_length1;
#line 147 "random-pattern.vala"
							_tmp49_ = _tmp48_[120 - xy];
#line 147 "random-pattern.vala"
							_tmp47_[120 - xy] = ('H' + 'P') - _tmp49_;
#line 777 "random-pattern.c"
						}
					}
				}
#line 138 "random-pattern.vala"
				p = (g_free (p), NULL);
#line 783 "random-pattern.c"
			}
		}
	}
#line 151 "random-pattern.vala"
	_tmp50_ = g_string_new ("");
#line 151 "random-pattern.vala"
	b = _tmp50_;
#line 791 "random-pattern.c"
	{
		gint i = 0;
#line 152 "random-pattern.vala"
		i = 0;
#line 796 "random-pattern.c"
		{
			gboolean _tmp51_ = FALSE;
#line 152 "random-pattern.vala"
			_tmp51_ = TRUE;
#line 152 "random-pattern.vala"
			while (TRUE) {
#line 803 "random-pattern.c"
				GString* _tmp53_;
				gchar* _tmp54_;
				gint _tmp54__length1;
				gchar _tmp55_;
#line 152 "random-pattern.vala"
				if (!_tmp51_) {
#line 810 "random-pattern.c"
					gint _tmp52_;
#line 152 "random-pattern.vala"
					_tmp52_ = i;
#line 152 "random-pattern.vala"
					i = _tmp52_ + 1;
#line 816 "random-pattern.c"
				}
#line 152 "random-pattern.vala"
				_tmp51_ = FALSE;
#line 152 "random-pattern.vala"
				if (!(i < 60)) {
#line 152 "random-pattern.vala"
					break;
#line 824 "random-pattern.c"
				}
#line 152 "random-pattern.vala"
				_tmp53_ = b;
#line 152 "random-pattern.vala"
				_tmp54_ = dots;
#line 152 "random-pattern.vala"
				_tmp54__length1 = dots_length1;
#line 152 "random-pattern.vala"
				_tmp55_ = _tmp54_[i];
#line 152 "random-pattern.vala"
				g_string_append_unichar (_tmp53_, (gunichar) _tmp55_);
#line 836 "random-pattern.c"
			}
		}
	}
#line 153 "random-pattern.vala"
	_tmp56_ = b;
#line 153 "random-pattern.vala"
	_tmp57_ = _tmp56_->str;
#line 153 "random-pattern.vala"
	_tmp58_ = g_strdup (_tmp57_);
#line 153 "random-pattern.vala"
	_g_free0 (((PasangPattern*) self)->dots);
#line 153 "random-pattern.vala"
	((PasangPattern*) self)->dots = _tmp58_;
#line 122 "random-pattern.vala"
	_g_string_free0 (b);
#line 122 "random-pattern.vala"
	dots = (g_free (dots), NULL);
#line 122 "random-pattern.vala"
	_g_free0 (seed);
#line 856 "random-pattern.c"
}

/**
     * From a random pattern specification such as " Rt Rt Rt *t RtJf JfRt",
     * select (randomly) a symmetry type such as "*t". Then construct a random
     * pattern based on the chosen symmetry type.
     *
     * Side effect: this.dots
     */
void
pasang_random_pattern_next_random (PasangRandomPattern* self)
{
#line 163 "random-pattern.vala"
	g_return_if_fail (self != NULL);
#line 164 "random-pattern.vala"
	pasang_random_pattern_next_random_aux (self);
#line 165 "random-pattern.vala"
	pasang_pattern_create_pixbuf ((PasangPattern*) self);
#line 875 "random-pattern.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1477 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1477 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1477 "glib-2.0.vapi"
	return result;
#line 894 "random-pattern.c"
}

static void
_vala_array_add20 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 216 "random-pattern.vala"
	if ((*length) == (*size)) {
#line 216 "random-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 216 "random-pattern.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 909 "random-pattern.c"
	}
#line 216 "random-pattern.vala"
	(*array)[(*length)++] = *value;
#line 913 "random-pattern.c"
}

static void
_vala_array_add21 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 217 "random-pattern.vala"
	if ((*length) == (*size)) {
#line 217 "random-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 217 "random-pattern.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 928 "random-pattern.c"
	}
#line 217 "random-pattern.vala"
	(*array)[(*length)++] = *value;
#line 932 "random-pattern.c"
}

static void
_vala_array_add22 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 218 "random-pattern.vala"
	if ((*length) == (*size)) {
#line 218 "random-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 218 "random-pattern.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 947 "random-pattern.c"
	}
#line 218 "random-pattern.vala"
	(*array)[(*length)++] = *value;
#line 951 "random-pattern.c"
}

static void
_vala_array_add23 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 219 "random-pattern.vala"
	if ((*length) == (*size)) {
#line 219 "random-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 219 "random-pattern.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 966 "random-pattern.c"
	}
#line 219 "random-pattern.vala"
	(*array)[(*length)++] = *value;
#line 970 "random-pattern.c"
}

static void
_vala_array_add24 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 220 "random-pattern.vala"
	if ((*length) == (*size)) {
#line 220 "random-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 220 "random-pattern.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 985 "random-pattern.c"
	}
#line 220 "random-pattern.vala"
	(*array)[(*length)++] = *value;
#line 989 "random-pattern.c"
}

static void
_vala_array_add25 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 221 "random-pattern.vala"
	if ((*length) == (*size)) {
#line 221 "random-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 221 "random-pattern.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 1004 "random-pattern.c"
	}
#line 221 "random-pattern.vala"
	(*array)[(*length)++] = *value;
#line 1008 "random-pattern.c"
}

static void
_vala_array_add26 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 222 "random-pattern.vala"
	if ((*length) == (*size)) {
#line 222 "random-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 222 "random-pattern.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 1023 "random-pattern.c"
	}
#line 222 "random-pattern.vala"
	(*array)[(*length)++] = *value;
#line 1027 "random-pattern.c"
}

static void
_vala_array_add27 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 230 "random-pattern.vala"
	if ((*length) == (*size)) {
#line 230 "random-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 230 "random-pattern.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 1042 "random-pattern.c"
	}
#line 230 "random-pattern.vala"
	(*array)[(*length)++] = *value;
#line 1046 "random-pattern.c"
}

static void
_vala_array_add28 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 244 "random-pattern.vala"
	if ((*length) == (*size)) {
#line 244 "random-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 244 "random-pattern.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 1061 "random-pattern.c"
	}
#line 244 "random-pattern.vala"
	(*array)[(*length)++] = *value;
#line 1065 "random-pattern.c"
}

static void
pasang_random_pattern_next_random_aux (PasangRandomPattern* self)
{
	gint index = 0;
	gint _tmp5_;
	const gchar* _tmp6_;
	gchar code1 = '\0';
	gchar _tmp7_;
	gchar code2 = '\0';
	gchar _tmp8_;
	gchar code3 = '\0';
	gchar _tmp9_;
	gchar code4 = '\0';
	gchar _tmp10_;
	gchar* dots = NULL;
	gchar* _tmp11_;
	gint dots_length1;
	gint _dots_size_;
	GString* b = NULL;
	GString* _tmp113_;
	GString* _tmp119_;
	const gchar* _tmp120_;
	gchar* _tmp121_;
#line 168 "random-pattern.vala"
	g_return_if_fail (self != NULL);
#line 169 "random-pattern.vala"
	index = 0;
#line 1095 "random-pattern.c"
	{
		gboolean _tmp0_ = FALSE;
#line 170 "random-pattern.vala"
		_tmp0_ = TRUE;
#line 170 "random-pattern.vala"
		while (TRUE) {
#line 1102 "random-pattern.c"
			const gchar* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
#line 170 "random-pattern.vala"
			if (!_tmp0_) {
#line 1108 "random-pattern.c"
				const gchar* _tmp1_;
#line 172 "random-pattern.vala"
				_tmp1_ = self->priv->spec;
#line 172 "random-pattern.vala"
				if (!(string_get (_tmp1_, (glong) index) != ' ')) {
#line 172 "random-pattern.vala"
					break;
#line 1116 "random-pattern.c"
				}
			}
#line 170 "random-pattern.vala"
			_tmp0_ = FALSE;
#line 171 "random-pattern.vala"
			_tmp2_ = self->priv->spec;
#line 171 "random-pattern.vala"
			_tmp3_ = strlen (_tmp2_);
#line 171 "random-pattern.vala"
			_tmp4_ = _tmp3_;
#line 171 "random-pattern.vala"
			index = (gint) g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp4_));
#line 1129 "random-pattern.c"
		}
	}
#line 173 "random-pattern.vala"
	_tmp5_ = index;
#line 173 "random-pattern.vala"
	index = _tmp5_ + 1;
#line 175 "random-pattern.vala"
	_tmp6_ = self->priv->spec;
#line 175 "random-pattern.vala"
	if (string_get (_tmp6_, (glong) index) == 'd') {
#line 176 "random-pattern.vala"
		pasang_random_pattern_next_random_day_and_night (self);
#line 177 "random-pattern.vala"
		return;
#line 1144 "random-pattern.c"
	}
#line 181 "random-pattern.vala"
	_tmp7_ = pasang_random_pattern_read_spec (self, &index, ' ');
#line 181 "random-pattern.vala"
	code1 = _tmp7_;
#line 182 "random-pattern.vala"
	_tmp8_ = pasang_random_pattern_read_spec (self, &index, 'f');
#line 182 "random-pattern.vala"
	code2 = _tmp8_;
#line 183 "random-pattern.vala"
	_tmp9_ = pasang_random_pattern_read_spec (self, &index, code1);
#line 183 "random-pattern.vala"
	code3 = _tmp9_;
#line 184 "random-pattern.vala"
	_tmp10_ = pasang_random_pattern_read_spec (self, &index, code2);
#line 184 "random-pattern.vala"
	code4 = _tmp10_;
#line 185 "random-pattern.vala"
	_tmp11_ = g_new0 (gchar, (PASANG_NUM_WHITES + PASANG_NUM_BLACKS) + 1);
#line 185 "random-pattern.vala"
	dots = _tmp11_;
#line 185 "random-pattern.vala"
	dots_length1 = (PASANG_NUM_WHITES + PASANG_NUM_BLACKS) + 1;
#line 185 "random-pattern.vala"
	_dots_size_ = dots_length1;
#line 1170 "random-pattern.c"
	{
		gint attempt = 0;
#line 187 "random-pattern.vala"
		attempt = 0;
#line 1175 "random-pattern.c"
		{
			gboolean _tmp12_ = FALSE;
#line 187 "random-pattern.vala"
			_tmp12_ = TRUE;
#line 187 "random-pattern.vala"
			while (TRUE) {
#line 1182 "random-pattern.c"
				gchar* _tmp18_;
				gint _tmp18__length1;
				gchar* _tmp19_;
				gint _tmp19__length1;
				gint center_range = 0;
				gint num_whites = 0;
#line 187 "random-pattern.vala"
				if (!_tmp12_) {
#line 1191 "random-pattern.c"
					gint _tmp13_;
#line 187 "random-pattern.vala"
					_tmp13_ = attempt;
#line 187 "random-pattern.vala"
					attempt = _tmp13_ + 1;
#line 1197 "random-pattern.c"
				}
#line 187 "random-pattern.vala"
				_tmp12_ = FALSE;
#line 1201 "random-pattern.c"
				{
					gint i = 0;
#line 189 "random-pattern.vala"
					i = 0;
#line 1206 "random-pattern.c"
					{
						gboolean _tmp14_ = FALSE;
#line 189 "random-pattern.vala"
						_tmp14_ = TRUE;
#line 189 "random-pattern.vala"
						while (TRUE) {
#line 1213 "random-pattern.c"
							gchar* _tmp16_;
							gint _tmp16__length1;
							gchar* _tmp17_;
							gint _tmp17__length1;
#line 189 "random-pattern.vala"
							if (!_tmp14_) {
#line 1220 "random-pattern.c"
								gint _tmp15_;
#line 189 "random-pattern.vala"
								_tmp15_ = i;
#line 189 "random-pattern.vala"
								i = _tmp15_ + 1;
#line 1226 "random-pattern.c"
							}
#line 189 "random-pattern.vala"
							_tmp14_ = FALSE;
#line 189 "random-pattern.vala"
							_tmp16_ = dots;
#line 189 "random-pattern.vala"
							_tmp16__length1 = dots_length1;
#line 189 "random-pattern.vala"
							if (!(i < _tmp16__length1)) {
#line 189 "random-pattern.vala"
								break;
#line 1238 "random-pattern.c"
							}
#line 190 "random-pattern.vala"
							_tmp17_ = dots;
#line 190 "random-pattern.vala"
							_tmp17__length1 = dots_length1;
#line 190 "random-pattern.vala"
							_tmp17_[i] = 'H';
#line 1246 "random-pattern.c"
						}
					}
				}
#line 192 "random-pattern.vala"
				_tmp18_ = dots;
#line 192 "random-pattern.vala"
				_tmp18__length1 = dots_length1;
#line 192 "random-pattern.vala"
				_tmp19_ = dots;
#line 192 "random-pattern.vala"
				_tmp19__length1 = dots_length1;
#line 192 "random-pattern.vala"
				_tmp18_[_tmp19__length1 / 2] = '-';
#line 195 "random-pattern.vala"
				center_range = (gint) g_random_int_range ((gint32) (2 * 2), (gint32) (4 * 4));
#line 196 "random-pattern.vala"
				num_whites = 0;
#line 197 "random-pattern.vala"
				while (TRUE) {
#line 1266 "random-pattern.c"
					gint x = 0;
					gint y = 0;
					gboolean _tmp20_ = FALSE;
					gboolean center = FALSE;
					gchar _tmp21_ = '\0';
					gchar orig_type = '\0';
					gchar _tmp22_ = '\0';
					gchar copy_type = '\0';
					gboolean _tmp23_ = FALSE;
					gboolean duplicate_tile = FALSE;
					gboolean _tmp24_ = FALSE;
					gboolean second_quarter_only = FALSE;
					gchar* s = NULL;
					gchar* _tmp25_;
					PasangPoint* grays = NULL;
					PasangPoint _tmp26_ = {0};
					PasangPoint* _tmp27_;
					gint grays_length1;
					gint _grays_size_;
					const gchar* _tmp28_;
					const gchar* _tmp31_;
					const gchar* _tmp34_;
					const gchar* _tmp37_;
					const gchar* _tmp40_;
					const gchar* _tmp43_;
					const gchar* _tmp46_;
					PasangPoint* whites = NULL;
					PasangPoint* _tmp49_;
					gint whites_length1;
					gint _whites_size_;
					PasangPoint* _tmp50_;
					gint _tmp50__length1;
					PasangPoint* _tmp89_;
					gint _tmp89__length1;
#line 197 "random-pattern.vala"
					if (!(num_whites < PASANG_NUM_WHITES)) {
#line 197 "random-pattern.vala"
						break;
#line 1305 "random-pattern.c"
					}
#line 200 "random-pattern.vala"
					x = (gint) g_random_int_range ((gint32) 0, (gint32) 6);
#line 201 "random-pattern.vala"
					y = (gint) g_random_int_range ((gint32) 0, (gint32) 6);
#line 202 "random-pattern.vala"
					if (x == 0) {
#line 202 "random-pattern.vala"
						_tmp20_ = y == 0;
#line 1315 "random-pattern.c"
					} else {
#line 202 "random-pattern.vala"
						_tmp20_ = FALSE;
#line 1319 "random-pattern.c"
					}
#line 202 "random-pattern.vala"
					if (_tmp20_) {
#line 202 "random-pattern.vala"
						continue;
#line 1325 "random-pattern.c"
					}
#line 203 "random-pattern.vala"
					center = ((x * x) + (y * y)) <= center_range;
#line 204 "random-pattern.vala"
					if (center) {
#line 204 "random-pattern.vala"
						_tmp21_ = code3;
#line 1333 "random-pattern.c"
					} else {
#line 204 "random-pattern.vala"
						_tmp21_ = code1;
#line 1337 "random-pattern.c"
					}
#line 204 "random-pattern.vala"
					orig_type = (gchar) _tmp21_;
#line 205 "random-pattern.vala"
					if (center) {
#line 205 "random-pattern.vala"
						_tmp22_ = code4;
#line 1345 "random-pattern.c"
					} else {
#line 205 "random-pattern.vala"
						_tmp22_ = code2;
#line 1349 "random-pattern.c"
					}
#line 205 "random-pattern.vala"
					copy_type = (gchar) _tmp22_;
#line 206 "random-pattern.vala"
					if (copy_type >= 'a') {
#line 206 "random-pattern.vala"
						_tmp23_ = copy_type <= 'z';
#line 1357 "random-pattern.c"
					} else {
#line 206 "random-pattern.vala"
						_tmp23_ = FALSE;
#line 1361 "random-pattern.c"
					}
#line 206 "random-pattern.vala"
					duplicate_tile = _tmp23_;
#line 207 "random-pattern.vala"
					if (!duplicate_tile) {
#line 207 "random-pattern.vala"
						_tmp24_ = g_random_int_range ((gint32) 0, (gint32) 2) == ((gint32) 1);
#line 1369 "random-pattern.c"
					} else {
#line 207 "random-pattern.vala"
						_tmp24_ = FALSE;
#line 1373 "random-pattern.c"
					}
#line 207 "random-pattern.vala"
					second_quarter_only = _tmp24_;
#line 208 "random-pattern.vala"
					if (second_quarter_only) {
#line 209 "random-pattern.vala"
						orig_type = copy_type;
#line 210 "random-pattern.vala"
						copy_type = 'i';
#line 1383 "random-pattern.c"
					}
#line 214 "random-pattern.vala"
					_tmp25_ = g_strdup_printf ("%c", orig_type);
#line 214 "random-pattern.vala"
					s = _tmp25_;
#line 215 "random-pattern.vala"
					pasang_point_init_xy (&_tmp26_, x, y);
#line 215 "random-pattern.vala"
					_tmp27_ = g_new0 (PasangPoint, 1);
#line 215 "random-pattern.vala"
					_tmp27_[0] = _tmp26_;
#line 215 "random-pattern.vala"
					grays = _tmp27_;
#line 215 "random-pattern.vala"
					grays_length1 = 1;
#line 215 "random-pattern.vala"
					_grays_size_ = grays_length1;
#line 216 "random-pattern.vala"
					_tmp28_ = s;
#line 216 "random-pattern.vala"
					if (string_contains ("JXO", _tmp28_)) {
#line 1405 "random-pattern.c"
						PasangPoint* _tmp29_;
						gint _tmp29__length1;
						PasangPoint _tmp30_ = {0};
#line 216 "random-pattern.vala"
						_tmp29_ = grays;
#line 216 "random-pattern.vala"
						_tmp29__length1 = grays_length1;
#line 216 "random-pattern.vala"
						pasang_point_init_xy (&_tmp30_, y, x);
#line 216 "random-pattern.vala"
						_vala_array_add20 (&grays, &grays_length1, &_grays_size_, &_tmp30_);
#line 1417 "random-pattern.c"
					}
#line 217 "random-pattern.vala"
					_tmp31_ = s;
#line 217 "random-pattern.vala"
					if (string_contains ("FO", _tmp31_)) {
#line 1423 "random-pattern.c"
						PasangPoint* _tmp32_;
						gint _tmp32__length1;
						PasangPoint _tmp33_ = {0};
#line 217 "random-pattern.vala"
						_tmp32_ = grays;
#line 217 "random-pattern.vala"
						_tmp32__length1 = grays_length1;
#line 217 "random-pattern.vala"
						pasang_point_init_xy (&_tmp33_, 6 - y, x);
#line 217 "random-pattern.vala"
						_vala_array_add21 (&grays, &grays_length1, &_grays_size_, &_tmp33_);
#line 1435 "random-pattern.c"
					}
#line 218 "random-pattern.vala"
					_tmp34_ = s;
#line 218 "random-pattern.vala"
					if (string_contains ("THO", _tmp34_)) {
#line 1441 "random-pattern.c"
						PasangPoint* _tmp35_;
						gint _tmp35__length1;
						PasangPoint _tmp36_ = {0};
#line 218 "random-pattern.vala"
						_tmp35_ = grays;
#line 218 "random-pattern.vala"
						_tmp35__length1 = grays_length1;
#line 218 "random-pattern.vala"
						pasang_point_init_xy (&_tmp36_, 6 - x, y);
#line 218 "random-pattern.vala"
						_vala_array_add22 (&grays, &grays_length1, &_grays_size_, &_tmp36_);
#line 1453 "random-pattern.c"
					}
#line 219 "random-pattern.vala"
					_tmp37_ = s;
#line 219 "random-pattern.vala"
					if (string_contains ("SXHFO", _tmp37_)) {
#line 1459 "random-pattern.c"
						PasangPoint* _tmp38_;
						gint _tmp38__length1;
						PasangPoint _tmp39_ = {0};
#line 219 "random-pattern.vala"
						_tmp38_ = grays;
#line 219 "random-pattern.vala"
						_tmp38__length1 = grays_length1;
#line 219 "random-pattern.vala"
						pasang_point_init_xy (&_tmp39_, 6 - x, 6 - y);
#line 219 "random-pattern.vala"
						_vala_array_add23 (&grays, &grays_length1, &_grays_size_, &_tmp39_);
#line 1471 "random-pattern.c"
					}
#line 220 "random-pattern.vala"
					_tmp40_ = s;
#line 220 "random-pattern.vala"
					if (string_contains ("LXO", _tmp40_)) {
#line 1477 "random-pattern.c"
						PasangPoint* _tmp41_;
						gint _tmp41__length1;
						PasangPoint _tmp42_ = {0};
#line 220 "random-pattern.vala"
						_tmp41_ = grays;
#line 220 "random-pattern.vala"
						_tmp41__length1 = grays_length1;
#line 220 "random-pattern.vala"
						pasang_point_init_xy (&_tmp42_, 6 - y, 6 - x);
#line 220 "random-pattern.vala"
						_vala_array_add24 (&grays, &grays_length1, &_grays_size_, &_tmp42_);
#line 1489 "random-pattern.c"
					}
#line 221 "random-pattern.vala"
					_tmp43_ = s;
#line 221 "random-pattern.vala"
					if (string_contains ("FO", _tmp43_)) {
#line 1495 "random-pattern.c"
						PasangPoint* _tmp44_;
						gint _tmp44__length1;
						PasangPoint _tmp45_ = {0};
#line 221 "random-pattern.vala"
						_tmp44_ = grays;
#line 221 "random-pattern.vala"
						_tmp44__length1 = grays_length1;
#line 221 "random-pattern.vala"
						pasang_point_init_xy (&_tmp45_, y, 6 - x);
#line 221 "random-pattern.vala"
						_vala_array_add25 (&grays, &grays_length1, &_grays_size_, &_tmp45_);
#line 1507 "random-pattern.c"
					}
#line 222 "random-pattern.vala"
					_tmp46_ = s;
#line 222 "random-pattern.vala"
					if (string_contains ("EHO", _tmp46_)) {
#line 1513 "random-pattern.c"
						PasangPoint* _tmp47_;
						gint _tmp47__length1;
						PasangPoint _tmp48_ = {0};
#line 222 "random-pattern.vala"
						_tmp47_ = grays;
#line 222 "random-pattern.vala"
						_tmp47__length1 = grays_length1;
#line 222 "random-pattern.vala"
						pasang_point_init_xy (&_tmp48_, x, 6 - y);
#line 222 "random-pattern.vala"
						_vala_array_add26 (&grays, &grays_length1, &_grays_size_, &_tmp48_);
#line 1525 "random-pattern.c"
					}
#line 225 "random-pattern.vala"
					_tmp49_ = g_new0 (PasangPoint, 0);
#line 225 "random-pattern.vala"
					whites = _tmp49_;
#line 225 "random-pattern.vala"
					whites_length1 = 0;
#line 225 "random-pattern.vala"
					_whites_size_ = whites_length1;
#line 226 "random-pattern.vala"
					_tmp50_ = grays;
#line 226 "random-pattern.vala"
					_tmp50__length1 = grays_length1;
#line 1539 "random-pattern.c"
					{
						PasangPoint* p_collection = NULL;
						gint p_collection_length1 = 0;
						gint _p_collection_size_ = 0;
						gint p_it = 0;
#line 226 "random-pattern.vala"
						p_collection = _tmp50_;
#line 226 "random-pattern.vala"
						p_collection_length1 = _tmp50__length1;
#line 226 "random-pattern.vala"
						for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
#line 1551 "random-pattern.c"
							PasangPoint p = {0};
#line 226 "random-pattern.vala"
							p = p_collection[p_it];
#line 1555 "random-pattern.c"
							{
								gboolean _tmp51_ = FALSE;
								PasangPoint _tmp52_;
								gboolean _tmp54_ = FALSE;
								PasangPoint _tmp55_;
								PasangPoint _tmp59_ = {0};
								PasangPoint p2 = {0};
								gint _tmp76_ = 0;
								gint cut_off = 0;
								gboolean _tmp77_ = FALSE;
								gboolean _tmp78_ = FALSE;
								gboolean _tmp79_ = FALSE;
								PasangPoint _tmp80_;
#line 227 "random-pattern.vala"
								_tmp52_ = p;
#line 227 "random-pattern.vala"
								if (_tmp52_.x >= 0) {
#line 1573 "random-pattern.c"
									PasangPoint _tmp53_;
#line 227 "random-pattern.vala"
									_tmp53_ = p;
#line 227 "random-pattern.vala"
									_tmp51_ = _tmp53_.y >= 0;
#line 1579 "random-pattern.c"
								} else {
#line 227 "random-pattern.vala"
									_tmp51_ = FALSE;
#line 1583 "random-pattern.c"
								}
#line 227 "random-pattern.vala"
								_vala_assert (_tmp51_, "p.x >= 0 && p.y >= 0");
#line 228 "random-pattern.vala"
								_tmp55_ = p;
#line 228 "random-pattern.vala"
								if (_tmp55_.x > 5) {
#line 228 "random-pattern.vala"
									_tmp54_ = TRUE;
#line 1593 "random-pattern.c"
								} else {
									PasangPoint _tmp56_;
#line 228 "random-pattern.vala"
									_tmp56_ = p;
#line 228 "random-pattern.vala"
									_tmp54_ = _tmp56_.y > 5;
#line 1600 "random-pattern.c"
								}
#line 228 "random-pattern.vala"
								if (_tmp54_) {
#line 228 "random-pattern.vala"
									continue;
#line 1606 "random-pattern.c"
								}
#line 229 "random-pattern.vala"
								if (!second_quarter_only) {
#line 1610 "random-pattern.c"
									PasangPoint* _tmp57_;
									gint _tmp57__length1;
									PasangPoint _tmp58_;
#line 230 "random-pattern.vala"
									_tmp57_ = whites;
#line 230 "random-pattern.vala"
									_tmp57__length1 = whites_length1;
#line 230 "random-pattern.vala"
									_tmp58_ = p;
#line 230 "random-pattern.vala"
									_vala_array_add27 (&whites, &whites_length1, &_whites_size_, &_tmp58_);
#line 231 "random-pattern.vala"
									if (!duplicate_tile) {
#line 231 "random-pattern.vala"
										continue;
#line 1626 "random-pattern.c"
									}
								}
#line 234 "random-pattern.vala"
								if (copy_type == 'f') {
#line 1631 "random-pattern.c"
									PasangPoint _tmp60_ = {0};
									gboolean _tmp61_ = FALSE;
									PasangPoint _tmp62_;
#line 234 "random-pattern.vala"
									_tmp62_ = p;
#line 234 "random-pattern.vala"
									if (_tmp62_.y == 0) {
#line 234 "random-pattern.vala"
										_tmp61_ = TRUE;
#line 1641 "random-pattern.c"
									} else {
										PasangPoint _tmp63_;
#line 234 "random-pattern.vala"
										_tmp63_ = p;
#line 234 "random-pattern.vala"
										_tmp61_ = _tmp63_.x == 0;
#line 1648 "random-pattern.c"
									}
#line 234 "random-pattern.vala"
									if (_tmp61_) {
#line 1652 "random-pattern.c"
										PasangPoint _tmp64_;
										PasangPoint _tmp65_;
#line 235 "random-pattern.vala"
										_tmp64_ = p;
#line 235 "random-pattern.vala"
										_tmp65_ = p;
#line 235 "random-pattern.vala"
										pasang_point_init_xy (&_tmp60_, _tmp64_.y, _tmp65_.x);
#line 1661 "random-pattern.c"
									} else {
										PasangPoint _tmp66_;
										PasangPoint _tmp67_;
#line 236 "random-pattern.vala"
										_tmp66_ = p;
#line 236 "random-pattern.vala"
										_tmp67_ = p;
#line 236 "random-pattern.vala"
										pasang_point_init_xy (&_tmp60_, 6 - _tmp66_.y, _tmp67_.x);
#line 1671 "random-pattern.c"
									}
#line 234 "random-pattern.vala"
									_tmp59_ = _tmp60_;
#line 1675 "random-pattern.c"
								} else {
									PasangPoint _tmp68_ = {0};
#line 237 "random-pattern.vala"
									if (copy_type == 't') {
#line 1680 "random-pattern.c"
										PasangPoint _tmp69_;
										PasangPoint _tmp70_;
#line 237 "random-pattern.vala"
										_tmp69_ = p;
#line 237 "random-pattern.vala"
										_tmp70_ = p;
#line 237 "random-pattern.vala"
										pasang_point_init_xy (&_tmp68_, 6 - _tmp69_.x, _tmp70_.y);
#line 1689 "random-pattern.c"
									} else {
										PasangPoint _tmp71_ = {0};
#line 238 "random-pattern.vala"
										if (copy_type == 's') {
#line 1694 "random-pattern.c"
											PasangPoint _tmp72_;
											PasangPoint _tmp73_;
#line 238 "random-pattern.vala"
											_tmp72_ = p;
#line 238 "random-pattern.vala"
											_tmp73_ = p;
#line 238 "random-pattern.vala"
											pasang_point_init_xy (&_tmp71_, 6 - _tmp72_.x, 6 - _tmp73_.y);
#line 1703 "random-pattern.c"
										} else {
											PasangPoint _tmp74_;
											PasangPoint _tmp75_;
#line 239 "random-pattern.vala"
											_tmp74_ = p;
#line 239 "random-pattern.vala"
											_tmp75_ = p;
#line 239 "random-pattern.vala"
											pasang_point_init_xy (&_tmp71_, _tmp74_.x, _tmp75_.y);
#line 1713 "random-pattern.c"
										}
#line 238 "random-pattern.vala"
										_tmp68_ = _tmp71_;
#line 1717 "random-pattern.c"
									}
#line 237 "random-pattern.vala"
									_tmp59_ = _tmp68_;
#line 1721 "random-pattern.c"
								}
#line 233 "random-pattern.vala"
								p2 = _tmp59_;
#line 240 "random-pattern.vala"
								if (second_quarter_only) {
#line 240 "random-pattern.vala"
									_tmp76_ = 1;
#line 1729 "random-pattern.c"
								} else {
#line 240 "random-pattern.vala"
									_tmp76_ = 0;
#line 1733 "random-pattern.c"
								}
#line 240 "random-pattern.vala"
								cut_off = _tmp76_;
#line 241 "random-pattern.vala"
								_tmp80_ = p2;
#line 241 "random-pattern.vala"
								if (_tmp80_.x >= cut_off) {
#line 1741 "random-pattern.c"
									PasangPoint _tmp81_;
#line 241 "random-pattern.vala"
									_tmp81_ = p2;
#line 241 "random-pattern.vala"
									_tmp79_ = _tmp81_.y >= cut_off;
#line 1747 "random-pattern.c"
								} else {
#line 241 "random-pattern.vala"
									_tmp79_ = FALSE;
#line 1751 "random-pattern.c"
								}
#line 241 "random-pattern.vala"
								if (_tmp79_) {
#line 1755 "random-pattern.c"
									PasangPoint _tmp82_;
#line 241 "random-pattern.vala"
									_tmp82_ = p2;
#line 241 "random-pattern.vala"
									_tmp78_ = _tmp82_.x <= 5;
#line 1761 "random-pattern.c"
								} else {
#line 241 "random-pattern.vala"
									_tmp78_ = FALSE;
#line 1765 "random-pattern.c"
								}
#line 241 "random-pattern.vala"
								if (_tmp78_) {
#line 1769 "random-pattern.c"
									PasangPoint _tmp83_;
#line 241 "random-pattern.vala"
									_tmp83_ = p2;
#line 241 "random-pattern.vala"
									_tmp77_ = _tmp83_.y <= 5;
#line 1775 "random-pattern.c"
								} else {
#line 241 "random-pattern.vala"
									_tmp77_ = FALSE;
#line 1779 "random-pattern.c"
								}
#line 241 "random-pattern.vala"
								if (_tmp77_) {
#line 1783 "random-pattern.c"
									gboolean _tmp84_ = FALSE;
									PasangPoint _tmp85_;
									PasangPoint* _tmp87_;
									gint _tmp87__length1;
									PasangPoint _tmp88_;
#line 243 "random-pattern.vala"
									_tmp85_ = p2;
#line 243 "random-pattern.vala"
									if (_tmp85_.x != 0) {
#line 1793 "random-pattern.c"
										PasangPoint _tmp86_;
#line 243 "random-pattern.vala"
										_tmp86_ = p2;
#line 243 "random-pattern.vala"
										_tmp84_ = _tmp86_.y != 0;
#line 1799 "random-pattern.c"
									} else {
#line 243 "random-pattern.vala"
										_tmp84_ = FALSE;
#line 1803 "random-pattern.c"
									}
#line 243 "random-pattern.vala"
									if (_tmp84_) {
#line 243 "random-pattern.vala"
										p2.x = p2.x - 6;
#line 1809 "random-pattern.c"
									}
#line 244 "random-pattern.vala"
									_tmp87_ = whites;
#line 244 "random-pattern.vala"
									_tmp87__length1 = whites_length1;
#line 244 "random-pattern.vala"
									_tmp88_ = p2;
#line 244 "random-pattern.vala"
									_vala_array_add28 (&whites, &whites_length1, &_whites_size_, &_tmp88_);
#line 1819 "random-pattern.c"
								}
							}
						}
					}
#line 248 "random-pattern.vala"
					_tmp89_ = whites;
#line 248 "random-pattern.vala"
					_tmp89__length1 = whites_length1;
#line 1828 "random-pattern.c"
					{
						PasangPoint* p_collection = NULL;
						gint p_collection_length1 = 0;
						gint _p_collection_size_ = 0;
						gint p_it = 0;
#line 248 "random-pattern.vala"
						p_collection = _tmp89_;
#line 248 "random-pattern.vala"
						p_collection_length1 = _tmp89__length1;
#line 248 "random-pattern.vala"
						for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
#line 1840 "random-pattern.c"
							PasangPoint p = {0};
#line 248 "random-pattern.vala"
							p = p_collection[p_it];
#line 1844 "random-pattern.c"
							{
								gint xy = 0;
								PasangPoint _tmp90_;
								PasangPoint _tmp91_;
								gchar* _tmp92_;
								gint _tmp92__length1;
								gchar _tmp93_;
								gboolean _tmp94_ = FALSE;
								gboolean _tmp95_ = FALSE;
								gboolean _tmp96_ = FALSE;
#line 249 "random-pattern.vala"
								_tmp90_ = p;
#line 249 "random-pattern.vala"
								_tmp91_ = p;
#line 249 "random-pattern.vala"
								xy = (_tmp90_.x + 5) + (11 * (_tmp91_.y + 5));
#line 250 "random-pattern.vala"
								_tmp92_ = dots;
#line 250 "random-pattern.vala"
								_tmp92__length1 = dots_length1;
#line 250 "random-pattern.vala"
								_tmp93_ = _tmp92_[xy];
#line 250 "random-pattern.vala"
								if (_tmp93_ == 'P') {
#line 250 "random-pattern.vala"
									continue;
#line 1871 "random-pattern.c"
								}
#line 251 "random-pattern.vala"
								if (center) {
#line 1875 "random-pattern.c"
									PasangPoint _tmp97_;
									PasangPoint _tmp98_;
									PasangPoint _tmp99_;
									PasangPoint _tmp100_;
#line 251 "random-pattern.vala"
									_tmp97_ = p;
#line 251 "random-pattern.vala"
									_tmp98_ = p;
#line 251 "random-pattern.vala"
									_tmp99_ = p;
#line 251 "random-pattern.vala"
									_tmp100_ = p;
#line 251 "random-pattern.vala"
									_tmp96_ = ((_tmp97_.x * _tmp98_.x) + (_tmp99_.y * _tmp100_.y)) <= center_range;
#line 1890 "random-pattern.c"
								} else {
#line 251 "random-pattern.vala"
									_tmp96_ = FALSE;
#line 1894 "random-pattern.c"
								}
#line 251 "random-pattern.vala"
								if (_tmp96_) {
#line 251 "random-pattern.vala"
									_tmp95_ = TRUE;
#line 1900 "random-pattern.c"
								} else {
									gboolean _tmp101_ = FALSE;
#line 252 "random-pattern.vala"
									if (!center) {
#line 1905 "random-pattern.c"
										PasangPoint _tmp102_;
										PasangPoint _tmp103_;
										PasangPoint _tmp104_;
										PasangPoint _tmp105_;
#line 252 "random-pattern.vala"
										_tmp102_ = p;
#line 252 "random-pattern.vala"
										_tmp103_ = p;
#line 252 "random-pattern.vala"
										_tmp104_ = p;
#line 252 "random-pattern.vala"
										_tmp105_ = p;
#line 252 "random-pattern.vala"
										_tmp101_ = ((_tmp102_.x * _tmp103_.x) + (_tmp104_.y * _tmp105_.y)) > center_range;
#line 1920 "random-pattern.c"
									} else {
#line 252 "random-pattern.vala"
										_tmp101_ = FALSE;
#line 1924 "random-pattern.c"
									}
#line 252 "random-pattern.vala"
									_tmp95_ = _tmp101_;
#line 1928 "random-pattern.c"
								}
#line 251 "random-pattern.vala"
								if (_tmp95_) {
#line 251 "random-pattern.vala"
									_tmp94_ = TRUE;
#line 1934 "random-pattern.c"
								} else {
									gboolean _tmp106_ = FALSE;
#line 253 "random-pattern.vala"
									if (code1 == code3) {
#line 253 "random-pattern.vala"
										_tmp106_ = code2 == code4;
#line 1941 "random-pattern.c"
									} else {
#line 253 "random-pattern.vala"
										_tmp106_ = FALSE;
#line 1945 "random-pattern.c"
									}
#line 253 "random-pattern.vala"
									_tmp94_ = _tmp106_;
#line 1949 "random-pattern.c"
								}
#line 251 "random-pattern.vala"
								if (_tmp94_) {
#line 1953 "random-pattern.c"
									gchar* _tmp107_;
									gint _tmp107__length1;
									gchar _tmp108_;
									gchar* _tmp109_;
									gint _tmp109__length1;
									gchar _tmp110_;
									gchar* _tmp111_;
									gint _tmp111__length1;
									gchar* _tmp112_;
									gint _tmp112__length1;
#line 255 "random-pattern.vala"
									_tmp107_ = dots;
#line 255 "random-pattern.vala"
									_tmp107__length1 = dots_length1;
#line 255 "random-pattern.vala"
									_tmp108_ = _tmp107_[xy];
#line 255 "random-pattern.vala"
									_vala_assert (_tmp108_ == 'H', "dots[xy] == 'H'");
#line 256 "random-pattern.vala"
									_tmp109_ = dots;
#line 256 "random-pattern.vala"
									_tmp109__length1 = dots_length1;
#line 256 "random-pattern.vala"
									_tmp110_ = _tmp109_[120 - xy];
#line 256 "random-pattern.vala"
									_vala_assert (_tmp110_ == 'H', "dots[120 - xy] == 'H'");
#line 257 "random-pattern.vala"
									_tmp111_ = dots;
#line 257 "random-pattern.vala"
									_tmp111__length1 = dots_length1;
#line 257 "random-pattern.vala"
									_tmp112_ = dots;
#line 257 "random-pattern.vala"
									_tmp112__length1 = dots_length1;
#line 257 "random-pattern.vala"
									_tmp112_[120 - xy] = 'P';
#line 257 "random-pattern.vala"
									_tmp111_[xy] = 'P';
#line 259 "random-pattern.vala"
									num_whites += 2;
#line 1994 "random-pattern.c"
								}
							}
						}
					}
#line 197 "random-pattern.vala"
					whites = (g_free (whites), NULL);
#line 197 "random-pattern.vala"
					grays = (g_free (grays), NULL);
#line 197 "random-pattern.vala"
					_g_free0 (s);
#line 2005 "random-pattern.c"
				}
#line 264 "random-pattern.vala"
				if (num_whites > PASANG_NUM_WHITES) {
#line 266 "random-pattern.vala"
					continue;
#line 2011 "random-pattern.c"
				} else {
#line 270 "random-pattern.vala"
					break;
#line 2015 "random-pattern.c"
				}
			}
		}
	}
#line 274 "random-pattern.vala"
	_tmp113_ = g_string_new ("");
#line 274 "random-pattern.vala"
	b = _tmp113_;
#line 2024 "random-pattern.c"
	{
		gint i = 0;
#line 275 "random-pattern.vala"
		i = 0;
#line 2029 "random-pattern.c"
		{
			gboolean _tmp114_ = FALSE;
#line 275 "random-pattern.vala"
			_tmp114_ = TRUE;
#line 275 "random-pattern.vala"
			while (TRUE) {
#line 2036 "random-pattern.c"
				GString* _tmp116_;
				gchar* _tmp117_;
				gint _tmp117__length1;
				gchar _tmp118_;
#line 275 "random-pattern.vala"
				if (!_tmp114_) {
#line 2043 "random-pattern.c"
					gint _tmp115_;
#line 275 "random-pattern.vala"
					_tmp115_ = i;
#line 275 "random-pattern.vala"
					i = _tmp115_ + 1;
#line 2049 "random-pattern.c"
				}
#line 275 "random-pattern.vala"
				_tmp114_ = FALSE;
#line 275 "random-pattern.vala"
				if (!(i < 60)) {
#line 275 "random-pattern.vala"
					break;
#line 2057 "random-pattern.c"
				}
#line 275 "random-pattern.vala"
				_tmp116_ = b;
#line 275 "random-pattern.vala"
				_tmp117_ = dots;
#line 275 "random-pattern.vala"
				_tmp117__length1 = dots_length1;
#line 275 "random-pattern.vala"
				_tmp118_ = _tmp117_[i];
#line 275 "random-pattern.vala"
				g_string_append_unichar (_tmp116_, (gunichar) _tmp118_);
#line 2069 "random-pattern.c"
			}
		}
	}
#line 276 "random-pattern.vala"
	_tmp119_ = b;
#line 276 "random-pattern.vala"
	_tmp120_ = _tmp119_->str;
#line 276 "random-pattern.vala"
	_tmp121_ = g_strdup (_tmp120_);
#line 276 "random-pattern.vala"
	_g_free0 (((PasangPattern*) self)->dots);
#line 276 "random-pattern.vala"
	((PasangPattern*) self)->dots = _tmp121_;
#line 168 "random-pattern.vala"
	_g_string_free0 (b);
#line 168 "random-pattern.vala"
	dots = (g_free (dots), NULL);
#line 2087 "random-pattern.c"
}

gdouble
pasang_random_pattern_get_temperature (PasangRandomPattern* self)
{
	gdouble result;
#line 81 "random-pattern.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 81 "random-pattern.vala"
	result = self->priv->_temperature;
#line 81 "random-pattern.vala"
	return result;
#line 2100 "random-pattern.c"
}

void
pasang_random_pattern_set_temperature (PasangRandomPattern* self,
                                       gdouble value)
{
#line 82 "random-pattern.vala"
	g_return_if_fail (self != NULL);
#line 83 "random-pattern.vala"
	self->priv->_temperature = value;
#line 84 "random-pattern.vala"
	pasang_pattern_create_pixbuf ((PasangPattern*) self);
#line 2113 "random-pattern.c"
}

static void
pasang_random_pattern_class_init (PasangRandomPatternClass * klass,
                                  gpointer klass_data)
{
#line 21 "random-pattern.vala"
	pasang_random_pattern_parent_class = g_type_class_peek_parent (klass);
#line 21 "random-pattern.vala"
	((PasangPatternClass *) klass)->finalize = pasang_random_pattern_finalize;
#line 21 "random-pattern.vala"
	g_type_class_adjust_private_offset (klass, &PasangRandomPattern_private_offset);
#line 21 "random-pattern.vala"
	((PasangPatternClass *) klass)->background = (void (*) (PasangPattern*, gint, gint, gint)) pasang_random_pattern_real_background;
#line 2128 "random-pattern.c"
}

static void
pasang_random_pattern_instance_init (PasangRandomPattern * self,
                                     gpointer klass)
{
#line 21 "random-pattern.vala"
	self->priv = pasang_random_pattern_get_instance_private (self);
#line 2137 "random-pattern.c"
}

static void
pasang_random_pattern_finalize (PasangPattern * obj)
{
	PasangRandomPattern * self;
#line 21 "random-pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_RANDOM_PATTERN, PasangRandomPattern);
#line 65 "random-pattern.vala"
	_g_free0 (self->priv->spec);
#line 21 "random-pattern.vala"
	PASANG_PATTERN_CLASS (pasang_random_pattern_parent_class)->finalize (obj);
#line 2150 "random-pattern.c"
}

GType
pasang_random_pattern_get_type (void)
{
	static volatile gsize pasang_random_pattern_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_random_pattern_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangRandomPatternClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_random_pattern_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangRandomPattern), 0, (GInstanceInitFunc) pasang_random_pattern_instance_init, NULL };
		GType pasang_random_pattern_type_id;
		pasang_random_pattern_type_id = g_type_register_static (PASANG_TYPE_PATTERN, "PasangRandomPattern", &g_define_type_info, 0);
		PasangRandomPattern_private_offset = g_type_add_instance_private (pasang_random_pattern_type_id, sizeof (PasangRandomPatternPrivate));
		g_once_init_leave (&pasang_random_pattern_type_id__volatile, pasang_random_pattern_type_id);
	}
	return pasang_random_pattern_type_id__volatile;
}

