/* server.c generated by valac 0.46.3, the Vala compiler
 * generated from server.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2018  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>
#include <../config.h>

#define PASANG_TYPE_CLIENT_CONNECTION (pasang_client_connection_get_type ())
#define PASANG_CLIENT_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_CLIENT_CONNECTION, PasangClientConnection))
#define PASANG_CLIENT_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_CLIENT_CONNECTION, PasangClientConnectionClass))
#define PASANG_IS_CLIENT_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_CLIENT_CONNECTION))
#define PASANG_IS_CLIENT_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_CLIENT_CONNECTION))
#define PASANG_CLIENT_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_CLIENT_CONNECTION, PasangClientConnectionClass))

typedef struct _PasangClientConnection PasangClientConnection;
typedef struct _PasangClientConnectionClass PasangClientConnectionClass;
typedef struct _PasangClientConnectionPrivate PasangClientConnectionPrivate;

#define PASANG_TYPE_GAME (pasang_game_get_type ())
#define PASANG_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME, PasangGame))
#define PASANG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME, PasangGameClass))
#define PASANG_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME))
#define PASANG_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME))
#define PASANG_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME, PasangGameClass))

typedef struct _PasangGame PasangGame;
typedef struct _PasangGameClass PasangGameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pasang_client_connection_unref0(var) ((var == NULL) ? NULL : (var = (pasang_client_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PasangClientConnectionRunData PasangClientConnectionRunData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef enum  {
	PASANG_STAGE_NULL = -999,
	PASANG_STAGE_OPENING = 0,
	PASANG_STAGE_SELECT = 1,
	PASANG_STAGE_SUB_SELECT = 2,
	PASANG_STAGE_MOVE = 3,
	PASANG_STAGE_SUB_MOVE = 4,
	PASANG_STAGE_GAME_OVER = 5
} PasangStage;

#define PASANG_TYPE_STAGE (pasang_stage_get_type ())

#define PASANG_TYPE_MOVE (pasang_move_get_type ())
#define PASANG_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_MOVE, PasangMove))
#define PASANG_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_MOVE, PasangMoveClass))
#define PASANG_IS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_MOVE))
#define PASANG_IS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_MOVE))
#define PASANG_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_MOVE, PasangMoveClass))

typedef struct _PasangMove PasangMove;
typedef struct _PasangMoveClass PasangMoveClass;
typedef struct _PasangParamSpecClientConnection PasangParamSpecClientConnection;

#define PASANG_TYPE_SERVER (pasang_server_get_type ())
#define PASANG_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_SERVER, PasangServer))
#define PASANG_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_SERVER, PasangServerClass))
#define PASANG_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_SERVER))
#define PASANG_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_SERVER))
#define PASANG_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_SERVER, PasangServerClass))

typedef struct _PasangServer PasangServer;
typedef struct _PasangServerClass PasangServerClass;
typedef struct _PasangServerPrivate PasangServerPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _pasang_server_unref0(var) ((var == NULL) ? NULL : (var = (pasang_server_unref (var), NULL)))
typedef struct _PasangParamSpecServer PasangParamSpecServer;

struct _PasangClientConnection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PasangClientConnectionPrivate * priv;
};

struct _PasangClientConnectionClass {
	GTypeClass parent_class;
	void (*finalize) (PasangClientConnection *self);
};

struct _PasangClientConnectionPrivate {
	GCancellable* cancellable;
	GSocketConnection* connection;
	GDataInputStream* input;
	GDataOutputStream* output;
	glong id;
	PasangGame* game;
	gchar* user_name;
	PasangClientConnection* opponent;
};

struct _PasangClientConnectionRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangClientConnection* self;
	gchar* line;
	gsize length;
	gchar* _tmp0_;
	GDataInputStream* _tmp1_;
	GCancellable* _tmp2_;
	gsize _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GCancellable* _tmp11_;
	GError* e;
	FILE* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GSocketConnection* _tmp15_;
	GError* e2;
	FILE* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GCancellable* _tmp19_;
	GError* _inner_error0_;
};

struct _PasangParamSpecClientConnection {
	GParamSpec parent_instance;
};

struct _PasangServer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PasangServerPrivate * priv;
};

struct _PasangServerClass {
	GTypeClass parent_class;
	void (*finalize) (PasangServer *self);
};

struct _PasangServerPrivate {
	GMainLoop* loop;
};

struct _PasangParamSpecServer {
	GParamSpec parent_instance;
};

static gint PasangClientConnection_private_offset;
static gpointer pasang_client_connection_parent_class = NULL;
static PasangClientConnection** pasang_client_connection_connections;
static gint pasang_client_connection_connections_length1;
static PasangClientConnection** pasang_client_connection_connections = NULL;
static gint pasang_client_connection_connections_length1 = 0;
static gint _pasang_client_connection_connections_size_ = 0;
static glong pasang_client_connection_next_id;
static glong pasang_client_connection_next_id = (glong) 0;
static gint PasangServer_private_offset;
static gpointer pasang_server_parent_class = NULL;

gpointer pasang_client_connection_ref (gpointer instance);
void pasang_client_connection_unref (gpointer instance);
GParamSpec* pasang_param_spec_client_connection (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
void pasang_value_set_client_connection (GValue* value,
                                         gpointer v_object);
void pasang_value_take_client_connection (GValue* value,
                                          gpointer v_object);
gpointer pasang_value_get_client_connection (const GValue* value);
GType pasang_client_connection_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangClientConnection, pasang_client_connection_unref)
GType pasang_game_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGame, g_object_unref)
void pasang_client_connection_add_connection (GSocketConnection* connection);
static PasangClientConnection* pasang_client_connection_new (GSocketConnection* con,
                                                      glong id);
static PasangClientConnection* pasang_client_connection_construct (GType object_type,
                                                            GSocketConnection* con,
                                                            glong id);
static void pasang_client_connection_run (PasangClientConnection* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
static void pasang_client_connection_run_finish (PasangClientConnection* self,
                                          GAsyncResult* _res_);
static void _vala_array_add29 (PasangClientConnection** * array,
                        int* length,
                        int* size,
                        PasangClientConnection* value);
static void pasang_client_connection_run_data_free (gpointer _data);
static gboolean pasang_client_connection_run_co (PasangClientConnectionRunData* _data_);
static void pasang_client_connection_run_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void pasang_client_connection_interpret (PasangClientConnection* self,
                                         const gchar* line);
static gchar* pasang_client_connection_sanitize (PasangClientConnection* self,
                                          const gchar* s);
static void pasang_client_connection_usher_out (PasangClientConnection* self);
static gboolean pasang_client_connection_is_others (PasangClientConnection* self,
                                             PasangClientConnection* con);
static gchar* pasang_client_connection_status (PasangClientConnection* self);
static void pasang_client_connection_broadcast (PasangClientConnection* self,
                                         const gchar* message);
static void pasang_client_connection_send (PasangClientConnection* self,
                                    const gchar* message);
static void pasang_client_connection_login (PasangClientConnection* self,
                                     const gchar* name);
static void pasang_client_connection_logout (PasangClientConnection* self);
static void pasang_client_connection_get_user_list (PasangClientConnection* self);
static void pasang_client_connection_challenge (PasangClientConnection* self,
                                         glong opponent_id);
static void pasang_client_connection_leave (PasangClientConnection* self);
static void pasang_client_connection_chat (PasangClientConnection* self,
                                    const gchar* msg);
static void pasang_client_connection_move (PasangClientConnection* self,
                                    const gchar* arg);
PasangGame* pasang_game_new (void);
PasangGame* pasang_game_construct (GType object_type);
GType pasang_stage_get_type (void) G_GNUC_CONST;
PasangStage pasang_game_get_stage (PasangGame* self);
gboolean pasang_game_is_valid_pattern (const gchar* pattern);
void pasang_game_start (PasangGame* self,
                        const gchar* starting_pattern);
gint pasang_game_get_seq (PasangGame* self);
GType pasang_move_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangMove, g_object_unref)
PasangMove* pasang_game_get_move (PasangGame* self,
                                  const gchar* move_notation);
void pasang_game_perform_from_notation (PasangGame* self,
                                        const gchar* move_notation);
static void pasang_client_connection_finalize (PasangClientConnection * obj);
gpointer pasang_server_ref (gpointer instance);
void pasang_server_unref (gpointer instance);
GParamSpec* pasang_param_spec_server (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void pasang_value_set_server (GValue* value,
                              gpointer v_object);
void pasang_value_take_server (GValue* value,
                               gpointer v_object);
gpointer pasang_value_get_server (const GValue* value);
GType pasang_server_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangServer, pasang_server_unref)
void pasang_server_main (guint16 port);
PasangServer* pasang_server_new (guint16 port);
PasangServer* pasang_server_construct (GType object_type,
                                       guint16 port);
static gboolean pasang_server_on_connection (PasangServer* self,
                                      GSocketConnection* connection,
                                      GObject* src);
static gboolean _pasang_server_on_connection_g_socket_service_incoming (GSocketService* _sender,
                                                                 GSocketConnection* connection,
                                                                 GObject* source_object,
                                                                 gpointer self);
static void pasang_server_finalize (PasangServer * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
pasang_client_connection_get_instance_private (PasangClientConnection* self)
{
	return G_STRUCT_MEMBER_P (self, PasangClientConnection_private_offset);
}

static gpointer
_pasang_client_connection_ref0 (gpointer self)
{
#line 30 "server.vala"
	return self ? pasang_client_connection_ref (self) : NULL;
#line 305 "server.c"
}

static void
_vala_array_add29 (PasangClientConnection** * array,
                   int* length,
                   int* size,
                   PasangClientConnection* value)
{
#line 36 "server.vala"
	if ((*length) == (*size)) {
#line 36 "server.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 36 "server.vala"
		*array = g_renew (PasangClientConnection*, *array, (*size) + 1);
#line 320 "server.c"
	}
#line 36 "server.vala"
	(*array)[(*length)++] = value;
#line 36 "server.vala"
	(*array)[*length] = NULL;
#line 326 "server.c"
}

void
pasang_client_connection_add_connection (GSocketConnection* connection)
{
	PasangClientConnection* cc = NULL;
	glong _tmp0_;
	PasangClientConnection* _tmp1_;
	PasangClientConnection** _tmp12_;
	gint _tmp12__length1;
	PasangClientConnection* _tmp13_;
	PasangClientConnection* _tmp14_;
	PasangClientConnection* _tmp15_;
#line 25 "server.vala"
	g_return_if_fail (connection != NULL);
#line 26 "server.vala"
	_tmp0_ = pasang_client_connection_next_id;
#line 26 "server.vala"
	pasang_client_connection_next_id = _tmp0_ + 1;
#line 26 "server.vala"
	_tmp1_ = pasang_client_connection_new (connection, _tmp0_);
#line 26 "server.vala"
	cc = _tmp1_;
#line 350 "server.c"
	{
		gint i = 0;
#line 28 "server.vala"
		i = 0;
#line 355 "server.c"
		{
			gboolean _tmp2_ = FALSE;
#line 28 "server.vala"
			_tmp2_ = TRUE;
#line 28 "server.vala"
			while (TRUE) {
#line 362 "server.c"
				PasangClientConnection** _tmp4_;
				gint _tmp4__length1;
				PasangClientConnection** _tmp5_;
				gint _tmp5__length1;
				PasangClientConnection* _tmp6_;
				GSocketConnection* _tmp7_;
#line 28 "server.vala"
				if (!_tmp2_) {
#line 371 "server.c"
					gint _tmp3_;
#line 28 "server.vala"
					_tmp3_ = i;
#line 28 "server.vala"
					i = _tmp3_ + 1;
#line 377 "server.c"
				}
#line 28 "server.vala"
				_tmp2_ = FALSE;
#line 28 "server.vala"
				_tmp4_ = pasang_client_connection_connections;
#line 28 "server.vala"
				_tmp4__length1 = pasang_client_connection_connections_length1;
#line 28 "server.vala"
				if (!(i < _tmp4__length1)) {
#line 28 "server.vala"
					break;
#line 389 "server.c"
				}
#line 29 "server.vala"
				_tmp5_ = pasang_client_connection_connections;
#line 29 "server.vala"
				_tmp5__length1 = pasang_client_connection_connections_length1;
#line 29 "server.vala"
				_tmp6_ = _tmp5_[i];
#line 29 "server.vala"
				_tmp7_ = _tmp6_->priv->connection;
#line 29 "server.vala"
				if (_tmp7_ == NULL) {
#line 401 "server.c"
					PasangClientConnection** _tmp8_;
					gint _tmp8__length1;
					PasangClientConnection* _tmp9_;
					PasangClientConnection* _tmp10_;
					PasangClientConnection* _tmp11_;
#line 30 "server.vala"
					_tmp8_ = pasang_client_connection_connections;
#line 30 "server.vala"
					_tmp8__length1 = pasang_client_connection_connections_length1;
#line 30 "server.vala"
					_tmp9_ = cc;
#line 30 "server.vala"
					_tmp10_ = _pasang_client_connection_ref0 (_tmp9_);
#line 30 "server.vala"
					_pasang_client_connection_unref0 (_tmp8_[i]);
#line 30 "server.vala"
					_tmp8_[i] = _tmp10_;
#line 31 "server.vala"
					_tmp11_ = cc;
#line 31 "server.vala"
					pasang_client_connection_run (_tmp11_, NULL, NULL);
#line 32 "server.vala"
					_pasang_client_connection_unref0 (cc);
#line 32 "server.vala"
					return;
#line 427 "server.c"
				}
			}
		}
	}
#line 36 "server.vala"
	_tmp12_ = pasang_client_connection_connections;
#line 36 "server.vala"
	_tmp12__length1 = pasang_client_connection_connections_length1;
#line 36 "server.vala"
	_tmp13_ = cc;
#line 36 "server.vala"
	_tmp14_ = _pasang_client_connection_ref0 (_tmp13_);
#line 36 "server.vala"
	_vala_array_add29 (&pasang_client_connection_connections, &pasang_client_connection_connections_length1, &_pasang_client_connection_connections_size_, _tmp14_);
#line 37 "server.vala"
	_tmp15_ = cc;
#line 37 "server.vala"
	pasang_client_connection_run (_tmp15_, NULL, NULL);
#line 25 "server.vala"
	_pasang_client_connection_unref0 (cc);
#line 448 "server.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 63 "server.vala"
	return self ? g_object_ref (self) : NULL;
#line 456 "server.c"
}

static PasangClientConnection*
pasang_client_connection_construct (GType object_type,
                                    GSocketConnection* con,
                                    glong id)
{
	PasangClientConnection* self = NULL;
	GSocketConnection* _tmp0_;
	GSocketConnection* _tmp1_;
	GInputStream* _tmp2_;
	GInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	GSocketConnection* _tmp5_;
	GOutputStream* _tmp6_;
	GOutputStream* _tmp7_;
	GDataOutputStream* _tmp8_;
	GCancellable* _tmp9_;
#line 62 "server.vala"
	g_return_val_if_fail (con != NULL, NULL);
#line 62 "server.vala"
	self = (PasangClientConnection*) g_type_create_instance (object_type);
#line 63 "server.vala"
	_tmp0_ = _g_object_ref0 (con);
#line 63 "server.vala"
	_g_object_unref0 (self->priv->connection);
#line 63 "server.vala"
	self->priv->connection = _tmp0_;
#line 64 "server.vala"
	_tmp1_ = self->priv->connection;
#line 64 "server.vala"
	_tmp2_ = g_io_stream_get_input_stream ((GIOStream*) _tmp1_);
#line 64 "server.vala"
	_tmp3_ = _tmp2_;
#line 64 "server.vala"
	_tmp4_ = g_data_input_stream_new (_tmp3_);
#line 64 "server.vala"
	_g_object_unref0 (self->priv->input);
#line 64 "server.vala"
	self->priv->input = _tmp4_;
#line 65 "server.vala"
	_tmp5_ = self->priv->connection;
#line 65 "server.vala"
	_tmp6_ = g_io_stream_get_output_stream ((GIOStream*) _tmp5_);
#line 65 "server.vala"
	_tmp7_ = _tmp6_;
#line 65 "server.vala"
	_tmp8_ = g_data_output_stream_new (_tmp7_);
#line 65 "server.vala"
	_g_object_unref0 (self->priv->output);
#line 65 "server.vala"
	self->priv->output = _tmp8_;
#line 66 "server.vala"
	self->priv->id = id;
#line 67 "server.vala"
	_tmp9_ = g_cancellable_new ();
#line 67 "server.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 67 "server.vala"
	self->priv->cancellable = _tmp9_;
#line 62 "server.vala"
	return self;
#line 519 "server.c"
}

static PasangClientConnection*
pasang_client_connection_new (GSocketConnection* con,
                              glong id)
{
#line 62 "server.vala"
	return pasang_client_connection_construct (PASANG_TYPE_CLIENT_CONNECTION, con, id);
#line 528 "server.c"
}

static void
pasang_client_connection_run_data_free (gpointer _data)
{
	PasangClientConnectionRunData* _data_;
	_data_ = _data;
#line 21 "server.vala"
	_pasang_client_connection_unref0 (_data_->self);
#line 21 "server.vala"
	g_slice_free (PasangClientConnectionRunData, _data_);
#line 540 "server.c"
}

static void
pasang_client_connection_run (PasangClientConnection* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	PasangClientConnectionRunData* _data_;
	PasangClientConnection* _tmp0_;
#line 21 "server.vala"
	_data_ = g_slice_new0 (PasangClientConnectionRunData);
#line 21 "server.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 21 "server.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_client_connection_run_data_free);
#line 21 "server.vala"
	_tmp0_ = _pasang_client_connection_ref0 (self);
#line 21 "server.vala"
	_data_->self = _tmp0_;
#line 21 "server.vala"
	pasang_client_connection_run_co (_data_);
#line 562 "server.c"
}

static void
pasang_client_connection_run_finish (PasangClientConnection* self,
                                     GAsyncResult* _res_)
{
	PasangClientConnectionRunData* _data_;
#line 21 "server.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 572 "server.c"
}

static void
pasang_client_connection_run_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	PasangClientConnectionRunData* _data_;
#line 75 "server.vala"
	_data_ = _user_data_;
#line 75 "server.vala"
	_data_->_source_object_ = source_object;
#line 75 "server.vala"
	_data_->_res_ = _res_;
#line 75 "server.vala"
	pasang_client_connection_run_co (_data_);
#line 589 "server.c"
}

static gboolean
pasang_client_connection_run_co (PasangClientConnectionRunData* _data_)
{
#line 70 "server.vala"
	switch (_data_->_state_) {
#line 70 "server.vala"
		case 0:
#line 599 "server.c"
		goto _state_0;
#line 70 "server.vala"
		case 1:
#line 603 "server.c"
		goto _state_1;
		default:
#line 70 "server.vala"
		g_assert_not_reached ();
#line 608 "server.c"
	}
	_state_0:
#line 71 "server.vala"
	g_message ("server.vala:71: Listening to #%ld", _data_->self->priv->id);
#line 613 "server.c"
	{
#line 75 "server.vala"
		while (TRUE) {
#line 75 "server.vala"
			_data_->_tmp1_ = _data_->self->priv->input;
#line 75 "server.vala"
			_data_->_tmp2_ = _data_->self->priv->cancellable;
#line 75 "server.vala"
			_data_->_tmp3_ = 0UL;
#line 75 "server.vala"
			_data_->_state_ = 1;
#line 75 "server.vala"
			g_data_input_stream_read_line_async (_data_->_tmp1_, 100, _data_->_tmp2_, pasang_client_connection_run_ready, _data_);
#line 75 "server.vala"
			return FALSE;
#line 629 "server.c"
			_state_1:
#line 75 "server.vala"
			_data_->_tmp4_ = g_data_input_stream_read_line_finish (_data_->_tmp1_, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error0_);
#line 75 "server.vala"
			_data_->length = _data_->_tmp3_;
#line 75 "server.vala"
			_data_->_tmp0_ = _data_->_tmp4_;
#line 75 "server.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 75 "server.vala"
				_g_free0 (_data_->line);
#line 641 "server.c"
				goto __catch13_g_error;
			}
#line 75 "server.vala"
			_data_->_tmp5_ = _data_->_tmp0_;
#line 75 "server.vala"
			_data_->_tmp0_ = NULL;
#line 75 "server.vala"
			_g_free0 (_data_->line);
#line 75 "server.vala"
			_data_->line = _data_->_tmp5_;
#line 75 "server.vala"
			_data_->_tmp6_ = _data_->line;
#line 75 "server.vala"
			if (!(_data_->_tmp6_ != NULL)) {
#line 75 "server.vala"
				_g_free0 (_data_->_tmp0_);
#line 75 "server.vala"
				break;
#line 660 "server.c"
			}
#line 76 "server.vala"
			_data_->_tmp7_ = _data_->line;
#line 76 "server.vala"
			g_message ("server.vala:76: From #%ld: %s", _data_->self->priv->id, _data_->_tmp7_);
#line 77 "server.vala"
			_data_->_tmp8_ = _data_->line;
#line 77 "server.vala"
			_data_->_tmp9_ = pasang_client_connection_sanitize (_data_->self, _data_->_tmp8_);
#line 77 "server.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 77 "server.vala"
			pasang_client_connection_interpret (_data_->self, _data_->_tmp10_);
#line 77 "server.vala"
			_g_free0 (_data_->_tmp10_);
#line 78 "server.vala"
			_data_->_tmp11_ = _data_->self->priv->cancellable;
#line 78 "server.vala"
			if (g_cancellable_is_cancelled (_data_->_tmp11_)) {
#line 78 "server.vala"
				_g_free0 (_data_->_tmp0_);
#line 78 "server.vala"
				break;
#line 684 "server.c"
			}
#line 75 "server.vala"
			_g_free0 (_data_->_tmp0_);
#line 688 "server.c"
		}
#line 72 "server.vala"
		_g_free0 (_data_->line);
#line 692 "server.c"
	}
	goto __finally13;
	__catch13_g_error:
	{
#line 72 "server.vala"
		_data_->e = _data_->_inner_error0_;
#line 72 "server.vala"
		_data_->_inner_error0_ = NULL;
#line 82 "server.vala"
		_data_->_tmp12_ = stderr;
#line 82 "server.vala"
		_data_->_tmp13_ = _data_->e;
#line 82 "server.vala"
		_data_->_tmp14_ = _data_->_tmp13_->message;
#line 82 "server.vala"
		fprintf (_data_->_tmp12_, "IO error in line #%ld: %s\n", _data_->self->priv->id, _data_->_tmp14_);
#line 72 "server.vala"
		_g_error_free0 (_data_->e);
#line 711 "server.c"
	}
	__finally13:
#line 72 "server.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 72 "server.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 72 "server.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 72 "server.vala"
		g_object_unref (_data_->_async_result);
#line 72 "server.vala"
		return FALSE;
#line 724 "server.c"
	}
#line 84 "server.vala"
	pasang_client_connection_usher_out (_data_->self);
#line 728 "server.c"
	{
#line 86 "server.vala"
		_data_->_tmp15_ = _data_->self->priv->connection;
#line 86 "server.vala"
		g_io_stream_close ((GIOStream*) _data_->_tmp15_, NULL, &_data_->_inner_error0_);
#line 86 "server.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 736 "server.c"
			goto __catch14_g_error;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
#line 85 "server.vala"
		_data_->e2 = _data_->_inner_error0_;
#line 85 "server.vala"
		_data_->_inner_error0_ = NULL;
#line 89 "server.vala"
		_data_->_tmp16_ = stderr;
#line 89 "server.vala"
		_data_->_tmp17_ = _data_->e2;
#line 89 "server.vala"
		_data_->_tmp18_ = _data_->_tmp17_->message;
#line 89 "server.vala"
		fprintf (_data_->_tmp16_, "Disconnection error in line #%ld: %s\n", _data_->self->priv->id, _data_->_tmp18_);
#line 85 "server.vala"
		_g_error_free0 (_data_->e2);
#line 757 "server.c"
	}
	__finally14:
#line 85 "server.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 85 "server.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 85 "server.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 85 "server.vala"
		g_object_unref (_data_->_async_result);
#line 85 "server.vala"
		return FALSE;
#line 770 "server.c"
	}
#line 91 "server.vala"
	_data_->_tmp19_ = _data_->self->priv->cancellable;
#line 91 "server.vala"
	g_cancellable_cancel (_data_->_tmp19_);
#line 92 "server.vala"
	_g_object_unref0 (_data_->self->priv->connection);
#line 92 "server.vala"
	_data_->self->priv->connection = NULL;
#line 93 "server.vala"
	g_message ("server.vala:93: Disconnecting #%ld", labs (_data_->self->priv->id));
#line 70 "server.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 70 "server.vala"
	if (_data_->_state_ != 0) {
#line 70 "server.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 70 "server.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 790 "server.c"
		}
	}
#line 70 "server.vala"
	g_object_unref (_data_->_async_result);
#line 70 "server.vala"
	return FALSE;
#line 797 "server.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1307 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1308 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1309 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1310 "glib-2.0.vapi"
	result = _result_;
#line 1310 "glib-2.0.vapi"
	return result;
#line 818 "server.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1481 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1481 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 840 "server.c"
	} else {
#line 1481 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 844 "server.c"
	}
#line 1481 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1481 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 850 "server.c"
	} else {
#line 1481 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 854 "server.c"
	}
#line 1481 "glib-2.0.vapi"
	if (_tmp0_) {
#line 858 "server.c"
		gchar* _tmp2_;
#line 1482 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1482 "glib-2.0.vapi"
		result = _tmp2_;
#line 1482 "glib-2.0.vapi"
		return result;
#line 866 "server.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1485 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1485 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1485 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1485 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1485 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1485 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1485 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1485 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 894 "server.c"
				goto __catch15_g_regex_error;
			}
#line 1485 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1485 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1485 "glib-2.0.vapi"
			return NULL;
#line 903 "server.c"
		}
#line 1486 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1486 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1486 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1486 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1486 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1486 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 917 "server.c"
				goto __catch15_g_regex_error;
			}
#line 1486 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1486 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1486 "glib-2.0.vapi"
			return NULL;
#line 926 "server.c"
		}
#line 1486 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1486 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1486 "glib-2.0.vapi"
		result = _tmp10_;
#line 1486 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1486 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1486 "glib-2.0.vapi"
		return result;
#line 940 "server.c"
	}
	goto __finally15;
	__catch15_g_regex_error:
	{
		GError* e = NULL;
#line 1484 "glib-2.0.vapi"
		e = _inner_error0_;
#line 1484 "glib-2.0.vapi"
		_inner_error0_ = NULL;
#line 1488 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1484 "glib-2.0.vapi"
		_g_error_free0 (e);
#line 954 "server.c"
	}
	__finally15:
#line 1484 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1484 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1484 "glib-2.0.vapi"
	return NULL;
#line 963 "server.c"
}

static gchar*
pasang_client_connection_sanitize (PasangClientConnection* self,
                                   const gchar* s)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 96 "server.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "server.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 97 "server.vala"
	_tmp0_ = string_strip (s);
#line 97 "server.vala"
	_tmp1_ = _tmp0_;
#line 97 "server.vala"
	_tmp2_ = string_replace (_tmp1_, "\n", "");
#line 97 "server.vala"
	_tmp3_ = _tmp2_;
#line 97 "server.vala"
	_g_free0 (_tmp1_);
#line 97 "server.vala"
	result = _tmp3_;
#line 97 "server.vala"
	return result;
#line 993 "server.c"
}

/**
     * true if con refers to another connection (not self)
     */
static gboolean
pasang_client_connection_is_others (PasangClientConnection* self,
                                    PasangClientConnection* con)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result = FALSE;
#line 103 "server.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 103 "server.vala"
	g_return_val_if_fail (con != NULL, FALSE);
#line 104 "server.vala"
	if (con->priv->id != self->priv->id) {
#line 1012 "server.c"
		GCancellable* _tmp2_;
#line 104 "server.vala"
		_tmp2_ = con->priv->cancellable;
#line 104 "server.vala"
		_tmp1_ = !g_cancellable_is_cancelled (_tmp2_);
#line 1018 "server.c"
	} else {
#line 104 "server.vala"
		_tmp1_ = FALSE;
#line 1022 "server.c"
	}
#line 104 "server.vala"
	if (_tmp1_) {
#line 1026 "server.c"
		const gchar* _tmp3_;
#line 104 "server.vala"
		_tmp3_ = con->priv->user_name;
#line 104 "server.vala"
		_tmp0_ = _tmp3_ != NULL;
#line 1032 "server.c"
	} else {
#line 104 "server.vala"
		_tmp0_ = FALSE;
#line 1036 "server.c"
	}
#line 104 "server.vala"
	result = _tmp0_;
#line 104 "server.vala"
	return result;
#line 1042 "server.c"
}

/**
     * return "USER id status name"
     *   e.g. USER 6 w mat bon
     * where status is either w (waiting) or p (playing)
     */
static gchar*
pasang_client_connection_status (PasangClientConnection* self)
{
	gchar _tmp0_ = '\0';
	PasangClientConnection* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 112 "server.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "server.vala"
	_tmp1_ = self->priv->opponent;
#line 113 "server.vala"
	if (_tmp1_ == NULL) {
#line 113 "server.vala"
		_tmp0_ = 'w';
#line 1066 "server.c"
	} else {
#line 113 "server.vala"
		_tmp0_ = 'p';
#line 1070 "server.c"
	}
#line 113 "server.vala"
	_tmp2_ = self->priv->user_name;
#line 113 "server.vala"
	_tmp3_ = g_strdup_printf ("USER %ld %c %s\n", self->priv->id, (gint) _tmp0_, _tmp2_);
#line 113 "server.vala"
	result = _tmp3_;
#line 113 "server.vala"
	return result;
#line 1080 "server.c"
}

/**
     * Send message to other connections other than self.
     */
static void
pasang_client_connection_broadcast (PasangClientConnection* self,
                                    const gchar* message)
{
	PasangClientConnection** _tmp0_;
	gint _tmp0__length1;
#line 119 "server.vala"
	g_return_if_fail (self != NULL);
#line 119 "server.vala"
	g_return_if_fail (message != NULL);
#line 120 "server.vala"
	_tmp0_ = pasang_client_connection_connections;
#line 120 "server.vala"
	_tmp0__length1 = pasang_client_connection_connections_length1;
#line 1100 "server.c"
	{
		PasangClientConnection** con_collection = NULL;
		gint con_collection_length1 = 0;
		gint _con_collection_size_ = 0;
		gint con_it = 0;
#line 120 "server.vala"
		con_collection = _tmp0_;
#line 120 "server.vala"
		con_collection_length1 = _tmp0__length1;
#line 120 "server.vala"
		for (con_it = 0; con_it < con_collection_length1; con_it = con_it + 1) {
#line 1112 "server.c"
			PasangClientConnection* _tmp1_;
			PasangClientConnection* con = NULL;
#line 120 "server.vala"
			_tmp1_ = _pasang_client_connection_ref0 (con_collection[con_it]);
#line 120 "server.vala"
			con = _tmp1_;
#line 1119 "server.c"
			{
				PasangClientConnection* _tmp2_;
#line 121 "server.vala"
				_tmp2_ = con;
#line 121 "server.vala"
				if (pasang_client_connection_is_others (self, _tmp2_)) {
#line 1126 "server.c"
					PasangClientConnection* _tmp3_;
#line 121 "server.vala"
					_tmp3_ = con;
#line 121 "server.vala"
					pasang_client_connection_send (_tmp3_, message);
#line 1132 "server.c"
				}
#line 120 "server.vala"
				_pasang_client_connection_unref0 (con);
#line 1136 "server.c"
			}
		}
	}
}

/**
     * Errorless put_string.
     * Error is caught here. Reason: in a broadcast, a disconnected client shouldn't cause
     * the broadcast to be aborted and fail to reach other clients.
     */
static void
pasang_client_connection_send (PasangClientConnection* self,
                               const gchar* message)
{
	GError* _inner_error0_ = NULL;
#line 130 "server.vala"
	g_return_if_fail (self != NULL);
#line 130 "server.vala"
	g_return_if_fail (message != NULL);
#line 1156 "server.c"
	{
		GDataOutputStream* _tmp0_;
#line 132 "server.vala"
		_tmp0_ = self->priv->output;
#line 132 "server.vala"
		g_data_output_stream_put_string (_tmp0_, message, NULL, &_inner_error0_);
#line 132 "server.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1165 "server.c"
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* err = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 131 "server.vala"
		err = _inner_error0_;
#line 131 "server.vala"
		_inner_error0_ = NULL;
#line 135 "server.vala"
		_tmp1_ = stderr;
#line 135 "server.vala"
		_tmp2_ = err;
#line 135 "server.vala"
		_tmp3_ = _tmp2_->message;
#line 135 "server.vala"
		fprintf (_tmp1_, "Send error in line #%ld: %s\n", self->priv->id, _tmp3_);
#line 131 "server.vala"
		_g_error_free0 (err);
#line 1190 "server.c"
	}
	__finally16:
#line 131 "server.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 131 "server.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 131 "server.vala"
		g_clear_error (&_inner_error0_);
#line 131 "server.vala"
		return;
#line 1201 "server.c"
	}
}

static glong
long_parse (const gchar* str)
{
	glong result = 0L;
#line 269 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0L);
#line 270 "glib-2.0.vapi"
	result = strtol (str, NULL, (guint) 0);
#line 270 "glib-2.0.vapi"
	return result;
#line 1215 "server.c"
}

static void
pasang_client_connection_interpret (PasangClientConnection* self,
                                    const gchar* line)
{
	gchar** cmd = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint cmd_length1;
	gint _cmd_size_;
	gchar* command = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* arg = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GQuark _tmp15_ = 0U;
#line 144 "server.vala"
	static GQuark _tmp14_label0 = 0;
#line 144 "server.vala"
	static GQuark _tmp14_label1 = 0;
#line 144 "server.vala"
	static GQuark _tmp14_label2 = 0;
#line 144 "server.vala"
	static GQuark _tmp14_label3 = 0;
#line 144 "server.vala"
	static GQuark _tmp14_label4 = 0;
#line 144 "server.vala"
	static GQuark _tmp14_label5 = 0;
#line 144 "server.vala"
	static GQuark _tmp14_label6 = 0;
#line 139 "server.vala"
	g_return_if_fail (self != NULL);
#line 139 "server.vala"
	g_return_if_fail (line != NULL);
#line 140 "server.vala"
	if (g_strcmp0 (line, "") == 0) {
#line 140 "server.vala"
		return;
#line 1262 "server.c"
	}
#line 141 "server.vala"
	_tmp1_ = _tmp0_ = g_strsplit (line, " ", 2);
#line 141 "server.vala"
	cmd = _tmp1_;
#line 141 "server.vala"
	cmd_length1 = _vala_array_length (_tmp0_);
#line 141 "server.vala"
	_cmd_size_ = cmd_length1;
#line 142 "server.vala"
	_tmp2_ = cmd;
#line 142 "server.vala"
	_tmp2__length1 = cmd_length1;
#line 142 "server.vala"
	_tmp3_ = _tmp2_[0];
#line 142 "server.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 142 "server.vala"
	command = _tmp4_;
#line 143 "server.vala"
	_tmp6_ = cmd;
#line 143 "server.vala"
	_tmp6__length1 = cmd_length1;
#line 143 "server.vala"
	if (_tmp6__length1 == 2) {
#line 1288 "server.c"
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
#line 143 "server.vala"
		_tmp7_ = cmd;
#line 143 "server.vala"
		_tmp7__length1 = cmd_length1;
#line 143 "server.vala"
		_tmp8_ = _tmp7_[1];
#line 143 "server.vala"
		_tmp9_ = string_strip (_tmp8_);
#line 143 "server.vala"
		_g_free0 (_tmp5_);
#line 143 "server.vala"
		_tmp5_ = _tmp9_;
#line 1305 "server.c"
	} else {
		gchar* _tmp10_;
#line 143 "server.vala"
		_tmp10_ = g_strdup ("");
#line 143 "server.vala"
		_g_free0 (_tmp5_);
#line 143 "server.vala"
		_tmp5_ = _tmp10_;
#line 1314 "server.c"
	}
#line 143 "server.vala"
	_tmp11_ = g_strdup (_tmp5_);
#line 143 "server.vala"
	arg = _tmp11_;
#line 144 "server.vala"
	_tmp12_ = command;
#line 144 "server.vala"
	_tmp13_ = _tmp12_;
#line 144 "server.vala"
	_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
#line 144 "server.vala"
	if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("LOGIN")))) {
#line 144 "server.vala"
		switch (0) {
#line 1330 "server.c"
			default:
			{
				const gchar* _tmp16_;
#line 145 "server.vala"
				_tmp16_ = arg;
#line 145 "server.vala"
				pasang_client_connection_login (self, _tmp16_);
#line 145 "server.vala"
				break;
#line 1340 "server.c"
			}
		}
	} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("LOGOUT")))) {
#line 144 "server.vala"
		switch (0) {
#line 1346 "server.c"
			default:
			{
#line 146 "server.vala"
				pasang_client_connection_logout (self);
#line 146 "server.vala"
				break;
#line 1353 "server.c"
			}
		}
	} else if (_tmp15_ == ((0 != _tmp14_label2) ? _tmp14_label2 : (_tmp14_label2 = g_quark_from_static_string ("GET-USER-LIST")))) {
#line 144 "server.vala"
		switch (0) {
#line 1359 "server.c"
			default:
			{
#line 147 "server.vala"
				pasang_client_connection_get_user_list (self);
#line 147 "server.vala"
				break;
#line 1366 "server.c"
			}
		}
	} else if (_tmp15_ == ((0 != _tmp14_label3) ? _tmp14_label3 : (_tmp14_label3 = g_quark_from_static_string ("CHALLENGE")))) {
#line 144 "server.vala"
		switch (0) {
#line 1372 "server.c"
			default:
			{
				const gchar* _tmp17_;
#line 148 "server.vala"
				_tmp17_ = arg;
#line 148 "server.vala"
				pasang_client_connection_challenge (self, long_parse (_tmp17_));
#line 148 "server.vala"
				break;
#line 1382 "server.c"
			}
		}
	} else if (_tmp15_ == ((0 != _tmp14_label4) ? _tmp14_label4 : (_tmp14_label4 = g_quark_from_static_string ("LEAVE")))) {
#line 144 "server.vala"
		switch (0) {
#line 1388 "server.c"
			default:
			{
#line 149 "server.vala"
				pasang_client_connection_leave (self);
#line 149 "server.vala"
				break;
#line 1395 "server.c"
			}
		}
	} else if (_tmp15_ == ((0 != _tmp14_label5) ? _tmp14_label5 : (_tmp14_label5 = g_quark_from_static_string ("CHAT")))) {
#line 144 "server.vala"
		switch (0) {
#line 1401 "server.c"
			default:
			{
				const gchar* _tmp18_;
#line 150 "server.vala"
				_tmp18_ = arg;
#line 150 "server.vala"
				pasang_client_connection_chat (self, _tmp18_);
#line 150 "server.vala"
				break;
#line 1411 "server.c"
			}
		}
	} else if (_tmp15_ == ((0 != _tmp14_label6) ? _tmp14_label6 : (_tmp14_label6 = g_quark_from_static_string ("MOVE")))) {
#line 144 "server.vala"
		switch (0) {
#line 1417 "server.c"
			default:
			{
				const gchar* _tmp19_;
#line 151 "server.vala"
				_tmp19_ = arg;
#line 151 "server.vala"
				pasang_client_connection_move (self, _tmp19_);
#line 151 "server.vala"
				break;
#line 1427 "server.c"
			}
		}
	}
#line 139 "server.vala"
	_g_free0 (arg);
#line 139 "server.vala"
	_g_free0 (_tmp5_);
#line 139 "server.vala"
	_g_free0 (command);
#line 139 "server.vala"
	cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
#line 1439 "server.c"
}

static void
pasang_client_connection_login (PasangClientConnection* self,
                                const gchar* name)
{
#line 155 "server.vala"
	g_return_if_fail (self != NULL);
#line 155 "server.vala"
	g_return_if_fail (name != NULL);
#line 156 "server.vala"
	if (g_strcmp0 (name, "") != 0) {
#line 1452 "server.c"
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 157 "server.vala"
		pasang_client_connection_usher_out (self);
#line 158 "server.vala"
		_tmp0_ = g_strdup (name);
#line 158 "server.vala"
		_g_free0 (self->priv->user_name);
#line 158 "server.vala"
		self->priv->user_name = _tmp0_;
#line 159 "server.vala"
		_tmp1_ = g_strdup_printf ("LOGIN-OK %ld %s\n", self->priv->id, name);
#line 159 "server.vala"
		_tmp2_ = _tmp1_;
#line 159 "server.vala"
		pasang_client_connection_send (self, _tmp2_);
#line 159 "server.vala"
		_g_free0 (_tmp2_);
#line 160 "server.vala"
		_tmp3_ = self->priv->user_name;
#line 160 "server.vala"
		_tmp4_ = g_strdup_printf ("USER %ld w %s\n", self->priv->id, _tmp3_);
#line 160 "server.vala"
		_tmp5_ = _tmp4_;
#line 160 "server.vala"
		pasang_client_connection_broadcast (self, _tmp5_);
#line 160 "server.vala"
		_g_free0 (_tmp5_);
#line 1485 "server.c"
	} else {
#line 163 "server.vala"
		pasang_client_connection_send (self, "LOGIN-ERROR\n");
#line 1489 "server.c"
	}
}

static void
pasang_client_connection_logout (PasangClientConnection* self)
{
	GCancellable* _tmp0_;
#line 167 "server.vala"
	g_return_if_fail (self != NULL);
#line 168 "server.vala"
	pasang_client_connection_usher_out (self);
#line 169 "server.vala"
	_tmp0_ = self->priv->cancellable;
#line 169 "server.vala"
	g_cancellable_cancel (_tmp0_);
#line 1505 "server.c"
}

/**
     * A player is ushered out after 1. logout, 2. lost connection.
     */
static void
pasang_client_connection_usher_out (PasangClientConnection* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 175 "server.vala"
	g_return_if_fail (self != NULL);
#line 176 "server.vala"
	_tmp0_ = self->priv->user_name;
#line 176 "server.vala"
	if (_tmp0_ == NULL) {
#line 176 "server.vala"
		return;
#line 1525 "server.c"
	}
#line 177 "server.vala"
	pasang_client_connection_leave (self);
#line 178 "server.vala"
	_tmp1_ = g_strdup_printf ("EXIT %ld\n", self->priv->id);
#line 178 "server.vala"
	_tmp2_ = _tmp1_;
#line 178 "server.vala"
	pasang_client_connection_broadcast (self, _tmp2_);
#line 178 "server.vala"
	_g_free0 (_tmp2_);
#line 179 "server.vala"
	_g_free0 (self->priv->user_name);
#line 179 "server.vala"
	self->priv->user_name = NULL;
#line 1541 "server.c"
}

static void
pasang_client_connection_get_user_list (PasangClientConnection* self)
{
	const gchar* _tmp0_;
	PasangClientConnection** _tmp1_;
	gint _tmp1__length1;
#line 182 "server.vala"
	g_return_if_fail (self != NULL);
#line 183 "server.vala"
	_tmp0_ = self->priv->user_name;
#line 183 "server.vala"
	if (_tmp0_ == NULL) {
#line 183 "server.vala"
		return;
#line 1558 "server.c"
	}
#line 184 "server.vala"
	_tmp1_ = pasang_client_connection_connections;
#line 184 "server.vala"
	_tmp1__length1 = pasang_client_connection_connections_length1;
#line 1564 "server.c"
	{
		PasangClientConnection** con_collection = NULL;
		gint con_collection_length1 = 0;
		gint _con_collection_size_ = 0;
		gint con_it = 0;
#line 184 "server.vala"
		con_collection = _tmp1_;
#line 184 "server.vala"
		con_collection_length1 = _tmp1__length1;
#line 184 "server.vala"
		for (con_it = 0; con_it < con_collection_length1; con_it = con_it + 1) {
#line 1576 "server.c"
			PasangClientConnection* _tmp2_;
			PasangClientConnection* con = NULL;
#line 184 "server.vala"
			_tmp2_ = _pasang_client_connection_ref0 (con_collection[con_it]);
#line 184 "server.vala"
			con = _tmp2_;
#line 1583 "server.c"
			{
				PasangClientConnection* _tmp3_;
#line 185 "server.vala"
				_tmp3_ = con;
#line 185 "server.vala"
				if (pasang_client_connection_is_others (self, _tmp3_)) {
#line 1590 "server.c"
					PasangClientConnection* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
#line 185 "server.vala"
					_tmp4_ = con;
#line 185 "server.vala"
					_tmp5_ = pasang_client_connection_status (_tmp4_);
#line 185 "server.vala"
					_tmp6_ = _tmp5_;
#line 185 "server.vala"
					pasang_client_connection_send (self, _tmp6_);
#line 185 "server.vala"
					_g_free0 (_tmp6_);
#line 1604 "server.c"
				}
#line 184 "server.vala"
				_pasang_client_connection_unref0 (con);
#line 1608 "server.c"
			}
		}
	}
}

/**
     * When a challenge is issued, the challengee must accept it (unless
     * if she is already in the middle of a game).
     */
static void
pasang_client_connection_challenge (PasangClientConnection* self,
                                    glong opponent_id)
{
	const gchar* _tmp0_;
	PasangClientConnection* _tmp1_;
	PasangClientConnection** _tmp2_;
	gint _tmp2__length1;
#line 193 "server.vala"
	g_return_if_fail (self != NULL);
#line 194 "server.vala"
	_tmp0_ = self->priv->user_name;
#line 194 "server.vala"
	if (_tmp0_ == NULL) {
#line 194 "server.vala"
		return;
#line 1634 "server.c"
	}
#line 195 "server.vala"
	_tmp1_ = self->priv->opponent;
#line 195 "server.vala"
	if (_tmp1_ != NULL) {
#line 195 "server.vala"
		return;
#line 1642 "server.c"
	}
#line 196 "server.vala"
	_tmp2_ = pasang_client_connection_connections;
#line 196 "server.vala"
	_tmp2__length1 = pasang_client_connection_connections_length1;
#line 1648 "server.c"
	{
		PasangClientConnection** con_collection = NULL;
		gint con_collection_length1 = 0;
		gint _con_collection_size_ = 0;
		gint con_it = 0;
#line 196 "server.vala"
		con_collection = _tmp2_;
#line 196 "server.vala"
		con_collection_length1 = _tmp2__length1;
#line 196 "server.vala"
		for (con_it = 0; con_it < con_collection_length1; con_it = con_it + 1) {
#line 1660 "server.c"
			PasangClientConnection* _tmp3_;
			PasangClientConnection* con = NULL;
#line 196 "server.vala"
			_tmp3_ = _pasang_client_connection_ref0 (con_collection[con_it]);
#line 196 "server.vala"
			con = _tmp3_;
#line 1667 "server.c"
			{
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				PasangClientConnection* _tmp6_;
#line 197 "server.vala"
				_tmp6_ = con;
#line 197 "server.vala"
				if (pasang_client_connection_is_others (self, _tmp6_)) {
#line 1676 "server.c"
					PasangClientConnection* _tmp7_;
#line 197 "server.vala"
					_tmp7_ = con;
#line 197 "server.vala"
					_tmp5_ = _tmp7_->priv->id == opponent_id;
#line 1682 "server.c"
				} else {
#line 197 "server.vala"
					_tmp5_ = FALSE;
#line 1686 "server.c"
				}
#line 197 "server.vala"
				if (_tmp5_) {
#line 1690 "server.c"
					PasangClientConnection* _tmp8_;
					PasangClientConnection* _tmp9_;
#line 197 "server.vala"
					_tmp8_ = con;
#line 197 "server.vala"
					_tmp9_ = _tmp8_->priv->opponent;
#line 197 "server.vala"
					_tmp4_ = _tmp9_ == NULL;
#line 1699 "server.c"
				} else {
#line 197 "server.vala"
					_tmp4_ = FALSE;
#line 1703 "server.c"
				}
#line 197 "server.vala"
				if (_tmp4_) {
#line 1707 "server.c"
					PasangClientConnection* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					PasangClientConnection* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					PasangClientConnection* _tmp16_;
					PasangClientConnection* _tmp17_;
					PasangClientConnection* _tmp18_;
					PasangClientConnection* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					PasangClientConnection* _tmp22_;
					PasangClientConnection* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					PasangGame* _tmp26_;
					PasangClientConnection* _tmp27_;
					PasangGame* _tmp28_;
					PasangGame* _tmp29_;
#line 198 "server.vala"
					_tmp10_ = con;
#line 198 "server.vala"
					_tmp11_ = g_strdup_printf ("PLAY-AGAINST %ld\n", _tmp10_->priv->id);
#line 198 "server.vala"
					_tmp12_ = _tmp11_;
#line 198 "server.vala"
					pasang_client_connection_send (self, _tmp12_);
#line 198 "server.vala"
					_g_free0 (_tmp12_);
#line 199 "server.vala"
					_tmp13_ = con;
#line 199 "server.vala"
					_tmp14_ = g_strdup_printf ("PLAY-AGAINST %ld\n", self->priv->id);
#line 199 "server.vala"
					_tmp15_ = _tmp14_;
#line 199 "server.vala"
					pasang_client_connection_send (_tmp13_, _tmp15_);
#line 199 "server.vala"
					_g_free0 (_tmp15_);
#line 200 "server.vala"
					_tmp16_ = con;
#line 200 "server.vala"
					_tmp17_ = _pasang_client_connection_ref0 (_tmp16_);
#line 200 "server.vala"
					_pasang_client_connection_unref0 (self->priv->opponent);
#line 200 "server.vala"
					self->priv->opponent = _tmp17_;
#line 201 "server.vala"
					_tmp18_ = self->priv->opponent;
#line 201 "server.vala"
					_tmp19_ = _pasang_client_connection_ref0 (self);
#line 201 "server.vala"
					_pasang_client_connection_unref0 (_tmp18_->priv->opponent);
#line 201 "server.vala"
					_tmp18_->priv->opponent = _tmp19_;
#line 202 "server.vala"
					_tmp20_ = pasang_client_connection_status (self);
#line 202 "server.vala"
					_tmp21_ = _tmp20_;
#line 202 "server.vala"
					pasang_client_connection_broadcast (self, _tmp21_);
#line 202 "server.vala"
					_g_free0 (_tmp21_);
#line 203 "server.vala"
					_tmp22_ = self->priv->opponent;
#line 203 "server.vala"
					_tmp23_ = self->priv->opponent;
#line 203 "server.vala"
					_tmp24_ = pasang_client_connection_status (_tmp23_);
#line 203 "server.vala"
					_tmp25_ = _tmp24_;
#line 203 "server.vala"
					pasang_client_connection_broadcast (_tmp22_, _tmp25_);
#line 203 "server.vala"
					_g_free0 (_tmp25_);
#line 204 "server.vala"
					_tmp26_ = pasang_game_new ();
#line 204 "server.vala"
					_g_object_unref0 (self->priv->game);
#line 204 "server.vala"
					self->priv->game = _tmp26_;
#line 205 "server.vala"
					_tmp27_ = self->priv->opponent;
#line 205 "server.vala"
					_tmp28_ = self->priv->game;
#line 205 "server.vala"
					_tmp29_ = _g_object_ref0 (_tmp28_);
#line 205 "server.vala"
					_g_object_unref0 (_tmp27_->priv->game);
#line 205 "server.vala"
					_tmp27_->priv->game = _tmp29_;
#line 206 "server.vala"
					_pasang_client_connection_unref0 (con);
#line 206 "server.vala"
					break;
#line 1804 "server.c"
				}
#line 196 "server.vala"
				_pasang_client_connection_unref0 (con);
#line 1808 "server.c"
			}
		}
	}
}

/**
     * The user cannot challenge another opponent until she LEAVE her current game.
     */
static void
pasang_client_connection_leave (PasangClientConnection* self)
{
	const gchar* _tmp0_;
	PasangClientConnection* _tmp1_;
	PasangClientConnection* _tmp2_;
	PasangClientConnection* _tmp3_;
	PasangClientConnection* _tmp4_;
	PasangClientConnection* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	PasangClientConnection* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
#line 214 "server.vala"
	g_return_if_fail (self != NULL);
#line 215 "server.vala"
	_tmp0_ = self->priv->user_name;
#line 215 "server.vala"
	if (_tmp0_ == NULL) {
#line 215 "server.vala"
		return;
#line 1839 "server.c"
	}
#line 216 "server.vala"
	_tmp1_ = self->priv->opponent;
#line 216 "server.vala"
	if (_tmp1_ == NULL) {
#line 216 "server.vala"
		return;
#line 1847 "server.c"
	}
#line 217 "server.vala"
	_tmp2_ = self->priv->opponent;
#line 217 "server.vala"
	_pasang_client_connection_unref0 (_tmp2_->priv->opponent);
#line 217 "server.vala"
	_tmp2_->priv->opponent = NULL;
#line 218 "server.vala"
	_tmp3_ = self->priv->opponent;
#line 218 "server.vala"
	pasang_client_connection_send (_tmp3_, "PLAY-END\n");
#line 219 "server.vala"
	_tmp4_ = self->priv->opponent;
#line 219 "server.vala"
	_tmp5_ = self->priv->opponent;
#line 219 "server.vala"
	_tmp6_ = pasang_client_connection_status (_tmp5_);
#line 219 "server.vala"
	_tmp7_ = _tmp6_;
#line 219 "server.vala"
	pasang_client_connection_broadcast (_tmp4_, _tmp7_);
#line 219 "server.vala"
	_g_free0 (_tmp7_);
#line 220 "server.vala"
	_g_object_unref0 (self->priv->game);
#line 220 "server.vala"
	self->priv->game = NULL;
#line 221 "server.vala"
	_tmp8_ = self->priv->opponent;
#line 221 "server.vala"
	_g_object_unref0 (_tmp8_->priv->game);
#line 221 "server.vala"
	_tmp8_->priv->game = NULL;
#line 222 "server.vala"
	_pasang_client_connection_unref0 (self->priv->opponent);
#line 222 "server.vala"
	self->priv->opponent = NULL;
#line 223 "server.vala"
	pasang_client_connection_send (self, "PLAY-END\n");
#line 224 "server.vala"
	_tmp9_ = pasang_client_connection_status (self);
#line 224 "server.vala"
	_tmp10_ = _tmp9_;
#line 224 "server.vala"
	pasang_client_connection_broadcast (self, _tmp10_);
#line 224 "server.vala"
	_g_free0 (_tmp10_);
#line 1895 "server.c"
}

/**
     * Broadcast chit-chat message.
     */
static void
pasang_client_connection_chat (PasangClientConnection* self,
                               const gchar* msg)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 230 "server.vala"
	g_return_if_fail (self != NULL);
#line 230 "server.vala"
	g_return_if_fail (msg != NULL);
#line 231 "server.vala"
	_tmp0_ = self->priv->user_name;
#line 231 "server.vala"
	if (_tmp0_ == NULL) {
#line 231 "server.vala"
		return;
#line 1918 "server.c"
	}
#line 232 "server.vala"
	_tmp1_ = g_strdup_printf ("MESSAGE %ld %s\n", self->priv->id, msg);
#line 232 "server.vala"
	_tmp2_ = _tmp1_;
#line 232 "server.vala"
	pasang_client_connection_broadcast (self, _tmp2_);
#line 232 "server.vala"
	_g_free0 (_tmp2_);
#line 1928 "server.c"
}

/**
     * Relay move to the opponent.
     * Also, echo the move back.
     */
static void
pasang_client_connection_move (PasangClientConnection* self,
                               const gchar* arg)
{
	const gchar* _tmp0_;
	PasangClientConnection* _tmp1_;
	gchar** arg_split = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint arg_split_length1;
	gint _arg_split_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint seq = 0;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar* move_notation = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	PasangClientConnection* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
#line 239 "server.vala"
	g_return_if_fail (self != NULL);
#line 239 "server.vala"
	g_return_if_fail (arg != NULL);
#line 240 "server.vala"
	_tmp0_ = self->priv->user_name;
#line 240 "server.vala"
	if (_tmp0_ == NULL) {
#line 240 "server.vala"
		return;
#line 1972 "server.c"
	}
#line 241 "server.vala"
	_tmp1_ = self->priv->opponent;
#line 241 "server.vala"
	if (_tmp1_ == NULL) {
#line 241 "server.vala"
		return;
#line 1980 "server.c"
	}
#line 242 "server.vala"
	_tmp3_ = _tmp2_ = g_strsplit (arg, " ", 2);
#line 242 "server.vala"
	arg_split = _tmp3_;
#line 242 "server.vala"
	arg_split_length1 = _vala_array_length (_tmp2_);
#line 242 "server.vala"
	_arg_split_size_ = arg_split_length1;
#line 243 "server.vala"
	_tmp4_ = arg_split;
#line 243 "server.vala"
	_tmp4__length1 = arg_split_length1;
#line 243 "server.vala"
	if (_tmp4__length1 != 2) {
#line 244 "server.vala"
		g_message ("server.vala:244: Error: Malformed move");
#line 245 "server.vala"
		arg_split = (_vala_array_free (arg_split, arg_split_length1, (GDestroyNotify) g_free), NULL);
#line 245 "server.vala"
		return;
#line 2002 "server.c"
	}
#line 247 "server.vala"
	_tmp5_ = arg_split;
#line 247 "server.vala"
	_tmp5__length1 = arg_split_length1;
#line 247 "server.vala"
	_tmp6_ = _tmp5_[0];
#line 247 "server.vala"
	seq = atoi (_tmp6_);
#line 248 "server.vala"
	_tmp7_ = arg_split;
#line 248 "server.vala"
	_tmp7__length1 = arg_split_length1;
#line 248 "server.vala"
	_tmp8_ = _tmp7_[1];
#line 248 "server.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 248 "server.vala"
	move_notation = _tmp9_;
#line 249 "server.vala"
	if (seq == 0) {
#line 2024 "server.c"
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		PasangGame* _tmp12_;
		PasangStage _tmp13_;
		PasangStage _tmp14_;
		PasangGame* _tmp19_;
		const gchar* _tmp20_;
#line 250 "server.vala"
		_tmp12_ = self->priv->game;
#line 250 "server.vala"
		_tmp13_ = pasang_game_get_stage (_tmp12_);
#line 250 "server.vala"
		_tmp14_ = _tmp13_;
#line 250 "server.vala"
		if (_tmp14_ != PASANG_STAGE_NULL) {
#line 2040 "server.c"
			PasangGame* _tmp15_;
			PasangStage _tmp16_;
			PasangStage _tmp17_;
#line 250 "server.vala"
			_tmp15_ = self->priv->game;
#line 250 "server.vala"
			_tmp16_ = pasang_game_get_stage (_tmp15_);
#line 250 "server.vala"
			_tmp17_ = _tmp16_;
#line 250 "server.vala"
			_tmp11_ = _tmp17_ != PASANG_STAGE_GAME_OVER;
#line 2052 "server.c"
		} else {
#line 250 "server.vala"
			_tmp11_ = FALSE;
#line 2056 "server.c"
		}
#line 250 "server.vala"
		if (_tmp11_) {
#line 250 "server.vala"
			_tmp10_ = TRUE;
#line 2062 "server.c"
		} else {
			const gchar* _tmp18_;
#line 250 "server.vala"
			_tmp18_ = move_notation;
#line 250 "server.vala"
			_tmp10_ = !pasang_game_is_valid_pattern (_tmp18_);
#line 2069 "server.c"
		}
#line 250 "server.vala"
		if (_tmp10_) {
#line 251 "server.vala"
			g_message ("server.vala:251: Invalid move: %s", arg);
#line 252 "server.vala"
			_g_free0 (move_notation);
#line 252 "server.vala"
			arg_split = (_vala_array_free (arg_split, arg_split_length1, (GDestroyNotify) g_free), NULL);
#line 252 "server.vala"
			return;
#line 2081 "server.c"
		}
#line 254 "server.vala"
		_tmp19_ = self->priv->game;
#line 254 "server.vala"
		_tmp20_ = move_notation;
#line 254 "server.vala"
		pasang_game_start (_tmp19_, _tmp20_);
#line 2089 "server.c"
	} else {
		PasangGame* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
#line 256 "server.vala"
		_tmp21_ = self->priv->game;
#line 256 "server.vala"
		_tmp22_ = pasang_game_get_seq (_tmp21_);
#line 256 "server.vala"
		_tmp23_ = _tmp22_;
#line 256 "server.vala"
		if (seq == (_tmp23_ + 1)) {
#line 2102 "server.c"
			PasangMove* move = NULL;
			PasangGame* _tmp24_;
			const gchar* _tmp25_;
			PasangMove* _tmp26_;
			PasangMove* _tmp27_;
			PasangGame* _tmp28_;
			const gchar* _tmp29_;
#line 257 "server.vala"
			_tmp24_ = self->priv->game;
#line 257 "server.vala"
			_tmp25_ = move_notation;
#line 257 "server.vala"
			_tmp26_ = pasang_game_get_move (_tmp24_, _tmp25_);
#line 257 "server.vala"
			move = _tmp26_;
#line 258 "server.vala"
			_tmp27_ = move;
#line 258 "server.vala"
			if (_tmp27_ == NULL) {
#line 259 "server.vala"
				g_message ("server.vala:259: Invalid move: %s", arg);
#line 260 "server.vala"
				_g_object_unref0 (move);
#line 260 "server.vala"
				_g_free0 (move_notation);
#line 260 "server.vala"
				arg_split = (_vala_array_free (arg_split, arg_split_length1, (GDestroyNotify) g_free), NULL);
#line 260 "server.vala"
				return;
#line 2132 "server.c"
			}
#line 262 "server.vala"
			_tmp28_ = self->priv->game;
#line 262 "server.vala"
			_tmp29_ = move_notation;
#line 262 "server.vala"
			pasang_game_perform_from_notation (_tmp28_, _tmp29_);
#line 256 "server.vala"
			_g_object_unref0 (move);
#line 2142 "server.c"
		} else {
#line 265 "server.vala"
			g_message ("server.vala:265: Invalid move: %s", arg);
#line 266 "server.vala"
			_g_free0 (move_notation);
#line 266 "server.vala"
			arg_split = (_vala_array_free (arg_split, arg_split_length1, (GDestroyNotify) g_free), NULL);
#line 266 "server.vala"
			return;
#line 2152 "server.c"
		}
	}
#line 268 "server.vala"
	_tmp30_ = self->priv->opponent;
#line 268 "server.vala"
	_tmp31_ = g_strdup_printf ("MOVE %ld %s\n", self->priv->id, arg);
#line 268 "server.vala"
	_tmp32_ = _tmp31_;
#line 268 "server.vala"
	pasang_client_connection_send (_tmp30_, _tmp32_);
#line 268 "server.vala"
	_g_free0 (_tmp32_);
#line 269 "server.vala"
	_tmp33_ = g_strdup_printf ("MOVE-POSTED %s\n", arg);
#line 269 "server.vala"
	_tmp34_ = _tmp33_;
#line 269 "server.vala"
	pasang_client_connection_send (self, _tmp34_);
#line 269 "server.vala"
	_g_free0 (_tmp34_);
#line 239 "server.vala"
	_g_free0 (move_notation);
#line 239 "server.vala"
	arg_split = (_vala_array_free (arg_split, arg_split_length1, (GDestroyNotify) g_free), NULL);
#line 2177 "server.c"
}

static void
pasang_value_client_connection_init (GValue* value)
{
#line 21 "server.vala"
	value->data[0].v_pointer = NULL;
#line 2185 "server.c"
}

static void
pasang_value_client_connection_free_value (GValue* value)
{
#line 21 "server.vala"
	if (value->data[0].v_pointer) {
#line 21 "server.vala"
		pasang_client_connection_unref (value->data[0].v_pointer);
#line 2195 "server.c"
	}
}

static void
pasang_value_client_connection_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
#line 21 "server.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "server.vala"
		dest_value->data[0].v_pointer = pasang_client_connection_ref (src_value->data[0].v_pointer);
#line 2207 "server.c"
	} else {
#line 21 "server.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2211 "server.c"
	}
}

static gpointer
pasang_value_client_connection_peek_pointer (const GValue* value)
{
#line 21 "server.vala"
	return value->data[0].v_pointer;
#line 2220 "server.c"
}

static gchar*
pasang_value_client_connection_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
#line 21 "server.vala"
	if (collect_values[0].v_pointer) {
#line 2231 "server.c"
		PasangClientConnection * object;
		object = collect_values[0].v_pointer;
#line 21 "server.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "server.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2238 "server.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "server.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2242 "server.c"
		}
#line 21 "server.vala"
		value->data[0].v_pointer = pasang_client_connection_ref (object);
#line 2246 "server.c"
	} else {
#line 21 "server.vala"
		value->data[0].v_pointer = NULL;
#line 2250 "server.c"
	}
#line 21 "server.vala"
	return NULL;
#line 2254 "server.c"
}

static gchar*
pasang_value_client_connection_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	PasangClientConnection ** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "server.vala"
	if (!object_p) {
#line 21 "server.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2269 "server.c"
	}
#line 21 "server.vala"
	if (!value->data[0].v_pointer) {
#line 21 "server.vala"
		*object_p = NULL;
#line 2275 "server.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "server.vala"
		*object_p = value->data[0].v_pointer;
#line 2279 "server.c"
	} else {
#line 21 "server.vala"
		*object_p = pasang_client_connection_ref (value->data[0].v_pointer);
#line 2283 "server.c"
	}
#line 21 "server.vala"
	return NULL;
#line 2287 "server.c"
}

GParamSpec*
pasang_param_spec_client_connection (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	PasangParamSpecClientConnection* spec;
#line 21 "server.vala"
	g_return_val_if_fail (g_type_is_a (object_type, PASANG_TYPE_CLIENT_CONNECTION), NULL);
#line 21 "server.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "server.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "server.vala"
	return G_PARAM_SPEC (spec);
#line 2306 "server.c"
}

gpointer
pasang_value_get_client_connection (const GValue* value)
{
#line 21 "server.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_TYPE_CLIENT_CONNECTION), NULL);
#line 21 "server.vala"
	return value->data[0].v_pointer;
#line 2316 "server.c"
}

void
pasang_value_set_client_connection (GValue* value,
                                    gpointer v_object)
{
	PasangClientConnection * old;
#line 21 "server.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_TYPE_CLIENT_CONNECTION));
#line 21 "server.vala"
	old = value->data[0].v_pointer;
#line 21 "server.vala"
	if (v_object) {
#line 21 "server.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PASANG_TYPE_CLIENT_CONNECTION));
#line 21 "server.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "server.vala"
		value->data[0].v_pointer = v_object;
#line 21 "server.vala"
		pasang_client_connection_ref (value->data[0].v_pointer);
#line 2338 "server.c"
	} else {
#line 21 "server.vala"
		value->data[0].v_pointer = NULL;
#line 2342 "server.c"
	}
#line 21 "server.vala"
	if (old) {
#line 21 "server.vala"
		pasang_client_connection_unref (old);
#line 2348 "server.c"
	}
}

void
pasang_value_take_client_connection (GValue* value,
                                     gpointer v_object)
{
	PasangClientConnection * old;
#line 21 "server.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_TYPE_CLIENT_CONNECTION));
#line 21 "server.vala"
	old = value->data[0].v_pointer;
#line 21 "server.vala"
	if (v_object) {
#line 21 "server.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PASANG_TYPE_CLIENT_CONNECTION));
#line 21 "server.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "server.vala"
		value->data[0].v_pointer = v_object;
#line 2369 "server.c"
	} else {
#line 21 "server.vala"
		value->data[0].v_pointer = NULL;
#line 2373 "server.c"
	}
#line 21 "server.vala"
	if (old) {
#line 21 "server.vala"
		pasang_client_connection_unref (old);
#line 2379 "server.c"
	}
}

static void
pasang_client_connection_class_init (PasangClientConnectionClass * klass,
                                     gpointer klass_data)
{
	PasangClientConnection** _tmp0_;
#line 21 "server.vala"
	pasang_client_connection_parent_class = g_type_class_peek_parent (klass);
#line 21 "server.vala"
	((PasangClientConnectionClass *) klass)->finalize = pasang_client_connection_finalize;
#line 21 "server.vala"
	g_type_class_adjust_private_offset (klass, &PasangClientConnection_private_offset);
#line 22 "server.vala"
	_tmp0_ = g_new0 (PasangClientConnection*, 0 + 1);
#line 22 "server.vala"
	pasang_client_connection_connections = _tmp0_;
#line 22 "server.vala"
	pasang_client_connection_connections_length1 = 0;
#line 2400 "server.c"
}

static void
pasang_client_connection_instance_init (PasangClientConnection * self,
                                        gpointer klass)
{
#line 21 "server.vala"
	self->priv = pasang_client_connection_get_instance_private (self);
#line 50 "server.vala"
	self->priv->game = NULL;
#line 55 "server.vala"
	self->priv->user_name = NULL;
#line 60 "server.vala"
	self->priv->opponent = NULL;
#line 21 "server.vala"
	self->ref_count = 1;
#line 2417 "server.c"
}

static void
pasang_client_connection_finalize (PasangClientConnection * obj)
{
	PasangClientConnection * self;
#line 21 "server.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_CLIENT_CONNECTION, PasangClientConnection);
#line 21 "server.vala"
	g_signal_handlers_destroy (self);
#line 40 "server.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 41 "server.vala"
	_g_object_unref0 (self->priv->connection);
#line 42 "server.vala"
	_g_object_unref0 (self->priv->input);
#line 43 "server.vala"
	_g_object_unref0 (self->priv->output);
#line 50 "server.vala"
	_g_object_unref0 (self->priv->game);
#line 55 "server.vala"
	_g_free0 (self->priv->user_name);
#line 60 "server.vala"
	_pasang_client_connection_unref0 (self->priv->opponent);
#line 2442 "server.c"
}

GType
pasang_client_connection_get_type (void)
{
	static volatile gsize pasang_client_connection_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_client_connection_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { pasang_value_client_connection_init, pasang_value_client_connection_free_value, pasang_value_client_connection_copy_value, pasang_value_client_connection_peek_pointer, "p", pasang_value_client_connection_collect_value, "p", pasang_value_client_connection_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PasangClientConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_client_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangClientConnection), 0, (GInstanceInitFunc) pasang_client_connection_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pasang_client_connection_type_id;
		pasang_client_connection_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PasangClientConnection", &g_define_type_info, &g_define_type_fundamental_info, 0);
		PasangClientConnection_private_offset = g_type_add_instance_private (pasang_client_connection_type_id, sizeof (PasangClientConnectionPrivate));
		g_once_init_leave (&pasang_client_connection_type_id__volatile, pasang_client_connection_type_id);
	}
	return pasang_client_connection_type_id__volatile;
}

gpointer
pasang_client_connection_ref (gpointer instance)
{
	PasangClientConnection * self;
	self = instance;
#line 21 "server.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "server.vala"
	return instance;
#line 2470 "server.c"
}

void
pasang_client_connection_unref (gpointer instance)
{
	PasangClientConnection * self;
	self = instance;
#line 21 "server.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "server.vala"
		PASANG_CLIENT_CONNECTION_GET_CLASS (self)->finalize (self);
#line 21 "server.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2484 "server.c"
	}
}

static inline gpointer
pasang_server_get_instance_private (PasangServer* self)
{
	return G_STRUCT_MEMBER_P (self, PasangServer_private_offset);
}

/**
     * Entry point for Server
     */
void
pasang_server_main (guint16 port)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	PasangServer* _tmp2_;
	PasangServer* _tmp3_;
#line 280 "server.vala"
	_tmp0_ = stdout;
#line 280 "server.vala"
	fprintf (_tmp0_, "%s\n", PACKAGE_STRING);
#line 281 "server.vala"
	_tmp1_ = stdout;
#line 281 "server.vala"
	fprintf (_tmp1_, "Connection port: %d\n", (gint) port);
#line 282 "server.vala"
	_tmp2_ = pasang_server_new (port);
#line 282 "server.vala"
	_tmp3_ = _tmp2_;
#line 282 "server.vala"
	_pasang_server_unref0 (_tmp3_);
#line 2518 "server.c"
}

static gboolean
_pasang_server_on_connection_g_socket_service_incoming (GSocketService* _sender,
                                                        GSocketConnection* connection,
                                                        GObject* source_object,
                                                        gpointer self)
{
	gboolean result;
	result = pasang_server_on_connection ((PasangServer*) self, connection, source_object);
#line 289 "server.vala"
	return result;
#line 2531 "server.c"
}

PasangServer*
pasang_server_construct (GType object_type,
                         guint16 port)
{
	PasangServer* self = NULL;
	GError* _inner_error0_ = NULL;
#line 285 "server.vala"
	self = (PasangServer*) g_type_create_instance (object_type);
#line 2542 "server.c"
	{
		GSocketService* service = NULL;
		GSocketService* _tmp0_;
		GMainLoop* _tmp1_;
		GMainLoop* _tmp2_;
#line 287 "server.vala"
		_tmp0_ = g_socket_service_new ();
#line 287 "server.vala"
		service = _tmp0_;
#line 288 "server.vala"
		g_socket_listener_add_inet_port ((GSocketListener*) service, port, NULL, &_inner_error0_);
#line 288 "server.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 288 "server.vala"
			_g_object_unref0 (service);
#line 2558 "server.c"
			goto __catch17_g_error;
		}
#line 289 "server.vala"
		g_signal_connect (service, "incoming", (GCallback) _pasang_server_on_connection_g_socket_service_incoming, self);
#line 290 "server.vala"
		g_socket_service_start (service);
#line 291 "server.vala"
		_tmp1_ = g_main_loop_new (NULL, FALSE);
#line 291 "server.vala"
		_g_main_loop_unref0 (self->priv->loop);
#line 291 "server.vala"
		self->priv->loop = _tmp1_;
#line 292 "server.vala"
		_tmp2_ = self->priv->loop;
#line 292 "server.vala"
		g_main_loop_run (_tmp2_);
#line 286 "server.vala"
		_g_object_unref0 (service);
#line 2577 "server.c"
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
#line 286 "server.vala"
		e = _inner_error0_;
#line 286 "server.vala"
		_inner_error0_ = NULL;
#line 294 "server.vala"
		_tmp3_ = e->message;
#line 294 "server.vala"
		g_error ("server.vala:294: Socket error: %s\n", _tmp3_);
#line 286 "server.vala"
		_g_error_free0 (e);
#line 2594 "server.c"
	}
	__finally17:
#line 286 "server.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 286 "server.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 286 "server.vala"
		g_clear_error (&_inner_error0_);
#line 286 "server.vala"
		return NULL;
#line 2605 "server.c"
	}
#line 285 "server.vala"
	return self;
#line 2609 "server.c"
}

PasangServer*
pasang_server_new (guint16 port)
{
#line 285 "server.vala"
	return pasang_server_construct (PASANG_TYPE_SERVER, port);
#line 2617 "server.c"
}

static gboolean
pasang_server_on_connection (PasangServer* self,
                             GSocketConnection* connection,
                             GObject* src)
{
	gboolean result = FALSE;
#line 298 "server.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 298 "server.vala"
	g_return_val_if_fail (connection != NULL, FALSE);
#line 299 "server.vala"
	pasang_client_connection_add_connection (connection);
#line 300 "server.vala"
	result = TRUE;
#line 300 "server.vala"
	return result;
#line 2636 "server.c"
}

static void
pasang_value_server_init (GValue* value)
{
#line 273 "server.vala"
	value->data[0].v_pointer = NULL;
#line 2644 "server.c"
}

static void
pasang_value_server_free_value (GValue* value)
{
#line 273 "server.vala"
	if (value->data[0].v_pointer) {
#line 273 "server.vala"
		pasang_server_unref (value->data[0].v_pointer);
#line 2654 "server.c"
	}
}

static void
pasang_value_server_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
#line 273 "server.vala"
	if (src_value->data[0].v_pointer) {
#line 273 "server.vala"
		dest_value->data[0].v_pointer = pasang_server_ref (src_value->data[0].v_pointer);
#line 2666 "server.c"
	} else {
#line 273 "server.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2670 "server.c"
	}
}

static gpointer
pasang_value_server_peek_pointer (const GValue* value)
{
#line 273 "server.vala"
	return value->data[0].v_pointer;
#line 2679 "server.c"
}

static gchar*
pasang_value_server_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
#line 273 "server.vala"
	if (collect_values[0].v_pointer) {
#line 2690 "server.c"
		PasangServer * object;
		object = collect_values[0].v_pointer;
#line 273 "server.vala"
		if (object->parent_instance.g_class == NULL) {
#line 273 "server.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2697 "server.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 273 "server.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2701 "server.c"
		}
#line 273 "server.vala"
		value->data[0].v_pointer = pasang_server_ref (object);
#line 2705 "server.c"
	} else {
#line 273 "server.vala"
		value->data[0].v_pointer = NULL;
#line 2709 "server.c"
	}
#line 273 "server.vala"
	return NULL;
#line 2713 "server.c"
}

static gchar*
pasang_value_server_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	PasangServer ** object_p;
	object_p = collect_values[0].v_pointer;
#line 273 "server.vala"
	if (!object_p) {
#line 273 "server.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2728 "server.c"
	}
#line 273 "server.vala"
	if (!value->data[0].v_pointer) {
#line 273 "server.vala"
		*object_p = NULL;
#line 2734 "server.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 273 "server.vala"
		*object_p = value->data[0].v_pointer;
#line 2738 "server.c"
	} else {
#line 273 "server.vala"
		*object_p = pasang_server_ref (value->data[0].v_pointer);
#line 2742 "server.c"
	}
#line 273 "server.vala"
	return NULL;
#line 2746 "server.c"
}

GParamSpec*
pasang_param_spec_server (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	PasangParamSpecServer* spec;
#line 273 "server.vala"
	g_return_val_if_fail (g_type_is_a (object_type, PASANG_TYPE_SERVER), NULL);
#line 273 "server.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 273 "server.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 273 "server.vala"
	return G_PARAM_SPEC (spec);
#line 2765 "server.c"
}

gpointer
pasang_value_get_server (const GValue* value)
{
#line 273 "server.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_TYPE_SERVER), NULL);
#line 273 "server.vala"
	return value->data[0].v_pointer;
#line 2775 "server.c"
}

void
pasang_value_set_server (GValue* value,
                         gpointer v_object)
{
	PasangServer * old;
#line 273 "server.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_TYPE_SERVER));
#line 273 "server.vala"
	old = value->data[0].v_pointer;
#line 273 "server.vala"
	if (v_object) {
#line 273 "server.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PASANG_TYPE_SERVER));
#line 273 "server.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 273 "server.vala"
		value->data[0].v_pointer = v_object;
#line 273 "server.vala"
		pasang_server_ref (value->data[0].v_pointer);
#line 2797 "server.c"
	} else {
#line 273 "server.vala"
		value->data[0].v_pointer = NULL;
#line 2801 "server.c"
	}
#line 273 "server.vala"
	if (old) {
#line 273 "server.vala"
		pasang_server_unref (old);
#line 2807 "server.c"
	}
}

void
pasang_value_take_server (GValue* value,
                          gpointer v_object)
{
	PasangServer * old;
#line 273 "server.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_TYPE_SERVER));
#line 273 "server.vala"
	old = value->data[0].v_pointer;
#line 273 "server.vala"
	if (v_object) {
#line 273 "server.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PASANG_TYPE_SERVER));
#line 273 "server.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 273 "server.vala"
		value->data[0].v_pointer = v_object;
#line 2828 "server.c"
	} else {
#line 273 "server.vala"
		value->data[0].v_pointer = NULL;
#line 2832 "server.c"
	}
#line 273 "server.vala"
	if (old) {
#line 273 "server.vala"
		pasang_server_unref (old);
#line 2838 "server.c"
	}
}

static void
pasang_server_class_init (PasangServerClass * klass,
                          gpointer klass_data)
{
#line 273 "server.vala"
	pasang_server_parent_class = g_type_class_peek_parent (klass);
#line 273 "server.vala"
	((PasangServerClass *) klass)->finalize = pasang_server_finalize;
#line 273 "server.vala"
	g_type_class_adjust_private_offset (klass, &PasangServer_private_offset);
#line 2852 "server.c"
}

static void
pasang_server_instance_init (PasangServer * self,
                             gpointer klass)
{
#line 273 "server.vala"
	self->priv = pasang_server_get_instance_private (self);
#line 273 "server.vala"
	self->ref_count = 1;
#line 2863 "server.c"
}

static void
pasang_server_finalize (PasangServer * obj)
{
	PasangServer * self;
#line 273 "server.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_SERVER, PasangServer);
#line 273 "server.vala"
	g_signal_handlers_destroy (self);
#line 274 "server.vala"
	_g_main_loop_unref0 (self->priv->loop);
#line 2876 "server.c"
}

GType
pasang_server_get_type (void)
{
	static volatile gsize pasang_server_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_server_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { pasang_value_server_init, pasang_value_server_free_value, pasang_value_server_copy_value, pasang_value_server_peek_pointer, "p", pasang_value_server_collect_value, "p", pasang_value_server_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PasangServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangServer), 0, (GInstanceInitFunc) pasang_server_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pasang_server_type_id;
		pasang_server_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PasangServer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		PasangServer_private_offset = g_type_add_instance_private (pasang_server_type_id, sizeof (PasangServerPrivate));
		g_once_init_leave (&pasang_server_type_id__volatile, pasang_server_type_id);
	}
	return pasang_server_type_id__volatile;
}

gpointer
pasang_server_ref (gpointer instance)
{
	PasangServer * self;
	self = instance;
#line 273 "server.vala"
	g_atomic_int_inc (&self->ref_count);
#line 273 "server.vala"
	return instance;
#line 2904 "server.c"
}

void
pasang_server_unref (gpointer instance)
{
	PasangServer * self;
	self = instance;
#line 273 "server.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 273 "server.vala"
		PASANG_SERVER_GET_CLASS (self)->finalize (self);
#line 273 "server.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2918 "server.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

