# This file is part of Cantera. See License.txt in the top-level directory or
# at https://cantera.org/license.txt for license and copyright information.

from typing_extensions import Never

from .solutionbase import _SolutionBase
from .units import UnitSystem

class YamlWriter:
    def set_header(self, soln: _SolutionBase) -> None: ...
    def add_solution(self, soln: _SolutionBase) -> None: ...
    def to_file(self, filename: str) -> None: ...
    def to_string(self) -> str: ...
    @property
    def precision(self) -> Never: ...
    @precision.setter
    def precision(self, precision: int) -> None: ...
    @property
    def skip_user_defined(self) -> Never: ...
    @skip_user_defined.setter
    def skip_user_defined(self, skip: bool) -> None: ...
    @property
    def output_units(self) -> Never: ...
    @output_units.setter
    def output_units(self, units: UnitSystem) -> None: ...
    def __reduce__(self) -> Never: ...
    def __copy__(self) -> Never: ...
