// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1experimental"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

// Profile are an implementation of the pprofextended data model.

// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewProfile function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Profile struct {
	orig  *otlpprofiles.Profile
	state *internal.State
}

func newProfile(orig *otlpprofiles.Profile, state *internal.State) Profile {
	return Profile{orig: orig, state: state}
}

// NewProfile creates a new empty Profile.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewProfile() Profile {
	state := internal.StateMutable
	return newProfile(&otlpprofiles.Profile{}, &state)
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Profile) MoveTo(dest Profile) {
	ms.state.AssertMutable()
	dest.state.AssertMutable()
	*dest.orig = *ms.orig
	*ms.orig = otlpprofiles.Profile{}
}

// SampleType returns the SampleType associated with this Profile.
func (ms Profile) SampleType() ValueTypeSlice {
	return newValueTypeSlice(&ms.orig.SampleType, ms.state)
}

// Sample returns the Sample associated with this Profile.
func (ms Profile) Sample() SampleSlice {
	return newSampleSlice(&ms.orig.Sample, ms.state)
}

// Mapping returns the Mapping associated with this Profile.
func (ms Profile) Mapping() MappingSlice {
	return newMappingSlice(&ms.orig.Mapping, ms.state)
}

// Location returns the Location associated with this Profile.
func (ms Profile) Location() LocationSlice {
	return newLocationSlice(&ms.orig.Location, ms.state)
}

// LocationIndices returns the LocationIndices associated with this Profile.
func (ms Profile) LocationIndices() pcommon.Int64Slice {
	return pcommon.Int64Slice(internal.NewInt64Slice(&ms.orig.LocationIndices, ms.state))
}

// Function returns the Function associated with this Profile.
func (ms Profile) Function() FunctionSlice {
	return newFunctionSlice(&ms.orig.Function, ms.state)
}

// AttributeTable returns the AttributeTable associated with this Profile.
func (ms Profile) AttributeTable() pcommon.Map {
	return pcommon.Map(internal.NewMap(&ms.orig.AttributeTable, ms.state))
}

// AttributeUnits returns the AttributeUnits associated with this Profile.
func (ms Profile) AttributeUnits() AttributeUnitSlice {
	return newAttributeUnitSlice(&ms.orig.AttributeUnits, ms.state)
}

// LinkTable returns the LinkTable associated with this Profile.
func (ms Profile) LinkTable() LinkSlice {
	return newLinkSlice(&ms.orig.LinkTable, ms.state)
}

// StringTable returns the StringTable associated with this Profile.
func (ms Profile) StringTable() pcommon.StringSlice {
	return pcommon.StringSlice(internal.NewStringSlice(&ms.orig.StringTable, ms.state))
}

// DropFrames returns the dropframes associated with this Profile.
func (ms Profile) DropFrames() int64 {
	return ms.orig.DropFrames
}

// SetDropFrames replaces the dropframes associated with this Profile.
func (ms Profile) SetDropFrames(v int64) {
	ms.state.AssertMutable()
	ms.orig.DropFrames = v
}

// KeepFrames returns the keepframes associated with this Profile.
func (ms Profile) KeepFrames() int64 {
	return ms.orig.KeepFrames
}

// SetKeepFrames replaces the keepframes associated with this Profile.
func (ms Profile) SetKeepFrames(v int64) {
	ms.state.AssertMutable()
	ms.orig.KeepFrames = v
}

// StartTime returns the starttime associated with this Profile.
func (ms Profile) StartTime() pcommon.Timestamp {
	return pcommon.Timestamp(ms.orig.TimeNanos)
}

// SetStartTime replaces the starttime associated with this Profile.
func (ms Profile) SetStartTime(v pcommon.Timestamp) {
	ms.state.AssertMutable()
	ms.orig.TimeNanos = int64(v)
}

// Duration returns the duration associated with this Profile.
func (ms Profile) Duration() pcommon.Timestamp {
	return pcommon.Timestamp(ms.orig.DurationNanos)
}

// SetDuration replaces the duration associated with this Profile.
func (ms Profile) SetDuration(v pcommon.Timestamp) {
	ms.state.AssertMutable()
	ms.orig.DurationNanos = int64(v)
}

// PeriodType returns the periodtype associated with this Profile.
func (ms Profile) PeriodType() ValueType {
	return newValueType(&ms.orig.PeriodType, ms.state)
}

// Period returns the period associated with this Profile.
func (ms Profile) Period() int64 {
	return ms.orig.Period
}

// SetPeriod replaces the period associated with this Profile.
func (ms Profile) SetPeriod(v int64) {
	ms.state.AssertMutable()
	ms.orig.Period = v
}

// Comment returns the Comment associated with this Profile.
func (ms Profile) Comment() pcommon.Int64Slice {
	return pcommon.Int64Slice(internal.NewInt64Slice(&ms.orig.Comment, ms.state))
}

// DefaultSampleType returns the defaultsampletype associated with this Profile.
func (ms Profile) DefaultSampleType() int64 {
	return ms.orig.DefaultSampleType
}

// SetDefaultSampleType replaces the defaultsampletype associated with this Profile.
func (ms Profile) SetDefaultSampleType(v int64) {
	ms.state.AssertMutable()
	ms.orig.DefaultSampleType = v
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Profile) CopyTo(dest Profile) {
	dest.state.AssertMutable()
	ms.SampleType().CopyTo(dest.SampleType())
	ms.Sample().CopyTo(dest.Sample())
	ms.Mapping().CopyTo(dest.Mapping())
	ms.Location().CopyTo(dest.Location())
	ms.LocationIndices().CopyTo(dest.LocationIndices())
	ms.Function().CopyTo(dest.Function())
	ms.AttributeTable().CopyTo(dest.AttributeTable())
	ms.AttributeUnits().CopyTo(dest.AttributeUnits())
	ms.LinkTable().CopyTo(dest.LinkTable())
	ms.StringTable().CopyTo(dest.StringTable())
	dest.SetDropFrames(ms.DropFrames())
	dest.SetKeepFrames(ms.KeepFrames())
	dest.SetStartTime(ms.StartTime())
	dest.SetDuration(ms.Duration())
	ms.PeriodType().CopyTo(dest.PeriodType())
	dest.SetPeriod(ms.Period())
	ms.Comment().CopyTo(dest.Comment())
	dest.SetDefaultSampleType(ms.DefaultSampleType())
}
