## RabbitMQ 4.1.5

RabbitMQ `4.1.5` is a maintenance release in the `4.1.x` [release series](https://www.rabbitmq.com/release-information).

It is **strongly recommended** that you read [4.1.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.1.0)
in detail if upgrading from a version prior to `4.1.0`.


### Minimum Supported Erlang Version

[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.1.x/release-notes).


### Core Server

#### Bug Fixes

 * Classic queues could run into a rare message store exception that resuulted in
   a loss of a few messages.

   Special kudos to the contributors who have spent a very significant amount of time
   reproducing and debugging the issue: @lhoguin @lukebakken @trvrnrth @gomoripeti

   GitHub issues: [#14181](https://github.com/rabbitmq/rabbitmq-server/discussions/14181), [#14576](https://github.com/rabbitmq/rabbitmq-server/pull/14576)

 * Messages routed to quorum queues during or immediately before a network partition,
   in some cases were not re-republished internally in certain cases.

   GitHub issue: [#14589](https://github.com/rabbitmq/rabbitmq-server/pull/14589)

 * Quorum queues with disabled [poison message handling](https://www.rabbitmq.com/docs/quorum-queues#poison-message-handling)
   (an unlimited number of redeliveries, which is **not** a recommended practice) could accumulate
   a significant number of Raft log segment files.

   GitHub issues: [#14202](https://github.com/rabbitmq/rabbitmq-server/issues/14202), [#14458](https://github.com/rabbitmq/rabbitmq-server/pull/14458)

### Streams

#### Bug Fixes

 * Streams declaration response was missing a leader field when the stream was declared via AMQP 1.0 or 0.9.1
   (that is, not the RabbitMQ Stream Protocol).

   GitHub issue: [#14476](https://github.com/rabbitmq/rabbitmq-server/pull/14476)

### CLI Tools

#### Bug Fixes

 * Fixes JSON formatting of cluster nodes produced by `rabbitmq-diagnostics status --formatter json`

   GitHub issue: [#14509](https://github.com/rabbitmq/rabbitmq-server/issues/14509)

### Shovel Prometheus Plugin

#### Bug Fixes

 * Requesting shovel status via Prometheus at a specific moment resulted in an exception
   because the plugin did not consider a highly transient starting state.

   GitHub issue: [#14481](https://github.com/rabbitmq/rabbitmq-server/pull/14481)
