using System.Runtime.InteropServices;

namespace NAPS2.ImportExport.Email.Mapi;

/// <summary>
/// A MAPI structure describing an email attachment.
/// Documented at: http://msdn.microsoft.com/en-us/library/windows/desktop/dd296737%28v=vs.85%29.aspx
/// </summary>
[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
internal class MapiFileDesc
{
    public int reserved;
    public int flags;
    public int position;
    public string? path;
    public string? name;
    public IntPtr type;
}

[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
internal class MapiFileDescW
{
    public int reserved;
    public int flags;
    public int position;
    public string? path;
    public string? name;
    public IntPtr type;
}