#ifndef ATL_sGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,100,175,212,250,288,326,363,401,439,477,552,628,665,703,741,779,816,854,892,930,1005,1081,1156,1232,1836,2440
 * N : 25,100,175,212,250,288,326,363,401,439,477,552,628,665,703,741,779,816,854,892,930,1005,1081,1156,1232,1836,2440
 * NB : 1,1,11,11,12,12,15,16,17,17,18,18,19,31,35,36,43,44,47,47,59,59,60,60,72,72,144
 */
#define ATL_sGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 137) (nb_) = 1; \
   else if ((n_) < 231) (nb_) = 11; \
   else if ((n_) < 307) (nb_) = 12; \
   else if ((n_) < 344) (nb_) = 15; \
   else if ((n_) < 382) (nb_) = 16; \
   else if ((n_) < 458) (nb_) = 17; \
   else if ((n_) < 590) (nb_) = 18; \
   else if ((n_) < 646) (nb_) = 19; \
   else if ((n_) < 684) (nb_) = 31; \
   else if ((n_) < 722) (nb_) = 35; \
   else if ((n_) < 760) (nb_) = 36; \
   else if ((n_) < 797) (nb_) = 43; \
   else if ((n_) < 835) (nb_) = 44; \
   else if ((n_) < 911) (nb_) = 47; \
   else if ((n_) < 1043) (nb_) = 59; \
   else if ((n_) < 1194) (nb_) = 60; \
   else if ((n_) < 2138) (nb_) = 72; \
   else (nb_) = 144; \
}


#endif    /* end ifndef ATL_sGetNB_geqrf */
