package batchai

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AllocationState enumerates the values for allocation state.
type AllocationState string

const (
	// Resizing ...
	Resizing AllocationState = "resizing"
	// Steady ...
	Steady AllocationState = "steady"
)

// PossibleAllocationStateValues returns an array of possible values for the AllocationState const type.
func PossibleAllocationStateValues() []AllocationState {
	return []AllocationState{Resizing, Steady}
}

// CachingType enumerates the values for caching type.
type CachingType string

const (
	// None ...
	None CachingType = "none"
	// Readonly ...
	Readonly CachingType = "readonly"
	// Readwrite ...
	Readwrite CachingType = "readwrite"
)

// PossibleCachingTypeValues returns an array of possible values for the CachingType const type.
func PossibleCachingTypeValues() []CachingType {
	return []CachingType{None, Readonly, Readwrite}
}

// DeallocationOption enumerates the values for deallocation option.
type DeallocationOption string

const (
	// Requeue ...
	Requeue DeallocationOption = "requeue"
	// Terminate ...
	Terminate DeallocationOption = "terminate"
	// Waitforjobcompletion ...
	Waitforjobcompletion DeallocationOption = "waitforjobcompletion"
)

// PossibleDeallocationOptionValues returns an array of possible values for the DeallocationOption const type.
func PossibleDeallocationOptionValues() []DeallocationOption {
	return []DeallocationOption{Requeue, Terminate, Waitforjobcompletion}
}

// ExecutionState enumerates the values for execution state.
type ExecutionState string

const (
	// Failed ...
	Failed ExecutionState = "failed"
	// Queued ...
	Queued ExecutionState = "queued"
	// Running ...
	Running ExecutionState = "running"
	// Succeeded ...
	Succeeded ExecutionState = "succeeded"
	// Terminating ...
	Terminating ExecutionState = "terminating"
)

// PossibleExecutionStateValues returns an array of possible values for the ExecutionState const type.
func PossibleExecutionStateValues() []ExecutionState {
	return []ExecutionState{Failed, Queued, Running, Succeeded, Terminating}
}

// FileServerProvisioningState enumerates the values for file server provisioning state.
type FileServerProvisioningState string

const (
	// FileServerProvisioningStateCreating ...
	FileServerProvisioningStateCreating FileServerProvisioningState = "creating"
	// FileServerProvisioningStateDeleting ...
	FileServerProvisioningStateDeleting FileServerProvisioningState = "deleting"
	// FileServerProvisioningStateFailed ...
	FileServerProvisioningStateFailed FileServerProvisioningState = "failed"
	// FileServerProvisioningStateSucceeded ...
	FileServerProvisioningStateSucceeded FileServerProvisioningState = "succeeded"
	// FileServerProvisioningStateUpdating ...
	FileServerProvisioningStateUpdating FileServerProvisioningState = "updating"
)

// PossibleFileServerProvisioningStateValues returns an array of possible values for the FileServerProvisioningState const type.
func PossibleFileServerProvisioningStateValues() []FileServerProvisioningState {
	return []FileServerProvisioningState{FileServerProvisioningStateCreating, FileServerProvisioningStateDeleting, FileServerProvisioningStateFailed, FileServerProvisioningStateSucceeded, FileServerProvisioningStateUpdating}
}

// FileType enumerates the values for file type.
type FileType string

const (
	// FileTypeDirectory ...
	FileTypeDirectory FileType = "directory"
	// FileTypeFile ...
	FileTypeFile FileType = "file"
)

// PossibleFileTypeValues returns an array of possible values for the FileType const type.
func PossibleFileTypeValues() []FileType {
	return []FileType{FileTypeDirectory, FileTypeFile}
}

// JobPriority enumerates the values for job priority.
type JobPriority string

const (
	// High ...
	High JobPriority = "high"
	// Low ...
	Low JobPriority = "low"
	// Normal ...
	Normal JobPriority = "normal"
)

// PossibleJobPriorityValues returns an array of possible values for the JobPriority const type.
func PossibleJobPriorityValues() []JobPriority {
	return []JobPriority{High, Low, Normal}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded}
}

// StorageAccountType enumerates the values for storage account type.
type StorageAccountType string

const (
	// PremiumLRS ...
	PremiumLRS StorageAccountType = "Premium_LRS"
	// StandardLRS ...
	StandardLRS StorageAccountType = "Standard_LRS"
)

// PossibleStorageAccountTypeValues returns an array of possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{PremiumLRS, StandardLRS}
}

// ToolType enumerates the values for tool type.
type ToolType string

const (
	// Caffe ...
	Caffe ToolType = "caffe"
	// Caffe2 ...
	Caffe2 ToolType = "caffe2"
	// Chainer ...
	Chainer ToolType = "chainer"
	// Cntk ...
	Cntk ToolType = "cntk"
	// Custom ...
	Custom ToolType = "custom"
	// Horovod ...
	Horovod ToolType = "horovod"
	// Mpi ...
	Mpi ToolType = "mpi"
	// Tensorflow ...
	Tensorflow ToolType = "tensorflow"
)

// PossibleToolTypeValues returns an array of possible values for the ToolType const type.
func PossibleToolTypeValues() []ToolType {
	return []ToolType{Caffe, Caffe2, Chainer, Cntk, Custom, Horovod, Mpi, Tensorflow}
}

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// Count ...
	Count UsageUnit = "Count"
)

// PossibleUsageUnitValues returns an array of possible values for the UsageUnit const type.
func PossibleUsageUnitValues() []UsageUnit {
	return []UsageUnit{Count}
}

// VMPriority enumerates the values for vm priority.
type VMPriority string

const (
	// Dedicated ...
	Dedicated VMPriority = "dedicated"
	// Lowpriority ...
	Lowpriority VMPriority = "lowpriority"
)

// PossibleVMPriorityValues returns an array of possible values for the VMPriority const type.
func PossibleVMPriorityValues() []VMPriority {
	return []VMPriority{Dedicated, Lowpriority}
}

// AppInsightsReference specifies Azure Application Insights information for performance counters reporting.
type AppInsightsReference struct {
	Component          *ResourceID `json:"component,omitempty"`
	InstrumentationKey *string     `json:"instrumentationKey,omitempty"`
	// InstrumentationKeySecretReference - Specifies KeyVault Store and Secret which contains Azure Application Insights instrumentation key. One of instumentationKey or instrumentationKeySecretReference must be specified.
	InstrumentationKeySecretReference *KeyVaultSecretReference `json:"instrumentationKeySecretReference,omitempty"`
}

// AutoScaleSettings the system automatically scales the cluster up and down (within minimumNodeCount and
// maximumNodeCount) based on the pending and running jobs on the cluster.
type AutoScaleSettings struct {
	MinimumNodeCount *int32 `json:"minimumNodeCount,omitempty"`
	MaximumNodeCount *int32 `json:"maximumNodeCount,omitempty"`
	InitialNodeCount *int32 `json:"initialNodeCount,omitempty"`
}

// AzureBlobFileSystemReference provides required information, for the service to be able to mount Azure Blob
// Storage container on the cluster nodes.
type AzureBlobFileSystemReference struct {
	AccountName   *string                      `json:"accountName,omitempty"`
	ContainerName *string                      `json:"containerName,omitempty"`
	Credentials   *AzureStorageCredentialsInfo `json:"credentials,omitempty"`
	// RelativeMountPath - Note that all cluster level blob file systems will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and all job level blob file systems will be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	MountOptions      *string `json:"mountOptions,omitempty"`
}

// AzureFileShareReference details of the Azure File Share to mount on the cluster.
type AzureFileShareReference struct {
	AccountName  *string                      `json:"accountName,omitempty"`
	AzureFileURL *string                      `json:"azureFileUrl,omitempty"`
	Credentials  *AzureStorageCredentialsInfo `json:"credentials,omitempty"`
	// RelativeMountPath - Note that all cluster level file shares will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and all job level file shares will be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	// FileMode - Default value is 0777. Valid only if OS is linux.
	FileMode *string `json:"fileMode,omitempty"`
	// DirectoryMode - Default value is 0777. Valid only if OS is linux.
	DirectoryMode *string `json:"directoryMode,omitempty"`
}

// AzureStorageCredentialsInfo credentials to access Azure File Share.
type AzureStorageCredentialsInfo struct {
	// AccountKey - One of accountKey or accountKeySecretReference must be specified.
	AccountKey *string `json:"accountKey,omitempty"`
	// AccountKeySecretReference - Users can store their secrets in Azure KeyVault and pass it to the Batch AI Service to integrate with KeyVault. One of accountKey or accountKeySecretReference must be specified.
	AccountKeySecretReference *KeyVaultSecretReference `json:"accountKeySecretReference,omitempty"`
}

// Caffe2Settings specifies the settings for Caffe2 job.
type Caffe2Settings struct {
	PythonScriptFilePath  *string `json:"pythonScriptFilePath,omitempty"`
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	CommandLineArgs       *string `json:"commandLineArgs,omitempty"`
}

// CaffeSettings specifies the settings for Caffe job.
type CaffeSettings struct {
	// ConfigFilePath - This property cannot be specified if pythonScriptFilePath is specified.
	ConfigFilePath *string `json:"configFilePath,omitempty"`
	// PythonScriptFilePath - This property cannot be specified if configFilePath is specified.
	PythonScriptFilePath *string `json:"pythonScriptFilePath,omitempty"`
	// PythonInterpreterPath - This property can be specified only if the pythonScriptFilePath is specified.
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	CommandLineArgs       *string `json:"commandLineArgs,omitempty"`
	// ProcessCount - The default value for this property is equal to nodeCount property
	ProcessCount *int32 `json:"processCount,omitempty"`
}

// ChainerSettings specifies the settings for Chainer job.
type ChainerSettings struct {
	PythonScriptFilePath  *string `json:"pythonScriptFilePath,omitempty"`
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	CommandLineArgs       *string `json:"commandLineArgs,omitempty"`
	// ProcessCount - The default value for this property is equal to nodeCount property
	ProcessCount *int32 `json:"processCount,omitempty"`
}

// CloudError an error response from the Batch AI service.
type CloudError struct {
	// Error - An error response from the Batch AI service.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the Batch AI service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// Cluster contains information about a Cluster.
type Cluster struct {
	autorest.Response `json:"-"`
	// ClusterProperties - The properties associated with the Cluster.
	*ClusterProperties `json:"properties,omitempty"`
	// ID - The ID of the resource
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.ID != nil {
		objectMap["id"] = c.ID
	}
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Type != nil {
		objectMap["type"] = c.Type
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		}
	}

	return nil
}

// ClusterBaseProperties the properties of a Cluster.
type ClusterBaseProperties struct {
	// VMSize - All virtual machines in a cluster are the same size. For information about available VM sizes for clusters using images from the Virtual Machines Marketplace (see Sizes for Virtual Machines (Linux) or Sizes for Virtual Machines (Windows). Batch AI service supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
	VMSize *string `json:"vmSize,omitempty"`
	// VMPriority - Default is dedicated. Possible values include: 'Dedicated', 'Lowpriority'
	VMPriority                  VMPriority                   `json:"vmPriority,omitempty"`
	ScaleSettings               *ScaleSettings               `json:"scaleSettings,omitempty"`
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	NodeSetup                   *NodeSetup                   `json:"nodeSetup,omitempty"`
	UserAccountSettings         *UserAccountSettings         `json:"userAccountSettings,omitempty"`
	Subnet                      *ResourceID                  `json:"subnet,omitempty"`
}

// ClusterCreateParameters parameters supplied to the Create operation.
type ClusterCreateParameters struct {
	// Location - The region in which to create the cluster.
	Location *string `json:"location,omitempty"`
	// Tags - The user specified tags associated with the Cluster.
	Tags map[string]*string `json:"tags"`
	// ClusterBaseProperties - The properties of the Cluster.
	*ClusterBaseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterCreateParameters.
func (ccp ClusterCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccp.Location != nil {
		objectMap["location"] = ccp.Location
	}
	if ccp.Tags != nil {
		objectMap["tags"] = ccp.Tags
	}
	if ccp.ClusterBaseProperties != nil {
		objectMap["properties"] = ccp.ClusterBaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterCreateParameters struct.
func (ccp *ClusterCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ccp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ccp.Tags = tags
			}
		case "properties":
			if v != nil {
				var clusterBaseProperties ClusterBaseProperties
				err = json.Unmarshal(*v, &clusterBaseProperties)
				if err != nil {
					return err
				}
				ccp.ClusterBaseProperties = &clusterBaseProperties
			}
		}
	}

	return nil
}

// ClusterListResult values returned by the List Clusters operation.
type ClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of returned Clusters.
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterListResultIterator provides access to a complete listing of Cluster values.
type ClusterListResultIterator struct {
	i    int
	page ClusterListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListResultIterator) Response() ClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListResultIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ClusterListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// clusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ClusterListResult) clusterListResultPreparer() (*http.Request, error) {
	if clr.NextLink == nil || len(to.String(clr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ClusterListResultPage contains a page of Cluster values.
type ClusterListResultPage struct {
	fn  func(ClusterListResult) (ClusterListResult, error)
	clr ClusterListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListResultPage) Next() error {
	next, err := page.fn(page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListResultPage) Response() ClusterListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListResultPage) Values() []Cluster {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// ClusterProperties job specific properties.
type ClusterProperties struct {
	// VMSize - All virtual machines in a cluster are the same size. For information about available VM sizes for clusters using images from the Virtual Machines Marketplace (see Sizes for Virtual Machines (Linux) or Sizes for Virtual Machines (Windows). Batch AI service supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
	VMSize *string `json:"vmSize,omitempty"`
	// VMPriority - The default value is dedicated. The node can get preempted while the task is running if lowpriority is choosen. This is best suited if the workload is checkpointing and can be restarted. Possible values include: 'Dedicated', 'Lowpriority'
	VMPriority                  VMPriority                   `json:"vmPriority,omitempty"`
	ScaleSettings               *ScaleSettings               `json:"scaleSettings,omitempty"`
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	NodeSetup                   *NodeSetup                   `json:"nodeSetup,omitempty"`
	UserAccountSettings         *UserAccountSettings         `json:"userAccountSettings,omitempty"`
	Subnet                      *ResourceID                  `json:"subnet,omitempty"`
	CreationTime                *date.Time                   `json:"creationTime,omitempty"`
	// ProvisioningState - Possible value are: creating - Specifies that the cluster is being created. succeeded - Specifies that the cluster has been created successfully. failed - Specifies that the cluster creation has failed. deleting - Specifies that the cluster is being deleted. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateDeleting'
	ProvisioningState               ProvisioningState `json:"provisioningState,omitempty"`
	ProvisioningStateTransitionTime *date.Time        `json:"provisioningStateTransitionTime,omitempty"`
	// AllocationState - Possible values are: steady and resizing. steady state indicates that the cluster is not resizing. There are no changes to the number of compute nodes in the cluster in progress. A cluster enters this state when it is created and when no operations are being performed on the cluster to change the number of compute nodes. resizing state indicates that the cluster is resizing; that is, compute nodes are being added to or removed from the cluster. Possible values include: 'Steady', 'Resizing'
	AllocationState               AllocationState `json:"allocationState,omitempty"`
	AllocationStateTransitionTime *date.Time      `json:"allocationStateTransitionTime,omitempty"`
	// Errors - This element contains all the errors encountered by various compute nodes during node setup.
	Errors           *[]Error         `json:"errors,omitempty"`
	CurrentNodeCount *int32           `json:"currentNodeCount,omitempty"`
	NodeStateCounts  *NodeStateCounts `json:"nodeStateCounts,omitempty"`
}

// ClustersCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ClustersCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersCreateFuture) Result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.ClustersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("batchai.ClustersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batchai.ClustersCreateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ClustersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersDeleteFuture) Result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("batchai.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClusterUpdateParameters parameters supplied to the Update operation.
type ClusterUpdateParameters struct {
	// Tags - The user specified tags associated with the Cluster.
	Tags map[string]*string `json:"tags"`
	// ClusterUpdateProperties - The properties of the Cluster.
	*ClusterUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpdateParameters.
func (cup ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.Tags != nil {
		objectMap["tags"] = cup.Tags
	}
	if cup.ClusterUpdateProperties != nil {
		objectMap["properties"] = cup.ClusterUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdateParameters struct.
func (cup *ClusterUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cup.Tags = tags
			}
		case "properties":
			if v != nil {
				var clusterUpdateProperties ClusterUpdateProperties
				err = json.Unmarshal(*v, &clusterUpdateProperties)
				if err != nil {
					return err
				}
				cup.ClusterUpdateProperties = &clusterUpdateProperties
			}
		}
	}

	return nil
}

// ClusterUpdateProperties the properties of a Cluster that need to be updated.
type ClusterUpdateProperties struct {
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
}

// CNTKsettings specifies the settings for CNTK (aka Microsoft Cognitive Toolkit) job.
type CNTKsettings struct {
	// LanguageType - Valid values are 'BrainScript' or 'Python'.
	LanguageType *string `json:"languageType,omitempty"`
	// ConfigFilePath - This property can be specified only if the languageType is 'BrainScript'.
	ConfigFilePath *string `json:"configFilePath,omitempty"`
	// PythonScriptFilePath - This property can be specified only if the languageType is 'Python'.
	PythonScriptFilePath *string `json:"pythonScriptFilePath,omitempty"`
	// PythonInterpreterPath - This property can be specified only if the languageType is 'Python'.
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	CommandLineArgs       *string `json:"commandLineArgs,omitempty"`
	// ProcessCount - The default value for this property is equal to nodeCount property
	ProcessCount *int32 `json:"processCount,omitempty"`
}

// ContainerSettings settings for the container to be downloaded.
type ContainerSettings struct {
	ImageSourceRegistry *ImageSourceRegistry `json:"imageSourceRegistry,omitempty"`
}

// CustomMpiSettings specifies the settings for a custom tool kit job.
type CustomMpiSettings struct {
	CommandLine *string `json:"commandLine,omitempty"`
	// ProcessCount - The default value for this property is equal to nodeCount property
	ProcessCount *int32 `json:"processCount,omitempty"`
}

// CustomToolkitSettings specifies the settings for a custom tool kit job.
type CustomToolkitSettings struct {
	CommandLine *string `json:"commandLine,omitempty"`
}

// DataDisks settings for the data disk which would be created for the File Server.
type DataDisks struct {
	DiskSizeInGB *int32 `json:"diskSizeInGB,omitempty"`
	// CachingType - Possible values include: 'None', 'Readonly', 'Readwrite'
	CachingType CachingType `json:"cachingType,omitempty"`
	DiskCount   *int32      `json:"diskCount,omitempty"`
	// StorageAccountType - Possible values include: 'StandardLRS', 'PremiumLRS'
	StorageAccountType StorageAccountType `json:"storageAccountType,omitempty"`
}

// EnvironmentVariable a collection of environment variables to set.
type EnvironmentVariable struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// EnvironmentVariableWithSecretValue a collection of environment variables with secret values to set.
type EnvironmentVariableWithSecretValue struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
	// ValueSecretReference - Specifies KeyVault Store and Secret which contains the value for the environment variable. One of value or valueSecretReference must be provided.
	ValueSecretReference *KeyVaultSecretReference `json:"valueSecretReference,omitempty"`
}

// Error an error response from the Batch AI service.
type Error struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]NameValuePair `json:"details,omitempty"`
}

// Experiment contains information about the experiment.
type Experiment struct {
	autorest.Response `json:"-"`
	// ExperimentProperties - The properties associated with the experiment.
	*ExperimentProperties `json:"properties,omitempty"`
	// ID - The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Experiment.
func (e Experiment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.ExperimentProperties != nil {
		objectMap["properties"] = e.ExperimentProperties
	}
	if e.ID != nil {
		objectMap["id"] = e.ID
	}
	if e.Name != nil {
		objectMap["name"] = e.Name
	}
	if e.Type != nil {
		objectMap["type"] = e.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Experiment struct.
func (e *Experiment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var experimentProperties ExperimentProperties
				err = json.Unmarshal(*v, &experimentProperties)
				if err != nil {
					return err
				}
				e.ExperimentProperties = &experimentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		}
	}

	return nil
}

// ExperimentListResult values returned by the List operation.
type ExperimentListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of experiments.
	Value *[]Experiment `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExperimentListResultIterator provides access to a complete listing of Experiment values.
type ExperimentListResultIterator struct {
	i    int
	page ExperimentListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExperimentListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExperimentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExperimentListResultIterator) Response() ExperimentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExperimentListResultIterator) Value() Experiment {
	if !iter.page.NotDone() {
		return Experiment{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (elr ExperimentListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// experimentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr ExperimentListResult) experimentListResultPreparer() (*http.Request, error) {
	if elr.NextLink == nil || len(to.String(elr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// ExperimentListResultPage contains a page of Experiment values.
type ExperimentListResultPage struct {
	fn  func(ExperimentListResult) (ExperimentListResult, error)
	elr ExperimentListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExperimentListResultPage) Next() error {
	next, err := page.fn(page.elr)
	if err != nil {
		return err
	}
	page.elr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExperimentListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExperimentListResultPage) Response() ExperimentListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExperimentListResultPage) Values() []Experiment {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// ExperimentProperties experiment specific properties.
type ExperimentProperties struct {
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - The provisioned state of the experiment. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningStateTransitionTime - The time at which the experiment entered its current provisioning state.
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
}

// ExperimentsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ExperimentsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExperimentsCreateFuture) Result(client ExperimentsClient) (e Experiment, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.ExperimentsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("batchai.ExperimentsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.CreateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batchai.ExperimentsCreateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExperimentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ExperimentsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExperimentsDeleteFuture) Result(client ExperimentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.ExperimentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("batchai.ExperimentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// File properties of the file or directory.
type File struct {
	// Name - Name of the file.
	Name *string `json:"name,omitempty"`
	// FileType - Contains information about file type. Possible values include: 'FileTypeFile', 'FileTypeDirectory'
	FileType    FileType `json:"fileType,omitempty"`
	DownloadURL *string  `json:"downloadUrl,omitempty"`
	// FileProperties - The properties associated with the file. The properties are not returned for directories.
	*FileProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for File.
func (f File) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if f.Name != nil {
		objectMap["name"] = f.Name
	}
	if f.FileType != "" {
		objectMap["fileType"] = f.FileType
	}
	if f.DownloadURL != nil {
		objectMap["downloadUrl"] = f.DownloadURL
	}
	if f.FileProperties != nil {
		objectMap["properties"] = f.FileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for File struct.
func (f *File) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				f.Name = &name
			}
		case "fileType":
			if v != nil {
				var fileType FileType
				err = json.Unmarshal(*v, &fileType)
				if err != nil {
					return err
				}
				f.FileType = fileType
			}
		case "downloadUrl":
			if v != nil {
				var downloadURL string
				err = json.Unmarshal(*v, &downloadURL)
				if err != nil {
					return err
				}
				f.DownloadURL = &downloadURL
			}
		case "properties":
			if v != nil {
				var fileProperties FileProperties
				err = json.Unmarshal(*v, &fileProperties)
				if err != nil {
					return err
				}
				f.FileProperties = &fileProperties
			}
		}
	}

	return nil
}

// FileListResult values returned by the List operation.
type FileListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of returned job directories and files.
	Value *[]File `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// FileListResultIterator provides access to a complete listing of File values.
type FileListResultIterator struct {
	i    int
	page FileListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FileListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FileListResultIterator) Response() FileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FileListResultIterator) Value() File {
	if !iter.page.NotDone() {
		return File{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (flr FileListResult) IsEmpty() bool {
	return flr.Value == nil || len(*flr.Value) == 0
}

// fileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (flr FileListResult) fileListResultPreparer() (*http.Request, error) {
	if flr.NextLink == nil || len(to.String(flr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(flr.NextLink)))
}

// FileListResultPage contains a page of File values.
type FileListResultPage struct {
	fn  func(FileListResult) (FileListResult, error)
	flr FileListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FileListResultPage) Next() error {
	next, err := page.fn(page.flr)
	if err != nil {
		return err
	}
	page.flr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FileListResultPage) NotDone() bool {
	return !page.flr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FileListResultPage) Response() FileListResult {
	return page.flr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FileListResultPage) Values() []File {
	if page.flr.IsEmpty() {
		return nil
	}
	return *page.flr.Value
}

// FileProperties file specific properties.
type FileProperties struct {
	// LastModified - The time at which the file was last modified.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// ContentLength - The file size.
	ContentLength *int64 `json:"contentLength,omitempty"`
}

// FileServer contains information about the File Server.
type FileServer struct {
	autorest.Response `json:"-"`
	// FileServerProperties - The properties associated with the File Server.
	*FileServerProperties `json:"properties,omitempty"`
	// ID - The ID of the resource
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FileServer.
func (fs FileServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fs.FileServerProperties != nil {
		objectMap["properties"] = fs.FileServerProperties
	}
	if fs.ID != nil {
		objectMap["id"] = fs.ID
	}
	if fs.Name != nil {
		objectMap["name"] = fs.Name
	}
	if fs.Type != nil {
		objectMap["type"] = fs.Type
	}
	if fs.Location != nil {
		objectMap["location"] = fs.Location
	}
	if fs.Tags != nil {
		objectMap["tags"] = fs.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileServer struct.
func (fs *FileServer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileServerProperties FileServerProperties
				err = json.Unmarshal(*v, &fileServerProperties)
				if err != nil {
					return err
				}
				fs.FileServerProperties = &fileServerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fs.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fs.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fs.Tags = tags
			}
		}
	}

	return nil
}

// FileServerBaseProperties the properties of a file server.
type FileServerBaseProperties struct {
	// VMSize - For information about available VM sizes for fileservers from the Virtual Machines Marketplace, see Sizes for Virtual Machines (Linux).
	VMSize           *string           `json:"vmSize,omitempty"`
	SSHConfiguration *SSHConfiguration `json:"sshConfiguration,omitempty"`
	DataDisks        *DataDisks        `json:"dataDisks,omitempty"`
	Subnet           *ResourceID       `json:"subnet,omitempty"`
}

// FileServerCreateParameters parameters supplied to the Create operation.
type FileServerCreateParameters struct {
	// Location - The region in which to create the File Server.
	Location *string `json:"location,omitempty"`
	// Tags - The user specified tags associated with the File Server.
	Tags map[string]*string `json:"tags"`
	// FileServerBaseProperties - The properties of the File Server.
	*FileServerBaseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for FileServerCreateParameters.
func (fscp FileServerCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fscp.Location != nil {
		objectMap["location"] = fscp.Location
	}
	if fscp.Tags != nil {
		objectMap["tags"] = fscp.Tags
	}
	if fscp.FileServerBaseProperties != nil {
		objectMap["properties"] = fscp.FileServerBaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileServerCreateParameters struct.
func (fscp *FileServerCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fscp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fscp.Tags = tags
			}
		case "properties":
			if v != nil {
				var fileServerBaseProperties FileServerBaseProperties
				err = json.Unmarshal(*v, &fileServerBaseProperties)
				if err != nil {
					return err
				}
				fscp.FileServerBaseProperties = &fileServerBaseProperties
			}
		}
	}

	return nil
}

// FileServerListResult values returned by the List operation.
type FileServerListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of File Servers.
	Value *[]FileServer `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// FileServerListResultIterator provides access to a complete listing of FileServer values.
type FileServerListResultIterator struct {
	i    int
	page FileServerListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FileServerListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FileServerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FileServerListResultIterator) Response() FileServerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FileServerListResultIterator) Value() FileServer {
	if !iter.page.NotDone() {
		return FileServer{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (fslr FileServerListResult) IsEmpty() bool {
	return fslr.Value == nil || len(*fslr.Value) == 0
}

// fileServerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fslr FileServerListResult) fileServerListResultPreparer() (*http.Request, error) {
	if fslr.NextLink == nil || len(to.String(fslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fslr.NextLink)))
}

// FileServerListResultPage contains a page of FileServer values.
type FileServerListResultPage struct {
	fn   func(FileServerListResult) (FileServerListResult, error)
	fslr FileServerListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FileServerListResultPage) Next() error {
	next, err := page.fn(page.fslr)
	if err != nil {
		return err
	}
	page.fslr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FileServerListResultPage) NotDone() bool {
	return !page.fslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FileServerListResultPage) Response() FileServerListResult {
	return page.fslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FileServerListResultPage) Values() []FileServer {
	if page.fslr.IsEmpty() {
		return nil
	}
	return *page.fslr.Value
}

// FileServerProperties file server specific properties.
type FileServerProperties struct {
	// VMSize - For information about available VM sizes for File Server from the Virtual Machines Marketplace, see Sizes for Virtual Machines (Linux).
	VMSize                          *string           `json:"vmSize,omitempty"`
	SSHConfiguration                *SSHConfiguration `json:"sshConfiguration,omitempty"`
	DataDisks                       *DataDisks        `json:"dataDisks,omitempty"`
	Subnet                          *ResourceID       `json:"subnet,omitempty"`
	MountSettings                   *MountSettings    `json:"mountSettings,omitempty"`
	ProvisioningStateTransitionTime *date.Time        `json:"provisioningStateTransitionTime,omitempty"`
	CreationTime                    *date.Time        `json:"creationTime,omitempty"`
	// ProvisioningState - Possible values: creating - The File Server is getting created. updating - The File Server creation has been accepted and it is getting updated. deleting - The user has requested that the File Server be deleted, and it is in the process of being deleted. failed - The File Server creation has failed with the specified errorCode. Details about the error code are specified in the message field. succeeded - The File Server creation has succeeded. Possible values include: 'FileServerProvisioningStateCreating', 'FileServerProvisioningStateUpdating', 'FileServerProvisioningStateDeleting', 'FileServerProvisioningStateSucceeded', 'FileServerProvisioningStateFailed'
	ProvisioningState FileServerProvisioningState `json:"provisioningState,omitempty"`
}

// FileServerReference provides required information, for the service to be able to mount Azure FileShare on the
// cluster nodes.
type FileServerReference struct {
	FileServer *ResourceID `json:"fileServer,omitempty"`
	// SourceDirectory - If this property is not specified, the entire File Server will be mounted.
	SourceDirectory *string `json:"sourceDirectory,omitempty"`
	// RelativeMountPath - Note that all cluster level file servers will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and job level file servers will be mouted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	MountOptions      *string `json:"mountOptions,omitempty"`
}

// FileServersCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type FileServersCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FileServersCreateFuture) Result(client FileServersClient) (fs FileServer, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.FileServersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("batchai.FileServersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fs.Response.Response, err = future.GetResult(sender); err == nil && fs.Response.Response.StatusCode != http.StatusNoContent {
		fs, err = client.CreateResponder(fs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batchai.FileServersCreateFuture", "Result", fs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FileServersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type FileServersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FileServersDeleteFuture) Result(client FileServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.FileServersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("batchai.FileServersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HorovodSettings specifies the settings for Chainer job.
type HorovodSettings struct {
	PythonScriptFilePath  *string `json:"pythonScriptFilePath,omitempty"`
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	CommandLineArgs       *string `json:"commandLineArgs,omitempty"`
	// ProcessCount - The default value for this property is equal to nodeCount property
	ProcessCount *int32 `json:"processCount,omitempty"`
}

// ImageReference the image reference.
type ImageReference struct {
	Publisher *string `json:"publisher,omitempty"`
	Offer     *string `json:"offer,omitempty"`
	Sku       *string `json:"sku,omitempty"`
	Version   *string `json:"version,omitempty"`
	// VirtualMachineImageID - The virtual machine image must be in the same region and subscription as the cluster. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration. Note, you need to provide publisher, offer and sku of the base OS image of which the custom image has been derived from.
	VirtualMachineImageID *string `json:"virtualMachineImageId,omitempty"`
}

// ImageSourceRegistry details of the container image such as name, URL and credentials.
type ImageSourceRegistry struct {
	ServerURL   *string                     `json:"serverUrl,omitempty"`
	Image       *string                     `json:"image,omitempty"`
	Credentials *PrivateRegistryCredentials `json:"credentials,omitempty"`
}

// InputDirectory input directory for the job.
type InputDirectory struct {
	// ID - The path of the input directory will be available as a value of an environment variable with AZ_BATCHAI_INPUT_<id> name, where <id> is the value of id attribute.
	ID   *string `json:"id,omitempty"`
	Path *string `json:"path,omitempty"`
}

// Job contains information about a Job.
type Job struct {
	autorest.Response `json:"-"`
	// JobProperties - The properties associated with the Job.
	*JobProperties `json:"properties,omitempty"`
	// ID - The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	if j.ID != nil {
		objectMap["id"] = j.ID
	}
	if j.Name != nil {
		objectMap["name"] = j.Name
	}
	if j.Type != nil {
		objectMap["type"] = j.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		}
	}

	return nil
}

// JobBaseProperties the properties of a Batch AI Job.
type JobBaseProperties struct {
	// SchedulingPriority - Scheduling priority associated with the job. Possible values include: 'Low', 'Normal', 'High'
	SchedulingPriority JobPriority `json:"schedulingPriority,omitempty"`
	Cluster            *ResourceID `json:"cluster,omitempty"`
	// MountVolumes - These volumes will be mounted before the job execution and will be unmouted after the job completion. The volumes will be mounted at location specified by $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
	MountVolumes *MountVolumes `json:"mountVolumes,omitempty"`
	// NodeCount - The job will be gang scheduled on that many compute nodes
	NodeCount *int32 `json:"nodeCount,omitempty"`
	// ContainerSettings - If the container was downloaded as part of cluster setup then the same container image will be used. If not provided, the job will run on the VM.
	ContainerSettings     *ContainerSettings     `json:"containerSettings,omitempty"`
	CntkSettings          *CNTKsettings          `json:"cntkSettings,omitempty"`
	PyTorchSettings       *PyTorchSettings       `json:"pyTorchSettings,omitempty"`
	TensorFlowSettings    *TensorFlowSettings    `json:"tensorFlowSettings,omitempty"`
	CaffeSettings         *CaffeSettings         `json:"caffeSettings,omitempty"`
	Caffe2Settings        *Caffe2Settings        `json:"caffe2Settings,omitempty"`
	ChainerSettings       *ChainerSettings       `json:"chainerSettings,omitempty"`
	CustomToolkitSettings *CustomToolkitSettings `json:"customToolkitSettings,omitempty"`
	CustomMpiSettings     *CustomMpiSettings     `json:"customMpiSettings,omitempty"`
	HorovodSettings       *HorovodSettings       `json:"horovodSettings,omitempty"`
	// JobPreparation - The specified actions will run on all the nodes that are part of the job
	JobPreparation *JobPreparation `json:"jobPreparation,omitempty"`
	// StdOutErrPathPrefix - The path where the Batch AI service will upload stdout and stderror of the job.
	StdOutErrPathPrefix *string            `json:"stdOutErrPathPrefix,omitempty"`
	InputDirectories    *[]InputDirectory  `json:"inputDirectories,omitempty"`
	OutputDirectories   *[]OutputDirectory `json:"outputDirectories,omitempty"`
	// EnvironmentVariables - Batch AI will setup these additional environment variables for the job.
	EnvironmentVariables *[]EnvironmentVariable `json:"environmentVariables,omitempty"`
	// Secrets - Batch AI will setup these additional environment variables for the job. Server will never report values of these variables back.
	Secrets *[]EnvironmentVariableWithSecretValue `json:"secrets,omitempty"`
	// Constraints - Constraints associated with the Job.
	Constraints *JobBasePropertiesConstraints `json:"constraints,omitempty"`
}

// JobBasePropertiesConstraints constraints associated with the Job.
type JobBasePropertiesConstraints struct {
	// MaxWallClockTime - Default Value = 1 week.
	MaxWallClockTime *string `json:"maxWallClockTime,omitempty"`
}

// JobCreateParameters parameters supplied to the Create operation.
type JobCreateParameters struct {
	// JobBaseProperties - The properties of the Job.
	*JobBaseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCreateParameters.
func (jcp JobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jcp.JobBaseProperties != nil {
		objectMap["properties"] = jcp.JobBaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobCreateParameters struct.
func (jcp *JobCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobBaseProperties JobBaseProperties
				err = json.Unmarshal(*v, &jobBaseProperties)
				if err != nil {
					return err
				}
				jcp.JobBaseProperties = &jobBaseProperties
			}
		}
	}

	return nil
}

// JobListResult values returned by the List operation.
type JobListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of jobs.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobListResultIterator provides access to a complete listing of Job values.
type JobListResultIterator struct {
	i    int
	page JobListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobListResultIterator) Response() JobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListResultIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (jlr JobListResult) IsEmpty() bool {
	return jlr.Value == nil || len(*jlr.Value) == 0
}

// jobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jlr JobListResult) jobListResultPreparer() (*http.Request, error) {
	if jlr.NextLink == nil || len(to.String(jlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jlr.NextLink)))
}

// JobListResultPage contains a page of Job values.
type JobListResultPage struct {
	fn  func(JobListResult) (JobListResult, error)
	jlr JobListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListResultPage) Next() error {
	next, err := page.fn(page.jlr)
	if err != nil {
		return err
	}
	page.jlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListResultPage) NotDone() bool {
	return !page.jlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobListResultPage) Response() JobListResult {
	return page.jlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListResultPage) Values() []Job {
	if page.jlr.IsEmpty() {
		return nil
	}
	return *page.jlr.Value
}

// JobPreparation specifies the settings for job preparation.
type JobPreparation struct {
	// CommandLine - If containerSettings is specified on the job, this commandLine will be executed in the same container as job. Otherwise it will be executed on the node.
	CommandLine *string `json:"commandLine,omitempty"`
}

// JobProperties job specific properties.
type JobProperties struct {
	// Priority - Priority associated with the job. Possible values include: 'Low', 'Normal', 'High'
	Priority JobPriority `json:"priority,omitempty"`
	Cluster  *ResourceID `json:"cluster,omitempty"`
	// MountVolumes - These volumes will be mounted before the job execution and will be unmouted after the job completion. The volumes will be mounted at location specified by $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
	MountVolumes *MountVolumes `json:"mountVolumes,omitempty"`
	// JobOutputDirectoryPathSegment - Batch AI creates job's output directories under an unique path to avoid conflicts between jobs. This value contains a path segment generated by Batch AI to make the path unique and can be used to find the output directory on the node or mounted filesystem.
	JobOutputDirectoryPathSegment *string `json:"jobOutputDirectoryPathSegment,omitempty"`
	// NodeCount - The job will be gang scheduled on that many compute nodes
	NodeCount *int32 `json:"nodeCount,omitempty"`
	// ContainerSettings - If the container was downloaded as part of cluster setup then the same container image will be used. If not provided, the job will run on the VM.
	ContainerSettings *ContainerSettings `json:"containerSettings,omitempty"`
	// ToolType - Possible values are: cntk, tensorflow, caffe, caffe2, chainer, pytorch, custom, mpi, horovod. Possible values include: 'Cntk', 'Tensorflow', 'Caffe', 'Caffe2', 'Chainer', 'Horovod', 'Mpi', 'Custom'
	ToolType              ToolType               `json:"toolType,omitempty"`
	CntkSettings          *CNTKsettings          `json:"cntkSettings,omitempty"`
	PyTorchSettings       *PyTorchSettings       `json:"pyTorchSettings,omitempty"`
	TensorFlowSettings    *TensorFlowSettings    `json:"tensorFlowSettings,omitempty"`
	CaffeSettings         *CaffeSettings         `json:"caffeSettings,omitempty"`
	ChainerSettings       *ChainerSettings       `json:"chainerSettings,omitempty"`
	CustomToolkitSettings *CustomToolkitSettings `json:"customToolkitSettings,omitempty"`
	CustomMpiSettings     *CustomMpiSettings     `json:"customMpiSettings,omitempty"`
	HorovodSettings       *HorovodSettings       `json:"horovodSettings,omitempty"`
	// JobPreparation - The specified actions will run on all the nodes that are part of the job
	JobPreparation *JobPreparation `json:"jobPreparation,omitempty"`
	// StdOutErrPathPrefix - The path where the Batch AI service will upload stdout and stderror of the job.
	StdOutErrPathPrefix *string            `json:"stdOutErrPathPrefix,omitempty"`
	InputDirectories    *[]InputDirectory  `json:"inputDirectories,omitempty"`
	OutputDirectories   *[]OutputDirectory `json:"outputDirectories,omitempty"`
	// EnvironmentVariables - Batch AI will setup these additional environment variables for the job.
	EnvironmentVariables *[]EnvironmentVariable `json:"environmentVariables,omitempty"`
	// Secrets - Batch AI will setup these additional environment variables for the job. Server will never report values of these variables back.
	Secrets *[]EnvironmentVariableWithSecretValue `json:"secrets,omitempty"`
	// Constraints - Constraints associated with the Job.
	Constraints *JobPropertiesConstraints `json:"constraints,omitempty"`
	// CreationTime - The creation time of the job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - The provisioned state of the Batch AI job. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningStateTransitionTime - The time at which the job entered its current provisioning state.
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
	// ExecutionState - The current state of the job. Possible values are: queued - The job is queued and able to run. A job enters this state when it is created, or when it is awaiting a retry after a failed run. running - The job is running on a compute cluster. This includes job-level preparation such as downloading resource files or set up container specified on the job - it does not necessarily mean that the job command line has started executing. terminating - The job is terminated by the user, the terminate operation is in progress. succeeded - The job has completed running succesfully and exited with exit code 0. failed - The job has finished unsuccessfully (failed with a non-zero exit code) and has exhausted its retry limit. A job is also marked as failed if an error occurred launching the job. Possible values include: 'Queued', 'Running', 'Terminating', 'Succeeded', 'Failed'
	ExecutionState ExecutionState `json:"executionState,omitempty"`
	// ExecutionStateTransitionTime - The time at which the job entered its current execution state.
	ExecutionStateTransitionTime *date.Time `json:"executionStateTransitionTime,omitempty"`
	// ExecutionInfo - Contains information about the execution of a job in the Azure Batch service.
	ExecutionInfo *JobPropertiesExecutionInfo `json:"executionInfo,omitempty"`
}

// JobPropertiesConstraints constraints associated with the Job.
type JobPropertiesConstraints struct {
	// MaxWallClockTime - Default Value = 1 week.
	MaxWallClockTime *string `json:"maxWallClockTime,omitempty"`
}

// JobPropertiesExecutionInfo contains information about the execution of a job in the Azure Batch service.
type JobPropertiesExecutionInfo struct {
	// StartTime - 'Running' corresponds to the running state. If the job has been restarted or retried, this is the most recent time at which the job started running. This property is present only for job that are in the running or completed state.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - This property is only returned if the job is in completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExitCode - This property is only returned if the job is in completed state.
	ExitCode *int32   `json:"exitCode,omitempty"`
	Errors   *[]Error `json:"errors,omitempty"`
}

// JobsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsCreateFuture) Result(client JobsClient) (j Job, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("batchai.JobsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if j.Response.Response, err = future.GetResult(sender); err == nil && j.Response.Response.StatusCode != http.StatusNoContent {
		j, err = client.CreateResponder(j.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batchai.JobsCreateFuture", "Result", j.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsDeleteFuture) Result(client JobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("batchai.JobsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// JobsTerminateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsTerminateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsTerminateFuture) Result(client JobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsTerminateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("batchai.JobsTerminateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// KeyVaultSecretReference describes a reference to Key Vault Secret.
type KeyVaultSecretReference struct {
	SourceVault *ResourceID `json:"sourceVault,omitempty"`
	SecretURL   *string     `json:"secretUrl,omitempty"`
}

// ListUsagesResult the List Usages operation response.
type ListUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - The list of compute resource usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of compute resource usage information. Call ListNext() with this to fetch the next page of compute resource usage information.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListUsagesResultIterator provides access to a complete listing of Usage values.
type ListUsagesResultIterator struct {
	i    int
	page ListUsagesResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListUsagesResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListUsagesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListUsagesResultIterator) Response() ListUsagesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListUsagesResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lur ListUsagesResult) IsEmpty() bool {
	return lur.Value == nil || len(*lur.Value) == 0
}

// listUsagesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lur ListUsagesResult) listUsagesResultPreparer() (*http.Request, error) {
	if lur.NextLink == nil || len(to.String(lur.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lur.NextLink)))
}

// ListUsagesResultPage contains a page of Usage values.
type ListUsagesResultPage struct {
	fn  func(ListUsagesResult) (ListUsagesResult, error)
	lur ListUsagesResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListUsagesResultPage) Next() error {
	next, err := page.fn(page.lur)
	if err != nil {
		return err
	}
	page.lur = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListUsagesResultPage) NotDone() bool {
	return !page.lur.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListUsagesResultPage) Response() ListUsagesResult {
	return page.lur
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListUsagesResultPage) Values() []Usage {
	if page.lur.IsEmpty() {
		return nil
	}
	return *page.lur.Value
}

// ManualScaleSettings manual scale settings for the cluster.
type ManualScaleSettings struct {
	// TargetNodeCount - Default is 0. If autoScaleSettings are not specified, then the Cluster starts with this target.
	TargetNodeCount *int32 `json:"targetNodeCount,omitempty"`
	// NodeDeallocationOption - The default value is requeue. Possible values include: 'Requeue', 'Terminate', 'Waitforjobcompletion'
	NodeDeallocationOption DeallocationOption `json:"nodeDeallocationOption,omitempty"`
}

// MountSettings details of the File Server.
type MountSettings struct {
	MountPoint           *string `json:"mountPoint,omitempty"`
	FileServerPublicIP   *string `json:"fileServerPublicIP,omitempty"`
	FileServerInternalIP *string `json:"fileServerInternalIP,omitempty"`
}

// MountVolumes details of volumes to mount on the cluster.
type MountVolumes struct {
	// AzureFileShares - References to Azure File Shares that are to be mounted to the cluster nodes.
	AzureFileShares *[]AzureFileShareReference `json:"azureFileShares,omitempty"`
	// AzureBlobFileSystems - References to Azure Blob FUSE that are to be mounted to the cluster nodes.
	AzureBlobFileSystems *[]AzureBlobFileSystemReference `json:"azureBlobFileSystems,omitempty"`
	FileServers          *[]FileServerReference          `json:"fileServers,omitempty"`
	UnmanagedFileSystems *[]UnmanagedFileSystemReference `json:"unmanagedFileSystems,omitempty"`
}

// NameValuePair represents a name-value pair.
type NameValuePair struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// NodeSetup use this to prepare the VM. NOTE: The volumes specified in mountVolumes are mounted first and then the
// setupTask is run. Therefore the setup task can use local mountPaths in its execution.
type NodeSetup struct {
	SetupTask *SetupTask `json:"setupTask,omitempty"`
	// MountVolumes - Specified mount volumes will be available to all jobs executing on the cluster. The volumes will be mounted at location specified by $AZ_BATCHAI_MOUNT_ROOT environment variable.
	MountVolumes                *MountVolumes                `json:"mountVolumes,omitempty"`
	PerformanceCountersSettings *PerformanceCountersSettings `json:"performanceCountersSettings,omitempty"`
}

// NodeStateCounts counts of various compute node states on the cluster.
type NodeStateCounts struct {
	IdleNodeCount      *int32 `json:"idleNodeCount,omitempty"`
	RunningNodeCount   *int32 `json:"runningNodeCount,omitempty"`
	PreparingNodeCount *int32 `json:"preparingNodeCount,omitempty"`
	UnusableNodeCount  *int32 `json:"unusableNodeCount,omitempty"`
	LeavingNodeCount   *int32 `json:"leavingNodeCount,omitempty"`
}

// Operation details of a REST API operation
type Operation struct {
	// Name - This is of the format {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that describes the operation.
	Display    *OperationDisplay `json:"display,omitempty"`
	Origin     *string           `json:"origin,omitempty"`
	Properties interface{}       `json:"properties,omitempty"`
}

// OperationDisplay the object that describes the operation.
type OperationDisplay struct {
	Provider *string `json:"provider,omitempty"`
	// Operation - For example: read, write, delete, or listKeys/action
	Operation   *string `json:"operation,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationListResult contains the list of all operations supported by BatchAI resource provider
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// OutputDirectory output directory for the job.
type OutputDirectory struct {
	// ID - The path of the output directory will be available as a value of an environment variable with AZ_BATCHAI_OUTPUT_<id> name, where <id> is the value of id attribute.
	ID *string `json:"id,omitempty"`
	// PathPrefix - NOTE: This is an absolute path to prefix. E.g. $AZ_BATCHAI_MOUNT_ROOT/MyNFS/MyLogs. You can find the full path to the output directory by combining pathPrefix, jobOutputDirectoryPathSegment (reported by get job) and pathSuffix.
	PathPrefix *string `json:"pathPrefix,omitempty"`
	// PathSuffix - The suffix path where the output directory will be created. E.g. models. You can find the full path to the output directory by combining pathPrefix, jobOutputDirectoryPathSegment (reported by get job) and pathSuffix.
	PathSuffix *string `json:"pathSuffix,omitempty"`
}

// PerformanceCountersSettings performance counters reporting settings.
type PerformanceCountersSettings struct {
	// AppInsightsReference - If provided, Batch AI will upload node performance counters to the corresponding Azure Application Insights account.
	AppInsightsReference *AppInsightsReference `json:"appInsightsReference,omitempty"`
}

// PrivateRegistryCredentials credentials to access a container image in a private repository.
type PrivateRegistryCredentials struct {
	Username *string `json:"username,omitempty"`
	// Password - One of password or passwordSecretReference must be specified.
	Password *string `json:"password,omitempty"`
	// PasswordSecretReference - Users can store their secrets in Azure KeyVault and pass it to the Batch AI Service to integrate with KeyVault. One of password or passwordSecretReference must be specified.
	PasswordSecretReference *KeyVaultSecretReference `json:"passwordSecretReference,omitempty"`
}

// ProxyResource a definition of an Azure proxy resource.
type ProxyResource struct {
	// ID - The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// PyTorchSettings specifies the settings for pyTorch job.
type PyTorchSettings struct {
	PythonScriptFilePath  *string `json:"pythonScriptFilePath,omitempty"`
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	CommandLineArgs       *string `json:"commandLineArgs,omitempty"`
	// ProcessCount - The default value for this property is equal to nodeCount property.
	ProcessCount *int32 `json:"processCount,omitempty"`
	// CommunicationBackend - Valid values are 'TCP', 'Gloo' or 'MPI'. Not required for non-distributed jobs.
	CommunicationBackend *string `json:"communicationBackend,omitempty"`
}

// RemoteLoginInformation contains remote login details to SSH/RDP to a compute node in cluster.
type RemoteLoginInformation struct {
	// NodeID - Id of the compute node
	NodeID *string `json:"nodeId,omitempty"`
	// IPAddress - ip address
	IPAddress *string  `json:"ipAddress,omitempty"`
	Port      *float64 `json:"port,omitempty"`
}

// RemoteLoginInformationListResult values returned by the List operation.
type RemoteLoginInformationListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of returned remote login details.
	Value *[]RemoteLoginInformation `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// RemoteLoginInformationListResultIterator provides access to a complete listing of RemoteLoginInformation values.
type RemoteLoginInformationListResultIterator struct {
	i    int
	page RemoteLoginInformationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RemoteLoginInformationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RemoteLoginInformationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RemoteLoginInformationListResultIterator) Response() RemoteLoginInformationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RemoteLoginInformationListResultIterator) Value() RemoteLoginInformation {
	if !iter.page.NotDone() {
		return RemoteLoginInformation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rlilr RemoteLoginInformationListResult) IsEmpty() bool {
	return rlilr.Value == nil || len(*rlilr.Value) == 0
}

// remoteLoginInformationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlilr RemoteLoginInformationListResult) remoteLoginInformationListResultPreparer() (*http.Request, error) {
	if rlilr.NextLink == nil || len(to.String(rlilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlilr.NextLink)))
}

// RemoteLoginInformationListResultPage contains a page of RemoteLoginInformation values.
type RemoteLoginInformationListResultPage struct {
	fn    func(RemoteLoginInformationListResult) (RemoteLoginInformationListResult, error)
	rlilr RemoteLoginInformationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RemoteLoginInformationListResultPage) Next() error {
	next, err := page.fn(page.rlilr)
	if err != nil {
		return err
	}
	page.rlilr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RemoteLoginInformationListResultPage) NotDone() bool {
	return !page.rlilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RemoteLoginInformationListResultPage) Response() RemoteLoginInformationListResult {
	return page.rlilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RemoteLoginInformationListResultPage) Values() []RemoteLoginInformation {
	if page.rlilr.IsEmpty() {
		return nil
	}
	return *page.rlilr.Value
}

// Resource a definition of an Azure resource.
type Resource struct {
	// ID - The ID of the resource
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceID represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
type ResourceID struct {
	// ID - The ID of the resource
	ID *string `json:"id,omitempty"`
}

// ScaleSettings at least one of manual or autoScale settings must be specified. Only one of manual or autoScale
// settings can be specified. If autoScale settings are specified, the system automatically scales the cluster up
// and down (within the supplied limits) based on the pending jobs on the cluster.
type ScaleSettings struct {
	Manual    *ManualScaleSettings `json:"manual,omitempty"`
	AutoScale *AutoScaleSettings   `json:"autoScale,omitempty"`
}

// SetupTask specifies a setup task which can be used to customize the compute nodes of the cluster.
type SetupTask struct {
	// CommandLine - Command line to be executed on each cluster's node after it being allocated or rebooted. The command is executed in a bash subshell as a root.
	CommandLine          *string                `json:"commandLine,omitempty"`
	EnvironmentVariables *[]EnvironmentVariable `json:"environmentVariables,omitempty"`
	// Secrets - Server will never report values of these variables back.
	Secrets *[]EnvironmentVariableWithSecretValue `json:"secrets,omitempty"`
	// StdOutErrPathPrefix - The prefix of a path where the Batch AI service will upload the stdout and stderr of the setup task.
	StdOutErrPathPrefix *string `json:"stdOutErrPathPrefix,omitempty"`
	// StdOutErrPathSuffix - Batch AI creates the setup task output directories under an unique path to avoid conflicts between different clusters. You can concatinate stdOutErrPathPrefix and stdOutErrPathSuffix to get the full path to the output directory.
	StdOutErrPathSuffix *string `json:"stdOutErrPathSuffix,omitempty"`
}

// SSHConfiguration SSH configuration settings for the VM
type SSHConfiguration struct {
	// PublicIPsToAllow - Default value is '*' can be used to match all source IPs. Maximum number of IP ranges that can be specified are 400.
	PublicIPsToAllow    *[]string            `json:"publicIPsToAllow,omitempty"`
	UserAccountSettings *UserAccountSettings `json:"userAccountSettings,omitempty"`
}

// TensorFlowSettings specifies the settings for TensorFlow job.
type TensorFlowSettings struct {
	PythonScriptFilePath  *string `json:"pythonScriptFilePath,omitempty"`
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	MasterCommandLineArgs *string `json:"masterCommandLineArgs,omitempty"`
	// WorkerCommandLineArgs - This property is optional for single machine training.
	WorkerCommandLineArgs *string `json:"workerCommandLineArgs,omitempty"`
	// ParameterServerCommandLineArgs - This property is optional for single machine training.
	ParameterServerCommandLineArgs *string `json:"parameterServerCommandLineArgs,omitempty"`
	// WorkerCount - If specified, the value must be less than or equal to (nodeCount * numberOfGPUs per VM). If not specified, the default value is equal to nodeCount. This property can be specified only for distributed TensorFlow training
	WorkerCount *int32 `json:"workerCount,omitempty"`
	// ParameterServerCount - If specified, the value must be less than or equal to nodeCount. If not specified, the default value is equal to 1 for distributed TensorFlow training (This property is not applicable for single machine training). This property can be specified only for distributed TensorFlow training.
	ParameterServerCount *int32 `json:"parameterServerCount,omitempty"`
}

// UnmanagedFileSystemReference details of the file system to mount on the compute cluster nodes.
type UnmanagedFileSystemReference struct {
	MountCommand *string `json:"mountCommand,omitempty"`
	// RelativeMountPath - Note that all cluster level unmanaged file system will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and job level unmanaged file system will be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
}

// Usage describes Batch AI Resource Usage.
type Usage struct {
	// Unit - An enum describing the unit of usage measurement. Possible values include: 'Count'
	Unit UsageUnit `json:"unit,omitempty"`
	// CurrentValue - The current usage of the resource.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - The maximum permitted usage of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Name - The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// UsageName the Usage Names.
type UsageName struct {
	// Value - The name of the resource.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UserAccountSettings settings for user account that gets created on each on the nodes of a cluster.
type UserAccountSettings struct {
	AdminUserName         *string `json:"adminUserName,omitempty"`
	AdminUserSSHPublicKey *string `json:"adminUserSshPublicKey,omitempty"`
	AdminUserPassword     *string `json:"adminUserPassword,omitempty"`
}

// VirtualMachineConfiguration settings for OS image.
type VirtualMachineConfiguration struct {
	ImageReference *ImageReference `json:"imageReference,omitempty"`
}

// Workspace describes Batch AI Workspace.
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - The properties associated with the workspace.
	*WorkspaceProperties `json:"properties,omitempty"`
	// ID - The ID of the resource
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.ID != nil {
		objectMap["id"] = w.ID
	}
	if w.Name != nil {
		objectMap["name"] = w.Name
	}
	if w.Type != nil {
		objectMap["type"] = w.Type
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		}
	}

	return nil
}

// WorkspaceCreateParameters parameters supplied to the Create operation.
type WorkspaceCreateParameters struct {
	// Location - The region in which to create the Workspace.
	Location *string `json:"location,omitempty"`
	// Tags - The user specified tags associated with the Workspace.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WorkspaceCreateParameters.
func (wcp WorkspaceCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wcp.Location != nil {
		objectMap["location"] = wcp.Location
	}
	if wcp.Tags != nil {
		objectMap["tags"] = wcp.Tags
	}
	return json.Marshal(objectMap)
}

// WorkspaceListResult values returned by the List operation.
type WorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of workspaces.
	Value *[]Workspace `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkspaceListResultIterator provides access to a complete listing of Workspace values.
type WorkspaceListResultIterator struct {
	i    int
	page WorkspaceListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceListResultIterator) Response() WorkspaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceListResultIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WorkspaceListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// workspaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WorkspaceListResult) workspaceListResultPreparer() (*http.Request, error) {
	if wlr.NextLink == nil || len(to.String(wlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WorkspaceListResultPage contains a page of Workspace values.
type WorkspaceListResultPage struct {
	fn  func(WorkspaceListResult) (WorkspaceListResult, error)
	wlr WorkspaceListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceListResultPage) Next() error {
	next, err := page.fn(page.wlr)
	if err != nil {
		return err
	}
	page.wlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceListResultPage) Response() WorkspaceListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceListResultPage) Values() []Workspace {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// WorkspaceProperties workspace specific properties.
type WorkspaceProperties struct {
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - The provisioned state of the workspace. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningStateTransitionTime - The time at which the workspace entered its current provisioning state.
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
}

// WorkspacesCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type WorkspacesCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkspacesCreateFuture) Result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.WorkspacesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("batchai.WorkspacesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batchai.WorkspacesCreateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type WorkspacesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkspacesDeleteFuture) Result(client WorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.WorkspacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("batchai.WorkspacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}
