/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ditaa.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.stathissideris.ditaa.core.ConversionOptions;
import org.stathissideris.ditaa.core.Pair;
import org.stathissideris.ditaa.graphics.BitmapRenderer;
import org.stathissideris.ditaa.graphics.CompositeDiagramShape;
import org.stathissideris.ditaa.graphics.CustomShapeDefinition;
import org.stathissideris.ditaa.graphics.DiagramComponent;
import org.stathissideris.ditaa.graphics.DiagramShape;
import org.stathissideris.ditaa.graphics.DiagramText;
import org.stathissideris.ditaa.graphics.FontMeasurer;
import org.stathissideris.ditaa.graphics.ShapeEdge;
import org.stathissideris.ditaa.graphics.ShapePoint;
import org.stathissideris.ditaa.text.AbstractionGrid;
import org.stathissideris.ditaa.text.CellSet;
import org.stathissideris.ditaa.text.TextGrid;

public class Diagram {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VERBOSE = false;
    private static final boolean DEBUG_MAKE_SHAPES = false;
    private ArrayList<DiagramShape> shapes = new ArrayList();
    private ArrayList<CompositeDiagramShape> compositeShapes = new ArrayList();
    private ArrayList<DiagramText> textObjects = new ArrayList();
    private int width;
    private int height;
    private int cellWidth;
    private int cellHeight;

    public Diagram(TextGrid grid, ConversionOptions options) {
        DiagramShape containingShape;
        ShapePoint point;
        DiagramComponent shape;
        boolean bl;
        this.cellWidth = options.renderingOptions.getCellWidth();
        this.cellHeight = options.renderingOptions.getCellHeight();
        FontMeasurer fontMeasurer = new FontMeasurer(options.renderingOptions.getFont(), options.renderingOptions.isFixedFontSize());
        this.width = grid.getWidth() * this.cellWidth;
        this.height = grid.getHeight() * this.cellHeight;
        TextGrid workGrid = new TextGrid(grid);
        workGrid.replaceTypeOnLine();
        workGrid.replacePointMarkersOnLine();
        int width = grid.getWidth();
        int height = grid.getHeight();
        AbstractionGrid temp = new AbstractionGrid(workGrid, workGrid.getAllBoundaries());
        ArrayList<CellSet> boundarySetsStep1 = temp.getDistinctShapes();
        ArrayList<CellSet> boundarySetsStep2 = new ArrayList<CellSet>();
        for (CellSet set : boundarySetsStep1) {
            TextGrid fillBuffer = new TextGrid(width * 3, height * 3);
            for (int yi = 0; yi < height * 3; ++yi) {
                for (int xi = 0; xi < width * 3; ++xi) {
                    TextGrid textGrid;
                    CellSet cellSet;
                    if (!fillBuffer.isBlank(xi, yi) || (cellSet = (textGrid = new AbstractionGrid(workGrid, set).getCopyOfInternalBuffer()).findBoundariesExpandingFrom(new TextGrid.Cell(xi, yi))).size() == 0) continue;
                    boundarySetsStep2.add(cellSet.makeScaledOneThirdEquivalent());
                    TextGrid textGrid2 = new AbstractionGrid(workGrid, set).getCopyOfInternalBuffer();
                    CellSet filled = textGrid2.fillContinuousArea(new TextGrid.Cell(xi, yi), '*');
                    fillBuffer.fillCellsWith(filled, '*');
                    fillBuffer.fillCellsWith(cellSet, '-');
                }
            }
        }
        boundarySetsStep2 = CellSet.removeDuplicateSets(boundarySetsStep2);
        int originalSize = boundarySetsStep2.size();
        boundarySetsStep2 = CellSet.removeDuplicateSets(boundarySetsStep2);
        ArrayList<CellSet> open = new ArrayList<CellSet>();
        ArrayList<CellSet> closed = new ArrayList<CellSet>();
        ArrayList<CellSet> mixed = new ArrayList<CellSet>();
        for (CellSet cellSet : boundarySetsStep2) {
            int n = cellSet.getType(workGrid);
            if (n == 0) {
                closed.add(cellSet);
                continue;
            }
            if (n == 1) {
                open.add(cellSet);
                continue;
            }
            if (n != 2) continue;
            mixed.add(cellSet);
        }
        boolean hadToEliminateMixed = false;
        if (mixed.size() > 0 && closed.size() > 0) {
            hadToEliminateMixed = true;
            for (CellSet cellSet : mixed) {
                for (CellSet cellSet2 : closed) {
                    cellSet.subtractSet(cellSet2);
                }
                if (cellSet.getType(workGrid) != 1) continue;
                boundarySetsStep2.remove(cellSet);
                boundarySetsStep2.addAll(cellSet.breakIntoDistinctBoundaries(workGrid));
            }
        } else if (mixed.size() > 0 && closed.size() == 0) {
            hadToEliminateMixed = true;
            for (CellSet cellSet : mixed) {
                boundarySetsStep2.remove(cellSet);
                boundarySetsStep2.addAll(cellSet.breakTrulyMixedBoundaries(workGrid));
            }
        }
        if (hadToEliminateMixed) {
            open = new ArrayList();
            closed = new ArrayList();
            mixed = new ArrayList();
            for (CellSet cellSet : boundarySetsStep2) {
                int type = cellSet.getType(workGrid);
                if (type == 0) {
                    closed.add(cellSet);
                    continue;
                }
                if (type == 1) {
                    open.add(cellSet);
                    continue;
                }
                if (type != 2) continue;
                mixed.add(cellSet);
            }
        }
        this.removeObsoleteShapes(workGrid, closed);
        boolean bl2 = false;
        if (options.processingOptions.areAllCornersRound()) {
            bl = true;
        }
        ArrayList<DiagramShape> arrayList = new ArrayList<DiagramShape>();
        for (CellSet cellSet : closed) {
            shape = DiagramComponent.createClosedFromBoundaryCells(workGrid, cellSet, this.cellWidth, this.cellHeight, bl);
            if (shape == null) continue;
            this.addToShapes((DiagramShape)shape);
            arrayList.add((DiagramShape)shape);
        }
        if (options.processingOptions.performSeparationOfCommonEdges()) {
            this.separateCommonEdges(arrayList);
        }
        for (CellSet cellSet : open) {
            if (cellSet.size() == 1) {
                DiagramShape shape2;
                TextGrid.Cell cell = cellSet.getFirst();
                if (grid.cellContainsDashedLineChar(cell) || (shape2 = DiagramShape.createSmallLine(workGrid, cell, this.cellWidth, this.cellHeight)) == null) continue;
                this.addToShapes(shape2);
                shape2.connectEndsToAnchors(workGrid, this);
                continue;
            }
            shape = CompositeDiagramShape.createOpenFromBoundaryCells(workGrid, cellSet, this.cellWidth, this.cellHeight, bl);
            if (shape == null) continue;
            if (shape instanceof CompositeDiagramShape) {
                this.addToCompositeShapes((CompositeDiagramShape)shape);
                ((CompositeDiagramShape)shape).connectEndsToAnchors(workGrid, this);
                continue;
            }
            if (!(shape instanceof DiagramShape)) continue;
            this.addToShapes((DiagramShape)shape);
            ((DiagramShape)shape).connectEndsToAnchors(workGrid, this);
            ((DiagramShape)shape).moveEndsToCellEdges(grid, this);
        }
        for (TextGrid.CellColorPair cellColorPair : grid.findColorCodes()) {
            point = new ShapePoint(this.getCellMidX(cellColorPair.cell), this.getCellMidY(cellColorPair.cell));
            containingShape = this.findSmallestShapeContaining(point);
            if (containingShape == null) continue;
            containingShape.setFillColor(cellColorPair.color);
        }
        for (TextGrid.CellTagPair cellTagPair : grid.findMarkupTags()) {
            CustomShapeDefinition def;
            point = new ShapePoint(this.getCellMidX(cellTagPair.cell), this.getCellMidY(cellTagPair.cell));
            containingShape = this.findSmallestShapeContaining(point);
            if (containingShape == null) continue;
            if (cellTagPair.tag.equals("d")) {
                def = options.processingOptions.getFromCustomShapes("d");
                if (def == null) {
                    containingShape.setType(3);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (cellTagPair.tag.equals("s")) {
                def = options.processingOptions.getFromCustomShapes("s");
                if (def == null) {
                    containingShape.setType(4);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (cellTagPair.tag.equals("io")) {
                def = options.processingOptions.getFromCustomShapes("io");
                if (def == null) {
                    containingShape.setType(5);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (cellTagPair.tag.equals("c")) {
                def = options.processingOptions.getFromCustomShapes("c");
                if (def == null) {
                    containingShape.setType(6);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (cellTagPair.tag.equals("mo")) {
                def = options.processingOptions.getFromCustomShapes("mo");
                if (def == null) {
                    containingShape.setType(7);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (cellTagPair.tag.equals("tr")) {
                def = options.processingOptions.getFromCustomShapes("tr");
                if (def == null) {
                    containingShape.setType(8);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            if (cellTagPair.tag.equals("o")) {
                def = options.processingOptions.getFromCustomShapes("o");
                if (def == null) {
                    containingShape.setType(9);
                    continue;
                }
                containingShape.setType(9999);
                containingShape.setDefinition(def);
                continue;
            }
            def = options.processingOptions.getFromCustomShapes(cellTagPair.tag);
            containingShape.setType(9999);
            containingShape.setDefinition(def);
        }
        for (TextGrid.Cell cell : workGrid.findArrowheads()) {
            DiagramShape arrowhead = DiagramShape.createArrowhead(workGrid, cell, this.cellWidth, this.cellHeight);
            if (arrowhead != null) {
                this.addToShapes(arrowhead);
                continue;
            }
            System.err.println("Could not create arrowhead shape. Unexpected error.");
        }
        for (TextGrid.Cell cell : grid.getPointMarkersOnLine()) {
            DiagramShape mark = new DiagramShape();
            mark.addToPoints(new ShapePoint(this.getCellMidX(cell), this.getCellMidY(cell)));
            mark.setType(2);
            mark.setFillColor(Color.white);
            this.shapes.add(mark);
        }
        this.removeDuplicateShapes();
        workGrid = new TextGrid(grid);
        workGrid.removeNonText();
        TextGrid textGroupGrid = new TextGrid(workGrid);
        CellSet cellSet = textGroupGrid.getAllBlanksBetweenCharacters();
        textGroupGrid.fillCellsWith(cellSet, '|');
        CellSet nonBlank = textGroupGrid.getAllNonBlank();
        ArrayList<CellSet> textGroups = nonBlank.breakIntoDistinctBoundaries();
        Font font = fontMeasurer.getFontFor(this.cellHeight);
        for (CellSet textGroupCellSet : textGroups) {
            TextGrid isolationGrid = new TextGrid(width, height);
            workGrid.copyCellsTo(textGroupCellSet, isolationGrid);
            ArrayList<TextGrid.CellStringPair> strings = isolationGrid.findStrings();
            for (TextGrid.CellStringPair pair : strings) {
                DiagramText textObject;
                TextGrid.Cell cell = pair.cell;
                String string = pair.string;
                TextGrid.Cell lastCell = new TextGrid.Cell(cell.x + string.length() - 1, cell.y);
                int minX = this.getCellMinX(cell);
                int y = this.getCellMaxY(cell);
                int maxX = this.getCellMaxX(lastCell);
                if (fontMeasurer.getWidthFor(string, font) > maxX - minX) {
                    Font lessWideFont = fontMeasurer.getFontFor(maxX - minX, string);
                    textObject = new DiagramText(minX, y, string, lessWideFont, fontMeasurer);
                } else {
                    textObject = new DiagramText(minX, y, string, font, fontMeasurer);
                }
                textObject.centerVerticallyBetween(this.getCellMinY(cell), this.getCellMaxY(cell));
                int otherStart = isolationGrid.otherStringsStartInTheSameColumn(cell);
                int otherEnd = isolationGrid.otherStringsEndInTheSameColumn(lastCell);
                if (0 == otherStart && 0 == otherEnd) {
                    textObject.centerHorizontallyBetween(minX, maxX);
                } else if (otherEnd > 0 && otherStart == 0) {
                    textObject.alignRightEdgeTo(maxX);
                } else if (otherEnd > 0 && otherStart > 0) {
                    if (otherEnd > otherStart) {
                        textObject.alignRightEdgeTo(maxX);
                    } else if (otherEnd == otherStart) {
                        textObject.centerHorizontallyBetween(minX, maxX);
                    }
                }
                this.addToTextObjects(textObject);
            }
        }
        for (DiagramText textObject : this.getTextObjects()) {
            DiagramShape shape3 = this.findSmallestShapeIntersecting(textObject.getBounds());
            if (shape3 == null || shape3.getFillColor() == null || !BitmapRenderer.isColorDark(shape3.getFillColor())) continue;
            textObject.setColor(Color.white);
        }
        for (DiagramShape shape4 : this.getAllDiagramShapes()) {
            if (shape4.getType() != 9999) continue;
            for (DiagramText textObject : this.getTextObjects()) {
                textObject.setHasOutline(true);
                textObject.setColor(DiagramText.DEFAULT_COLOR);
            }
        }
    }

    public ArrayList<DiagramShape> getAllDiagramShapes() {
        ArrayList<DiagramShape> shapes = new ArrayList<DiagramShape>();
        shapes.addAll(this.getShapes());
        for (CompositeDiagramShape compShape : this.getCompositeShapes()) {
            shapes.addAll(compShape.getShapes());
        }
        return shapes;
    }

    private boolean removeObsoleteShapes(TextGrid grid, ArrayList<CellSet> sets) {
        boolean removedAny = false;
        ArrayList<CellSet> filledSets = new ArrayList<CellSet>();
        for (CellSet set : sets) {
            if ((set = set.getFilledEquivalent(grid)) == null) {
                return false;
            }
            filledSets.add(set);
        }
        ArrayList<Integer> toBeRemovedIndices = new ArrayList<Integer>();
        for (CellSet set : filledSets) {
            ArrayList common = new ArrayList();
            common.add(set);
            for (CellSet set2 : filledSets) {
                if (set == set2 || !set.hasCommonCells(set2)) continue;
                common.add(set2);
            }
            if (common.size() == 2) continue;
            CellSet largest = set;
            Iterator it2 = common.iterator();
            while (it2.hasNext()) {
                CellSet set2 = (CellSet)it2.next();
                if (set2.size() <= largest.size()) continue;
                largest = set2;
            }
            common.remove(largest);
            TextGrid gridOfSmalls = new TextGrid(largest.getMaxX() + 2, largest.getMaxY() + 2);
            it2 = common.iterator();
            while (it2.hasNext()) {
                CellSet set2 = (CellSet)it2.next();
                gridOfSmalls.fillCellsWith(set2, '*');
            }
            TextGrid gridLargest = new TextGrid(largest.getMaxX() + 2, largest.getMaxY() + 2);
            gridLargest.fillCellsWith(largest, '*');
            int index = filledSets.indexOf(largest);
            if (!gridLargest.equals(gridOfSmalls) || toBeRemovedIndices.contains(index)) continue;
            toBeRemovedIndices.add(index);
        }
        ArrayList<CellSet> setsToBeRemoved = new ArrayList<CellSet>();
        for (Integer i : toBeRemovedIndices) {
            setsToBeRemoved.add(sets.get(i));
        }
        for (CellSet set : setsToBeRemoved) {
            removedAny = true;
            sets.remove(set);
        }
        return removedAny;
    }

    public float getMinimumOfCellDimension() {
        return Math.min(this.getCellWidth(), this.getCellHeight());
    }

    private void separateCommonEdges(ArrayList<DiagramShape> shapes) {
        float offset = this.getMinimumOfCellDimension() / 5.0f;
        ArrayList<ShapeEdge> edges = new ArrayList<ShapeEdge>();
        for (DiagramShape shape : shapes) {
            edges.addAll(shape.getEdges());
        }
        ArrayList<Pair<ShapeEdge, ShapeEdge>> listOfPairs = new ArrayList<Pair<ShapeEdge, ShapeEdge>>();
        int startIndex = 1;
        for (ShapeEdge edge1 : edges) {
            for (int i = startIndex; i < edges.size(); ++i) {
                ShapeEdge edge2 = (ShapeEdge)edges.get(i);
                if (!edge1.touchesWith(edge2)) continue;
                listOfPairs.add(new Pair<ShapeEdge, ShapeEdge>(edge1, edge2));
            }
            ++startIndex;
        }
        ArrayList<ShapeEdge> movedEdges = new ArrayList<ShapeEdge>();
        for (Pair pair : listOfPairs) {
            if (!movedEdges.contains(pair.first)) {
                ((ShapeEdge)pair.first).moveInwardsBy(offset);
                movedEdges.add((ShapeEdge)pair.first);
            }
            if (movedEdges.contains(pair.second)) continue;
            ((ShapeEdge)pair.second).moveInwardsBy(offset);
            movedEdges.add((ShapeEdge)pair.second);
        }
    }

    private void removeDuplicateShapes() {
        ArrayList<DiagramShape> originalShapes = new ArrayList<DiagramShape>();
        for (DiagramShape shape : this.getShapes()) {
            boolean isOriginal = true;
            for (Object e : originalShapes) {
                DiagramShape originalShape = (DiagramShape)e;
                if (!shape.equals(originalShape)) continue;
                isOriginal = false;
            }
            if (!isOriginal) continue;
            originalShapes.add(shape);
        }
        this.shapes.clear();
        this.shapes.addAll(originalShapes);
    }

    private DiagramShape findSmallestShapeContaining(ShapePoint point) {
        DiagramShape containingShape = null;
        for (DiagramShape shape : this.getShapes()) {
            if (!shape.contains(point)) continue;
            if (containingShape == null) {
                containingShape = shape;
                continue;
            }
            if (!shape.isSmallerThan(containingShape)) continue;
            containingShape = shape;
        }
        return containingShape;
    }

    private DiagramShape findSmallestShapeIntersecting(Rectangle2D rect) {
        DiagramShape intersectingShape = null;
        for (DiagramShape shape : this.getShapes()) {
            if (!shape.intersects(rect)) continue;
            if (intersectingShape == null) {
                intersectingShape = shape;
                continue;
            }
            if (!shape.isSmallerThan(intersectingShape)) continue;
            intersectingShape = shape;
        }
        return intersectingShape;
    }

    private void addToTextObjects(DiagramText shape) {
        this.textObjects.add(shape);
    }

    private void addToCompositeShapes(CompositeDiagramShape shape) {
        this.compositeShapes.add(shape);
    }

    private void addToShapes(DiagramShape shape) {
        this.shapes.add(shape);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public ArrayList<CompositeDiagramShape> getCompositeShapes() {
        return this.compositeShapes;
    }

    public ArrayList<DiagramShape> getShapes() {
        return this.shapes;
    }

    public int getCellMinX(TextGrid.Cell cell) {
        return Diagram.getCellMinX(cell, this.cellWidth);
    }

    public static int getCellMinX(TextGrid.Cell cell, int cellXSize) {
        return cell.x * cellXSize;
    }

    public int getCellMidX(TextGrid.Cell cell) {
        return Diagram.getCellMidX(cell, this.cellWidth);
    }

    public static int getCellMidX(TextGrid.Cell cell, int cellXSize) {
        return cell.x * cellXSize + cellXSize / 2;
    }

    public int getCellMaxX(TextGrid.Cell cell) {
        return Diagram.getCellMaxX(cell, this.cellWidth);
    }

    public static int getCellMaxX(TextGrid.Cell cell, int cellXSize) {
        return cell.x * cellXSize + cellXSize;
    }

    public int getCellMinY(TextGrid.Cell cell) {
        return Diagram.getCellMinY(cell, this.cellHeight);
    }

    public static int getCellMinY(TextGrid.Cell cell, int cellYSize) {
        return cell.y * cellYSize;
    }

    public int getCellMidY(TextGrid.Cell cell) {
        return Diagram.getCellMidY(cell, this.cellHeight);
    }

    public static int getCellMidY(TextGrid.Cell cell, int cellYSize) {
        return cell.y * cellYSize + cellYSize / 2;
    }

    public int getCellMaxY(TextGrid.Cell cell) {
        return Diagram.getCellMaxY(cell, this.cellHeight);
    }

    public static int getCellMaxY(TextGrid.Cell cell, int cellYSize) {
        return cell.y * cellYSize + cellYSize;
    }

    public TextGrid.Cell getCellFor(ShapePoint point) {
        if (point == null) {
            throw new IllegalArgumentException("ShapePoint cannot be null");
        }
        return new TextGrid.Cell((int)point.x / this.cellWidth, (int)point.y / this.cellHeight);
    }

    public ArrayList<DiagramText> getTextObjects() {
        return this.textObjects;
    }
}

