/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.asciidoctor.diagram.CommandProcessor;
import org.asciidoctor.diagram.DiagramGenerator;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.HTTPInputStream;
import org.asciidoctor.diagram.HTTPOutputStream;
import org.asciidoctor.diagram.Request;

public class AbstractCommandServer {
    private static final Map<String, DiagramGenerator> DEFAULT_GENERATORS = AbstractCommandServer.loadGenerators();
    private CommandProcessor processor;

    public AbstractCommandServer(Map<String, DiagramGenerator> generators) {
        this.processor = new CommandProcessor(generators);
    }

    protected static Map<String, DiagramGenerator> getGenerators() {
        return DEFAULT_GENERATORS;
    }

    private static Map<String, DiagramGenerator> loadGenerators() {
        HashMap<String, DiagramGenerator> generatorMap = new HashMap<String, DiagramGenerator>();
        ServiceLoader<DiagramGenerator> generatorLoader = ServiceLoader.load(DiagramGenerator.class, AbstractCommandServer.class.getClassLoader());
        for (DiagramGenerator generator : generatorLoader) {
            generatorMap.put(generator.getName(), generator);
        }
        ServiceLoader<DiagramGenerator> generatorLoaderTCCL = ServiceLoader.load(DiagramGenerator.class);
        for (DiagramGenerator generator : generatorLoaderTCCL) {
            generatorMap.put(generator.getName(), generator);
        }
        return generatorMap;
    }

    protected void processRequests(InputStream inputStream, OutputStream outputStream) throws IOException {
        Request request;
        HTTPInputStream input = new HTTPInputStream(inputStream);
        HTTPOutputStream output = new HTTPOutputStream(outputStream);
        while ((request = input.readRequest()) != null) {
            output.writeResponse(this.processor.processRequest(request));
            if (!"close".equals(request.headers.getValue(HTTPHeader.CONNECTION))) continue;
            break;
        }
    }
}

