/*****************************************************************************

NAME
    bin2c.c -- convert a binary data file to a C source file

***************************************************************************/
// SPDX-FileCopyrightText: (C) Alex Smith
// SPDX-License-Identifier: GPL-2.0-or-later
#include <stdio.h>

int main(int argc, char** argv)
{
  int c,colno;
  if(argc!=2)
  {
    fprintf(stderr,"Usage: bin2c varname < infile > outfile\n");
    return 0;
  }
  (void) puts("/* This file is automatically generated; to modify it,");
  (void) puts("   modify the source file, not this file. */");
  (void) puts("#include \"config.h\"");
  printf("const char* %s=\"\\\n",argv[1]);
  colno=0;
  while((c=getchar())!=EOF)
  {
    printf("\\x%02x",(unsigned)c);
    colno+=4;
    if(colno>70) {(void) puts("\\"); colno=0;}
  }
  (void) puts("\";");
  return 0;
}
