/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.impl.api.ColumnToInsert;
import org.jetbrains.kotlinx.dataframe.impl.columns.tree.ReadonlyTreeNode;
import org.jetbrains.kotlinx.dataframe.impl.columns.tree.ReferenceData;
import org.jetbrains.kotlinx.dataframe.impl.columns.tree.UtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a6\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u0007H\u0001\u001a1\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0001\u00a2\u0006\u0002\b\u000b\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u001aJ\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a8\u0006\u0014"}, d2={"insertImpl", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "T", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "column", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "columns", "", "Lorg/jetbrains/kotlinx/dataframe/impl/api/ColumnToInsert;", "insertImplT", "df", "dataFrameOf", "", "treeNode", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/tree/ReadonlyTreeNode;", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/tree/ReferenceData;", "depth", "", "core"})
@SourceDebugExtension(value={"SMAP\ninsert.kt\nKotlin\n*S Kotlin\n*F\n+ 1 insert.kt\norg/jetbrains/kotlinx/dataframe/impl/api/InsertKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1485#2:152\n1510#2,3:153\n1513#2,3:163\n1863#2:166\n295#2,2:167\n1864#2:169\n1611#2,9:170\n1863#2:179\n1864#2:181\n1620#2:182\n1053#2:183\n1863#2:184\n295#2,2:185\n1782#2,4:187\n774#2:191\n865#2,2:192\n1864#2:194\n381#3,7:156\n1#4:180\n*S KotlinDebug\n*F\n+ 1 insert.kt\norg/jetbrains/kotlinx/dataframe/impl/api/InsertKt\n*L\n45#1:152\n45#1:153,3\n45#1:163,3\n50#1:166\n54#1:167,2\n50#1:169\n73#1:170,9\n73#1:179\n73#1:181\n73#1:182\n100#1:183\n106#1:184\n118#1:185,2\n122#1:187,4\n128#1:191\n128#1:192,2\n106#1:194\n45#1:156,7\n73#1:180\n*E\n"})
public final class InsertKt {
    @PublishedApi
    @NotNull
    public static final <T> DataFrame<T> insertImpl(@NotNull DataFrame<? extends T> $this$insertImpl, @NotNull ColumnPath path, @NotNull DataColumn<?> column) {
        Intrinsics.checkNotNullParameter($this$insertImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return InsertKt.insertImpl($this$insertImpl, CollectionsKt.listOf((Object)new ColumnToInsert(path, column, null, 4, null)));
    }

    @JvmName(name="insertImplT")
    @NotNull
    public static final <T> DataFrame<T> insertImplT(@NotNull DataFrame<? extends T> $this$insertImpl, @NotNull List<ColumnToInsert> columns2) {
        Intrinsics.checkNotNullParameter($this$insertImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        return InsertKt.insertImpl($this$insertImpl, columns2);
    }

    @NotNull
    public static final <T> DataFrame<T> insertImpl(@Nullable DataFrame<? extends T> df2, @NotNull List<ColumnToInsert> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Object object = (ColumnToInsert)CollectionsKt.firstOrNull(columns2);
        return InsertKt.insertImpl(df2, columns2, object != null && (object = ((ColumnToInsert)object).getReferenceNode()) != null ? object.getRoot() : null, 0);
    }

    @NotNull
    public static final DataFrame<Unit> dataFrameOf(@NotNull List<ColumnToInsert> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Object object = (ColumnToInsert)CollectionsKt.firstOrNull(columns2);
        return InsertKt.insertImpl(null, columns2, object != null && (object = ((ColumnToInsert)object).getReferenceNode()) != null ? object.getRoot() : null, 0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> DataFrame<T> insertImpl(@Nullable DataFrame<? extends T> df2, @NotNull List<ColumnToInsert> columns2, @Nullable ReadonlyTreeNode<? extends ReferenceData> treeNode, int depth) {
        void $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv;
        ColumnToInsert it;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        if (columns2.isEmpty()) {
            DataFrame<Object> dataFrame = df2;
            if (dataFrame == null) {
                dataFrame = CastKt.cast(DataFrame.Companion.empty$default(DataFrame.Companion, 0, 1, null));
            }
            return dataFrame;
        }
        int childDepth = depth + 1;
        Iterable $this$groupBy$iv = columns2;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ColumnToInsert it2 = (ColumnToInsert)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it2.getInsertionPath().get(depth);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map columnsMap = MapsKt.toMutableMap((Map)destination$iv$iv);
        List newColumns = new ArrayList();
        DataFrame<? extends T> dataFrame = df2;
        if (dataFrame != null && (dataFrame = dataFrame.columns()) != null) {
            Iterable $this$forEach$iv = (Iterable)((Object)dataFrame);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Boolean bl;
                DataColumn it3 = (DataColumn)element$iv;
                boolean bl3 = false;
                List subTree = (List)columnsMap.get(it3.name());
                if (subTree != null) {
                    Object v3;
                    block38: {
                        Iterable $this$firstOrNull$iv = subTree;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv2 : $this$firstOrNull$iv) {
                            it = (ColumnToInsert)element$iv2;
                            boolean bl4 = false;
                            if (!(it.getInsertionPath().size() == childDepth)) continue;
                            v3 = element$iv2;
                            break block38;
                        }
                        v3 = null;
                    }
                    ColumnToInsert invalidPath = v3;
                    if (!(invalidPath == null)) {
                        boolean $i$a$-check-InsertKt$insertImpl$1$32 = false;
                        ColumnToInsert columnToInsert = invalidPath;
                        Intrinsics.checkNotNull((Object)columnToInsert);
                        String text = columnToInsert.getInsertionPath().joinToString(".");
                        String $i$a$-check-InsertKt$insertImpl$1$32 = "Can not insert column `" + text + "` because column with this path already exists in DataFrame";
                        throw new IllegalStateException($i$a$-check-InsertKt$insertImpl$1$32.toString());
                    }
                    ColumnGroup group = it3 instanceof ColumnGroup ? (ColumnGroup)((Object)it3) : null;
                    if (!(group != null)) {
                        boolean $i$a$-check-InsertKt$insertImpl$1$42 = false;
                        String $i$a$-check-InsertKt$insertImpl$1$42 = "Can not insert columns under a column '" + it3.name() + "', because it is not a column group";
                        throw new IllegalStateException($i$a$-check-InsertKt$insertImpl$1$42.toString());
                    }
                    ReadonlyTreeNode<? extends ReferenceData> readonlyTreeNode = treeNode;
                    DataFrame<T> newDf = InsertKt.insertImpl(group, subTree, readonlyTreeNode != null ? readonlyTreeNode.get(((ColumnGroup)((Object)it3)).name()) : null, childDepth);
                    ColumnGroup<T> newCol = org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.withDf(group, newDf);
                    newColumns.add(newCol);
                    bl = columnsMap.remove(((ColumnGroup)((Object)it3)).name());
                    continue;
                }
                bl = newColumns.add(it3);
            }
        }
        Iterable $this$mapNotNull$iv = columns2;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$groupByTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Pair pair = $this$forEach$iv$iv$iv.iterator();
        while (pair.hasNext()) {
            Pair pair2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = pair.next();
            boolean bl = false;
            it = (ColumnToInsert)element$iv$iv;
            boolean bl5 = false;
            String name = it.getInsertionPath().get(depth);
            List subTree = (List)columnsMap.get(name);
            if (subTree != null) {
                int n;
                columnsMap.remove(name);
                Iterator iterator2 = ((Iterable)subTree).iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                ColumnToInsert it22 = (ColumnToInsert)iterator2.next();
                boolean bl6 = false;
                if (it22.getReferenceNode() == null) {
                    n = Integer.MAX_VALUE;
                } else {
                    ReadonlyTreeNode<ReferenceData> col = it22.getReferenceNode();
                    if (col.getDepth() > depth) {
                        col = UtilsKt.getAncestor(col, depth + 1);
                    }
                    n = col.getParent() == treeNode ? (col.getData().getWasRemoved() ? col.getData().getOriginalIndex() : col.getData().getOriginalIndex() + 1) : Integer.MAX_VALUE;
                }
                int it22 = n;
                while (iterator2.hasNext()) {
                    int n2;
                    ColumnToInsert it4 = (ColumnToInsert)iterator2.next();
                    $i$a$-minOf-InsertKt$insertImpl$columnsToAdd$1$minIndex$1 = false;
                    if (it4.getReferenceNode() == null) {
                        n2 = Integer.MAX_VALUE;
                    } else {
                        ReadonlyTreeNode<ReferenceData> col = it4.getReferenceNode();
                        if (col.getDepth() > depth) {
                            col = UtilsKt.getAncestor(col, depth + 1);
                        }
                        n2 = col.getParent() == treeNode ? (col.getData().getWasRemoved() ? col.getData().getOriginalIndex() : col.getData().getOriginalIndex() + 1) : Integer.MAX_VALUE;
                    }
                    if (it22 <= (it4 = n2)) continue;
                    it22 = it4;
                }
                int minIndex = it22;
                pair2 = TuplesKt.to((Object)minIndex, (Object)TuplesKt.to((Object)name, (Object)subTree));
            } else {
                pair2 = null;
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair2;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        List columnsToAdd = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        ReadonlyTreeNode<? extends ReferenceData> readonlyTreeNode = treeNode;
        List<ReadonlyTreeNode<? extends ReferenceData>> removedSiblings = readonlyTreeNode != null ? readonlyTreeNode.getChildren() : null;
        int k = 0;
        int insertionIndexOffset = 0;
        Iterable $this$forEach$iv = columnsToAdd;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseColumn newCol;
            BaseColumn baseColumn;
            Object v11;
            List columns3;
            String name;
            int insertionIndex;
            block39: {
                pair = (Pair)element$iv;
                boolean bl = false;
                insertionIndex = ((Number)pair.component1()).intValue();
                Pair pair3 = (Pair)pair.component2();
                name = (String)pair3.component1();
                columns3 = (List)pair3.component2();
                if (removedSiblings != null) {
                    while (k < removedSiblings.size() && removedSiblings.get(k).getData().getOriginalIndex() < insertionIndex) {
                        if (removedSiblings.get(k).getData().getWasRemoved()) {
                            insertionIndexOffset += -1;
                        }
                        ++k;
                    }
                }
                Iterable $this$firstOrNull$iv = columns3;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv3 : $this$firstOrNull$iv) {
                    ColumnToInsert it5 = (ColumnToInsert)element$iv3;
                    boolean bl8 = false;
                    if (!(it5.getInsertionPath().size() == childDepth)) continue;
                    v11 = element$iv3;
                    break block39;
                }
                v11 = null;
            }
            ColumnToInsert nodeToInsert = v11;
            if (nodeToInsert != null) {
                BaseColumn<?> column = nodeToInsert.getColumn();
                if (columns3.size() > 1) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    int n;
                    Iterable $this$count$iv = columns3;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv4 : $this$count$iv) {
                            ColumnToInsert it6 = (ColumnToInsert)element$iv4;
                            boolean bl = false;
                            if (!(it6.getInsertionPath().size() == childDepth) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    if (!(n == 1)) {
                        boolean $i$a$-check-InsertKt$insertImpl$2$newCol$32 = false;
                        String $i$a$-check-InsertKt$insertImpl$2$newCol$32 = "Can not insert more than one column into the path " + nodeToInsert.getInsertionPath();
                        throw new IllegalStateException($i$a$-check-InsertKt$insertImpl$2$newCol$32.toString());
                    }
                    if (!(column instanceof ColumnGroup)) {
                        String $i$a$-check-InsertKt$insertImpl$2$newCol$32 = "Check failed.";
                        throw new IllegalStateException($i$a$-check-InsertKt$insertImpl$2$newCol$32.toString());
                    }
                    Iterable $i$a$-check-InsertKt$insertImpl$2$newCol$32 = columns3;
                    DataFrame dataFrame2 = (DataFrame)((Object)column);
                    boolean $i$f$filter = false;
                    void bl8 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        ColumnToInsert it7 = (ColumnToInsert)element$iv$iv;
                        boolean bl = false;
                        if (!(it7.getInsertionPath().size() > childDepth)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    ReadonlyTreeNode<? extends ReferenceData> readonlyTreeNode2 = treeNode;
                    DataFrame<T> newDf = InsertKt.insertImpl(dataFrame2, (List)destination$iv$iv3, readonlyTreeNode2 != null ? readonlyTreeNode2.get(name) : null, childDepth);
                    baseColumn = org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.withDf((ColumnGroup)column, newDf);
                } else {
                    baseColumn = column.rename(name);
                }
            } else {
                ReadonlyTreeNode<? extends ReferenceData> readonlyTreeNode3 = treeNode;
                DataFrame<T> newDf = InsertKt.insertImpl(null, columns3, readonlyTreeNode3 != null ? readonlyTreeNode3.get(name) : null, childDepth);
                baseColumn = newCol = (BaseColumn)DataColumn.Companion.createColumnGroup(name, newDf);
            }
            if (insertionIndex == Integer.MAX_VALUE) {
                newColumns.add(newCol);
                continue;
            }
            newColumns.add(insertionIndex + insertionIndexOffset, newCol);
            int n = insertionIndexOffset;
            insertionIndexOffset = n + 1;
        }
        return CastKt.cast(ToDataFrameKt.toDataFrameAnyColumn(newColumns));
    }
}

