/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BinaryMaxDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.Float1Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IdentityDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.ReadOnlyDomain;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextMaxDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.util.Version;
import com.intellij.database.util.VersionRange;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class MsDomains
extends BaseDomainRegistry {
    private static final VersionRange MS_2008 = VersionRange.after((Version)Version.of((int[])new int[]{10, 50}));
    private static final VersionRange MS_2025 = VersionRange.after((Version)Version.of((int[])new int[]{17, 0}));
    static final int TS_FRACTION = 3;
    private static final int MAX_BINARY = 8000;
    private static final int MAX_PRECISION = 38;
    private static final int MAX_TIME_FRACTION = 7;
    private static final int MAX_CHAR = 4000;
    private static final long MAX_TEXT = 0x3FFFFFFFL;
    private static final int MONEY_PRECISION = 19;
    private static final int SMALLMONEY_PRECISION = 10;
    private static final int MONEY_SCALE = 4;

    public MsDomains() {
        this.add((Domain)new Float1Domain(this, "float", ConversionPoint.SINGLE_PRECISION, new DomainRegistry.Limits(new DomainRegistry.Limit[]{new DomainRegistry.Limit((Number)24, (Number)Float.valueOf(-3.4028235E38f), (Number)Float.valueOf(Float.MAX_VALUE)), new DomainRegistry.Limit((Number)53, (Number)-1.7976931348623157E308, (Number)Double.MAX_VALUE)})){

            @NotNull
            public Float1Domain narrow(@NotNull SizeProvider provider) {
                int size;
                if (provider == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (provider instanceof DataConsumer.Column && ((size = provider.getSize()) == 7 || size == 15)) {
                    size = size == 7 ? 24 : 53;
                    double min = this.myLimits.minValue((Number)size).doubleValue();
                    double max = this.myLimits.maxValue((Number)size).doubleValue();
                    return new Float1Domain(this.simpleName(), this.getPoint(), min, max, this.myLimits);
                }
                Float1Domain float1Domain = super.narrow(provider);
                if (float1Domain == null) {
                    1.$$$reportNull$$$0(1);
                }
                return float1Domain;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/mssql/MsDomains$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/mssql/MsDomains$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "narrow";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "narrow";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        this.add((Domain)new ReadOnlyDomain(new BinaryDomain("timestamp", ConversionPoint.BINARY, 8L).withOperationSupport(OperationSupport.SUPPORTS_NOTHING)));
        this.add(new BinaryMaxDomain("binary", ConversionPoint.BINARY, Integer.MAX_VALUE, 8000L, 1L, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryMaxDomain("varbinary", ConversionPoint.VARBINARY, Integer.MAX_VALUE, 8000L, 1L, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("image", ConversionPoint.GRAPHIC, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new BooleanDomain("bit", ConversionPoint.BOOLEAN).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new IdentityDomain((Domain)new IntegerDomain("int", ConversionPoint.SERIAL_NUMBER, -2.147483648E9, 2.147483647E9)));
        this.add((Domain)new IdentityDomain((Domain)new IntegerDomain("smallint", ConversionPoint.SERIAL_NUMBER, -32768.0, 32767.0)));
        this.add((Domain)new IdentityDomain((Domain)new IntegerDomain("tinyint", ConversionPoint.SERIAL_NUMBER, -128.0, 127.0)));
        this.add((Domain)new IdentityDomain((Domain)new IntegerDomain("bigint", ConversionPoint.SERIAL_NUMBER, -9.223372036854776E18, 9.223372036854776E18)));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new Number2Domain("dec", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new IdentityDomain((Domain)new Number2Domain("decimal", ConversionPoint.SERIAL_NUMBER, 38, 0, true)));
        this.add((Domain)new IdentityDomain((Domain)new Number2Domain("dec", ConversionPoint.SERIAL_NUMBER, 38, 0, true)));
        this.add((Domain)new IdentityDomain((Domain)new Number2Domain("numeric", ConversionPoint.SERIAL_NUMBER, 38, 0, true)));
        this.add(new Number2Domain("smallmoney", ConversionPoint.MONEY, 10, 4, false).withOperationSupport(OperationSupport.SUPPORTS_NUMERIC_EQUALS));
        this.add(new Number2Domain("money", ConversionPoint.MONEY, 19, 4, false).withOperationSupport(OperationSupport.SUPPORTS_NUMERIC_EQUALS));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_LIKE_ONLY));
        this.add(new TextDomain("ntext", ConversionPoint.NTEXT, 0x3FFFFFFFL).withOperationSupport(OperationSupport.SUPPORTS_LIKE_ONLY));
        this.add((Domain)new TextDomain("sysname", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add(new SimpleDomain("uniqueidentifier", ConversionPoint.UUID_TEXT).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("nchar", ConversionPoint.NCHAR, 4000L, 1L, true, false));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 4000L, 1L, true, false));
        this.add((Domain)new TextMaxDomain("varchar", ConversionPoint.VARCHAR, Integer.MAX_VALUE, 8000L, 1L));
        this.add((Domain)new TextMaxDomain("nvarchar", ConversionPoint.NVARCHAR, Integer.MAX_VALUE, 8000L, 1L));
        this.add(new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new FractionDomain("datetime", ConversionPoint.TIMESTAMP, 3, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new FractionDomain(this, "smalldatetime", ConversionPoint.TIMESTAMP, 0, -1, false){

            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    2.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = StringUtil.equalsIgnoreCase((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? Compatibility.full((Cardinality)this.cardinality(), (LogicalType)domain.getLogicType(), (LogicalType)this.getLogicType()) : (domain.getLogicType() == LogicalType.TIMESTAMP ? Compatibility.compatibleLossy((Cardinality)this.cardinality(), (LogicalType)domain.getLogicType(), (LogicalType)this.getLogicType()) : Compatibility.incompatible());
                if (compatibility == null) {
                    2.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/mssql/MsDomains$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/mssql/MsDomains$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        this.add((Domain)new UnknownDomain("hierarchyid"));
        this.add((Domain)new UnknownDomain("datetimeoffset"));
        this.add((Domain)new UnknownDomain("geometry"));
        this.add((Domain)new UnknownDomain("geography"));
        this.add(new FractionDomain("time", ConversionPoint.TIME, 7, 7, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE).withVersionRange(MS_2008));
        this.add(new FractionDomain("datetime2", ConversionPoint.TIMESTAMP, 3, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE).withVersionRange(MS_2008));
        this.add(new SimpleDomain("date", ConversionPoint.DATE).withOperationSupport(OperationSupport.SUPPORTS_LIKE_ONLY).withVersionRange(MS_2008));
        this.add(new TextDomain("vector", ConversionPoint.JSON, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING).withVersionRange(MS_2025));
        this.add(new SimpleDomain("json", ConversionPoint.JSON).withOperationSupport(OperationSupport.SUPPORTS_NOTHING).withVersionRange(MS_2025));
    }
}

