/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.gherkin;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.gherkin.PyBDDFramework;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

class PyBDDStepDefinitionCreator
implements StepDefinitionCreator {
    private static final Pattern VALID_FILE_NAME = Pattern.compile("^[^\\s|]+$");
    @NotNull
    private final PyBDDFramework myFramework;
    private static final Map<PyBDDFramework, PsiFile> lastCreatedFiles = new HashMap<PyBDDFramework, PsiFile>();

    PyBDDStepDefinitionCreator(@NotNull PyBDDFramework framework) {
        if (framework == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(0);
        }
        this.myFramework = framework;
    }

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        if (dir == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(1);
        }
        if (name == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = (PsiFile)WriteAction.compute(() -> {
            PsiFile file = dir.createFile(String.format("%s.py", name));
            this.myFramework.initStepDefinitionFile(file);
            lastCreatedFiles.put(this.myFramework, file);
            return file;
        });
        if (psiFile == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file, boolean withTemplate) {
        if (step == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(5);
        }
        TypeEvalContext context = TypeEvalContext.deepCodeInsight((Project)file.getProject());
        boolean createdForThisFramework = file.equals((Object)lastCreatedFiles.get(this.myFramework));
        if (!(file instanceof PyFile) || !createdForThisFramework && !this.myFramework.isFileMayBeStepDefinition((PyFile)file, context)) {
            return false;
        }
        this.myFramework.createStepDefinition(step, file);
        lastCreatedFiles.remove(this.myFramework);
        return true;
    }

    public boolean validateNewStepDefinitionFileName(@NotNull Project project, @NotNull String fileName) {
        if (project == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(7);
        }
        return VALID_FILE_NAME.matcher(fileName).matches();
    }

    @NotNull
    public String getDefaultStepDefinitionFolderPath(@NotNull GherkinStep step) {
        PsiFile file;
        if (step == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(8);
        }
        if (!((file = step.getContainingFile()) instanceof GherkinFile)) {
            String string = file.getContainingDirectory().getVirtualFile().getPath();
            if (string == null) {
                PyBDDStepDefinitionCreator.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.myFramework.getDefaultStepDefinitionFolder((GherkinFile)file);
        if (string == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getStepDefinitionFilePath(@NotNull PsiFile file) {
        if (file == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(11);
        }
        String string = file.getVirtualFile().getPath();
        if (string == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        GherkinFeature feature;
        if (step == null) {
            PyBDDStepDefinitionCreator.$$$reportNull$$$0(13);
        }
        if ((feature = (GherkinFeature)PsiTreeUtil.getParentOfType((PsiElement)step, GherkinFeature.class)) != null) {
            String string = feature.getContainingFile().getVirtualFile().getNameWithoutExtension();
            if (string == null) {
                PyBDDStepDefinitionCreator.$$$reportNull$$$0(14);
            }
            return string;
        }
        return "steps";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 10, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/gherkin/PyBDDStepDefinitionCreator";
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/gherkin/PyBDDStepDefinitionCreator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefinitionContainer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepDefinitionFolderPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionFilePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionContainer";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateNewStepDefinitionFileName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepDefinitionFolderPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionFilePath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepFileName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 10, 12, 14 -> new IllegalStateException(string);
        };
    }
}

