/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.util;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.state.DiagramNodeIdentity;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.util.Key;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramSelectionService {
    @NotNull
    private static final Key<Map<DiagramNodeIdentity, Color>> PERMANENT_HIGHLIGHTING_MAP_KEY = Key.create((String)"com.intellij.diagram.util.DiagramSelectionService.PERMANENT_HIGHLIGHTING_MAP_KEY");
    @NotNull
    private static final DiagramSelectionService INSTANCE = new DiagramSelectionService();

    @NotNull
    public static DiagramSelectionService getInstance() {
        DiagramSelectionService diagramSelectionService = INSTANCE;
        if (diagramSelectionService == null) {
            DiagramSelectionService.$$$reportNull$$$0(0);
        }
        return diagramSelectionService;
    }

    private DiagramSelectionService() {
    }

    public boolean isSelected(@NotNull DiagramBuilder builder, @NotNull DiagramNode<?> node) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(1);
        }
        if (node == null) {
            DiagramSelectionService.$$$reportNull$$$0(2);
        }
        return (Boolean)builder.getGraphBuilder().getActionExecutor().computeReadAction(() -> {
            Node graphNode = Objects.requireNonNull(builder.getNode(node), "Node " + node.getTooltip() + " is not in the model. Or model was not updated. Call DiagramBuilder.update()");
            return builder.getGraph().isSelected(graphNode);
        });
    }

    public void setSelected(@NotNull DiagramBuilder builder, @NotNull DiagramNode<?> node, boolean state) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(3);
        }
        if (node == null) {
            DiagramSelectionService.$$$reportNull$$$0(4);
        }
        builder.getGraphBuilder().getActionExecutor().runGraphActionAsync(() -> {
            Node graphNode = Objects.requireNonNull(builder.getNode(node), "Node " + node.getTooltip() + " is not in the model. Or model was not updated. Call DiagramBuilder.update()");
            builder.getGraph().setSelected(graphNode, state);
        });
    }

    public boolean isSelected(@NotNull DiagramBuilder builder, @NotNull DiagramEdge<?> edge) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(5);
        }
        if (edge == null) {
            DiagramSelectionService.$$$reportNull$$$0(6);
        }
        return (Boolean)builder.getGraphBuilder().getActionExecutor().computeReadAction(() -> {
            Edge graphEdge = Objects.requireNonNull(builder.getEdge(edge), "Edge " + String.valueOf(edge) + " is not in the model. Or model was not updated. Call DiagramBuilder.update()");
            return builder.getGraph().isSelected(graphEdge);
        });
    }

    public void setSelected(@NotNull DiagramBuilder builder, @NotNull DiagramEdge<?> edge, boolean state) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(7);
        }
        if (edge == null) {
            DiagramSelectionService.$$$reportNull$$$0(8);
        }
        builder.getGraphBuilder().getActionExecutor().runGraphActionAsync(() -> {
            Edge graphEdge = Objects.requireNonNull(builder.getEdge(edge), "Edge " + String.valueOf(edge) + " is not in the model. Or model was not updated. Call DiagramBuilder.update()");
            builder.getGraph().setSelected(graphEdge, state);
        });
    }

    @NotNull
    public List<DiagramNode<?>> getSelectedNodes(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(9);
        }
        List list = (List)builder.getGraphBuilder().getActionExecutor().computeReadAction(() -> {
            ArrayList result = new ArrayList();
            NodeCursor cursor = builder.getGraph().selectedNodes();
            while (cursor.ok()) {
                DiagramNode<?> modelNode = builder.getNodeObject(cursor.node());
                if (modelNode != null) {
                    result.add(modelNode);
                }
                cursor.next();
            }
            return result;
        });
        if (list == null) {
            DiagramSelectionService.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<NodeGroupDescriptor> getSelectedGroupNodes(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(11);
        }
        ArrayList<NodeGroupDescriptor> result = new ArrayList<NodeGroupDescriptor>();
        NodeCursor cursor = builder.getGraph().selectedNodes();
        while (cursor.ok()) {
            NodeGroupDescriptor modelNode = builder.getGroupNodeObject(cursor.node());
            if (modelNode != null) {
                result.add(modelNode);
            }
            cursor.next();
        }
        ArrayList<NodeGroupDescriptor> arrayList = result;
        if (arrayList == null) {
            DiagramSelectionService.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public List<DiagramNode<?>> getSelectedNodesExceptNotes(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(13);
        }
        List list = (List)builder.getGraphBuilder().getActionExecutor().computeReadAction(() -> {
            ArrayList result = new ArrayList();
            NodeCursor cursor = builder.getGraph().selectedNodes();
            while (cursor.ok()) {
                DiagramNode<?> modelNode = builder.getNodeObject(cursor.node());
                if (modelNode != null && !(modelNode instanceof DiagramNoteNode)) {
                    result.add(modelNode);
                }
                cursor.next();
            }
            return result;
        });
        if (list == null) {
            DiagramSelectionService.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    public DiagramNode<?> getSingleSelectedNode(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(15);
        }
        return (DiagramNode)builder.getGraphBuilder().getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getNodeObject(GraphSelectionService.getInstance().getSingleSelectedNode(builder.getGraph())));
    }

    @Nullable
    public DiagramEdge<?> getSingleSelectedEdge(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(16);
        }
        return (DiagramEdge)builder.getGraphBuilder().getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getEdgeObject(GraphSelectionService.getInstance().getSingleSelectedEdge(builder.getGraph())));
    }

    @NotNull
    public List<DiagramEdge<?>> getSelectedEdges(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(17);
        }
        List list = (List)builder.getGraphBuilder().getActionExecutor().computeReadAction(() -> {
            ArrayList selectedEdges = new ArrayList();
            EdgeCursor cursor = builder.getGraph().selectedEdges();
            while (cursor.ok()) {
                DiagramEdge<?> edgeObject = builder.getEdgeObject(cursor.edge());
                if (edgeObject != null) {
                    selectedEdges.add(edgeObject);
                }
                cursor.next();
            }
            return selectedEdges;
        });
        if (list == null) {
            DiagramSelectionService.$$$reportNull$$$0(18);
        }
        return list;
    }

    public void setPermanentHighlighting(@NotNull DiagramBuilder builder, @NotNull DiagramNode<?> node, @Nullable Color color) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(19);
        }
        if (node == null) {
            DiagramSelectionService.$$$reportNull$$$0(20);
        }
        Map highlightingMap = Optional.ofNullable((Map)builder.getUserData(PERMANENT_HIGHLIGHTING_MAP_KEY)).orElseGet(() -> {
            HashMap map = new HashMap();
            builder.putUserData(PERMANENT_HIGHLIGHTING_MAP_KEY, map);
            return map;
        });
        highlightingMap.put(DiagramNodeIdentity.of(node), color);
    }

    @Nullable
    public Color getPermanentHighlighting(@NotNull DiagramBuilder builder, @NotNull DiagramNode<?> node) {
        if (builder == null) {
            DiagramSelectionService.$$$reportNull$$$0(21);
        }
        if (node == null) {
            DiagramSelectionService.$$$reportNull$$$0(22);
        }
        return Optional.ofNullable((Map)builder.getUserData(PERMANENT_HIGHLIGHTING_MAP_KEY)).map(it -> (Color)it.get(DiagramNodeIdentity.of(node))).orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 13, 15, 16, 17, 19, 20, 21, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/util/DiagramSelectionService";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 4: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/util/DiagramSelectionService";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedGroupNodes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodesExceptNotes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEdges";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedGroupNodes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodesExceptNotes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSingleSelectedNode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSingleSelectedEdge";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEdges";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setPermanentHighlighting";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPermanentHighlighting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 13, 15, 16, 17, 19, 20, 21, 22 -> new IllegalArgumentException(string);
        };
    }
}

