/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.console.client.DatabaseScriptingSessionClient;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.sql.dialects.EvaluationHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptModelUtil
extends ScriptModelUtilCore {
    private ScriptModelUtil() {
    }

    @NotNull
    public static TextRange getSelectedStatementsRange(@NotNull DatabaseScriptingSessionClient client, @NotNull Editor editor2, @NotNull DatabaseSettings.ExecOption execOption) {
        if (client == null) {
            ScriptModelUtil.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ScriptModelUtil.$$$reportNull$$$0(1);
        }
        if (execOption == null) {
            ScriptModelUtil.$$$reportNull$$$0(2);
        }
        TextRange range = ScriptModelUtil.getSelectionForConsole(editor2, execOption);
        TextRange textRange = ScriptModelUtil.adjustModelForSelection(client.getScriptModel(), client.getDocument(), range, execOption).getTextRange();
        if (textRange == null) {
            ScriptModelUtil.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @NotNull
    public static TextRange getSelectionForConsole(@Nullable Editor editor2, @NotNull DatabaseSettings.ExecOption execOption) {
        if (execOption == null) {
            ScriptModelUtil.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                ScriptModelUtil.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        if (execOption.execSelection == 3) {
            TextRange textRange = EditorUtil.getSelectionInAnyMode((Editor)editor2);
            if (textRange == null) {
                ScriptModelUtil.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        Caret caret = editor2.getCaretModel().getPrimaryCaret();
        TextRange textRange = TextRange.create((int)caret.getSelectionStart(), (int)caret.getSelectionEnd());
        if (textRange == null) {
            ScriptModelUtil.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @NotNull
    public static TextRange adjustSelectionRange(@NotNull ScriptModel<?> model, @NotNull Document document, @NotNull TextRange selectionRange, @NotNull DatabaseSettings.ExecOption execOption) {
        if (model == null) {
            ScriptModelUtil.$$$reportNull$$$0(8);
        }
        if (document == null) {
            ScriptModelUtil.$$$reportNull$$$0(9);
        }
        if (selectionRange == null) {
            ScriptModelUtil.$$$reportNull$$$0(10);
        }
        if (execOption == null) {
            ScriptModelUtil.$$$reportNull$$$0(11);
        }
        if (selectionRange.isEmpty()) {
            int lineEnd;
            int lineNumber;
            int lineStart;
            int lineStartFixed;
            CharSequence sequence = document.getCharsSequence();
            int sequenceLength = sequence.length();
            if (sequenceLength == 0) {
                TextRange textRange = selectionRange;
                if (textRange == null) {
                    ScriptModelUtil.$$$reportNull$$$0(12);
                }
                return textRange;
            }
            int offset = Math.min(sequenceLength - 1, selectionRange.getStartOffset());
            if (!Character.isWhitespace(sequence.charAt(offset))) {
                ++offset;
            }
            if ((lineStartFixed = EditorActionUtil.findFirstNonSpaceOffsetInRange((CharSequence)sequence, (int)(lineStart = document.getLineStartOffset(lineNumber = document.getLineNumber(offset))), (int)(lineEnd = document.getLineEndOffset(lineNumber)))) >= 0) {
                TextRange subRange = TextRange.create((int)lineStartFixed, (int)Math.max(lineStartFixed, offset));
                EvaluationHelper evaluationHelper = (EvaluationHelper)EvaluationHelper.EP.forLanguage(model.getLanguage());
                TextRange r = (TextRange)model.subModel((TextRange)new ScriptModel.PositionRange(subRange)).statements().filter(st -> evaluationHelper.isStatement(st.api()).value(st.object())).transform(TO_RANGE).last();
                if (r != null) {
                    TextRange textRange = r;
                    if (textRange == null) {
                        ScriptModelUtil.$$$reportNull$$$0(13);
                    }
                    return textRange;
                }
            }
            TextRange textRange = selectionRange;
            if (textRange == null) {
                ScriptModelUtil.$$$reportNull$$$0(14);
            }
            return textRange;
        }
        if (execOption.execSelection == 1) {
            return new ScriptModel.StrictRange(selectionRange);
        }
        if (execOption.execSelection == 2) {
            TextRange textRange = selectionRange;
            if (textRange == null) {
                ScriptModelUtil.$$$reportNull$$$0(15);
            }
            return textRange;
        }
        if (execOption.execSelection == 3) {
            ScriptModel.SmartRange smartRange = new ScriptModel.SmartRange(selectionRange);
            ScriptModel m = model.subModel((TextRange)smartRange);
            if (m.statements().take(2).size() > 1) {
                TextRange r = selectionRange;
                for (TextRange range : m.statements().transform(TO_RANGE)) {
                    r = r.union(range);
                }
                return new ScriptModel.SmartRange(r);
            }
            ScriptModel.SmartRange smartRange2 = smartRange;
            if (smartRange2 == null) {
                ScriptModelUtil.$$$reportNull$$$0(16);
            }
            return smartRange2;
        }
        throw new AssertionError(execOption.execSelection);
    }

    @NotNull
    public static <V> ScriptModel<V> adjustModelForSelection(@NotNull ScriptModel<V> model, @NotNull Document document, @NotNull TextRange selectionRange, @NotNull DatabaseSettings.ExecOption execOption) {
        TextRange adjustedRange;
        if (model == null) {
            ScriptModelUtil.$$$reportNull$$$0(17);
        }
        if (document == null) {
            ScriptModelUtil.$$$reportNull$$$0(18);
        }
        if (selectionRange == null) {
            ScriptModelUtil.$$$reportNull$$$0(19);
        }
        if (execOption == null) {
            ScriptModelUtil.$$$reportNull$$$0(20);
        }
        int fixedOffset = (adjustedRange = ScriptModelUtil.adjustSelectionRange(model, document, selectionRange, execOption)).contains(selectionRange.getStartOffset()) ? selectionRange.getStartOffset() : adjustedRange.getStartOffset();
        ScriptModel scriptModel = selectionRange.getLength() == 0 ? model.subModel((TextRange)new ScriptModel.PositionRange(fixedOffset)) : model.subModel(adjustedRange);
        if (scriptModel == null) {
            ScriptModelUtil.$$$reportNull$$$0(21);
        }
        return scriptModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 12, 13, 14, 15, 16, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/script/ScriptModelUtil";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/script/ScriptModelUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedStatementsRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionForConsole";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectionRange";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModelForSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedStatementsRange";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionForConsole";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectionRange";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "adjustModelForSelection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7, 12, 13, 14, 15, 16, 21 -> new IllegalStateException(string);
        };
    }
}

