/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.ContentMetadata;
import java.util.Map;
import java.util.Objects;

public record DefaultContent(TextSegment textSegment, Map<ContentMetadata, Object> metadata) implements Content
{
    public DefaultContent {
        ValidationUtils.ensureNotNull(textSegment, "textSegment");
        ValidationUtils.ensureNotNull(metadata, "metadata");
    }

    public DefaultContent(String text) {
        this(TextSegment.from(text));
    }

    public DefaultContent(TextSegment textSegment) {
        this(textSegment, Map.of());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Content that = (Content)o;
        return Objects.equals(this.textSegment, that.textSegment());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.textSegment);
    }
}

