/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.impl.util.table.CssCompletionContext;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtilCore;
import com.intellij.psi.css.impl.util.table.CssPropertyDescriptorImpl;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssReferencePropertyValue;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.psi.css.impl.util.table.CssVendorSpecificPropertyUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssShorthandExpandProcessor {
    private final CssPropertyDescriptor myDescriptor;
    @NonNls
    private static final String[] VALUE_4 = new String[]{"top", "right", "bottom", "left"};

    public CssShorthandExpandProcessor(@NotNull CssPropertyDescriptor descriptor) {
        if (descriptor == null) {
            CssShorthandExpandProcessor.$$$reportNull$$$0(0);
        }
        this.myDescriptor = descriptor;
    }

    public static CssShorthandExpandProcessor create(@NotNull CssPropertyDescriptor descriptor) {
        if (descriptor == null) {
            CssShorthandExpandProcessor.$$$reportNull$$$0(1);
        }
        assert (descriptor.isShorthandValue());
        return new CssShorthandExpandProcessor(descriptor);
    }

    public String @NotNull [] expand(@NotNull CssDeclaration decl) {
        String propertyName;
        String vendorPrefix;
        if (decl == null) {
            CssShorthandExpandProcessor.$$$reportNull$$$0(2);
        }
        String string = vendorPrefix = !(propertyName = this.myDescriptor.getPropertyName()).equalsIgnoreCase(decl.getPropertyName()) ? CssVendorSpecificPropertyUtil.getVendorPrefix((String)decl.getPropertyName()) : "";
        if (propertyName.startsWith("-moz-border-radius")) {
            String[] stringArray = new String[]{"-moz-border-radius-topleft", "-moz-border-radius-topright", "-moz-border-radius-bottomright", "-moz-border-radius-bottomleft"};
            if (stringArray == null) {
                CssShorthandExpandProcessor.$$$reportNull$$$0(3);
            }
            return stringArray;
        }
        if (propertyName.contains("border-radius")) {
            String prefix = vendorPrefix + propertyName.substring(0, propertyName.indexOf("border-radius"));
            String[] stringArray = new String[]{prefix + "border-top-left-radius", prefix + "border-top-right-radius", prefix + "border-bottom-right-radius", prefix + "border-bottom-left-radius"};
            if (stringArray == null) {
                CssShorthandExpandProcessor.$$$reportNull$$$0(4);
            }
            return stringArray;
        }
        if (this.myDescriptor.is4ValueProperty()) {
            String[] stringArray = this.suggestValueNames();
            if (stringArray == null) {
                CssShorthandExpandProcessor.$$$reportNull$$$0(5);
            }
            return stringArray;
        }
        if ("overflow".equals(propertyName)) {
            String[] stringArray = new String[]{"overflow-x", "overflow-y"};
            if (stringArray == null) {
                CssShorthandExpandProcessor.$$$reportNull$$$0(6);
            }
            return stringArray;
        }
        Map<String, String> refNames = this.processReferences(decl);
        Set<String> keys = refNames.keySet();
        String[] stringArray = ArrayUtilRt.toStringArray(keys);
        if (stringArray == null) {
            CssShorthandExpandProcessor.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    @Nullable
    public CssPropertyValue getPropertyValue(@NotNull CssDeclaration decl, @NotNull String propertyName) {
        if (decl == null) {
            CssShorthandExpandProcessor.$$$reportNull$$$0(8);
        }
        if (propertyName == null) {
            CssShorthandExpandProcessor.$$$reportNull$$$0(9);
        }
        if (this.myDescriptor.is4ValueProperty()) {
            return this.myDescriptor.getValue();
        }
        Map<String, String> expanded2refName = this.processReferences(decl);
        String refName = expanded2refName.get(propertyName);
        if (refName != null) {
            return this.myDescriptor.getReferencedPropertyValue(refName);
        }
        return null;
    }

    @NotNull
    private Map<String, String> processReferences(final @NotNull CssDeclaration decl) {
        if (decl == null) {
            CssShorthandExpandProcessor.$$$reportNull$$$0(10);
        }
        CssCompletionContext context = CssPropertyDescriptorImpl.buildFullContext(decl);
        final String vendorPrefix = CssVendorSpecificPropertyUtil.getVendorPrefix((String)decl.getPropertyName());
        final HashMap<String, String> result = new HashMap<String, String>();
        CssPropertyValue value = this.myDescriptor.getValue();
        if (context != null && value != null) {
            value.accept((CssTableValueVisitor)new CssTableValueVisitor.Recursive<CssPropertyValueImpl>(){
                final CssElementDescriptorProvider provider;
                {
                    this.provider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)decl);
                }

                public void visitValue(@NotNull CssPropertyValueImpl value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value.isGroup() && !(value instanceof CssReferencePropertyValue)) {
                        for (CssPropertyValue each : value.getChildren()) {
                            String refName = each.getRefName();
                            if (refName == null) continue;
                            String referencedPropertyName = CssShorthandExpandProcessor.this.createName(refName, each.hasImmutablePrefix());
                            CssPropertyDescriptor referencedDescriptor = this.provider != null ? this.provider.getPropertyDescriptor(referencedPropertyName, (PsiElement)decl) : null;
                            if (referencedDescriptor == null) continue;
                            if (referencedDescriptor.isShorthandValue()) {
                                String[] expandedValues;
                                for (String expandedValue : expandedValues = referencedDescriptor.expand(decl)) {
                                    result.put(vendorPrefix + expandedValue, refName);
                                }
                                continue;
                            }
                            result.put(vendorPrefix + referencedPropertyName, refName);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor$1", "visitValue"));
                }
            });
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            CssShorthandExpandProcessor.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    @NotNull
    private String createName(@NotNull String name, boolean hasImmutablePrefix) {
        if (name == null) {
            CssShorthandExpandProcessor.$$$reportNull$$$0(12);
        }
        String propertyName = this.myDescriptor.getPropertyName();
        int index = name.lastIndexOf(45);
        Object object = index == -1 || hasImmutablePrefix ? name : propertyName + name.substring(index);
        if (object == null) {
            CssShorthandExpandProcessor.$$$reportNull$$$0(13);
        }
        return object;
    }

    private String[] suggestValueNames() {
        String propertyName = this.myDescriptor.getPropertyName();
        String[] strings = propertyName.split("-");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            StringBuilder builder = new StringBuilder(strings[0]);
            builder.append('-').append(VALUE_4[i]);
            if (strings.length > 1) {
                builder.append('-').append(strings[1]);
            }
            result.add(builder.toString());
        }
        return ArrayUtilRt.toStringArray(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "expand";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processReferences";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processReferences";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 11, 13 -> new IllegalStateException(string);
        };
    }
}

